/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdaweb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.autoplot.cdaweb.CDAWebDB;
import org.autoplot.cdaweb.CDAWebDataSetIdDialog;
import org.das2.components.DasProgressPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.virbo.cdf.CdfJavaDataSourceEditorPanel;
import org.virbo.datasource.AutoplotSettings;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.URISplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDAWebEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    public static final String PARAM_FILTER = "filter";
    CdfJavaDataSourceEditorPanel paramEditor;
    JComponent messageComponent = null;
    boolean haveAddedRecent = false;
    private static final String MSG_NO_DATASET = "<html><em>No dataset selected, pick initial dataset...</em></html>";
    private String currentDs = "";
    private String filter = "";
    private JLabel availableTextField;
    private JLabel descriptionLabel;
    private JComboBox dsidComboBox;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel parameterPanel;
    private JButton pickDsButton;
    private JPanel timeRangePanel;
    private JTextField timeRangeTextField;
    private boolean expert = true;

    public CDAWebEditorPanel() {
        this.initComponents();
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                CDAWebEditorPanel.this.refresh(CDAWebEditorPanel.this.getURI());
            }
        });
    }

    private boolean pickDs() {
        Window own;
        Window win = SwingUtilities.getWindowAncestor(this);
        JFrame frame = null;
        if (win != null && (own = win.getOwner()) instanceof JFrame) {
            frame = (JFrame)own;
        }
        CDAWebDataSetIdDialog t = new CDAWebDataSetIdDialog(frame, true);
        t.setLocationRelativeTo(this);
        t.setTitle("Pick Dataset");
        t.setFilter(this.filter);
        t.refresh();
        t.setResizable(true);
        t.setVisible(true);
        if (t.isCancelled()) {
            return false;
        }
        this.filter = t.getFilter();
        this.dsidComboBox.setSelectedItem(t.getSelectedItem());
        final String uri = this.getURI();
        Runnable run = new Runnable(){

            public void run() {
                CDAWebEditorPanel.this.refresh(uri);
            }
        };
        new Thread(run).start();
        return true;
    }

    private void refreshDataSet(CdfJavaDataSourceEditorPanel panel, String ds, Map<String, String> args) throws Exception {
        try {
            DatumRange tr1;
            if (!CDAWebDB.getInstance().getServiceProviderIds().containsKey(ds)) {
                this.messageComponent = new JLabel("<html>Service provider \"" + ds + "\" not found in ftp/cdaweb.gsfc.nasa.gov/pub/cdaweb/all.xml");
                this.descriptionLabel.setText("");
                this.timeRangeTextField.setText("");
                this.paramEditor = null;
                return;
            }
            String avail = CDAWebDB.getInstance().getTimeRange(ds);
            this.availableTextField.setText(avail);
            DatumRange dr = DatumRangeUtil.parseTimeRange((String)avail);
            String timeDflt = CDAWebDB.getInstance().getSampleTime(ds);
            DatumRange tr = DatumRangeUtil.parseTimeRange((String)timeDflt);
            String str = this.timeRangeTextField.getText().trim();
            if (!str.equals("") && dr.intersects(tr1 = DatumRangeUtil.parseTimeRange((String)str))) {
                tr = tr1;
            }
            this.timeRangeTextField.setText(tr.toString());
        }
        catch (ParseException ex) {
            this.availableTextField.setText(ex.toString());
        }
    }

    private synchronized void doRefreshDataSet(final String ds, final Map<String, String> args) throws IOException, Exception {
        String master;
        Window w = SwingUtilities.getWindowAncestor(this);
        DasProgressPanel mon = w == null ? DasProgressPanel.createFramed((String)"getting master CDF") : DasProgressPanel.createFramed((Window)w, (String)"getting master CDF");
        this.currentDs = ds;
        final String fmaster = ds != null ? (master = CDAWebDB.getInstance().getMasterFile(ds, (ProgressMonitor)mon)) : null;
        Runnable run = new Runnable(){

            public synchronized void run() {
                block8: {
                    if (ds != null) {
                        try {
                            CdfJavaDataSourceEditorPanel panel = new CdfJavaDataSourceEditorPanel();
                            String master = fmaster;
                            String id = (String)args.get("id");
                            if (id != null) {
                                master = master + "?" + id;
                            }
                            boolean status = panel.prepare(master, SwingUtilities.getWindowAncestor(CDAWebEditorPanel.this), (ProgressMonitor)new NullProgressMonitor());
                            panel.setURI(master);
                            if (!status) {
                                CDAWebEditorPanel.this.messageComponent = new JLabel("<html>CDF file subpanel prepare method failed");
                                CDAWebEditorPanel.this.paramEditor = null;
                                break block8;
                            }
                            if (CDAWebEditorPanel.this.messageComponent != null) {
                                CDAWebEditorPanel.this.parameterPanel.remove(CDAWebEditorPanel.this.messageComponent);
                            }
                            CDAWebEditorPanel.this.parameterPanel.add((Component)panel, "Center");
                            panel.setShowAdvancedSubpanel(false);
                            CDAWebEditorPanel.this.paramEditor = panel;
                            CDAWebEditorPanel.this.parameterPanel.revalidate();
                            CDAWebEditorPanel.this.messageComponent = null;
                            CDAWebEditorPanel.this.refreshDataSet(panel, ds, args);
                        }
                        catch (Exception ex) {
                            CDAWebEditorPanel.this.messageComponent = new JLabel("<html>Exception:<br>" + ex.toString().replaceAll("\n", "<br>"));
                            CDAWebEditorPanel.this.paramEditor = null;
                        }
                    } else {
                        CDAWebEditorPanel.this.messageComponent = new JLabel(CDAWebEditorPanel.MSG_NO_DATASET);
                    }
                }
                if (CDAWebEditorPanel.this.messageComponent != null) {
                    CDAWebEditorPanel.this.parameterPanel.removeAll();
                    CDAWebEditorPanel.this.parameterPanel.add((Component)CDAWebEditorPanel.this.messageComponent, "North");
                }
                CDAWebEditorPanel.this.parameterPanel.revalidate();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public synchronized void refresh(String suri) {
        if (EventQueue.isDispatchThread()) {
            System.err.println("TODO: refresh should not be called from the event thread");
        }
        if (!this.haveAddedRecent) {
            this.addRecent();
            this.haveAddedRecent = true;
        }
        String ds = (String)this.dsidComboBox.getSelectedItem();
        if (this.paramEditor != null) {
            this.parameterPanel.remove((Component)this.paramEditor);
        }
        if (this.messageComponent != null) {
            this.parameterPanel.remove(this.messageComponent);
        }
        this.messageComponent = new JLabel("<html><em>Loading file...</em></html>");
        this.parameterPanel.add((Component)this.messageComponent, "North");
        URISplit split = URISplit.parse((String)suri);
        LinkedHashMap args = URISplit.parseParams((String)split.params);
        if (ds != null) {
            String desc = CDAWebDB.getInstance().getServiceProviderIds().get(ds);
            this.descriptionLabel.setText("<html><small>" + desc + "</small></html>");
        } else {
            this.descriptionLabel.setText("<html><small> </small></html>");
        }
        try {
            if (ds == null ? this.currentDs != null : !ds.equals(this.currentDs)) {
                this.doRefreshDataSet(ds, args);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecent() {
        String val = (String)this.dsidComboBox.getSelectedItem();
        BufferedReader r = null;
        try {
            File home = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
            File book = new File(home, "bookmarks");
            File hist = new File(book, "history.txt");
            long t0 = System.currentTimeMillis();
            System.err.println("reading recent datasources from " + hist.toString());
            if (!hist.exists()) {
                return;
            }
            r = new BufferedReader(new FileReader(hist));
            String s = r.readLine();
            LinkedHashSet<String> dss = new LinkedHashSet<String>();
            while (s != null) {
                int i;
                if (s.length() > 25 && s.substring(25).startsWith("vap+cdaweb") && (i = s.indexOf("ds=")) != -1) {
                    int j = s.indexOf("&", i);
                    if (j == -1) {
                        j = s.length();
                    }
                    String ds = s.substring(i + 3, j);
                    dss.add(ds);
                }
                s = r.readLine();
            }
            this.dsidComboBox.setModel(new DefaultComboBoxModel<Object>(dss.toArray()));
            this.dsidComboBox.setSelectedItem(val);
            t0 = System.currentTimeMillis() - t0;
            System.err.printf("done in %d millis\n", t0);
        }
        catch (IOException ex) {
            Logger.getLogger(CDAWebEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            this.dsidComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"error in parsing history.txt"}));
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CDAWebEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.dsidComboBox = new JComboBox();
        this.pickDsButton = new JButton();
        this.parameterPanel = new JPanel();
        this.timeRangePanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.timeRangeTextField = new JTextField();
        this.availableTextField = new JLabel();
        this.descriptionLabel = new JLabel();
        this.jLabel1.setText("Dataset:");
        this.dsidComboBox.setEditable(true);
        this.dsidComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "recent items will go here"}));
        this.dsidComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CDAWebEditorPanel.this.dsidComboBoxActionPerformed(evt);
            }
        });
        this.pickDsButton.setText("Pick...");
        this.pickDsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CDAWebEditorPanel.this.pickDsButtonActionPerformed(evt);
            }
        });
        this.parameterPanel.setLayout(new BorderLayout());
        this.jLabel3.setText("Time Range: ");
        this.timeRangeTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CDAWebEditorPanel.this.timeRangeTextFieldActionPerformed(evt);
            }
        });
        this.availableTextField.setText("data availability");
        GroupLayout timeRangePanelLayout = new GroupLayout((Container)this.timeRangePanel);
        this.timeRangePanel.setLayout((LayoutManager)timeRangePanelLayout);
        timeRangePanelLayout.setHorizontalGroup((GroupLayout.Group)timeRangePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeRangePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)timeRangePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeRangePanelLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.availableTextField, -1, 398, Short.MAX_VALUE)).add((GroupLayout.Group)timeRangePanelLayout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.timeRangeTextField, -1, 315, Short.MAX_VALUE))).addContainerGap()));
        timeRangePanelLayout.setVerticalGroup((GroupLayout.Group)timeRangePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeRangePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)timeRangePanelLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.timeRangeTextField, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.availableTextField).addContainerGap()));
        this.descriptionLabel.setText("Description of dataset goes here");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.dsidComboBox, 0, 259, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pickDsButton, -2, 78, -2).addContainerGap()).add((Component)this.timeRangePanel, -1, -1, Short.MAX_VALUE).add((Component)this.parameterPanel, -1, 434, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.descriptionLabel, -1, 410, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.dsidComboBox, -2, -1, -2).add((Component)this.pickDsButton)).addPreferredGap(0).add((Component)this.descriptionLabel).add(4, 4, 4).add((Component)this.parameterPanel, -1, 195, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.timeRangePanel, -2, -1, -2)));
    }

    private void pickDsButtonActionPerformed(ActionEvent evt) {
        this.pickDs();
    }

    private void timeRangeTextFieldActionPerformed(ActionEvent evt) {
    }

    private void dsidComboBoxActionPerformed(ActionEvent evt) {
        this.parameterPanel.removeAll();
        this.messageComponent = new JLabel("<html><em>Resetting...</em></html>");
        this.parameterPanel.add((Component)this.messageComponent, "North");
        this.parameterPanel.revalidate();
        this.parameterPanel.repaint();
        if (this.isShowing()) {
            Runnable run = new Runnable(){

                public void run() {
                    CDAWebEditorPanel.this.refresh(CDAWebEditorPanel.this.getURI());
                }
            };
            new Thread(run).start();
        }
    }

    public JPanel getPanel() {
        return this;
    }

    private void initialize(String uri) {
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap args = URISplit.parseParams((String)split.params);
        this.dsidComboBox.setSelectedItem(args.get("ds"));
        String timeRange = (String)args.get("timerange");
        if (timeRange != null) {
            this.timeRangeTextField.setText(timeRange.replaceAll("\\+", " "));
        }
    }

    public void setURI(String uri) {
        this.initialize(uri);
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap args = URISplit.parseParams((String)split.params);
        String filter1 = (String)args.get(PARAM_FILTER);
        if (filter1 != null) {
            this.filter = filter1;
        }
        if (args.get("ds") == null) {
            Runnable run = new Runnable(){

                public void run() {
                    try {
                        while (!CDAWebEditorPanel.this.isShowing()) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(CDAWebEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CDAWebEditorPanel.this.messageComponent = new JLabel(CDAWebEditorPanel.MSG_NO_DATASET);
                            CDAWebEditorPanel.this.parameterPanel.removeAll();
                            CDAWebEditorPanel.this.parameterPanel.add((Component)CDAWebEditorPanel.this.messageComponent, "North");
                            CDAWebEditorPanel.this.parameterPanel.revalidate();
                            if (!CDAWebEditorPanel.this.pickDs()) {
                                // empty if block
                            }
                        }
                    });
                }
            };
            new Thread(run).start();
        }
    }

    public String getURI() {
        String id = null;
        if (this.paramEditor != null) {
            id = this.paramEditor.getURI();
            URISplit split = URISplit.parse((String)id);
            LinkedHashMap args = URISplit.parseParams((String)split.params);
            id = (String)args.get("arg_0");
        }
        if (id == null) {
            id = "";
        }
        String timeRange = this.timeRangeTextField.getText();
        timeRange = timeRange.replaceAll(" ", "+");
        String result = "vap+cdaweb:ds=" + this.dsidComboBox.getSelectedItem() + "&id=" + id;
        if (this.filter.length() > 0) {
            result = result + "&filter=" + this.filter;
        }
        return result + "&timerange=" + timeRange;
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        this.initialize(uri);
        CDAWebDB.getInstance().maybeRefresh(mon);
        this.refresh(uri);
        return true;
    }

    public boolean reject(String uri) throws Exception {
        return false;
    }

    public void setExpertMode(boolean expert) {
        this.expert = expert;
    }
}

