/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.util.ArrayList;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ReplaceVariableCheck;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;

public class DatasetConstructor {
    public static void transferDataset(NetcdfFile src, NetcdfDataset target, ReplaceVariableCheck replaceCheck) {
        DatasetConstructor.transferGroup(src, src.getRootGroup(), target.getRootGroup(), replaceCheck);
    }

    private static void transferGroup(NetcdfFile ds, Group src, Group target, ReplaceVariableCheck replaceCheck) {
        boolean unlimitedOK = false;
        DatasetConstructor.transferGroupAttributes(src, target);
        for (Dimension d : src.getDimensions()) {
            if (null != target.findDimensionLocal(d.getName())) continue;
            Dimension newd = new Dimension(d.getName(), d.getLength(), d.isShared(), unlimitedOK && d.isUnlimited(), d.isVariableLength());
            target.addDimension(newd);
        }
        for (Variable v : src.getVariables()) {
            boolean replace;
            Variable targetV = target.findVariable(v.getShortName());
            VariableEnhanced targetVe = (VariableEnhanced)((Object)targetV);
            boolean bl = replace = replaceCheck != null && replaceCheck.replace(v);
            if (replace || null == targetV) {
                if (v instanceof Structure && !(v instanceof StructureDS)) {
                    v = new StructureDS(target, (Structure)v);
                } else if (!(v instanceof VariableDS) && !(v instanceof StructureDS)) {
                    v = new VariableDS(target, v, false);
                }
                if (null != targetV) {
                    target.remove(targetV);
                }
                target.addVariable(v);
                v.resetDimensions();
                continue;
            }
            if (targetV.hasCachedData() || targetVe.getOriginalVariable() != null) continue;
            targetVe.setOriginalVariable(v);
        }
        for (Group srcNested : src.getGroups()) {
            Group nested = new Group(ds, target, srcNested.getShortName());
            target.addGroup(nested);
            DatasetConstructor.transferGroup(ds, srcNested, nested, replaceCheck);
        }
    }

    public static void transferVariableAttributes(Variable src, Variable target) {
        for (Attribute a : src.getAttributes()) {
            if (null != target.findAttribute(a.getName())) continue;
            target.addAttribute(a);
        }
    }

    public static void transferGroupAttributes(Group src, Group target) {
        for (Attribute a : src.getAttributes()) {
            if (null != target.findAttribute(a.getName())) continue;
            target.addAttribute(a);
        }
    }

    public static Group findGroup(NetcdfFile newFile, Group oldGroup) {
        ArrayList<Group> chain = new ArrayList<Group>(5);
        Group g = oldGroup;
        while (g.getParentGroup() != null) {
            chain.add(0, g);
            g = g.getParentGroup();
        }
        Group newg = newFile.getRootGroup();
        for (Group oldg : chain) {
            if ((newg = newg.findGroup(oldg.getShortName())) != null) continue;
            return null;
        }
        return newg;
    }
}

