/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.Join;

public class JoinMuiltdimStructure
implements Join {
    Structure parentStructure;
    ArrayStructure parentData;
    int dimLength;

    public JoinMuiltdimStructure(Structure parentStructure, int dimLength) {
        this.parentStructure = parentStructure;
        this.dimLength = dimLength;
        try {
            this.parentData = (ArrayStructure)parentStructure.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public StructureData getJoinData(Cursor cursor) {
        int recnum = cursor.recnum[0] / this.dimLength;
        return this.parentData.getStructureData(recnum);
    }

    public Variable findVariable(String axisName) {
        return this.parentStructure.findVariable(axisName);
    }

    public String toString() {
        return "JoinMuiltdimStructure{parentStructure=" + this.parentStructure + ", dimLength='" + this.dimLength + '}';
    }
}

