/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.Formatter;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import ucar.nc2.ft.point.standard.Join;
import ucar.nc2.ft.point.standard.JoinArray;
import ucar.nc2.ft.point.standard.JoinMuiltdimStructure;
import ucar.nc2.ft.point.standard.JoinParentIndex;
import ucar.nc2.ft.point.standard.TableConfig;

public class TableConfigXML {
    private TableConfig tc;
    private String analyserClass;

    TableConfigXML(TableConfig tc, String analyserClass) {
        this.tc = tc;
        this.analyserClass = analyserClass;
    }

    public void writeConfigXML(Formatter sf) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        sf.format("%s", fmt.outputString(this.makeDocument()));
    }

    public Document makeDocument() {
        Element rootElem = new Element("tableConfig");
        Document doc = new Document(rootElem);
        if (this.analyserClass != null) {
            rootElem.addContent((Content)new Element("analyser").setAttribute("class", this.analyserClass));
        }
        if (this.tc.featureType != null) {
            rootElem.setAttribute("featureType", this.tc.featureType.toString());
        }
        rootElem.addContent((Content)this.writeTable(this.tc));
        return doc;
    }

    private Element writeTable(TableConfig config) {
        Element tableElem = new Element("table");
        if (config.name != null) {
            tableElem.setAttribute("name", config.name);
        }
        if (config.type != null) {
            tableElem.setAttribute("type", config.type.toString());
        }
        switch (config.type) {
            case ArrayStructure: {
                tableElem.addContent((Content)new Element("dimension").addContent(config.dim.getName()));
                break;
            }
            case Construct: {
                tableElem.addContent((Content)new Element("structure").addContent(config.structName));
                break;
            }
            case Contiguous: {
                if (config.start != null) {
                    tableElem.addContent((Content)new Element("start").addContent(config.start));
                }
                tableElem.addContent((Content)new Element("numRecords").addContent(config.numRecords));
                break;
            }
            case LinkedList: {
                tableElem.addContent((Content)new Element("start").addContent(config.start));
                tableElem.addContent((Content)new Element("next").addContent(config.next));
                break;
            }
            case MultiDimInner: {
                tableElem.addContent((Content)new Element("dimension").addContent(config.dim.getName()));
                break;
            }
            case MultiDimStructurePsuedo: {
                tableElem.addContent((Content)new Element("outerDimension").addContent(config.dim.getName()));
                tableElem.addContent((Content)new Element("innerDimension").addContent(config.inner.getName()));
                break;
            }
            case NestedStructure: {
                tableElem.addContent((Content)new Element("structure").addContent(config.structName));
                break;
            }
            case ParentIndex: {
                tableElem.addContent((Content)new Element("parentIndex").addContent(config.parentIndex));
                break;
            }
            case Singleton: {
                break;
            }
            case MultiDimStructure: 
            case Structure: {
                tableElem.addContent((Content)new Element("dimension").addContent(config.dim.getName()));
                if (!config.isPsuedoStructure) break;
                tableElem.setAttribute("isPsuedoStructure", Boolean.toString(config.isPsuedoStructure));
                break;
            }
            case Top: {
                tableElem.addContent((Content)new Element("structure").addContent(config.structName));
            }
        }
        this.addCoordinates(tableElem, config);
        if (config.vars != null) {
            for (String col : config.vars) {
                tableElem.addContent((Content)new Element("variable").addContent(col));
            }
        }
        if (config.extraJoin != null) {
            for (Join j : config.extraJoin) {
                if (j instanceof JoinArray) {
                    tableElem.addContent((Content)this.writeJoinArray((JoinArray)j));
                    continue;
                }
                if (j instanceof JoinMuiltdimStructure) {
                    tableElem.addContent((Content)this.writeJoinMuiltdimStructure((JoinMuiltdimStructure)j));
                    continue;
                }
                if (!(j instanceof JoinParentIndex)) continue;
                tableElem.addContent((Content)this.writeJoinParentIndex((JoinParentIndex)j));
            }
        }
        if (config.children != null) {
            for (TableConfig child : config.children) {
                tableElem.addContent((Content)this.writeTable(child));
            }
        }
        return tableElem;
    }

    private void addCoordinates(Element tableElem, TableConfig table) {
        this.addCoord(tableElem, table.lat, "lat");
        this.addCoord(tableElem, table.lon, "lon");
        this.addCoord(tableElem, table.elev, "elev");
        this.addCoord(tableElem, table.time, "time");
        this.addCoord(tableElem, table.timeNominal, "timeNominal");
        this.addCoord(tableElem, table.stnId, "stnId");
        this.addCoord(tableElem, table.stnDesc, "stnDesc");
        this.addCoord(tableElem, table.stnNpts, "stnNpts");
        this.addCoord(tableElem, table.stnWmoId, "stnWmoId");
        this.addCoord(tableElem, table.stnAlt, "stnAlt");
        this.addCoord(tableElem, table.limit, "limit");
    }

    private void addCoord(Element tableElem, String name, String type) {
        if (name != null) {
            Element elem = new Element("coordinate").setAttribute("type", type);
            elem.addContent(name);
            tableElem.addContent((Content)elem);
        }
    }

    private Element writeJoinArray(JoinArray join) {
        Element joinElem = new Element("extraJoin");
        joinElem.setAttribute("class", join.getClass().toString());
        if (join.type != null) {
            joinElem.setAttribute("type", join.type.toString());
        }
        if (join.v != null) {
            joinElem.addContent((Content)new Element("variable").addContent(join.v.getName()));
        }
        joinElem.addContent((Content)new Element("param").setAttribute("value", Integer.toString(join.param)));
        return joinElem;
    }

    private Element writeJoinMuiltdimStructure(JoinMuiltdimStructure join) {
        Element joinElem = new Element("extraJoin");
        joinElem.setAttribute("class", join.getClass().toString());
        if (join.parentStructure != null) {
            joinElem.addContent((Content)new Element("parentStructure").addContent(join.parentStructure.getName()));
        }
        joinElem.addContent((Content)new Element("dimLength").setAttribute("value", Integer.toString(join.dimLength)));
        return joinElem;
    }

    private Element writeJoinParentIndex(JoinParentIndex join) {
        Element joinElem = new Element("extraJoin");
        joinElem.setAttribute("class", join.getClass().toString());
        if (join.parentStructure != null) {
            joinElem.addContent((Content)new Element("parentStructure").addContent(join.parentStructure.getName()));
        }
        if (join.parentIndex != null) {
            joinElem.addContent((Content)new Element("parentIndex").addContent(join.parentIndex));
        }
        return joinElem;
    }
}

