/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CF;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.gempak.GempakFileReader;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakParameters;
import ucar.nc2.iosp.gempak.GempakStation;
import ucar.nc2.iosp.gempak.GempakSurfaceFileReader;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil;
import visad.util.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GempakSurfaceIOSP
extends AbstractIOServiceProvider {
    protected NetcdfFile ncfile;
    protected RandomAccessFile raf;
    protected GempakSurfaceFileReader gemreader;
    protected StringBuilder parseInfo = new StringBuilder();
    private DateFormatter dateFormat = new DateFormatter();
    private static final Number RMISS = new Float(-9999.0f);
    private static final Number IMISS = new Integer(-9999);
    private static final Dimension DIM_LEN8 = new Dimension("len8", 8, true);
    private static final Dimension DIM_LEN4 = new Dimension("len4", 4, true);
    private static final Dimension DIM_LEN2 = new Dimension("len2", 2, true);
    private static final String TIME_VAR = "time";
    private static final String MISSING_VAR = "_isMissing";
    private static String[] stnVarNames = new String[]{"STID", "STNM", "SLAT", "SLON", "SELV", "STAT", "COUN", "STD2", "SPRI", "SWFO", "WFO2"};
    private static int[] stnVarSizes = new int[]{8, 4, 4, 4, 4, 2, 2, 4, 4, 4, 4};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        try {
            this.gemreader = new GempakSurfaceFileReader();
            Trace.call1((String)"GEMPAKSIOSP.isValidFile: reader.init");
            this.gemreader.init(raf, false);
            Trace.call2((String)"GEMPAKSIOSP.isValidFile: reader.init");
        }
        catch (Exception ioe) {
            return false;
        }
        if (this.gemreader.getSurfaceFileType().equals("standard")) return true;
        if (!this.gemreader.getSurfaceFileType().equals("ship")) return false;
        return true;
    }

    @Override
    public String getFileTypeId() {
        return "GempakSurface";
    }

    @Override
    public String getFileTypeDescription() {
        return "GEMPAK Surface Obs Data";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
        this.ncfile = ncfile;
        long start = System.currentTimeMillis();
        if (this.gemreader == null) {
            this.gemreader = new GempakSurfaceFileReader();
        }
        Trace.call1((String)"GEMPAKSIOSP.open: initTables");
        this.initTables();
        Trace.call2((String)"GEMPAKSIOSP.open: initTables");
        Trace.call1((String)"GEMPAKSIOSP.open: reader.init");
        this.gemreader.init(raf, true);
        Trace.call2((String)"GEMPAKSIOSP.open: reader.init");
        this.buildNCFile();
    }

    private void initTables() {
        try {
            GempakParameters.addParameters("resources/nj22/tables/gempak/params.tbl");
        }
        catch (Exception e) {
            System.out.println("unable to init param tables");
        }
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public boolean syncExtend() {
        return false;
    }

    @Override
    public String getDetailInfo() {
        return this.parseInfo.toString();
    }

    @Override
    public boolean sync() throws IOException {
        if (this.gemreader.getInitFileSize() < this.raf.length()) {
            long start = System.currentTimeMillis();
            Trace.msg((String)("GEMPAKSIOSP.sync: file is bigger: " + this.raf.length() + " > " + this.gemreader.getInitFileSize()));
            Trace.call1((String)"GEMPAKSIOSP.sync: reader.init");
            this.gemreader.init(this.raf, true);
            Trace.call2((String)"GEMPAKSIOSP.sync: reader.init");
            Trace.call1((String)"GEMPAKSIOSP.sync: buildNCFile");
            this.buildNCFile();
            Trace.call2((String)"GEMPAKSIOSP.sync: buildNCFile");
            return true;
        }
        return false;
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        if (this.gemreader == null) {
            return null;
        }
        Array array = null;
        if (this.gemreader.getSurfaceFileType().equals("ship")) {
            array = this.readShipData(v2, section);
        } else if (this.gemreader.getSurfaceFileType().equals("standard")) {
            array = this.readStandardData(v2, section);
        }
        return array;
    }

    private Array readStandardData(Variable v2, Section section) throws IOException {
        ArrayStructureBB array = null;
        if (v2 instanceof Structure) {
            List<GempakParameter> params = this.gemreader.getParameters("SFDT");
            Structure pdata = (Structure)v2;
            StructureMembers members = pdata.makeStructureMembers();
            List<StructureMembers.Member> mbers = members.getMembers();
            int i = 0;
            int numBytes = 0;
            int totalNumBytes = 0;
            for (StructureMembers.Member member : mbers) {
                member.setDataParam(4 * i++);
                numBytes = member.getDataType().getSize();
                totalNumBytes += numBytes;
            }
            members.setStructureSize(totalNumBytes);
            float[] missing = new float[mbers.size()];
            int missnum = 0;
            for (Variable v : pdata.getVariables()) {
                Attribute att = v.findAttribute("missing_value");
                missing[missnum++] = att == null ? -9999.0f : att.getNumericValue().floatValue();
            }
            boolean num = false;
            Range stationRange = section.getRange(0);
            Range timeRange = section.getRange(1);
            int size = stationRange.length() * timeRange.length();
            byte[] bytes = new byte[totalNumBytes * size];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            array = new ArrayStructureBB(members, new int[]{size}, buf, 0);
            for (int y = stationRange.first(); y <= stationRange.last(); y += stationRange.stride()) {
                for (int x = timeRange.first(); x <= timeRange.last(); x += timeRange.stride()) {
                    GempakFileReader.RData vals = this.gemreader.DM_RDTR(x + 1, y + 1, "SFDT");
                    if (vals == null) {
                        int k = 0;
                        for (StructureMembers.Member member : mbers) {
                            if (member.getDataType().equals((Object)DataType.FLOAT)) {
                                buf.putFloat(missing[k]);
                            } else {
                                buf.put((byte)1);
                            }
                            ++k;
                        }
                        continue;
                    }
                    float[] reals = vals.data;
                    int var = 0;
                    for (GempakParameter param : params) {
                        if (members.findMember(param.getName()) != null) {
                            buf.putFloat(reals[var]);
                        }
                        ++var;
                    }
                    buf.put((byte)0);
                }
            }
        }
        return array;
    }

    private Array readShipData(Variable v2, Section section) throws IOException {
        ArrayStructureBB array = null;
        if (v2 instanceof Structure) {
            boolean needToReadData;
            List<GempakParameter> params = this.gemreader.getParameters("SFDT");
            Structure pdata = (Structure)v2;
            StructureMembers members = pdata.makeStructureMembers();
            List<StructureMembers.Member> mbers = members.getMembers();
            int ssize = 0;
            boolean stnVarNum = false;
            List<String> stnKeyNames = this.gemreader.getStationKeyNames();
            for (StructureMembers.Member member : mbers) {
                if (stnKeyNames.contains(member.getName())) {
                    int varSize = this.getStnVarSize(member.getName());
                    member.setDataParam(ssize);
                    ssize += varSize;
                    continue;
                }
                if (member.getName().equals(TIME_VAR)) {
                    member.setDataParam(ssize);
                    ssize += 8;
                    continue;
                }
                if (member.getName().equals(MISSING_VAR)) {
                    member.setDataParam(ssize);
                    ++ssize;
                    continue;
                }
                member.setDataParam(ssize);
                ssize += 4;
            }
            members.setStructureSize(ssize);
            Range recordRange = section.getRange(0);
            int size = recordRange.length();
            byte[] bytes = new byte[ssize * size];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            array = new ArrayStructureBB(members, new int[]{size}, buf, 0);
            List<GempakStation> stationList = this.gemreader.getStations();
            List<Date> dateList = this.gemreader.getDates();
            boolean bl = needToReadData = !pdata.isSubset();
            if (!needToReadData) {
                for (GempakParameter param : params) {
                    if (members.findMember(param.getName()) == null) continue;
                    needToReadData = true;
                    break;
                }
            }
            boolean hasTime = members.findMember(TIME_VAR) != null;
            for (int x = recordRange.first(); x <= recordRange.last(); x += recordRange.stride()) {
                GempakStation stn = stationList.get(x);
                for (String varname : stnKeyNames) {
                    if (members.findMember(varname) == null) continue;
                    String temp = null;
                    if (varname.equals("STID")) {
                        temp = StringUtil.padRight(stn.getName(), 8);
                    } else if (varname.equals("STNM")) {
                        buf.putInt(stn.getSTNM());
                    } else if (varname.equals("SLAT")) {
                        buf.putFloat((float)stn.getLatitude());
                    } else if (varname.equals("SLON")) {
                        buf.putFloat((float)stn.getLongitude());
                    } else if (varname.equals("SELV")) {
                        buf.putFloat((float)stn.getAltitude());
                    } else if (varname.equals("STAT")) {
                        temp = StringUtil.padRight(stn.getSTAT(), 2);
                    } else if (varname.equals("COUN")) {
                        temp = StringUtil.padRight(stn.getCOUN(), 2);
                    } else if (varname.equals("STD2")) {
                        temp = StringUtil.padRight(stn.getSTD2(), 4);
                    } else if (varname.equals("SPRI")) {
                        buf.putInt(stn.getSPRI());
                    } else if (varname.equals("SWFO")) {
                        temp = StringUtil.padRight(stn.getSWFO(), 4);
                    } else if (varname.equals("WFO2")) {
                        temp = StringUtil.padRight(stn.getWFO2(), 4);
                    }
                    if (temp == null) continue;
                    buf.put(temp.getBytes());
                }
                if (members.findMember(TIME_VAR) != null) {
                    Date time = dateList.get(x);
                    buf.putDouble((double)time.getTime() / 1000.0);
                }
                if (!needToReadData) continue;
                int column = stn.getIndex();
                GempakFileReader.RData vals = this.gemreader.DM_RDTR(1, column, "SFDT");
                if (vals == null) {
                    for (GempakParameter param : params) {
                        if (members.findMember(param.getName()) == null) continue;
                        buf.putFloat(-9999.0f);
                    }
                    buf.put((byte)1);
                    continue;
                }
                float[] reals = vals.data;
                int var = 0;
                for (GempakParameter param : params) {
                    if (members.findMember(param.getName()) != null) {
                        buf.putFloat(reals[var]);
                    }
                    ++var;
                }
                buf.put((byte)0);
            }
        }
        return array;
    }

    public static void main(String[] args) throws IOException {
        GempakSurfaceIOSP mciosp = new GempakSurfaceIOSP();
        RandomAccessFile rf = new RandomAccessFile(args[0], "r", 2048);
        MakeNetcdfFile ncfile = new MakeNetcdfFile(mciosp, rf, args[0], null);
        if (args.length > 1) {
            FileWriter.writeToFile(ncfile, args[1]);
        } else {
            System.out.println(ncfile);
        }
    }

    private void buildNCFile() throws IOException {
        Trace.call1((String)"GEMPAKSIOSP: buildNCFile");
        this.ncfile.empty();
        String fileType = this.gemreader.getSurfaceFileType();
        if (fileType.equals("standard")) {
            this.buildStandardFile();
        } else if (fileType.equals("ship")) {
            this.buildShipFile();
        } else {
            this.buildClimateFile();
        }
        this.addGlobalAttributes();
        this.ncfile.finish();
        Trace.call2((String)"GEMPAKSIOSP: buildNCFile");
    }

    private void buildStandardFile() {
        List<GempakStation> stations = this.gemreader.getStations();
        Trace.msg((String)("GEMPAKSIOSP: now have " + stations.size() + " stations"));
        Dimension station = new Dimension("station", stations.size(), true);
        this.ncfile.addDimension(null, station);
        this.ncfile.addDimension(null, DIM_LEN4);
        this.ncfile.addDimension(null, DIM_LEN2);
        List<Variable> stationVars = this.makeStationVars(stations, station);
        for (Variable stnVar : stationVars) {
            this.ncfile.addVariable(null, stnVar);
        }
        List<Date> timeList = this.gemreader.getDates();
        int numTimes = timeList.size();
        Dimension times = new Dimension(TIME_VAR, numTimes, true);
        this.ncfile.addDimension(null, times);
        ArrayDouble.D1 varArray = null;
        Variable timeVar = new Variable(this.ncfile, null, null, TIME_VAR, DataType.DOUBLE, TIME_VAR);
        timeVar.addAttribute(new Attribute("units", "seconds since 1970-01-01 00:00:00"));
        timeVar.addAttribute(new Attribute("long_name", TIME_VAR));
        varArray = new ArrayDouble.D1(numTimes);
        int i = 0;
        for (Date date : timeList) {
            varArray.set(i, (double)date.getTime() / 1000.0);
            ++i;
        }
        timeVar.setCachedData(varArray, false);
        this.ncfile.addVariable(null, timeVar);
        ArrayList<Dimension> stationTime = new ArrayList<Dimension>();
        stationTime.add(station);
        stationTime.add(times);
        Structure sfData = this.makeStructure("SFDT", stationTime);
        if (sfData == null) {
            return;
        }
        sfData.addAttribute(new Attribute("coordinates", "time SLAT SLON SELV"));
        this.ncfile.addVariable(null, sfData);
        this.ncfile.addAttribute(null, new Attribute("CF:featureType", CF.FeatureType.stationTimeSeries.toString()));
    }

    private Structure makeStructure(String partName, List dimensions) {
        List<GempakParameter> params = this.gemreader.getParameters(partName);
        if (params == null) {
            return null;
        }
        Structure sVar = new Structure(this.ncfile, null, null, partName);
        sVar.setDimensions(dimensions);
        for (GempakParameter param : params) {
            sVar.addMemberVariable(this.makeParamVariable(param, null));
        }
        sVar.addMemberVariable(this.makeMissingVariable());
        return sVar;
    }

    private Variable makeMissingVariable() {
        Variable var = new Variable(this.ncfile, null, null, MISSING_VAR);
        var.setDataType(DataType.BYTE);
        var.setDimensions((List<Dimension>)null);
        var.addAttribute(new Attribute("description", "missing flag - 1 means all params are missing"));
        return var;
    }

    private Variable makeParamVariable(GempakParameter param, List<Dimension> dims) {
        Variable var = new Variable(this.ncfile, null, null, param.getName());
        var.setDataType(DataType.FLOAT);
        var.setDimensions(dims);
        var.addAttribute(new Attribute("long_name", param.getDescription()));
        String units = param.getUnit();
        if (units != null && !units.equals("")) {
            var.addAttribute(new Attribute("units", units));
        }
        var.addAttribute(new Attribute("missing_value", RMISS));
        return var;
    }

    private void buildShipFile() {
        List<GempakStation> stations = this.gemreader.getStations();
        int numObs = stations.size();
        Trace.msg((String)("GEMPAKSIOSP: now have " + numObs + " stations"));
        Dimension record = new Dimension("record", numObs, true);
        this.ncfile.addDimension(null, record);
        ArrayList<Dimension> records = new ArrayList<Dimension>(1);
        records.add(record);
        Variable timeVar = new Variable(this.ncfile, null, null, TIME_VAR, DataType.DOUBLE, null);
        timeVar.addAttribute(new Attribute("units", "seconds since 1970-01-01 00:00:00"));
        timeVar.addAttribute(new Attribute("long_name", TIME_VAR));
        this.ncfile.addDimension(null, DIM_LEN4);
        this.ncfile.addDimension(null, DIM_LEN2);
        List<Variable> stationVars = this.makeStationVars(stations, null);
        List<GempakParameter> params = this.gemreader.getParameters("SFDT");
        if (params == null) {
            return;
        }
        Structure sVar = new Structure(this.ncfile, null, null, "Obs");
        sVar.setDimensions(records);
        for (Variable stnVar : stationVars) {
            sVar.addMemberVariable(stnVar);
        }
        sVar.addMemberVariable(timeVar);
        for (GempakParameter param : params) {
            Variable var = this.makeParamVariable(param, null);
            sVar.addMemberVariable(var);
        }
        sVar.addMemberVariable(this.makeMissingVariable());
        sVar.addAttribute(new Attribute("coordinates", "Obs.time Obs.SLAT Obs.SLON Obs.SELV"));
        this.ncfile.addVariable(null, sVar);
        this.ncfile.addAttribute(null, new Attribute("CF:featureType", CF.FeatureType.point.toString()));
    }

    private void buildClimateFile() {
    }

    private void addGlobalAttributes() {
        this.ncfile.addAttribute(null, new Attribute("Conventions", "GEMPAK/CDM"));
        String fileType = "GEMPAK Surface (" + this.gemreader.getSurfaceFileType() + ")";
        this.ncfile.addAttribute(null, new Attribute("file_format", fileType));
        this.ncfile.addAttribute(null, new Attribute("history", "Direct read of " + fileType + " into NetCDF-Java 4.0 API"));
    }

    private int getStnVarSize(String name) {
        int size = -1;
        for (int i = 0; i < stnVarNames.length; ++i) {
            if (!name.equals(stnVarNames[i])) continue;
            size = stnVarSizes[i];
            break;
        }
        return size;
    }

    private List<Variable> makeStationVars(List<GempakStation> stations, Dimension dim) {
        int numStations = stations.size();
        GempakStation sample = stations.get(0);
        boolean useSTID = true;
        for (GempakStation station : stations) {
            if (!station.getSTID().equals("")) continue;
            useSTID = false;
            break;
        }
        ArrayList<Variable> vars = new ArrayList<Variable>();
        List<String> stnKeyNames = this.gemreader.getStationKeyNames();
        for (String varName : stnKeyNames) {
            Variable v = this.makeStationVariable(varName, dim);
            Attribute stIDAttr = new Attribute("standard_name", "station_id");
            if (varName.equals("STID") && useSTID) {
                v.addAttribute(stIDAttr);
            }
            if (varName.equals("STNM") && !useSTID) {
                v.addAttribute(stIDAttr);
            }
            vars.add(v);
        }
        if (dim != null) {
            for (Variable v : vars) {
                Array varArray;
                if (v.getDataType().equals((Object)DataType.CHAR)) {
                    int[] shape = v.getShape();
                    varArray = new ArrayChar.D2(shape[0], shape[1]);
                } else {
                    varArray = this.get1DArray(v.getDataType(), numStations);
                }
                int index = 0;
                String varname = v.getName();
                for (GempakStation stn : stations) {
                    String test = "";
                    if (varname.equals("STID")) {
                        test = stn.getName();
                    } else if (varname.equals("STNM")) {
                        ((ArrayInt.D1)varArray).set(index, stn.getSTNM());
                    } else if (varname.equals("SLAT")) {
                        ((ArrayFloat.D1)varArray).set(index, (float)stn.getLatitude());
                    } else if (varname.equals("SLON")) {
                        ((ArrayFloat.D1)varArray).set(index, (float)stn.getLongitude());
                    } else if (varname.equals("SELV")) {
                        ((ArrayFloat.D1)varArray).set(index, (float)stn.getAltitude());
                    } else if (varname.equals("STAT")) {
                        test = stn.getSTAT();
                    } else if (varname.equals("COUN")) {
                        test = stn.getCOUN();
                    } else if (varname.equals("STD2")) {
                        test = stn.getSTD2();
                    } else if (varname.equals("SPRI")) {
                        ((ArrayInt.D1)varArray).set(index, stn.getSPRI());
                    } else if (varname.equals("SWFO")) {
                        test = stn.getSWFO();
                    } else if (varname.equals("WFO2")) {
                        test = stn.getWFO2();
                    }
                    if (!test.equals("")) {
                        ((ArrayChar.D2)varArray).setString(index, test);
                    }
                    ++index;
                }
                v.setCachedData(varArray, false);
            }
        }
        return vars;
    }

    private Array get1DArray(DataType type, int len) {
        Array varArray = null;
        if (type.equals((Object)DataType.FLOAT)) {
            varArray = new ArrayFloat.D1(len);
        } else if (type.equals((Object)DataType.DOUBLE)) {
            varArray = new ArrayDouble.D1(len);
        } else if (type.equals((Object)DataType.INT)) {
            varArray = new ArrayInt.D1(len);
        }
        return varArray;
    }

    private Variable makeStationVariable(String varname, Dimension firstDim) {
        String longName = varname;
        String unit = null;
        DataType type = DataType.CHAR;
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (firstDim != null) {
            dims.add(firstDim);
        }
        if (varname.equals("STID")) {
            longName = "Station identifier";
            dims.add(DIM_LEN8);
        } else if (varname.equals("STNM")) {
            longName = "WMO station id";
            type = DataType.INT;
        } else if (varname.equals("SLAT")) {
            longName = "latitude";
            unit = "degrees_north";
            type = DataType.FLOAT;
            attrs.add(new Attribute("standard_name", "latitude"));
        } else if (varname.equals("SLON")) {
            longName = "longitude";
            unit = "degrees_east";
            type = DataType.FLOAT;
            attrs.add(new Attribute("standard_name", "longitude"));
        } else if (varname.equals("SELV")) {
            longName = "altitude";
            unit = "meter";
            type = DataType.FLOAT;
            attrs.add(new Attribute("positive", "up"));
        } else if (varname.equals("STAT")) {
            longName = "state or province";
            dims.add(DIM_LEN2);
        } else if (varname.equals("COUN")) {
            longName = "country code";
            dims.add(DIM_LEN2);
        } else if (varname.equals("STD2")) {
            longName = "Extended station id";
            dims.add(DIM_LEN4);
        } else if (varname.equals("SPRI")) {
            longName = "Station priority";
            type = DataType.INT;
        } else if (varname.equals("SWFO")) {
            longName = "WFO code";
            dims.add(DIM_LEN4);
        } else if (varname.equals("WFO2")) {
            longName = "Second WFO code";
            dims.add(DIM_LEN4);
        }
        Variable v = new Variable(this.ncfile, null, null, varname);
        v.setDataType(type);
        v.addAttribute(new Attribute("long_name", longName));
        if (unit != null) {
            v.addAttribute(new Attribute("units", unit));
        }
        if (type.equals((Object)DataType.FLOAT)) {
            v.addAttribute(new Attribute("missing_value", RMISS));
        } else if (type.equals((Object)DataType.INT)) {
            v.addAttribute(new Attribute("missing_value", IMISS));
        }
        if (!attrs.isEmpty()) {
            for (Attribute attr : attrs) {
                v.addAttribute(attr);
            }
        }
        if (!dims.isEmpty()) {
            v.setDimensions(dims);
        } else {
            v.setDimensions((String)null);
        }
        return v;
    }

    private void printStack(String msg, int maxLines) {
        String trace = this.getStackTrace();
        if (msg != null) {
            System.out.println(msg);
        }
        StringTokenizer tok = new StringTokenizer(trace, "\n");
        int allcnt = 0;
        int cnt = 0;
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            if (++allcnt <= 4) continue;
            System.out.println(line);
            if (++cnt <= maxLines) continue;
            break;
        }
    }

    private String getStackTrace() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new IllegalArgumentException("").printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    protected static class MakeNetcdfFile
    extends NetcdfFile {
        MakeNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }
}

