/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.grib1.Grib1GDSVariables;
import ucar.grib.grib1.Grib1GridTableLookup;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.grid.GridDefRecord;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridVertCoord
implements Comparable {
    private static Logger logger = LoggerFactory.getLogger(GridVertCoord.class);
    private GridRecord typicalRecord;
    private String levelName;
    private GridTableLookup lookup;
    private int seq = 0;
    private double[] coordValues;
    boolean usesBounds = false;
    boolean dontUseVertical = false;
    String positive = "up";
    String units;
    private List<LevelCoord> levels = new ArrayList<LevelCoord>();

    GridVertCoord(String name) {
        this.levelName = name;
        this.dontUseVertical = true;
    }

    GridVertCoord(List<GridRecord> records, String levelName, GridTableLookup lookup, GridHorizCoordSys hcs) {
        this.typicalRecord = records.get(0);
        this.levelName = levelName;
        this.lookup = lookup;
        this.dontUseVertical = !lookup.isVerticalCoordinate(this.typicalRecord);
        this.positive = lookup.isPositiveUp(this.typicalRecord) ? "up" : "down";
        this.units = lookup.getLevelUnit(this.typicalRecord);
        this.usesBounds = lookup.isLayer(this.typicalRecord);
        this.addLevels(records);
        if (this.typicalRecord.getLevelType1() == 109 && lookup instanceof Grib1GridTableLookup) {
            this.checkForPressureLevels(records, hcs);
        }
        if (GridServiceProvider.debugVert) {
            System.out.println("GribVertCoord: " + this.getVariableName() + "(" + this.typicalRecord.getLevelType1() + ") useVertical= " + !this.dontUseVertical + " positive=" + this.positive + " units=" + this.units);
        }
    }

    GridVertCoord(GridRecord record, String levelName, GridTableLookup lookup, double[] level1, double[] level2) {
        this.typicalRecord = record;
        this.levelName = levelName;
        this.lookup = lookup;
        this.positive = lookup.isPositiveUp(record) ? "up" : "down";
        this.units = lookup.getLevelUnit(record);
        this.usesBounds = lookup.isLayer(this.typicalRecord);
        this.levels = new ArrayList<LevelCoord>(level1.length);
        for (int i = 0; i < level1.length; ++i) {
            this.levels.add(new LevelCoord(level1[i], level2 == null ? 0.0 : level2[i]));
        }
        Collections.sort(this.levels);
        if (this.positive.equals("down")) {
            Collections.reverse(this.levels);
        }
        this.dontUseVertical = this.levels.size() == 1;
    }

    void setSequence(int seq) {
        this.seq = seq;
    }

    String getLevelName() {
        return this.levelName;
    }

    String getVariableName() {
        return this.seq == 0 ? this.levelName : this.levelName + this.seq;
    }

    int getNLevels() {
        return this.dontUseVertical ? 1 : this.levels.size();
    }

    void addLevels(List<GridRecord> records) {
        for (int i = 0; i < records.size(); ++i) {
            GridRecord record = records.get(i);
            if (this.coordIndex(record) >= 0) continue;
            this.levels.add(new LevelCoord(record.getLevel1(), record.getLevel2()));
            if (!this.dontUseVertical || this.levels.size() <= 1 || !GridServiceProvider.debugVert) continue;
            logger.warn("GribCoordSys: unused level coordinate has > 1 levels = " + this.levelName + " " + record.getLevelType1() + " " + this.levels.size());
        }
        Collections.sort(this.levels);
        if (this.positive.equals("down")) {
            Collections.reverse(this.levels);
        }
    }

    boolean matchLevels(List<GridRecord> records) {
        ArrayList<LevelCoord> levelList = new ArrayList<LevelCoord>(records.size());
        for (GridRecord record : records) {
            LevelCoord lc = new LevelCoord(record.getLevel1(), record.getLevel2());
            if (levelList.contains(lc)) continue;
            levelList.add(lc);
        }
        Collections.sort(levelList);
        if (this.positive.equals("down")) {
            Collections.reverse(levelList);
        }
        return ((Object)levelList).equals(this.levels);
    }

    void checkForPressureLevels(List<GridRecord> records, GridHorizCoordSys hcs) {
        GridDefRecord gdr = hcs.getGds();
        Grib1GDSVariables g1dr = (Grib1GDSVariables)gdr.getGdsv();
        if (g1dr == null || !g1dr.hasVerticalPressureLevels()) {
            return;
        }
        int NV = g1dr.getNV() / 2 - 1;
        this.coordValues = new double[this.levels.size() * NV];
        int idx = 0;
        for (LevelCoord lc : this.levels) {
            double[] plevels = g1dr.getVerticalPressureLevels(lc.value1);
            System.arraycopy(plevels, 0, this.coordValues, idx, NV);
            idx += NV;
        }
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile, Group g) {
        if (this.dontUseVertical) {
            return;
        }
        int nlevs = this.levels.size();
        ncfile.addDimension(g, new Dimension(this.getVariableName(), nlevs, true));
    }

    void addToNetcdfFile(NetcdfFile ncfile, Group g) {
        if (this.dontUseVertical) {
            this.typicalRecord = null;
            return;
        }
        if (g == null) {
            g = ncfile.getRootGroup();
        }
        Variable v = new Variable(ncfile, g, null, this.getVariableName());
        v.setDataType(DataType.DOUBLE);
        String desc = this.lookup.getLevelDescription(this.typicalRecord);
        if (this.lookup instanceof Grib2GridTableLookup && this.usesBounds) {
            desc = "Layer between " + desc;
        }
        v.addAttribute(new Attribute("long_name", desc));
        v.addAttribute(new Attribute("units", this.lookup.getLevelUnit(this.typicalRecord)));
        if (this.positive != null) {
            v.addAttribute(new Attribute("positive", this.positive));
        }
        if (this.units != null) {
            AxisType axisType = SimpleUnit.isCompatible("millibar", this.units) ? AxisType.Pressure : (SimpleUnit.isCompatible("m", this.units) ? AxisType.Height : AxisType.GeoZ);
            if (this.lookup instanceof Grib2GridTableLookup || this.lookup instanceof Grib1GridTableLookup) {
                v.addAttribute(new Attribute("GRIB_level_type", Integer.toString(this.typicalRecord.getLevelType1())));
            } else {
                v.addAttribute(new Attribute("level_type", Integer.toString(this.typicalRecord.getLevelType1())));
            }
            v.addAttribute(new Attribute("_CoordinateAxisType", axisType.toString()));
        }
        if (this.coordValues == null) {
            this.coordValues = new double[this.levels.size()];
            for (int i = 0; i < this.levels.size(); ++i) {
                LevelCoord lc = this.levels.get(i);
                this.coordValues[i] = lc.mid;
            }
        }
        Array dataArray = Array.factory(DataType.DOUBLE, new int[]{this.coordValues.length}, (Object)this.coordValues);
        v.setDimensions(this.getVariableName());
        v.setCachedData(dataArray, true);
        ncfile.addVariable(g, v);
        if (this.usesBounds) {
            String boundsDimName = "bounds_dim";
            if (g.findDimension(boundsDimName) == null) {
                ncfile.addDimension(g, new Dimension(boundsDimName, 2, true));
            }
            String bname = this.getVariableName() + "_bounds";
            v.addAttribute(new Attribute("bounds", bname));
            v.addAttribute(new Attribute("_CoordinateZisLayer", "true"));
            Variable b = new Variable(ncfile, g, null, bname);
            b.setDataType(DataType.DOUBLE);
            b.setDimensions(this.getVariableName() + " " + boundsDimName);
            b.addAttribute(new Attribute("long_name", "bounds for " + v.getName()));
            b.addAttribute(new Attribute("units", this.lookup.getLevelUnit(this.typicalRecord)));
            Array boundsArray = Array.factory(DataType.DOUBLE, new int[]{this.coordValues.length, 2});
            Index ima = boundsArray.getIndex();
            for (int i = 0; i < this.coordValues.length; ++i) {
                LevelCoord lc = this.levels.get(i);
                boundsArray.setDouble(ima.set(i, 0), lc.value1);
                boundsArray.setDouble(ima.set(i, 1), lc.value2);
            }
            b.setCachedData(boundsArray, true);
            ncfile.addVariable(g, b);
        }
    }

    void empty() {
        this.typicalRecord = null;
    }

    int getIndex(GridRecord record) {
        if (this.dontUseVertical) {
            return 0;
        }
        return this.coordIndex(record);
    }

    public int compareTo(Object o) {
        GridVertCoord gv = (GridVertCoord)o;
        return this.getLevelName().compareToIgnoreCase(gv.getLevelName());
    }

    private int coordIndex(GridRecord record) {
        double val = record.getLevel1();
        double val2 = record.getLevel2();
        if (this.usesBounds && val > val2) {
            val = record.getLevel2();
            val2 = record.getLevel1();
        }
        for (int i = 0; i < this.levels.size(); ++i) {
            LevelCoord lc = this.levels.get(i);
            if (!(this.usesBounds ? Misc.closeEnough(lc.value1, val) && Misc.closeEnough(lc.value2, val2) : Misc.closeEnough(lc.value1, val))) continue;
            return i;
        }
        return -1;
    }

    private class LevelCoord
    implements Comparable {
        double mid;
        double value1;
        double value2;

        LevelCoord(double value1, double value2) {
            this.value1 = value1;
            this.value2 = value2;
            if (GridVertCoord.this.usesBounds && value1 > value2) {
                this.value1 = value2;
                this.value2 = value1;
            }
            this.mid = GridVertCoord.this.usesBounds ? (value1 + value2) / 2.0 : value1;
        }

        public int compareTo(Object o) {
            LevelCoord other = (LevelCoord)o;
            if (this.mid < other.mid) {
                return -1;
            }
            if (this.mid > other.mid) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof LevelCoord)) {
                return false;
            }
            LevelCoord other = (LevelCoord)oo;
            return Misc.closeEnough(this.value1, other.value1) && Misc.closeEnough(this.value2, other.value2);
        }

        public int hashCode() {
            return (int)(this.value1 * 100000.0 + this.value2 * 100.0);
        }
    }
}

