/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eso.fits.FitsException;
import org.eso.fits.FitsHeader;
import org.eso.fits.FitsKeyword;

public class FitsData {
    protected int type;
    protected int[] naxis;
    protected long size;
    protected int bitpix = 0;
    protected int noParm = 0;
    protected int noGroup = 1;
    protected boolean changeData = false;
    protected RandomAccessFile dataFile = null;
    protected long dataOffset = 0L;
    protected byte[] dataArray = null;
    protected boolean isRAFile = false;

    public FitsData(FitsHeader fitsHeader, DataInput dataInput, boolean bl) throws FitsException {
        if (dataInput instanceof RandomAccessFile) {
            this.dataFile = (RandomAccessFile)dataInput;
            try {
                this.dataOffset = this.dataFile.getFilePointer();
            }
            catch (IOException iOException) {
                throw new FitsException("Cannot read data offset", 1);
            }
            this.isRAFile = true;
        }
        this.size = fitsHeader.getDataSize();
        this.type = fitsHeader.getType();
        long l = this.size;
        if (this.size % 2880L != 0L) {
            l = (this.size / 2880L + 1L) * 2880L;
        }
        try {
            if (bl && !this.isRAFile) {
                this.dataArray = new byte[(int)l];
                dataInput.readFully(this.dataArray);
            } else {
                dataInput.skipBytes((int)l);
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot read/skip over data matrix", 1);
        }
        this.decodeBasicHeader(fitsHeader);
    }

    public FitsData(int n, int[] nArray) throws FitsException {
        switch (n) {
            case -64: 
            case -32: 
            case 8: 
            case 16: 
            case 32: {
                this.bitpix = n;
                break;
            }
            default: {
                throw new FitsException("Invalid BITPIX value", 5);
            }
        }
        this.type = 0;
        this.size = 1L;
        this.naxis = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.naxis[i] = nArray[i];
            this.size *= (long)this.naxis[i];
        }
        this.size *= (long)(Math.abs(this.bitpix) / 8);
        if (this.size < 0L) {
            throw new FitsException("Data size less than zero", 5);
        }
        long l = this.size;
        if (this.size % 2880L != 0L) {
            l = (this.size / 2880L + 1L) * 2880L;
        }
        this.dataArray = new byte[(int)l];
    }

    private void decodeBasicHeader(FitsHeader fitsHeader) throws FitsException {
        FitsKeyword fitsKeyword = fitsHeader.getKeyword("NAXIS");
        if (fitsKeyword == null) {
            throw new FitsException("Missing NAXIS keyword", 4);
        }
        int n = fitsKeyword.getInt();
        this.naxis = new int[n];
        fitsKeyword = fitsHeader.getKeyword("BITPIX");
        if (fitsKeyword == null) {
            throw new FitsException("Missing BITPIX keyword", 4);
        }
        this.bitpix = fitsKeyword.getInt();
        for (int i = 1; i <= n; ++i) {
            fitsKeyword = fitsHeader.getKeyword("NAXIS" + i);
            if (fitsKeyword == null) {
                throw new FitsException("Missing NAXISn keyword", 4);
            }
            this.naxis[i - 1] = fitsKeyword.getInt();
        }
        fitsKeyword = fitsHeader.getKeyword("GCOUNT");
        this.noGroup = fitsKeyword == null ? 1 : fitsKeyword.getInt();
        fitsKeyword = fitsHeader.getKeyword("PCOUNT");
        this.noParm = fitsKeyword == null ? 0 : fitsKeyword.getInt();
        this.changeData = false;
    }

    public FitsHeader getHeader() {
        FitsHeader fitsHeader = new FitsHeader();
        fitsHeader.addKeyword(new FitsKeyword("SIMPLE", true, "Standard FITS format; NOST 100-2.0"));
        fitsHeader.addKeyword(new FitsKeyword("BITPIX", this.bitpix, "No. of bits per pixel"));
        fitsHeader.addKeyword(new FitsKeyword("NAXIS", this.naxis.length, "No. of axes in image"));
        for (int i = 1; i <= this.naxis.length; ++i) {
            fitsHeader.addKeyword(new FitsKeyword("NAXIS" + i, this.naxis[i - 1], "No. of pixels"));
        }
        fitsHeader.addKeyword(new FitsKeyword("PCOUNT", 0, "Parameter count"));
        fitsHeader.addKeyword(new FitsKeyword("GCOUNT", 1, "Groupe count"));
        return fitsHeader;
    }

    public void writeFile(DataOutput dataOutput) throws IOException, FitsException {
        int n;
        byte[] byArray;
        int n2 = 0;
        int n3 = 28800;
        if (this.isRAFile) {
            byArray = new byte[n3];
            this.dataFile.seek(this.dataOffset);
            n = (int)this.size / n3;
            while (0 < n--) {
                this.dataFile.read(byArray);
                dataOutput.write(byArray);
            }
            n2 = (int)this.size % n3;
            if (n2 == 0) {
                return;
            }
            byArray = new byte[n2];
            this.dataFile.read(byArray);
            dataOutput.write(byArray);
        } else if (this.dataArray != null) {
            dataOutput.write(this.dataArray);
        }
        if (n2 % 2880 != 0) {
            n2 = 2880 * (n2 / 2880 + 1) - n2;
            byArray = new byte[n2];
            if (this.type == 3) {
                for (n = 0; n < n2; ++n) {
                    byArray[n] = 32;
                }
            }
            dataOutput.write(byArray);
        }
    }

    public void closeFile() {
        this.dataFile = null;
        this.dataOffset = 0L;
        this.size = 0L;
        this.type = 0;
    }

    public int getNoAxes() {
        return this.naxis.length;
    }

    public int getType() {
        return this.type;
    }

    public int[] getNaxis() {
        return this.naxis;
    }
}

