/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.asdatasource;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.binarydatasource.BufferDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.capability.Updating;
import org.virbo.dsops.Ops;

public class AudioSystemDataSource
extends AbstractDataSource
implements Updating {
    public static final double LEN_SECONDS = 1.0;
    public static final int SAMPLE_RATE = 8000;
    ByteBuffer dataBuffer;
    ReadableByteChannel audioChannel;
    int nsamples;
    int spec = -1;
    PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);

    public AudioSystemDataSource(URI uri) {
        super(uri);
        String sspec = (String)this.getParams().get("spec");
        if (sspec != null) {
            this.spec = Integer.parseInt(sspec);
        }
        this.addCability(Updating.class, (Object)this);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        double lenSeconds = 1.0;
        this.nsamples = (int)(lenSeconds * 8000.0);
        int len = this.nsamples * 4;
        int nchannels = 1;
        int bitsPerSample = 16;
        int frameSize = bitsPerSample / (nchannels * 8);
        this.dataBuffer = ByteBuffer.allocateDirect(len);
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, bitsPerSample, nchannels, frameSize, 8000.0f, false);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
        targetDataLine.open(audioFormat);
        AudioInputStream audioInputStream = new AudioInputStream(targetDataLine);
        audioFormat = audioInputStream.getFormat();
        targetDataLine.start();
        this.audioChannel = Channels.newChannel(audioInputStream);
        mon.setTaskSize((long)len);
        mon.started();
        this.dataBuffer.limit(2048);
        this.fillBuffer(mon);
        mon.finished();
        this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        BufferDataSet ds = BufferDataSet.makeDataSet((int)1, (int)2, (int)0, (int)this.nsamples, (int)1, (int)1, (int)1, (ByteBuffer)this.dataBuffer, (Object)BufferDataSet.SHORT);
        if (this.spec > -1) {
            ds = Ops.fftWindow((QDataSet)ds, (int)this.spec);
        }
        return ds;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private void fillBuffer(ProgressMonitor mon) throws IllegalArgumentException, IOException {
        System.err.println("fillBuffer" + this.dataBuffer);
        while (this.dataBuffer.position() < this.dataBuffer.capacity()) {
            this.audioChannel.read(this.dataBuffer);
            this.dataBuffer.limit(Math.min(this.dataBuffer.position() + 2048, this.dataBuffer.capacity()));
            mon.setTaskProgress((long)this.dataBuffer.position());
        }
    }
}

