/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdfdatasource;

import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.cdfdatasource.CdfDataSetUtil;
import org.virbo.cdfdatasource.CdfFileDataSourceFactory;
import org.virbo.cdfdatasource.CdfUtil;
import org.virbo.cdfdatasource.CdfVirtualVars;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.MetadataModel;
import org.virbo.dsops.Ops;
import org.virbo.metatree.IstpMetadataModel;
import org.virbo.metatree.MetadataUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdfFileDataSource
extends AbstractDataSource {
    protected static final String PARAM_DODEP = "doDep";
    protected static final String PARAM_INTERPMETA = "interpMeta";
    protected static final String PARAM_ID = "id";
    protected static final String PARAM_SLICE1 = "slice1";
    Map properties;
    Map<String, Object> attributes;
    private static final Logger logger = Logger.getLogger(CdfFileDataSource.class.getName());

    public CdfFileDataSource(URI uri) {
        super(uri);
    }

    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws IOException, CDFException, ParseException {
        mon.started();
        File cdfFile = this.getFile(mon);
        logger.log(Level.FINE, "reading {0}", this.resourceURI);
        mon.setProgressMessage("retrieving file...");
        String fileName = cdfFile.toString();
        Map map = this.getParams();
        mon.setProgressMessage("opening file...");
        CDF cdf = CdfFileDataSourceFactory.getCDFFile(fileName);
        mon.setProgressMessage("done opening file");
        String svariable = (String)map.get(PARAM_ID);
        if (svariable == null) {
            svariable = (String)map.get("arg_0");
        }
        mon.setProgressMessage("reading " + svariable);
        if (svariable == null) {
            throw new IllegalArgumentException("CDF URI needs an argument");
        }
        String constraint = null;
        int i = svariable.indexOf("[");
        if (i != -1) {
            constraint = svariable.substring(i);
            svariable = svariable.substring(0, i);
        }
        try {
            boolean doDep;
            MutablePropertyDataSet result;
            Variable variable = cdf.getVariable(svariable);
            String interpMeta = (String)map.get(PARAM_INTERPMETA);
            if (!"no".equals(interpMeta)) {
                long numRec = variable.getMaxWrittenRecord() + 1L;
                long[] recs = DataSourceUtil.parseConstraint((String)constraint, (long)numRec);
                this.attributes = this.readAttributes(cdf, variable, 0);
                if (recs[2] == -1L) {
                    this.attributes = MetadataUtil.sliceProperties(this.attributes, (int)0);
                }
            }
            if (this.attributes != null && this.attributes.containsKey("VIRTUAL") && this.attributes.containsKey("FUNCTION")) {
                ArrayList<QDataSet> attr = new ArrayList<QDataSet>();
                String function = (String)this.attributes.get("FUNCTION");
                if (this.attributes.get("COMPONENT_0") != null) {
                    attr.add((QDataSet)this.wrapDataSet(cdf, (String)this.attributes.get("COMPONENT_0"), constraint, false, true, mon));
                }
                if (this.attributes.get("COMPONENT_1") != null) {
                    attr.add((QDataSet)this.wrapDataSet(cdf, (String)this.attributes.get("COMPONENT_1"), constraint, false, true, mon));
                }
                if (this.attributes.get("COMPONENT_2") != null) {
                    attr.add((QDataSet)this.wrapDataSet(cdf, (String)this.attributes.get("COMPONENT_2"), constraint, false, true, mon));
                }
                if (this.attributes.get("COMPONENT_3") != null) {
                    attr.add((QDataSet)this.wrapDataSet(cdf, (String)this.attributes.get("COMPONENT_3"), constraint, false, true, mon));
                }
                if (this.attributes.get("COMPONENT_4") != null) {
                    attr.add((QDataSet)this.wrapDataSet(cdf, (String)this.attributes.get("COMPONENT_4"), constraint, false, true, mon));
                }
                try {
                    Map qmetadata = new IstpMetadataModel().properties(this.attributes);
                    result = (MutablePropertyDataSet)CdfVirtualVars.execute(qmetadata, function, attr, mon);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("virtual function " + function + " not supported", ex);
                }
            } else {
                result = this.wrapDataSet(cdf, svariable, constraint, false, true, mon);
            }
            CdfFileDataSourceFactory.closeCDF(cdf);
            boolean bl = doDep = !"no".equals(map.get(PARAM_DODEP));
            if (!doDep) {
                result.putProperty("DEPEND_0", null);
                result.putProperty("DEPEND_1", null);
                result.putProperty("DEPEND_2", null);
                result.putProperty("DEPEND_3", null);
                if (this.attributes != null) {
                    this.attributes.remove("DEPEND_0");
                    this.attributes.remove("DEPEND_1");
                    this.attributes.remove("DEPEND_2");
                    this.attributes.remove("DEPEND_3");
                }
            }
            if (!"no".equals(interpMeta)) {
                IstpMetadataModel model = new IstpMetadataModel();
                Map istpProps = model.properties(this.attributes);
                this.maybeAddValidRange(istpProps, result);
                result.putProperty("FILL_VALUE", istpProps.get("FILL_VALUE"));
                result.putProperty("LABEL", istpProps.get("FIELDNAM"));
                result.putProperty("TITLE", istpProps.get("CATDESC"));
                if (result.rank() < 3 && result.rank() == 2 && result.length() > 0 && result.length(0) < 50) {
                    String rt = (String)istpProps.get("RENDER_TYPE");
                    if (rt != null) {
                        result.putProperty("RENDER_TYPE", (Object)rt);
                    }
                    if (istpProps.get("RENDER_TYPE") == null && result.property("DEPEND_1") == null) {
                        result.putProperty("RENDER_TYPE", (Object)"time_series");
                    }
                }
                for (int j = 0; j < 4; ++j) {
                    MutablePropertyDataSet depds = (MutablePropertyDataSet)result.property("DEPEND_" + j);
                    Map depProps = (Map)istpProps.get("DEPEND_" + j);
                    if (depds == null || depProps == null) continue;
                    this.maybeAddValidRange(depProps, depds);
                    depds.putProperty("FILL_VALUE", depProps.get("FILL_VALUE"));
                    depds.putProperty("LABEL", depProps.get("FIELDNAM"));
                    depds.putProperty("TITLE", depProps.get("CATDESC"));
                }
            } else {
                QDataSet dep = (QDataSet)result.property("DEPEND_0");
                if (dep != null && dep.length() != result.length()) {
                    result.putProperty("DEPEND_0", null);
                }
                result.putProperty("DEPEND_1", null);
                result.putProperty("DEPEND_2", null);
                result.putProperty("DEPEND_3", null);
            }
            result.putProperty("METADATA", this.attributes);
            result.putProperty("METADATA_MODEL", (Object)"ISTP-CDF");
            String os1 = (String)map.get(PARAM_SLICE1);
            if (os1 != null && !os1.equals("") && result.rank() > 1) {
                int is = Integer.parseInt(os1);
                result = DataSetOps.slice1((QDataSet)result, (int)is);
                this.attributes = null;
            }
            MutablePropertyDataSet mutablePropertyDataSet = result;
            return mutablePropertyDataSet;
        }
        catch (CDFException ex) {
            throw new IllegalArgumentException("no such variable: " + svariable);
        }
        finally {
            mon.finished();
        }
    }

    private Variable maybeGetVariable(Vector vars, String name) {
        for (Object ov : vars) {
            Variable v = (Variable)ov;
            if (!v.getName().equals(name)) continue;
            return v;
        }
        return null;
    }

    private MutablePropertyDataSet wrapDataSet(CDF cdf, String svariable, String constraints, boolean reform, boolean depend, ProgressMonitor mon) throws CDFException, ParseException {
        Map dep0map;
        MutablePropertyDataSet result;
        boolean slice;
        Variable variable = cdf.getVariable(svariable);
        HashMap<String, Object> thisAttributes = this.readAttributes(cdf, variable, 0);
        long numRec = variable.getMaxWrittenRecord() + 1L;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        if (numRec == 0L) {
            if (thisAttributes.containsKey("COMPONENT_0")) {
                MutablePropertyDataSet c0 = this.wrapDataSet(cdf, (String)thisAttributes.get("COMPONENT_0"), constraints, true, false, null);
                if (thisAttributes.containsKey("COMPONENT_1")) {
                    MutablePropertyDataSet c1 = this.wrapDataSet(cdf, (String)thisAttributes.get("COMPONENT_1"), constraints, false, false, null);
                    if (c0.rank() == 1 && CdfDataSetUtil.validCount((QDataSet)c0, 2) == 1 && c1.length() > 1 && Units.cdfEpoch == (c0 = DataSetOps.slice0((QDataSet)c0, (int)0)).property("UNITS")) {
                        double value = ((RankZeroDataSet)c0).value();
                        double valueUs2000 = Units.cdfEpoch.convertDoubleTo((Units)Units.us2000, value);
                        c0 = DataSetUtil.asDataSet((Datum)Units.us2000.createDatum(valueUs2000));
                    }
                    if (c0.property("UNITS") != null && c1.property("UNITS") != null) {
                        c0 = CdfDataSetUtil.add((QDataSet)c0, (QDataSet)c1);
                    }
                }
                return DDataSet.maybeCopy((QDataSet)c0);
            }
            throw new IllegalArgumentException("variable " + svariable + " contains no records!");
        }
        long[] recs = DataSourceUtil.parseConstraint((String)constraints, (long)numRec);
        boolean bl = slice = recs[1] == -1L;
        if (reform) {
            result = CdfUtil.wrapCdfHyperData(variable, 0L, -1L, 1L);
        } else {
            long recCount = (recs[1] - recs[0]) / recs[2];
            if (slice) {
                recCount = -1L;
                recs[2] = 1L;
            }
            result = CdfUtil.wrapCdfHyperDataHacked(variable, recs[0], recCount, recs[2], mon);
        }
        result.putProperty("NAME", (Object)svariable);
        boolean doUnits = true;
        if (thisAttributes.containsKey("UNITS")) {
            String sunits = (String)thisAttributes.get("UNITS");
            Units mu = sunits.equalsIgnoreCase("row number") || sunits.equalsIgnoreCase("column number") ? Units.dimensionless : SemanticOps.lookupUnits((String)sunits);
            Units u = (Units)result.property("UNITS");
            if (u == null) {
                result.putProperty("UNITS", (Object)mu);
            }
        }
        if (slice && depend && (dep0map = (Map)thisAttributes.get("DEPEND_0")) != null) {
            MutablePropertyDataSet dep0 = this.wrapDataSet(cdf, (String)dep0map.get("NAME"), constraints, false, false, null);
            result.putProperty("CONTEXT_0", (Object)dep0);
        }
        int[] qubeDims = DataSetUtil.qubeDims((QDataSet)result);
        if (depend) {
            for (int idep = 0; idep < 4; ++idep) {
                int sidep = slice ? idep + 1 : idep;
                Map dep = (Map)thisAttributes.get("DEPEND_" + sidep);
                String labl = (String)thisAttributes.get("LABL_PTR_" + sidep);
                if (labl == null) {
                    labl = (String)thisAttributes.get("LABEL_" + sidep);
                }
                if (dep != null && qubeDims.length <= idep) {
                    logger.log(Level.INFO, "DEPEND_{0} found but data is lower rank", idep);
                    continue;
                }
                if (dep != null && (qubeDims[idep] > 6 || labl == null)) {
                    try {
                        boolean reformDep;
                        boolean bl2 = reformDep = idep > 0;
                        if (reformDep && cdf.getVariable((String)dep.get("NAME")).getRecVariance()) {
                            reformDep = false;
                        }
                        MutablePropertyDataSet depDs = this.wrapDataSet(cdf, (String)dep.get("NAME"), idep == 0 ? constraints : null, reformDep, false, null);
                        if (idep > 0 && !reformDep && depDs.length() == 1 && qubeDims[0] > depDs.length()) {
                            depDs = (MutablePropertyDataSet)depDs.slice(0);
                        }
                        if (idep == 0 && depDs.length() != result.length() && result.length() == 1) continue;
                        if (depDs.rank() == 2 && depDs.length(0) == 2) {
                            MutablePropertyDataSet depDs1 = (MutablePropertyDataSet)Ops.reduceMean((QDataSet)depDs, (int)1);
                            MutablePropertyDataSet binmax = DataSetOps.slice1((QDataSet)depDs, (int)1);
                            MutablePropertyDataSet binmin = DataSetOps.slice1((QDataSet)depDs, (int)0);
                            depDs1.putProperty("DELTA_MINUS", (Object)Ops.subtract((QDataSet)depDs1, (QDataSet)binmin));
                            depDs1.putProperty("DELTA_PLUS", (Object)Ops.subtract((QDataSet)binmax, (QDataSet)depDs1));
                            depDs = depDs1;
                        }
                        if (DataSetUtil.isMonotonic((QDataSet)depDs)) {
                            depDs.putProperty("MONOTONIC", (Object)Boolean.TRUE);
                        }
                        result.putProperty("DEPEND_" + idep, (Object)depDs);
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (labl == null) continue;
                try {
                    MutablePropertyDataSet depDs = this.wrapDataSet(cdf, labl, idep == 0 ? constraints : null, idep > 0, false, null);
                    result.putProperty("DEPEND_" + idep, (Object)depDs);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        boolean swapHack = false;
        if (result.rank() == 3) {
            int n1 = result.length(0);
            int n2 = result.length(0, 0);
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            QDataSet dep2 = (QDataSet)result.property("DEPEND_2");
            if (n1 != n2 && dep1 != null && dep1.length() == n2 && dep2 != null && dep2.length() == n1) {
                swapHack = true;
                System.err.println("swaphack avoids runtime error");
            }
        }
        if (slice && result.rank() == 2) {
            int n0 = result.length();
            int n1 = result.length(0);
            QDataSet dep0 = (QDataSet)result.property("DEPEND_0");
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            if (n0 != n1 && dep0 != null && dep0.length() == n1 && dep1 != null && dep1.length() == n0) {
                swapHack = true;
                System.err.println("swaphack avoids runtime error");
            }
        }
        if (swapHack && result.rank() == 3) {
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            QDataSet dep2 = (QDataSet)result.property("DEPEND_2");
            result.putProperty("DEPEND_2", (Object)dep1);
            result.putProperty("DEPEND_1", (Object)dep2);
            Object att1 = this.attributes.get("DEPEND_1");
            Object att2 = this.attributes.get("DEPEND_2");
            this.attributes.put("DEPEND_1", att2);
            this.attributes.put("DEPEND_2", att1);
        }
        if (swapHack && slice && result.rank() == 2) {
            QDataSet dep0 = (QDataSet)result.property("DEPEND_0");
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            result.putProperty("DEPEND_1", (Object)dep0);
            result.putProperty("DEPEND_0", (Object)dep1);
            Object att0 = this.attributes.get("DEPEND_0");
            Object att1 = this.attributes.get("DEPEND_1");
            this.attributes.put("DEPEND_0", att1);
            this.attributes.put("DEPEND_1", att0);
        }
        return result;
    }

    private HashMap<String, Object> readAttributes(CDF cdf, Variable var, int depth) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        Pattern p = Pattern.compile("DEPEND_[0-9]");
        Vector v = cdf.getAttributes();
        for (int ipass = 0; ipass < 2; ++ipass) {
            for (int ivar = 0; ivar < v.size(); ++ivar) {
                Attribute attr = (Attribute)v.get(ivar);
                Entry entry = null;
                try {
                    entry = attr.getEntry(var);
                    boolean isDep = p.matcher(attr.getName()).matches() & depth == 0;
                    if (ipass == 0 && isDep) {
                        Object val = entry.getData();
                        String name = (String)val;
                        HashMap<String, Object> newVal = this.readAttributes(cdf, cdf.getVariable(name), depth + 1);
                        newVal.put("NAME", name);
                        props.put(attr.getName(), newVal);
                        continue;
                    }
                    if (ipass != 1 || isDep) continue;
                    props.put(attr.getName(), entry.getData());
                    continue;
                }
                catch (CDFException e) {
                    // empty catch block
                }
            }
        }
        return props;
    }

    private void maybeAddValidRange(Map<String, Object> props, MutablePropertyDataSet ds) {
        String t;
        Number nmin;
        UnitsConverter uc;
        Units pu = (Units)props.get("UNITS");
        Units u = (Units)ds.property("UNITS");
        if (pu == null || u == null) {
            uc = UnitsConverter.IDENTITY;
        } else if (u == Units.cdfEpoch) {
            uc = UnitsConverter.IDENTITY;
        } else if (pu == Units.microseconds && u == Units.us2000) {
            uc = UnitsConverter.IDENTITY;
        } else if (pu == u) {
            uc = UnitsConverter.IDENTITY;
        } else {
            if (UnitsUtil.isOrdinalMeasurement((Units)u) || UnitsUtil.isOrdinalMeasurement((Units)pu)) {
                return;
            }
            try {
                uc = UnitsConverter.getConverter((Units)pu, (Units)u);
            }
            catch (InconvertibleUnitsException ex) {
                uc = UnitsConverter.IDENTITY;
            }
        }
        double dmin = Double.NEGATIVE_INFINITY;
        double dmax = Double.POSITIVE_INFINITY;
        if (ds.rank() == 1) {
            QDataSet range = Ops.extent((QDataSet)ds);
            dmin = uc.convert(range.value(0));
            dmax = uc.convert(range.value(1));
        }
        double vmin = (nmin = (Number)props.get("VALID_MIN")) == null ? Double.POSITIVE_INFINITY : nmin.doubleValue();
        Number nmax = (Number)props.get("VALID_MAX");
        double vmax = nmax == null ? Double.POSITIVE_INFINITY : nmax.doubleValue();
        boolean intersects = false;
        if (dmax > vmin && dmin < vmax) {
            intersects = true;
        }
        if (intersects || dmax == dmin || dmax < -1.0E30 || dmin > 1.0E30) {
            if (nmax != null) {
                ds.putProperty("VALID_MAX", (Object)uc.convert(nmax));
            }
            if (nmin != null) {
                ds.putProperty("VALID_MIN", (Object)uc.convert(nmin));
            }
        }
        if ((t = (String)props.get("SCALE_TYPE")) != null) {
            ds.putProperty("SCALE_TYPE", (Object)t);
        }
    }

    public boolean asynchronousLoad() {
        return true;
    }

    public MetadataModel getMetadataModel() {
        return new IstpMetadataModel();
    }

    public synchronized Map<String, Object> getMetadata(ProgressMonitor mon) throws IOException {
        if (this.attributes == null) {
            try {
                File cdfFile = this.getFile(mon);
                String fileName = cdfFile.toString();
                Map map = this.getParams();
                if (map.containsKey(PARAM_SLICE1)) {
                    return null;
                }
                CDF cdf = CdfFileDataSourceFactory.getCDFFile(fileName);
                String svariable = (String)map.get(PARAM_ID);
                if (svariable == null) {
                    svariable = (String)map.get("arg_0");
                }
                if (svariable == null) {
                    throw new IllegalArgumentException("variable not specified");
                }
                int i = svariable.indexOf("[");
                if (i != -1) {
                    svariable = svariable.substring(0, i);
                }
                Variable variable = cdf.getVariable(svariable);
                this.attributes = this.readAttributes(cdf, variable, 0);
                CdfFileDataSourceFactory.closeCDF(cdf);
                return this.attributes;
            }
            catch (CDFException ex) {
                throw new IOException(ex.getMessage());
            }
        }
        return this.attributes;
    }
}

