/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdfdatasource;

import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.cdfdatasource.CdfFileDataSource;
import org.virbo.cdfdatasource.CdfUtil;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.URISplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdfFileDataSourceFactory
implements DataSourceFactory {
    private static final Logger logger = Logger.getLogger("virbo.cdfdatasource");
    private static CDF currentCDF;
    private static String currentFile;

    public static void loadCdfLibraries() {
        String cdfLib1 = System.getProperty("cdfLib1");
        String cdfLib2 = System.getProperty("cdfLib2");
        if (cdfLib1 == null && cdfLib2 == null) {
            System.err.println("System properties for cdfLib not set, setting up for debugging");
            String os = System.getProperty("os.name");
            if (os.startsWith("Windows")) {
                cdfLib1 = "dllcdf";
                cdfLib2 = "cdfNativeLibrary";
            } else {
                System.err.println("no values set identifying cdf libraries, hope you're on a mac or linux!");
                System.err.println(System.getProperty("java.library.path"));
                cdfLib2 = "cdfNativeLibrary";
            }
        }
        try {
            if (cdfLib1 != null) {
                System.loadLibrary(cdfLib1);
            }
            if (cdfLib2 != null) {
                System.loadLibrary(cdfLib2);
            }
        }
        catch (UnsatisfiedLinkError ex) {
            ex.printStackTrace();
            System.err.println("java.library.path: " + System.getProperty("java.library.path"));
            throw ex;
        }
        logger.fine("cdf binaries loaded");
    }

    public DataSource getDataSource(URI uri) throws Exception {
        return new CdfFileDataSource(uri);
    }

    public String editPanel(String surl) throws Exception {
        return surl;
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context.equals(CompletionContext.CONTEXT_PARAMETER_NAME)) {
            File cdfFile = DataSetURI.getFile((URI)cc.resourceURI, (ProgressMonitor)mon);
            String fileName = cdfFile.toString();
            logger.log(Level.FINEST, "opening cdf file {0}", fileName);
            CDF cdf = CdfFileDataSourceFactory.getCDFFile(fileName);
            logger.finest("inspect cdf for plottable parameters");
            Map<String, String> result = CdfUtil.getPlottable(cdf, false, 4);
            logger.finest("close cdf");
            CdfFileDataSourceFactory.closeCDF(cdf);
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
            for (Map.Entry<String, String> e : result.entrySet()) {
                String key = e.getKey();
                CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, key, (DataSourceFactory)this, "arg_0", e.getValue(), null, true);
                ccresult.add(cc1);
            }
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "interpMeta=", "control interpretation of metadata"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "doDep=", "control dependencies between variables"));
            return ccresult;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String parmname = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
            if (parmname.equals("id")) {
                String file = CompletionContext.get((Object)CompletionContext.CONTEXT_FILE, (CompletionContext)cc);
                File cdfFile = DataSetURI.getFile((URL)DataSetURI.getURL((String)file), (ProgressMonitor)mon);
                String fileName = cdfFile.toString();
                CDF cdf = CdfFileDataSourceFactory.getCDFFile(fileName);
                Map<String, String> result = CdfUtil.getPlottable(cdf, false, 4);
                CdfFileDataSourceFactory.closeCDF(cdf);
                ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                for (Map.Entry<String, String> e : result.entrySet()) {
                    String key = e.getKey();
                    CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key, (DataSourceFactory)this, null, key, e.getValue(), true);
                    ccresult.add(cc1);
                }
                return ccresult;
            }
            if (parmname.equals("interpMeta")) {
                return Arrays.asList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "yes", "use metadata (default)"), new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "no", "inhibit use of metadata"));
            }
            if (parmname.equals("doDep")) {
                return Arrays.asList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "yes", "use dependency tags (default)"), new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "no", "inhibit use of dependency tags"));
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        try {
            if (!surl.contains("?") || surl.indexOf("?") == surl.length() - 1) {
                return true;
            }
            URISplit split = URISplit.parse((String)surl);
            LinkedHashMap args = URISplit.parseParams((String)split.params);
            String param = (String)args.get("arg_0");
            if (param == null && (param = (String)args.get("id")) == null) {
                return true;
            }
            File file = DataSetURI.getFile((URI)split.resourceUri, (ProgressMonitor)mon);
            if (!file.isFile()) {
                return true;
            }
            CDF cdf = CdfFileDataSourceFactory.getCDFFile(file.getPath());
            Map<String, String> result = CdfUtil.getPlottable(cdf, false, 4);
            CdfFileDataSourceFactory.closeCDF(cdf);
            int i = param.indexOf("[");
            if (i > -1) {
                param = param.substring(0, i);
            }
            return !result.containsKey(param);
        }
        catch (CDFException ex) {
            Logger.getLogger(CdfFileDataSourceFactory.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected static CDF getCDFFile(String cdfFile) throws CDFException {
        System.err.println("opening " + cdfFile);
        currentCDF = CDF.open((String)cdfFile);
        return currentCDF;
    }

    protected static void closeCDF(CDF cdf) throws CDFException {
        cdf.close();
    }

    public <T> T getCapability(Class<T> clazz) {
        return null;
    }

    static {
        CdfFileDataSourceFactory.loadCdfLibraries();
        currentCDF = null;
        currentFile = null;
    }
}

