/*
 * Decompiled with CFR 0.152.
 */
package org.tsds.datasource;

import java.text.ParseException;
import java.util.LinkedHashMap;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;

public class TsdsTimeSeriesBrowse
implements TimeSeriesBrowse {
    DatumRange timeRange;
    Datum resolution;
    int currentPpd = -1;
    int parameterPpd = -1;

    private DatumRange quantizeTimeRange(DatumRange timeRange) {
        timeRange = new DatumRange(TimeUtil.prevMidnight((Datum)timeRange.min()), TimeUtil.nextMidnight((Datum)timeRange.max()));
        return timeRange;
    }

    private int quantizePpd(Datum resolution) {
        int[] ppds = new int[]{1, 8, 24, 96, 144, 4320, 17280, 86400, 864000};
        if (resolution == null) {
            return 1;
        }
        double resdays = resolution.doubleValue(Units.days);
        double dppd = 1.0 / resdays;
        int ppd = ppds[ppds.length - 1];
        for (int i = 0; i < ppds.length && ppds[i] <= this.parameterPpd; ++i) {
            if (!((double)ppds[i] > dppd)) continue;
            ppd = ppds[i];
            return ppd;
        }
        return this.parameterPpd;
    }

    public void setTimeRange(DatumRange dr) {
        System.out.println(dr);
        this.timeRange = this.quantizeTimeRange(dr);
        System.out.println(this.timeRange);
        System.out.println(this.timeRange.width());
    }

    public void setTimeResolution(Datum d) {
        this.resolution = d;
        if (this.resolution == null) {
            this.currentPpd = -1;
        } else {
            this.currentPpd = this.quantizePpd(this.resolution);
            this.resolution = Units.days.createDatum(1.0).divide((double)this.currentPpd);
        }
    }

    public String getURI() {
        TimeParser tp = TimeParser.create((String)"%Y%m%d");
        String sparams = "StartDate=" + tp.format(this.timeRange.min(), null) + "&EndDate=" + tp.format(this.timeRange.max(), null) + "&ppd=" + this.currentPpd;
        return "vap+tsds:" + sparams;
    }

    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    public Datum getTimeResolution() {
        return this.resolution;
    }

    public void setURI(String suri) throws ParseException {
        URISplit split = URISplit.parse((String)suri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String startTime = (String)params.remove("StartDate");
        String endTime = (String)params.get("EndDate");
        String sppd = (String)params.get("ppd");
        if (startTime != null && endTime != null) {
            this.timeRange = new DatumRange(Units.us2000.parse(startTime), Units.us2000.parse(endTime));
        }
        if (sppd != null) {
            this.currentPpd = Integer.parseInt(sppd);
        }
    }
}

