/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.aggregator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.virbo.aggregator.AggregatingDataSourceFactory;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.DataSourceEditorPanelUtil;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.SourceTypesBrowser;
import org.virbo.datasource.URISplit;

public class AggregatingDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    String uri;
    List<DatumRange> ranges;
    boolean updatingDropLists = false;
    private JComboBox daysComboBox;
    private JLabel delegateFileLabel;
    private JPanel delegatePanel;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JComboBox monthsComboBox;
    private JLabel outerRangeTextField;
    private JTextField timeRangeTextField;
    private JComboBox yearsComboBox;
    JComponent delegateComponent = null;
    DataSetSelector delegateDataSetSelector = null;
    DataSourceEditorPanel delegateEditorPanel = null;
    URISplit split;
    Map<String, String> params;

    public AggregatingDataSourceEditorPanel() {
        this.initComponents();
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this, "aggregator_main");
    }

    public void setDelegateEditorPanel(DataSourceEditorPanel edit) {
        this.delegateEditorPanel = edit;
    }

    private void initComponents() {
        this.delegatePanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.timeRangeTextField = new JTextField();
        this.outerRangeTextField = new JLabel();
        this.yearsComboBox = new JComboBox();
        this.monthsComboBox = new JComboBox();
        this.daysComboBox = new JComboBox();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.delegateFileLabel = new JLabel();
        this.delegatePanel.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Time Range for Aggregation:");
        this.jLabel1.setToolTipText("<html>Enter the time range to over which to aggregate data. <br>\nData from files within this range will be combined by concatenating over the first dimension.</br>\n</html>\n\n");
        this.timeRangeTextField.setText("jTextField1");
        this.outerRangeTextField.setFont(new Font("SansSerif", 0, 10));
        this.outerRangeTextField.setText("listing to get available time ranges...");
        this.yearsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"..."}));
        this.yearsComboBox.setToolTipText("Select from available years");
        this.yearsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AggregatingDataSourceEditorPanel.this.yearsComboBoxItemStateChanged(evt);
            }
        });
        this.monthsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"...", " "}));
        this.monthsComboBox.setToolTipText("Select from available months");
        this.monthsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AggregatingDataSourceEditorPanel.this.monthsComboBoxItemStateChanged(evt);
            }
        });
        this.daysComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"...", " "}));
        this.daysComboBox.setToolTipText("Select from available days");
        this.jButton1.setText("Copy");
        this.jButton1.setToolTipText("<html>\nCopy the date into the time range field.<br>\nHolding shift down will add the selected time to the aggregation.<br>\n</html>");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AggregatingDataSourceEditorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("jButton2");
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/datasource/help.png")));
        this.jButton3.setToolTipText("Help for this component\n");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AggregatingDataSourceEditorPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.delegateFileLabel.setFont(new Font("SansSerif", 0, 10));
        this.delegateFileLabel.setText("example file used for editing goes here");
        this.delegateFileLabel.setToolTipText("Aggregation works by automatically generating a set of \"delegate uris\" that are read and combined into one dataset.  This editor works by picking a delegate and providing an editor for the delegate as well.\n");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.timeRangeTextField, -2, 215, -2).addPreferredGap(0, 208, Short.MAX_VALUE).add((Component)this.jButton3)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(7, 7, 7).add((Component)this.yearsComboBox, -2, 93, -2).addPreferredGap(0).add((Component)this.monthsComboBox, -2, 88, -2).addPreferredGap(0).add((Component)this.daysComboBox, -2, 72, -2).addPreferredGap(0).add((Component)this.jButton1).addContainerGap(318, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add(1, (Component)this.delegateFileLabel, -1, 607, Short.MAX_VALUE).add((Component)this.outerRangeTextField, -1, 607, Short.MAX_VALUE)).add(26, 26, 26)));
        jPanel1Layout.linkSize(new Component[]{this.monthsComboBox, this.yearsComboBox}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.timeRangeTextField, -2, -1, -2).add((Component)this.jButton3)).addPreferredGap(0).add((Component)this.outerRangeTextField).add(9, 9, 9).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.yearsComboBox, -2, -1, -2).add((Component)this.monthsComboBox, -2, -1, -2).add((Component)this.daysComboBox, -2, -1, -2).add((Component)this.jButton1)).addPreferredGap(0).add((Component)this.delegateFileLabel).addContainerGap(13, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.delegatePanel, -1, 649, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.delegatePanel, -1, 259, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String syr = String.valueOf(this.yearsComboBox.getSelectedItem()).trim();
        String smn = String.valueOf(this.monthsComboBox.getSelectedItem()).trim();
        String sday = String.valueOf(this.daysComboBox.getSelectedItem()).trim();
        String range = syr + " " + smn + " " + sday;
        range = range.trim();
        if ((evt.getModifiers() & 1) == 1) {
            DatumRange dr1 = DatumRangeUtil.parseTimeRangeValid((String)range);
            DatumRange dr2 = null;
            try {
                dr2 = DatumRangeUtil.parseTimeRange((String)this.timeRangeTextField.getText());
                dr2 = DatumRangeUtil.union((DatumRange)dr1, (DatumRange)dr2);
                this.timeRangeTextField.setText(dr2.toString());
            }
            catch (ParseException ex) {
                this.timeRangeTextField.setText(range);
            }
        } else {
            this.timeRangeTextField.setText(range);
        }
    }

    private void yearsComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.updatingDropLists) {
            this.updateDropLists(false, true);
        }
    }

    private void monthsComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.updatingDropLists) {
            this.updateDropLists(false, false);
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        AutoplotHelpSystem.getHelpSystem().displayHelpFromEvent(evt, (Object)this);
    }

    public JPanel getPanel() {
        return this;
    }

    private void setDelegateComponent(JComponent c) {
        if (this.delegateComponent != null) {
            this.delegatePanel.remove(this.delegateComponent);
        }
        this.delegateComponent = c;
        this.delegatePanel.add((Component)c, "Center");
        this.delegatePanel.validate();
    }

    private void updateTimeRanges() {
        DatumRange dr = null;
        try {
            FileStorageModelNew fsm = AggregatingDataSourceFactory.getFileStorageModel(this.uri);
            String[] names = fsm.getNamesFor(null, (ProgressMonitor)new NullProgressMonitor());
            this.ranges = new ArrayList<DatumRange>(names.length);
            for (int i = 0; i < names.length; ++i) {
                this.ranges.add(i, fsm.getRangeFor(names[i]));
                dr = dr == null ? this.ranges.get(i) : DatumRangeUtil.union((DatumRange)dr, (DatumRange)this.ranges.get(i));
            }
        }
        catch (IOException ex) {
            this.outerRangeTextField.setText(ex.toString());
            return;
        }
        this.outerRangeTextField.setText("found files for " + dr.toString());
    }

    private void updateDropLists(boolean updateYear, boolean updateMonth) {
        DefaultComboBoxModel<String> model;
        List result;
        List possible;
        this.updatingDropLists = true;
        DatumRange selectedRange = null;
        try {
            selectedRange = DatumRangeUtil.parseTimeRange((String)this.timeRangeTextField.getText());
        }
        catch (ParseException ex) {
            Logger.getLogger(AggregatingDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (updateYear) {
            possible = DatumRangeUtil.generateList((DatumRange)DatumRangeUtil.parseTimeRangeValid((String)"1800-2200"), (DatumRange)DatumRangeUtil.parseTimeRangeValid((String)"1800"));
            result = DatumRangeUtil.intersection((List)possible, this.ranges, (boolean)false);
            String[] yrLabels = new String[result.size() + 1];
            yrLabels[0] = "";
            int isel = result.size() == 1 ? 1 : 0;
            for (int i = 0; i < result.size(); ++i) {
                yrLabels[i + 1] = ((DatumRange)result.get(i)).toString();
                if (selectedRange == null || !((DatumRange)result.get(i)).intersects(selectedRange)) continue;
                isel = i + 1;
            }
            model = new DefaultComboBoxModel<String>(yrLabels);
            this.yearsComboBox.setModel(model);
            this.yearsComboBox.setSelectedIndex(isel);
        }
        String syr = String.valueOf(this.yearsComboBox.getSelectedItem()).trim();
        if (updateMonth) {
            if (syr.length() > 0) {
                possible = DatumRangeUtil.generateList((DatumRange)DatumRangeUtil.parseTimeRangeValid((String)syr), (DatumRange)DatumRangeUtil.parseTimeRangeValid((String)(syr + " jan")));
                result = DatumRangeUtil.intersection((List)possible, this.ranges, (boolean)false);
                String[] mnLabels = new String[result.size() + 1];
                mnLabels[0] = "";
                int isel = result.size() == 1 ? 1 : 0;
                for (int i = 0; i < result.size(); ++i) {
                    mnLabels[i + 1] = ((DatumRange)result.get(i)).toString().replace(syr, "").trim();
                    if (selectedRange == null || !((DatumRange)result.get(i)).intersects(selectedRange) || !selectedRange.width().le(((DatumRange)result.get(i)).width())) continue;
                    isel = i + 1;
                }
                model = new DefaultComboBoxModel<String>(mnLabels);
                this.monthsComboBox.setModel(model);
                this.monthsComboBox.setSelectedIndex(isel);
            } else {
                this.monthsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
            }
        }
        String smon = String.valueOf(this.monthsComboBox.getSelectedItem()).trim();
        if (syr.length() > 0 && smon.length() > 0) {
            possible = DatumRangeUtil.generateList((DatumRange)DatumRangeUtil.parseTimeRangeValid((String)(syr + " " + smon)), (DatumRange)DatumRangeUtil.parseTimeRangeValid((String)(syr + " " + smon + " 1")));
            result = DatumRangeUtil.intersection((List)possible, this.ranges, (boolean)false);
            String[] dayLabels = new String[result.size() + 1];
            dayLabels[0] = "";
            int isel = result.size() == 1 ? 1 : 0;
            for (int i = 0; i < result.size(); ++i) {
                dayLabels[i + 1] = String.valueOf(TimeUtil.toTimeStruct((Datum)((DatumRange)result.get((int)i)).min()).day);
                if (selectedRange == null || !((DatumRange)result.get(i)).intersects(selectedRange) || !selectedRange.width().le(((DatumRange)result.get(i)).width())) continue;
                isel = i + 1;
            }
            model = new DefaultComboBoxModel<String>(dayLabels);
            this.daysComboBox.setModel(model);
            this.daysComboBox.setSelectedIndex(isel);
        } else {
            this.daysComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
        }
        this.updatingDropLists = false;
    }

    public boolean reject(String uri) throws Exception {
        String delegateUrl = null;
        delegateUrl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(uri);
        if (this.delegateEditorPanel == null) {
            this.delegateEditorPanel = DataSourceEditorPanelUtil.getDataSourceEditorPanel(DataSetURI.toUri(delegateUrl));
        }
        if (this.delegateEditorPanel == null) {
            return false;
        }
        return this.delegateEditorPanel.reject(delegateUrl);
    }

    public boolean prepare(String url, Window parent, ProgressMonitor mon) throws IOException, URISyntaxException, Exception {
        String delegateUrl = null;
        delegateUrl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(url);
        Pattern p = Pattern.compile("(vap(\\+[a-z]+)?\\:)?([^\\?]*)(\\?.*)");
        Matcher m = p.matcher(delegateUrl);
        if (m.matches()) {
            this.delegateFileLabel.setText("editing example URI " + m.group(3) + " above");
        } else {
            this.delegateFileLabel.setText("editing example URI  " + delegateUrl + " above");
        }
        if (this.delegateEditorPanel == null) {
            this.delegateEditorPanel = DataSourceEditorPanelUtil.getDataSourceEditorPanel(DataSetURI.toUri(delegateUrl));
        }
        if (this.delegateEditorPanel == null) {
            return true;
        }
        return this.delegateEditorPanel.prepare(delegateUrl, parent, mon);
    }

    public void hintAtCompletion() {
        if (this.delegateDataSetSelector != null) {
            String text = this.delegateDataSetSelector.getEditor().getText();
            this.delegateDataSetSelector.getEditor().setCaretPosition(text.length());
        }
        String delegateUrl = null;
        try {
            delegateUrl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(this.getURI());
            DataSourceFactory dsf = DataSetURI.getDataSourceFactory(DataSetURI.toUri(delegateUrl), (ProgressMonitor)new NullProgressMonitor());
            if (!dsf.reject(delegateUrl, (ProgressMonitor)new NullProgressMonitor()) && this.timeRangeTextField.getText().trim().length() == 0) {
                this.timeRangeTextField.requestFocus();
            }
        }
        catch (IOException ex) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setURI(String url) {
        this.split = URISplit.parse(url);
        this.params = URISplit.parseParams(this.split.params);
        this.uri = url;
        try {
            String timeRange = this.params.get("timerange");
            if (timeRange != null && timeRange.trim().length() > 0) {
                timeRange = timeRange.replaceAll("\\+", " ");
                try {
                    DatumRange dr = DatumRangeUtil.parseTimeRange((String)timeRange);
                }
                catch (ParseException ex) {
                    timeRange = "!!! " + timeRange + " !!!";
                }
            }
            this.timeRangeTextField.setText(timeRange);
            String delegateUrl = null;
            delegateUrl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(url);
            if (this.delegateEditorPanel == null) {
                this.delegateEditorPanel = DataSourceEditorPanelUtil.getDataSourceEditorPanel(DataSetURI.toUri(delegateUrl));
            }
            if (this.delegateEditorPanel == null) {
                try {
                    DataSetURI.getDataSource(delegateUrl);
                    JPanel delegateP = new JPanel();
                    BoxLayout l = new BoxLayout(delegateP, 1);
                    delegateP.setLayout(l);
                    delegateP.add(Box.createVerticalGlue());
                    this.delegateDataSetSelector = new DataSetSelector();
                    this.delegateDataSetSelector.setValue(delegateUrl);
                    this.delegateDataSetSelector.setAlignmentX(0.0f);
                    JTextField jtf = this.delegateDataSetSelector.getEditor();
                    int rolimit = delegateUrl.indexOf("?");
                    rolimit = rolimit == -1 ? delegateUrl.length() : ++rolimit;
                    final int frolimit = rolimit;
                    NavigationFilter nf = new NavigationFilter(){

                        public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
                            return super.getNextVisualPositionFrom(text, pos, bias, direction, biasRet);
                        }

                        public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                            if (dot < frolimit) {
                                dot = frolimit;
                            }
                            super.moveDot(fb, dot, bias);
                        }

                        public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                            if (dot < frolimit) {
                                dot = frolimit;
                            }
                            super.setDot(fb, dot, bias);
                        }
                    };
                    jtf.setNavigationFilter(nf);
                    JLabel la = new JLabel("<html>The delegate data source doesn't provide an editor.  Use this editor to modify parameters, but not the delegate file name.</html>");
                    la.setAlignmentX(0.0f);
                    delegateP.add(la);
                    delegateP.add(this.delegateDataSetSelector);
                    this.setDelegateComponent(delegateP);
                }
                catch (IllegalArgumentException ex) {
                    SourceTypesBrowser browser = new SourceTypesBrowser();
                    browser.getDataSetSelector().setValue(delegateUrl);
                    this.setDelegateComponent(browser);
                }
            } else {
                this.delegateEditorPanel.setURI(delegateUrl);
                this.setDelegateComponent(this.delegateEditorPanel.getPanel());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(AggregatingDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            RuntimeException ex2 = new RuntimeException("Unable to create example file for aggregation", ex);
            throw ex2;
        }
        Runnable run = new Runnable(){

            public void run() {
                AggregatingDataSourceEditorPanel.this.updateTimeRanges();
                AggregatingDataSourceEditorPanel.this.updateDropLists(true, true);
            }
        };
        new Thread(run).start();
    }

    public void setTimeRange(DatumRange timerange) {
        this.timeRangeTextField.setText(timerange.toString());
    }

    public DatumRange getTimeRange() {
        if (this.timeRangeTextField.getText().trim().equals("")) {
            return null;
        }
        try {
            return DatumRangeUtil.parseTimeRange((String)this.timeRangeTextField.getText().trim());
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public String getURI() {
        String delegateUrl;
        String vapScheme = this.split.vapScheme;
        if (this.delegateEditorPanel != null) {
            delegateUrl = this.delegateEditorPanel.getURI();
        } else if (this.delegateComponent instanceof SourceTypesBrowser) {
            delegateUrl = ((SourceTypesBrowser)this.delegateComponent).getUri();
            vapScheme = null;
        } else {
            delegateUrl = this.delegateDataSetSelector.getValue();
        }
        URISplit dsplit = URISplit.parse(delegateUrl);
        LinkedHashMap<String, String> allParams = new LinkedHashMap<String, String>();
        allParams.putAll(this.params);
        allParams.putAll(URISplit.parseParams(dsplit.params));
        String tr = this.timeRangeTextField.getText();
        if (tr.startsWith("!!! ")) {
            tr = tr.substring(4);
        }
        if (tr.endsWith(" !!!")) {
            tr = tr.substring(0, tr.length() - 4);
        }
        tr = tr.replaceAll(" ", "+");
        allParams.put("timerange", tr);
        this.split.params = URISplit.formatParams(allParams);
        if (vapScheme == null) {
            this.split.vapScheme = dsplit.vapScheme;
        }
        return URISplit.format(this.split);
    }
}

