/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.virbo.aggregator.AggregatingDataSourceEditorPanel;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.DataSourceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceEditorPanelUtil {
    public static DataSourceEditorPanel getDataSourceEditorPanel(URI uri) {
        String surl = DataSetURI.fromUri(uri);
        String ext = DataSetURI.getExt(surl);
        if (DataSetURI.isAggregating(surl)) {
            String eext = DataSetURI.getExplicitExt(surl);
            if (eext != null) {
                AggregatingDataSourceEditorPanel result = new AggregatingDataSourceEditorPanel();
                DataSourceEditorPanel edit = DataSourceEditorPanelUtil.getEditorByExt(eext);
                if (edit != null) {
                    result.setDelegateEditorPanel(edit);
                }
                return result;
            }
            return new AggregatingDataSourceEditorPanel();
        }
        DataSourceEditorPanel edit = DataSourceEditorPanelUtil.getEditorByExt(ext);
        return edit;
    }

    public static DataSourceEditorPanel getEditorByExt(String extension) {
        DataSourceEditorPanel result;
        if (extension == null) {
            return null;
        }
        Object o = DataSourceRegistry.getInstance().dataSourceEditorByExt.get(extension = DataSourceRegistry.getExtension(extension));
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                Class<?> clas = Class.forName((String)o);
                Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
                result = (DataSourceEditorPanel)constructor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            result = (DataSourceEditorPanel)o;
        }
        return result;
    }

    public static List<String> getDiscoverableExtensions() {
        List<String> exts = DataSourceRegistry.getInstance().getSourceEditorExtensions();
        ArrayList<String> result = new ArrayList<String>();
        for (String ext : exts) {
            String uri = "vap+" + ext.substring(1) + ":";
            try {
                DataSourceEditorPanel p = DataSourceEditorPanelUtil.getEditorByExt(ext);
                if (p.reject(uri)) continue;
                result.add(ext);
            }
            catch (Exception ex) {}
        }
        return result;
    }
}

