/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.DataSourceFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceRegistry {
    private static DataSourceRegistry instance;
    HashMap<String, Object> dataSourcesByExt = new HashMap();
    HashMap<String, Object> dataSourcesByMime = new HashMap();
    HashMap<String, Object> dataSourceFormatByExt = new HashMap();
    HashMap<String, Object> dataSourceFormatEditorByExt;
    HashMap<String, Object> dataSourceEditorByExt = new HashMap();
    HashMap<String, String> extToDescription;

    private DataSourceRegistry() {
        this.dataSourceFormatEditorByExt = new HashMap();
        this.extToDescription = new HashMap();
    }

    public static DataSourceRegistry getInstance() {
        if (instance == null) {
            instance = new DataSourceRegistry();
        }
        return instance;
    }

    public static Object getInstanceFromClassName(String o) {
        try {
            Class<?> clas = Class.forName(o);
            Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
            Object result = constructor.newInstance(new Object[0]);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getFormatterExtensions() {
        ArrayList<String> result = new ArrayList<String>();
        for (String k : this.dataSourceFormatByExt.keySet()) {
            result.add(k);
        }
        return result;
    }

    public List<String> getSourceExtensions() {
        ArrayList<String> result = new ArrayList<String>();
        for (String k : this.dataSourcesByExt.keySet()) {
            result.add(k);
        }
        return result;
    }

    public List<String> getSourceEditorExtensions() {
        ArrayList<String> result = new ArrayList<String>();
        for (String k : this.dataSourceEditorByExt.keySet()) {
            result.add(k);
        }
        return result;
    }

    protected void discoverFactories() {
        DataSourceRegistry registry = this;
        try {
            ClassLoader loader = DataSetURI.class.getClassLoader();
            Enumeration<URL> urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.virbo.datasource.DataSourceFactory") : loader.getResources("META-INF/org.virbo.datasource.DataSourceFactory");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                String s = reader.readLine();
                while (s != null) {
                    if (s.trim().length() > 0) {
                        List extensions = null;
                        List mimeTypes = null;
                        String factoryClassName = s;
                        try {
                            Method m;
                            Class<?> c = Class.forName(factoryClassName);
                            DataSourceFactory f = (DataSourceFactory)c.newInstance();
                            try {
                                m = c.getMethod("extensions", new Class[0]);
                                extensions = (List)m.invoke((Object)f, new Object[0]);
                            }
                            catch (NoSuchMethodException ex) {
                            }
                            catch (InvocationTargetException ex) {
                                ex.printStackTrace();
                            }
                            try {
                                m = c.getMethod("mimeTypes", new Class[0]);
                                mimeTypes = (List)m.invoke((Object)f, new Object[0]);
                            }
                            catch (NoSuchMethodException ex) {
                            }
                            catch (InvocationTargetException ex) {
                                ex.printStackTrace();
                            }
                        }
                        catch (ClassNotFoundException ex) {
                            ex.printStackTrace();
                        }
                        catch (InstantiationException ex) {
                            ex.printStackTrace();
                        }
                        catch (IllegalAccessException ex) {
                            ex.printStackTrace();
                        }
                        if (extensions != null) {
                            for (String e : extensions) {
                                registry.registerExtension(factoryClassName, e, null);
                            }
                        }
                        if (mimeTypes != null) {
                            for (String m : mimeTypes) {
                                registry.registerMimeType(factoryClassName, m);
                            }
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> readStuff(Iterator<URL> urls) throws IOException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        while (urls.hasNext()) {
            URL url = urls.next();
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String s = reader.readLine();
            while (s != null) {
                if ((s = s.trim()).length() > 0) {
                    String[] ss = s.split("\\s");
                    for (int i = 1; i < ss.length; ++i) {
                        result.put(ss[i], ss[0]);
                    }
                }
                s = reader.readLine();
            }
            reader.close();
        }
        return result;
    }

    protected void discoverRegistryEntries() {
        DataSourceRegistry registry = this;
        try {
            int i;
            String[] ss;
            String s;
            BufferedReader reader;
            URL url;
            ClassLoader loader = DataSetURI.class.getClassLoader();
            Enumeration<URL> urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.virbo.datasource.DataSourceFactory.extensions") : loader.getResources("META-INF/org.virbo.datasource.DataSourceFactory.extensions");
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                s = reader.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0) {
                        ss = s.split("\\s");
                        for (i = 1; i < ss.length; ++i) {
                            registry.registerExtension(ss[0], ss[i], null);
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
            urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.virbo.datasource.DataSourceFactory.mimeTypes") : loader.getResources("META-INF/org.virbo.datasource.DataSourceFactory.mimeTypes");
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                s = reader.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0) {
                        ss = s.split("\\s");
                        for (i = 1; i < ss.length; ++i) {
                            registry.registerMimeType(ss[0], ss[i]);
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
            urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.virbo.datasource.DataSourceFormat.extensions") : loader.getResources("META-INF/org.virbo.datasource.DataSourceFormat.extensions");
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                s = reader.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0) {
                        ss = s.split("\\s");
                        for (i = 1; i < ss.length; ++i) {
                            registry.registerFormatter(ss[0], ss[i]);
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
            urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.virbo.datasource.DataSourceEditorPanel.extensions") : loader.getResources("META-INF/org.virbo.datasource.DataSourceEditorPanel.extensions");
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                s = reader.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0) {
                        ss = s.split("\\s");
                        for (i = 1; i < ss.length; ++i) {
                            registry.registerEditor(ss[0], ss[i]);
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
            urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.virbo.datasource.DataSourceFormatEditorPanel.extensions") : loader.getResources("META-INF/org.virbo.datasource.DataSourceFormatEditorPanel.extensions");
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                s = reader.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0) {
                        ss = s.split("\\s");
                        for (i = 1; i < ss.length; ++i) {
                            registry.registerFormatEditor(ss[0], ss[i]);
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerDataSourceJar(String ext, URL jarFile) throws IOException {
        URLClassLoader loader = new URLClassLoader(new URL[]{jarFile}, DataSourceRegistry.class.getClassLoader());
        Enumeration<URL> re = loader.getResources("META-INF/org.virbo.datasource.DataSourceFactory.extensions");
        ArrayList<URL> rre = new ArrayList<URL>();
        while (re.hasMoreElements()) {
            URL u = re.nextElement();
            if (!u.toString().startsWith("jar:" + jarFile.toString())) continue;
            rre.add(u);
        }
        Map<String, String> stuff = this.readStuff(rre.iterator());
        for (Map.Entry<String, String> ent : stuff.entrySet()) {
            try {
                Class<?> clas = loader.loadClass(ent.getValue());
                if (ext != null) {
                    this.dataSourcesByExt.put(DataSourceRegistry.getExtension(ext), clas.getConstructor(new Class[0]).newInstance(new Object[0]));
                    continue;
                }
                this.dataSourcesByExt.put(DataSourceRegistry.getExtension(ent.getKey()), clas.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    public boolean hasSourceByExt(String ext) {
        if (ext == null) {
            return false;
        }
        return this.dataSourcesByExt.get(DataSourceRegistry.getExtension(ext)) != null;
    }

    public boolean hasSourceByMime(String mime) {
        if (mime == null) {
            return false;
        }
        return this.dataSourcesByMime.get(mime) != null;
    }

    public void register(DataSourceFactory factory, String extension) {
        extension = DataSourceRegistry.getExtension(extension);
        this.dataSourcesByExt.put(extension, factory);
    }

    public void register(DataSourceFactory factory, String extension, String mime) {
        extension = DataSourceRegistry.getExtension(extension);
        this.dataSourcesByExt.put(extension, factory);
        this.dataSourcesByMime.put(mime.toLowerCase(), factory);
    }

    public void registerExtension(String className, String extension, String description) {
        Object old = this.dataSourcesByExt.get(extension = DataSourceRegistry.getExtension(extension));
        if (old != null) {
            String oldClassName;
            String string = oldClassName = old instanceof String ? (String)old : old.getClass().getName();
            if (!oldClassName.equals(className)) {
                System.err.println("extension " + extension + " is already handled by " + oldClassName + ", replacing with " + className);
            }
        }
        this.dataSourcesByExt.put(extension, className);
        if (description != null) {
            this.extToDescription.put(extension, description);
        }
    }

    public void registerFormatter(String className, String extension) {
        if (extension.indexOf(46) != 0) {
            extension = "." + extension;
        }
        this.dataSourceFormatByExt.put(extension, className);
    }

    public void registerEditor(String className, String extension) {
        extension = DataSourceRegistry.getExtension(extension);
        this.dataSourceEditorByExt.put(extension, className);
    }

    public void registerFormatEditor(String className, String extension) {
        extension = DataSourceRegistry.getExtension(extension);
        this.dataSourceFormatEditorByExt.put(extension, className);
    }

    public void registerMimeType(String className, String mimeType) {
        this.dataSourcesByMime.put(mimeType, className);
    }

    public void register(String className, String extension, String mime) {
        extension = DataSourceRegistry.getExtension(extension);
        this.dataSourcesByExt.put(extension, className);
        this.dataSourcesByMime.put(mime.toLowerCase(), className);
    }

    public synchronized DataSourceFactory getSource(String extension) {
        DataSourceFactory result;
        if (extension == null) {
            return null;
        }
        Object o = this.dataSourcesByExt.get(extension = DataSourceRegistry.getExtension(extension));
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                Class<?> clas = Class.forName((String)o);
                Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
                result = (DataSourceFactory)constructor.newInstance(new Object[0]);
                this.dataSourcesByExt.put(extension, result);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (UnsatisfiedLinkError ex) {
                if (extension.equals(".cdf")) {
                    System.err.println("attempting to use java based reader to handle cdf.");
                    DataSourceFactory dsf = this.getSource(".cdfj");
                    if (dsf != null) {
                        this.dataSourcesByExt.put(extension, dsf);
                        this.dataSourceEditorByExt.put(extension, this.getDataSourceEditorByExt(".cdfj"));
                        this.dataSourceFormatByExt.remove(extension);
                        return dsf;
                    }
                    throw new RuntimeException(ex);
                }
                throw new RuntimeException(ex);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            result = (DataSourceFactory)o;
        }
        return result;
    }

    protected static String getExtension(String name) {
        int i;
        if (name.indexOf(46) == -1) {
            name = "." + name;
        }
        if (name.indexOf(46) > 0) {
            i = name.lastIndexOf(46);
            name = name.substring(i);
        }
        if ((i = name.indexOf("?")) != -1) {
            name = name.substring(0, i);
        }
        if ((i = name.indexOf("&")) != -1) {
            name = name.substring(0, i);
        }
        name = name.toLowerCase();
        return name;
    }

    public DataSourceFormat getFormatByExt(String extension) {
        DataSourceFormat result;
        if (extension == null) {
            return null;
        }
        Object o = this.dataSourceFormatByExt.get(extension = DataSourceRegistry.getExtension(extension));
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                Class<?> clas = Class.forName((String)o);
                Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
                result = (DataSourceFormat)constructor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            result = (DataSourceFormat)o;
        }
        return result;
    }

    public synchronized DataSourceFactory getSourceByMime(String mime) {
        DataSourceFactory result;
        if (mime == null) {
            return null;
        }
        Object o = this.dataSourcesByMime.get(mime.toLowerCase());
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                Class<?> clas = Class.forName((String)o);
                Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
                result = (DataSourceFactory)constructor.newInstance(new Object[0]);
                this.dataSourcesByMime.put(mime.toLowerCase(), result);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            result = (DataSourceFactory)o;
        }
        return result;
    }

    public synchronized Object getDataSourceEditorByExt(String ext) {
        return this.dataSourceEditorByExt.get(ext);
    }

    public synchronized Object getDataSourceFormatEditorByExt(String ext) {
        return this.dataSourceFormatEditorByExt.get(ext);
    }

    String getExtensionFor(DataSourceFactory factory) {
        for (String ext : this.dataSourcesByExt.keySet()) {
            if (this.dataSourcesByExt.get(ext) != factory) continue;
            return ext;
        }
        return null;
    }

    public static String getPluginsText() {
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("<h1>Plugins by Extension:</h1>");
        HashMap<String, Object> m = DataSourceRegistry.getInstance().dataSourcesByExt;
        for (Object k : m.keySet()) {
            buf.append("" + k + ": " + m.get(k) + "<br>");
        }
        buf.append("<h1>Plugins by Mime Type:</h1>");
        m = DataSourceRegistry.getInstance().dataSourcesByMime;
        for (Object k : m.keySet()) {
            buf.append("" + k + ": " + m.get(k) + "<br>");
        }
        buf.append("</html>");
        return buf.toString();
    }

    public static List<CompletionContext> getPlugins() {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        HashMap<String, Object> m = DataSourceRegistry.getInstance().dataSourcesByExt;
        for (Object k : m.keySet()) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_AUTOPLOT_SCHEME, "vap+" + k.toString().substring(1) + ":"));
        }
        return result;
    }
}

