/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;
import org.virbo.dsops.Ops;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceUtil {
    public static String unescape(String s) {
        try {
            if (s.contains(" ") && s.contains("%3A")) {
                s = s.replaceAll(" ", "");
            }
            s = URLDecoder.decode(s, "UTF-8");
            return s;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URL newURL(URL context, String spec) throws MalformedURLException {
        if (context == null || spec.contains("://") || spec.startsWith("file:/")) {
            if (!(spec.startsWith("file:/") || spec.startsWith("ftp://") || spec.startsWith("http://") || spec.startsWith("https://"))) {
                spec = "file://" + (spec.charAt(0) == '/' ? spec : '/' + spec);
            }
            return new URL(spec);
        }
        String contextString = context.toString();
        if (!contextString.endsWith("/")) {
            contextString = contextString + "/";
        }
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        return new URL(contextString + spec);
    }

    public static String urlWithinContext(URL context, String url) {
        String result = url.startsWith(context.toString()) ? url.substring(context.toString().length()) : url;
        return result;
    }

    public static String unquote(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static int firstIndexOf(String str, List<String> targets) {
        int i0 = Integer.MAX_VALUE;
        for (String t : targets) {
            int i = str.indexOf(t);
            if (i <= -1 || i >= i0) continue;
            i0 = i;
        }
        return i0 == Integer.MAX_VALUE ? -1 : i0;
    }

    private static int splitIndex(String surl) {
        int i = DataSourceUtil.firstIndexOf(surl, Arrays.asList("%Y", "$Y", "%y", "$y", ".*"));
        i = i != -1 ? surl.lastIndexOf(47, i) : surl.lastIndexOf(47);
        return i;
    }

    public static List<String> findAggregations(List<String> files, boolean remove) {
        return DataSourceUtil.findAggregations(files, remove, false);
    }

    public static List<String> findAggregations(List<String> files, boolean remove, boolean loose) {
        ArrayList<String> accountedFor = new ArrayList<String>();
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> nonAgg = new ArrayList<String>();
        LinkedList<String> notAccountedFor = new LinkedList<String>(files);
        while (notAccountedFor.size() > 0) {
            TimeParser tp;
            String surl = (String)notAccountedFor.remove(0);
            String sagg = DataSourceUtil.makeAggregation(surl);
            if (sagg == null || sagg.equals(surl)) {
                nonAgg.add(surl);
                continue;
            }
            accountedFor.add(surl);
            DatumRange dr = null;
            sagg = URISplit.removeParam(sagg, "timerange");
            try {
                tp = TimeParser.create((String)sagg);
                tp.parse(surl);
            }
            catch (ParseException ex) {
                continue;
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                continue;
            }
            DatumRange dr1 = dr = tp.getTimeRange();
            boolean okay = true;
            ArrayList<String> moveUs = new ArrayList<String>();
            Pattern p = Pattern.compile(tp.getRegex());
            for (String s : notAccountedFor) {
                if (!p.matcher(s).matches()) continue;
                try {
                    tp.parse(s);
                    dr = DatumRangeUtil.union((DatumRange)dr, (DatumRange)tp.getTimeRange());
                    moveUs.add(s);
                }
                catch (ParseException ex) {}
            }
            double nc = dr.width().divide(dr1.width()).doubleValue(Units.dimensionless);
            if (loose || moveUs.size() > 0 && (moveUs.size() > 4 || nc < (double)((1 + moveUs.size()) * 2))) {
                notAccountedFor.removeAll(moveUs);
                accountedFor.addAll(moveUs);
                result.add(URISplit.putParam(sagg, "timerange", dr.toString()));
                continue;
            }
            notAccountedFor.removeAll(moveUs);
        }
        if (remove) {
            files.removeAll(accountedFor);
        }
        return result;
    }

    public static String makeAggregation(String surl, String[] surls) {
        try {
            String sagg = DataSourceUtil.makeAggregation(surl);
            if (sagg == null || sagg.equals(surl)) {
                return surl;
            }
            DatumRange dr = null;
            sagg = URISplit.removeParam(sagg, "timerange");
            TimeParser tp = TimeParser.create((String)sagg);
            tp.parse(surl);
            dr = tp.getTimeRange();
            boolean okay = true;
            for (int i = 0; okay && i < surls.length; ++i) {
                try {
                    tp.parse(surls[i]);
                    dr = DatumRangeUtil.union((DatumRange)dr, (DatumRange)tp.getTimeRange());
                    continue;
                }
                catch (ParseException ex) {
                    okay = false;
                    Logger.getLogger(DataSourceUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (!okay) {
                return surl;
            }
            return URISplit.putParam(sagg, "timerange", dr.toString());
        }
        catch (ParseException ex) {
            Logger.getLogger(DataSourceUtil.class.getName()).log(Level.SEVERE, null, ex);
            return surl;
        }
    }

    private static String replaceLast(String s, List<String> search, List<String> replaceWith, List<Integer> resolution) {
        HashMap<String, Integer> found = new HashMap<String, Integer>();
        int last = -1;
        String flast = null;
        String frepl = null;
        int best = -1;
        int n = search.size();
        while (true) {
            for (int i = 0; i < n; ++i) {
                if (search.get(i) == null) continue;
                Matcher m = Pattern.compile(search.get(i)).matcher(s);
                int idx = -1;
                while (m.find()) {
                    idx = m.start();
                }
                if (idx <= -1) continue;
                found.put(search.get(i), idx);
                if (idx <= last) continue;
                last = idx;
                flast = search.get(i);
                frepl = replaceWith.get(i);
                best = i;
            }
            if (best <= -1) break;
            s = s.substring(0, last) + s.substring(last).replaceAll(flast, frepl);
            int res = resolution.get(best);
            int count = 0;
            for (int i = 0; i < n; ++i) {
                if (resolution.get(i) <= res) continue;
                ++count;
                search.set(i, null);
            }
            if (count == search.size()) {
                return s;
            }
            best = -1;
            last = -1;
        }
        return s;
    }

    public static String makeAggregation(String surl) {
        String yyyy = "/(19|20)\\d{2}/";
        String yyyymmdd = "(?<!\\d)(19|20)(\\d{6})(?!\\d)";
        String yyyyjjj = "(?<!\\d)(19|20)\\d{2}\\d{3}(?!\\d)";
        String yyyymm = "(?<!\\d)(19|20)\\d{2}\\d{2}(?!\\d)";
        String yyyy_mm_dd = "(?<!\\d)(19|20)\\d{2}([\\-_/])\\d{2}\\2\\d{2}(?!\\d)";
        String yyyy_jjj = "(?<!\\d)(19|20)\\d{2}([\\-_/])\\d{3}(?!\\d)";
        String yyyymmdd_HH = "(?<!\\d)(19|20)(\\d{6})(\\-)\\d{2}(?!\\d)";
        String result = surl;
        String[] abs = new String[]{yyyymmdd_HH, yyyy_mm_dd, yyyy_jjj, yyyymmdd, yyyyjjj, yyyymm};
        String timeRange = null;
        for (int i = 0; i < abs.length; ++i) {
            Matcher m = Pattern.compile(abs[i]).matcher(surl);
            if (!m.find()) continue;
            timeRange = m.group(0);
            break;
        }
        if (timeRange == null) {
            return null;
        }
        int day = 3;
        int year = 1;
        int month = 2;
        int hour = 4;
        ArrayList<String> search = new ArrayList<String>(Arrays.asList(yyyymmdd_HH, yyyy_jjj, yyyymmdd, yyyyjjj, yyyymm, yyyy_mm_dd, yyyy));
        ArrayList<String> replac = new ArrayList<String>(Arrays.asList("\\$Y\\$m\\$d-\\$H", "\\$Y$2\\$j", "\\$Y\\$m\\$d", "\\$Y\\$j", "\\$Y\\$m", "\\$Y$2\\$m$2\\$d", "/\\$Y/"));
        ArrayList<Integer> resol = new ArrayList<Integer>(Arrays.asList(hour, day, day, day, month, day, year));
        String s = DataSourceUtil.replaceLast(result, search, replac, resol);
        try {
            TimeParser tp = TimeParser.create((String)s);
            timeRange = tp.parse(surl).getTimeRange().toString();
            result = s;
            return result + (result.contains("?") ? "&" : "?") + "timerange=" + timeRange;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static String toJavaIdentifier(String label) {
        StringBuilder buf = new StringBuilder(label.length());
        for (int i = 0; i < label.length(); ++i) {
            char ch = label.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                buf.append(ch);
                continue;
            }
            if (ch != ' ') continue;
            buf.append("_");
        }
        return buf.toString();
    }

    public static boolean isJavaIdentifier(String label) {
        if (label.length() == 0 || !Character.isJavaIdentifierStart(label.charAt(0))) {
            return false;
        }
        for (int i = 1; i < label.length(); ++i) {
            if (Character.isJavaIdentifierPart(label.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String strjoin(Collection<String> c, String delim) {
        StringBuilder result = new StringBuilder();
        for (String s : c) {
            if (result.length() > 0) {
                result.append(delim);
            }
            result.append(s);
        }
        return result.toString();
    }

    public static String strjoin(long[] dims, String delim) {
        StringBuilder sdims = new StringBuilder();
        if (dims.length > 0) {
            sdims.append(dims[0]);
            for (int i = 1; i < dims.length; ++i) {
                sdims.append(delim).append(dims[i]);
            }
        }
        return sdims.toString();
    }

    public static String strjoin(int[] dims, String delim) {
        StringBuilder sdims = new StringBuilder();
        if (dims.length > 0) {
            sdims.append(dims[0]);
            for (int i = 1; i < dims.length; ++i) {
                sdims.append(delim).append(dims[i]);
            }
        }
        return sdims.toString();
    }

    public static void transfer(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
        dest.close();
        src.close();
    }

    public static void transfer(InputStream src, OutputStream dest) throws IOException {
        byte[] buffer = new byte[16384];
        int i = src.read(buffer);
        while (i != -1) {
            dest.write(buffer, 0, i);
            i = src.read(buffer);
        }
        dest.close();
        src.close();
    }

    public static long[] parseConstraint(String constraint, long recCount) throws ParseException {
        long[] result = new long[]{0L, recCount, 1L};
        if (constraint == null) {
            return result;
        }
        if (constraint.startsWith("[") && constraint.endsWith("]")) {
            constraint = constraint.substring(1, constraint.length() - 1);
        }
        try {
            String[] ss = constraint.split(":", -2);
            if (ss.length > 0 && ss[0].length() > 0) {
                result[0] = Integer.parseInt(ss[0]);
                if (result[0] < 0L) {
                    result[0] = recCount + result[0];
                }
            }
            if (ss.length > 1 && ss[1].length() > 0) {
                result[1] = Integer.parseInt(ss[1]);
                if (result[1] < 0L) {
                    result[1] = recCount + result[1];
                }
            }
            if (ss.length > 2 && ss[2].length() > 0) {
                result[2] = Integer.parseInt(ss[2]);
            }
            if (ss.length == 1) {
                result[1] = -1L;
                result[2] = -1L;
            }
        }
        catch (NumberFormatException ex) {
            throw new ParseException("expected integer: " + ex.toString(), 0);
        }
        return result;
    }

    public static String guessRenderType(QDataSet fillds) {
        String spec;
        String specPref = "spectrogram";
        String srenderType = (String)fillds.property("RENDER_TYPE");
        if (srenderType != null && srenderType.length() > 0) {
            return srenderType;
        }
        QDataSet dep1 = (QDataSet)fillds.property("DEPEND_1");
        QDataSet plane0 = (QDataSet)fillds.property("PLANE_0");
        QDataSet bundle1 = (QDataSet)fillds.property("BUNDLE_1");
        if (fillds.property("JOIN_0") != null) {
            if (fillds.length() == 0) {
                return "series";
            }
            dep1 = (QDataSet)fillds.property("DEPEND_1", 0);
            plane0 = (QDataSet)fillds.property("PLANE_0", 0);
            bundle1 = (QDataSet)fillds.property("BUNDLE_1", 0);
        }
        if (fillds.rank() >= 2) {
            if (bundle1 != null || dep1 != null && SemanticOps.isBundle((QDataSet)fillds) || Ops.isLegacyBundle((QDataSet)fillds)) {
                spec = fillds.length() > 80000 ? "hugeScatter" : "series";
                if (bundle1 != null) {
                    if (bundle1.length() == 3 && bundle1.property("DEPEND_0", 2) != null) {
                        spec = "colorScatter";
                    } else if (bundle1.length() == 3 || bundle1.length() == 4) {
                        Units u3;
                        Units u1;
                        Units u0 = (Units)bundle1.property("UNITS", 0);
                        if (u0 == null) {
                            u0 = Units.dimensionless;
                        }
                        if ((u1 = (Units)bundle1.property("UNITS", 1)) == null) {
                            u1 = Units.dimensionless;
                        }
                        if ((u3 = (Units)bundle1.property("UNITS", bundle1.length() - 1)) != null && UnitsUtil.isOrdinalMeasurement((Units)u3) && u0.getOffsetUnits().isConvertableTo(u1)) {
                            spec = "eventsBar";
                        }
                    }
                }
            } else {
                spec = dep1 == null && fillds.rank() == 2 && fillds.length() > 3 && fillds.length(0) < 4 ? "series" : specPref;
            }
        } else if (fillds.rank() == 0 || fillds.rank() == 1 && SemanticOps.isBundle((QDataSet)fillds)) {
            spec = "digital";
        } else {
            spec = fillds.length() > 80000 ? "hugeScatter" : "series";
            if (plane0 != null) {
                Units u = (Units)plane0.property("UNITS");
                if (u == null) {
                    u = Units.dimensionless;
                }
                if (u != null && (UnitsUtil.isRatioMeasurement((Units)u) || UnitsUtil.isIntervalMeasurement((Units)u))) {
                    spec = "colorScatter";
                }
            }
        }
        return spec;
    }

    public static boolean isHtmlStream(String magic) {
        return magic.toLowerCase().startsWith("<!doc") || magic.toLowerCase().startsWith("<html");
    }

    public static TimeSeriesBrowse getTimeSeriesBrowse(DataSource dss) {
        return dss.getCapability(TimeSeriesBrowse.class);
    }

    public static String guessNameFor(String uri) {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
        String name = "ds";
        if (args.containsKey("arg_0")) {
            name = Ops.safeName((String)((String)args.get("arg_0")));
        } else if (args.containsKey("id")) {
            name = Ops.safeName((String)((String)args.get("id")));
        } else if (args.containsKey("column")) {
            name = Ops.safeName((String)((String)args.get("column")));
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            name = name.toLowerCase();
        } else if (name.length() > 0 && Character.isUpperCase(name.charAt(0))) {
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    public static void main(String[] args) {
        String surl = "http://cdaweb.gsfc.nasa.gov/istp_public/data/polar/hyd_h0/2000/po_h0_hyd_20000109_v01.cdf?ELECTRON_DIFFERENTIAL_ENERGY_FLUX";
        System.err.println(DataSourceUtil.makeAggregation(surl));
    }
}

