/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.metatree;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.das2.datum.Units;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.MetadataModel;
import org.virbo.metatree.IstpMetadataModel;
import org.virbo.metatree.SpaseMetadataModel;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataUtil {
    public static synchronized Units lookupUnits(String sunits) {
        return SemanticOps.lookupUnits((String)sunits);
    }

    public static Units lookupTimeLengthUnit(String s) throws ParseException {
        return SemanticOps.lookupTimeLengthUnit((String)s);
    }

    public static synchronized Units lookupTimeUnits(String units) throws ParseException {
        return SemanticOps.lookupTimeUnits((String)units);
    }

    public static Map<String, Object> toMetaTree(Node node) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Object value = child.hasChildNodes() ? MetadataUtil.toMetaTree(child) : child.getNodeValue();
            result.put(child.getNodeName(), value);
        }
        return result;
    }

    public static Node getNode(Node node, String[] path) {
        int i = 0;
        Node child = node.getFirstChild();
        while (i < path.length) {
            if (child == null) {
                throw new IllegalArgumentException("couldn't find node");
            }
            if (child.getNodeName().equals(path[i])) {
                node = child;
                child = node.getFirstChild();
                ++i;
                continue;
            }
            child = child.getNextSibling();
        }
        return node;
    }

    public static Object getNode(Map<String, Object> tree, String[] path) {
        int i = 0;
        Object child = tree.get(path[0]);
        ++i;
        while (i < path.length) {
            if (child == null) {
                return null;
            }
            if (!(child instanceof Map)) {
                return null;
            }
            child = ((Map)child).get(path[i]);
            ++i;
        }
        return child;
    }

    public static Map<String, Object> sliceProperties(Map<String, Object> properties, int sliceDimension) {
        int i;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(properties);
        ArrayList<Object> deps = new ArrayList<Object>(4);
        for (i = 0; i < 4; ++i) {
            deps.add(i, properties.get("DEPEND_" + i));
        }
        deps.remove(sliceDimension);
        deps.add(2, null);
        for (i = 0; i < 3; ++i) {
            result.put("DEPEND_" + i, deps.get(i));
        }
        return result;
    }

    public static Map<String, Object> transposeProperties(Map<String, Object> properties) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(properties);
        result.put("DEPEND_1", properties.get("DEPEND_0"));
        result.put("DEPEND_0", properties.get("DEPEND_1"));
        return result;
    }

    public static Map<String, Object> sprocess(String c, Map<String, Object> properties) {
        Scanner s = new Scanner(c);
        s.useDelimiter("[\\(\\),]");
        while (s.hasNext()) {
            String cmd = s.next();
            if (cmd.equals("|slices")) {
                Pattern skipPattern = Pattern.compile("\\':?\\'");
                ArrayList<Object> args = new ArrayList<Object>();
                while (s.hasNextInt() || s.hasNext(skipPattern)) {
                    if (s.hasNextInt()) {
                        args.add(s.nextInt());
                        continue;
                    }
                    args.add(s.next());
                }
                for (int idim = args.size() - 1; idim >= 0; --idim) {
                    if (!(args.get(idim) instanceof Integer)) continue;
                    properties = MetadataUtil.sliceProperties(properties, idim);
                }
                continue;
            }
            if (cmd.startsWith("|slice")) {
                int dim = cmd.charAt(6) - 48;
                int idx = s.nextInt();
                properties = MetadataUtil.sliceProperties(properties, dim);
                continue;
            }
            if (cmd.startsWith("|collapse")) {
                int dim = cmd.charAt(9) - 48;
                properties = MetadataUtil.sliceProperties(properties, dim);
                continue;
            }
            if (cmd.equals("|autoHistogram")) {
                HashMap<String, Object> newproperties = new HashMap<String, Object>();
                newproperties.put("DEPEND_0", properties);
                properties = newproperties;
                continue;
            }
            if (cmd.equals("|transpose")) {
                properties = MetadataUtil.transposeProperties(properties);
                continue;
            }
            return new HashMap<String, Object>();
        }
        return properties;
    }

    public static MetadataModel getMetadataModel(String t) {
        if (t == null) {
            return null;
        }
        if (t.equals("ISTP-CDF")) {
            return new IstpMetadataModel();
        }
        if (t.equals("SPASE")) {
            return new SpaseMetadataModel();
        }
        return null;
    }
}

