/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.netCDF;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.MetadataModel;
import org.virbo.dsutil.TransposeRankNDataSet;
import org.virbo.metatree.IstpMetadataModel;
import org.virbo.netCDF.NetCDFDataSourceFactory;
import org.virbo.netCDF.NetCdfVarDataSet;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetCDFDataSource
extends AbstractDataSource {
    Variable variable;
    String sMyUrl;
    String svariable;
    NetcdfDataset ncfile;
    String constraint;

    public NetCDFDataSource(URI uri) throws IOException {
        super(uri);
        this.parseUrl();
    }

    private void parseUrl() {
        String surl = DataSetURI.fromUri((URI)this.uri);
        int i = surl.lastIndexOf(63);
        this.sMyUrl = i > -1 ? surl.substring(0, i) : surl;
        if (i == -1) {
            this.svariable = null;
            return;
        }
        Map p = this.getParams();
        if (p.containsKey("id")) {
            this.svariable = (String)p.get("id");
        } else {
            this.svariable = (String)p.get("arg_0");
            this.svariable = this.svariable.replaceAll(" ", "+");
        }
        int ic = this.svariable.indexOf("[");
        if (ic > -1) {
            this.constraint = this.svariable.substring(ic);
            this.svariable = this.svariable.substring(0, ic);
        } else {
            this.constraint = null;
        }
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws IOException {
        mon.started();
        this.readData(mon);
        NetCdfVarDataSet result = NetCdfVarDataSet.create(this.variable, this.constraint, this.ncfile, mon);
        QDataSet qresult = this.checkLatLon(result);
        mon.finished();
        return qresult;
    }

    private QDataSet checkLatLon(NetCdfVarDataSet v) {
        int lat = -1;
        int lon = -1;
        for (int i = 0; i < v.rank(); ++i) {
            QDataSet dep = (QDataSet)v.property("DEPEND_" + i);
            if (dep == null) continue;
            String name = (String)dep.property("NAME");
            if ("lon".equals(name)) {
                lon = i;
            }
            if (!"lat".equals(name)) continue;
            lat = i;
        }
        if (lat > -1 && lon > -1 && lat < lon) {
            int[] order = new int[v.rank()];
            for (int i = 0; i < v.rank(); ++i) {
                order[i] = i;
            }
            int t = order[lat];
            order[lat] = order[lon];
            order[lon] = t;
            TransposeRankNDataSet transpose = new TransposeRankNDataSet((QDataSet)v, order);
            return transpose;
        }
        return v;
    }

    private synchronized void readData(ProgressMonitor mon) throws IOException {
        String location;
        boolean makeLocal = true;
        if (makeLocal) {
            File file = this.getFile(mon);
            location = file.toURI().toURL().toString();
        } else {
            location = DataSetURI.fromUri((URI)this.resourceURI);
        }
        NetcdfDataset dataset = null;
        mon.started();
        if (this.sMyUrl.endsWith(".ncml")) {
            dataset = NcMLReader.readNcML((String)location, null);
        } else {
            NetcdfFile f = NetcdfFile.open((String)location);
            dataset = new NetcdfDataset(f);
        }
        this.ncfile = dataset;
        List variables = dataset.getVariables();
        if (this.svariable == null) {
            for (int i = 0; i < variables.size(); ++i) {
                Variable v = (Variable)variables.get(i);
                if (v.getDimension(0).getName().equals(v.getName())) continue;
                this.variable = v;
                break;
            }
        } else {
            for (int i = 0; i < variables.size(); ++i) {
                Variable v = (Variable)variables.get(i);
                if (!v.getName().replaceAll(" ", "+").equals(this.svariable)) continue;
                this.variable = v;
            }
        }
        mon.finished();
    }

    public static DataSourceFactory getFactory() {
        return new NetCDFDataSourceFactory();
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        mon.started();
        mon.setProgressMessage("reading metadata");
        this.readData(mon);
        List attr = this.variable.getAttributes();
        if (attr == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int i = 0; i < attr.size(); ++i) {
            Attribute at = (Attribute)attr.get(i);
            result.put(at.getName(), at.getStringValue());
        }
        mon.finished();
        return result;
    }

    public MetadataModel getMetadataModel() {
        List attr;
        if (this.variable == null) {
            try {
                this.readData((ProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException ex) {
                System.err.println("exception when trying to readData to test for ISTP props, returning null model");
                return MetadataModel.createNullModel();
            }
        }
        if ((attr = this.variable.getAttributes()) == null) {
            return null;
        }
        for (int i = 0; i < attr.size(); ++i) {
            Attribute at = (Attribute)attr.get(i);
            if (!at.getName().equals("VAR_TYPE")) continue;
            return new IstpMetadataModel();
        }
        return MetadataModel.createNullModel();
    }
}

