/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.netCDF;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.HtmlResponseIOException;
import org.virbo.datasource.MetadataModel;
import org.virbo.datasource.URISplit;
import org.virbo.netCDF.NetCDFDataSource;
import ucar.ma2.DataType;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetCDFDataSourceFactory
implements DataSourceFactory {
    public DataSource getDataSource(URI uri) throws IOException {
        return new NetCDFDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws IOException {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            String file = DataSetURI.fromUri((URI)cc.resourceURI);
            NetcdfDataset dataset = this.getDataSet(file);
            List vars = dataset.getVariables();
            for (int j = 0; j < vars.size(); ++j) {
                boolean isFormattedTime;
                Variable v = (Variable)vars.get(j);
                if (v.getDimensions().size() == 0) continue;
                boolean bl = isFormattedTime = v.getDataType() == DataType.CHAR && v.getRank() == 2 && v.getShape(1) >= 14 && v.getShape(1) <= 30;
                if (!isFormattedTime && !v.getDataType().isNumeric()) continue;
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, v.getName(), (DataSourceFactory)this, "arg_0", v.getNameAndDimensions(), v.getDescription(), true));
            }
        }
        return result;
    }

    public MetadataModel getMetadataModel(URL url) {
        return MetadataModel.createNullModel();
    }

    private NetcdfDataset getDataSet(String resource) throws IOException {
        if (resource.endsWith(".ncml")) {
            return NcMLReader.readNcML((String)resource, null);
        }
        NetcdfFile f = NetcdfFile.open((String)resource);
        NetcdfDataset dataset = new NetcdfDataset(f);
        return dataset;
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        try {
            URISplit split = URISplit.parse((String)surl);
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            DataSetURI.getFile((String)surl, (ProgressMonitor)mon);
            NetcdfDataset dataset = this.getDataSet(split.file);
            int depCount = 0;
            List vars = dataset.getVariables();
            String svariable = (String)params.get("arg_0");
            if (svariable != null) {
                int ic = svariable.indexOf("[");
                if (ic > -1) {
                    svariable = svariable.substring(0, ic);
                }
                if (svariable != null) {
                    svariable = svariable.replaceAll(" ", "+");
                }
            }
            boolean haveIt = false;
            for (int j = 0; j < vars.size(); ++j) {
                Variable v = (Variable)vars.get(j);
                if (v.getDimensions().isEmpty()) continue;
                List l = v.getDimension(0).getCoordinateVariables();
                if (l.size() > 1) {
                    throw new IllegalArgumentException("Huh?");
                }
                for (int i = 0; i < l.size(); ++i) {
                    Variable dv = (Variable)l.get(0);
                    if (dv == v) continue;
                    ++depCount;
                }
                if (!v.getName().replaceAll(" ", "+").equals(svariable)) continue;
                haveIt = true;
            }
            if (depCount == 1) {
                return false;
            }
            return !haveIt;
        }
        catch (HtmlResponseIOException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getCapability(Class<T> clazz) {
        return null;
    }
}

