/*
 * Decompiled with CFR 0.152.
 */
package com.cottagesystems.jdiskhog;

import com.cottagesystems.jdiskhog.DiskUsageModel;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FSTreeModel
implements TreeModel {
    DecimalFormat nf = new DecimalFormat();
    DiskUsageModel model;
    File root;
    Map<File, File[]> listings = new HashMap<File, File[]>();
    ArrayList listeners = new ArrayList();

    FSTreeModel(DiskUsageModel model, File root) {
        this.model = model;
        this.root = root;
    }

    public Object getRoot() {
        return new TreeNode(this.root, null, true);
    }

    public Object getChild(Object parent, int index) {
        File[] ffs;
        File fparent = ((TreeNode)parent).getFile();
        File[] ff = this.listings.get(fparent);
        File reportParent = null;
        File ff1 = ff[index];
        while (ff1.isDirectory() && (ffs = ff1.listFiles()).length == 1 && ffs[0].isDirectory()) {
            ff1 = ffs[0];
            reportParent = fparent;
        }
        return new TreeNode(ff1, fparent);
    }

    public synchronized int getChildCount(Object parent) {
        final File f = ((TreeNode)parent).getFile();
        if (!f.exists()) {
            return 0;
        }
        File[] ff = this.listings.get(f);
        if (ff == null) {
            ff = f.listFiles();
            Arrays.sort(ff, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Long l;
                    File f1 = (File)o1;
                    File f2 = (File)o2;
                    if (f1 == null || f2 == null) {
                        System.err.println("" + f + " lists null!");
                        return -1;
                    }
                    long s1 = f1.isFile() ? f1.length() / 1000L : ((l = FSTreeModel.this.model.usage(f1)) == null ? 0L : l);
                    long s2 = f2.isFile() ? f2.length() / 1000L : ((l = FSTreeModel.this.model.usage(f2)) == null ? 0L : l);
                    if (f1.isFile() && f2.isFile()) {
                        String key1 = ((File)o1).getName();
                        String key2 = ((File)o2).getName();
                        return key1.compareTo(key2);
                    }
                    if (f1.isDirectory() && f2.isDirectory()) {
                        return s1 < s2 ? 1 : -1;
                    }
                    return f1.isDirectory() ? -1 : 1;
                }
            });
            this.listings.put(f, ff);
        }
        return ff.length;
    }

    public boolean isLeaf(Object node) {
        File f = ((TreeNode)node).getFile();
        return f.isFile();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public File getFile(TreePath context) {
        Object node = context.getPathComponent(context.getPathCount() - 1);
        return ((TreeNode)node).getFile();
    }

    private boolean isParentOf(File parent, File child) {
        try {
            return child.getCanonicalPath().startsWith(parent.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getIndexOfChild(Object parent, Object child) {
        File f = ((TreeNode)parent).getFile();
        File fchild = ((TreeNode)child).getFile();
        File[] ff = this.listings.get(f);
        for (int i = 0; i < ff.length; ++i) {
            if (!ff[i].equals(fchild) && !this.isParentOf(ff[i], fchild)) continue;
            return i;
        }
        throw new IllegalArgumentException("bad child");
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    class TreeNode {
        File parentFile;
        File f;
        boolean abs;

        TreeNode(File f) {
            this(f, null);
        }

        TreeNode(File f, File parentFile) {
            this(f, parentFile, false);
        }

        TreeNode(File f, File parentFile, boolean abs) {
            this.f = f;
            this.parentFile = parentFile;
            this.abs = abs;
        }

        public File getFile() {
            return this.f;
        }

        private String getName() {
            if (this.abs) {
                return this.f.toString();
            }
            if (this.parentFile == null) {
                return this.f.getName();
            }
            return this.f.toString().substring(this.parentFile.toString().length() + 1);
        }

        public String toString() {
            if (this.f.isFile()) {
                return this.getName() + " " + FSTreeModel.this.nf.format(this.f.length() / 1000L) + " KB";
            }
            if (this.f.exists()) {
                Long usages = FSTreeModel.this.model.usage(this.f);
                if (usages == null) {
                    return this.getName() + " ??? KB";
                }
                return this.getName() + " " + FSTreeModel.this.nf.format(FSTreeModel.this.model.usage(this.f)) + " KB";
            }
            return this.getName() + " 0 KB";
        }
    }
}

