/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import org.autoplot.pngwalk.PngWalkTool1;
import org.autoplot.pngwalk.WalkUtil;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeParser;
import org.das2.util.ArgumentList;
import org.das2.util.filesystem.FileSystem;
import org.virbo.autoplot.ScriptContext;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.autoplot.bookmarks.BookmarksManager;
import org.virbo.datasource.DataSetURI;
import org.xml.sax.SAXException;

public class DemoPngWalk {
    public static void main(String[] args) {
        DataSetURI.init();
        System.err.println("this is pngwalk 20090529");
        ArgumentList alm = new ArgumentList("DemoPngWalk");
        alm.addBooleanSwitchArgument("nativeLAF", "n", "nativeLAF", "use the system look and feel");
        alm.addOptionalPositionArgument(0, "template", "file:/tmp/pngwalk/product_$Y$m$d.png", "initial template to use.");
        alm.process(args);
        if (alm.getBooleanValue("nativeLAF")) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String template = alm.getValue("template");
        DemoPngWalk.start(template, null);
    }

    public static PngWalkTool1 start(String template, Window parent) {
        final PngWalkTool1 tool = new PngWalkTool1();
        if (template != null) {
            tool.setTemplate(template);
        } else {
            Preferences prefs = Preferences.userNodeForPackage(PngWalkTool1.class);
            String srecent = prefs.get("pngWalkRecent", "");
            if (srecent.equals("")) {
                tool.setTemplate("file:/tmp/pngwalk/product_$Y$m$d.png");
            } else {
                try {
                    List<Bookmark> books = Bookmark.parseBookmarks(srecent);
                    tool.setTemplate(((Bookmark.Item)books.get(0)).getUri());
                }
                catch (SAXException ex) {
                    Logger.getLogger(DemoPngWalk.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(DemoPngWalk.class.getName()).log(Level.SEVERE, null, ex);
                }
                tool.setTemplate("file:/tmp/pngwalk/product_$Y$m$d.png");
            }
        }
        PngWalkTool1.ActionEnabler enabler = new PngWalkTool1.ActionEnabler(){

            public boolean isActionEnabled(String filename) {
                int i1;
                String s = filename;
                String template = tool.getTemplate();
                int i0 = template.indexOf("_$Y");
                if (i0 == -1) {
                    i0 = template.indexOf("_%Y");
                }
                if ((i1 = s.indexOf(".png")) == -1 || i0 == -1) {
                    return false;
                }
                String productFile = template.substring(0, i0) + ".vap";
                try {
                    return WalkUtil.fileExists(productFile);
                }
                catch (FileSystem.FileSystemOfflineException ex) {
                    Logger.getLogger(DemoPngWalk.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(DemoPngWalk.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
        };
        final int op = parent == null ? 3 : 2;
        tool.addFileAction(enabler, "autoplot", new AbstractAction("Launch Autoplot"){

            public void actionPerformed(ActionEvent e) {
                int i1;
                String s = tool.getSelectedFile();
                String template = tool.getTemplate();
                int i0 = template.indexOf("_$Y");
                if (i0 == -1) {
                    i0 = template.indexOf("_%Y");
                }
                if ((i1 = s.indexOf(".png")) == -1) {
                    return;
                }
                TimeParser tp = TimeParser.create(template.substring(i0 + 1, i1));
                String timeRange = s.substring(i0 + 1, i1);
                try {
                    DatumRange dr = tp.parse(timeRange).getTimeRange();
                    timeRange = dr.toString().replaceAll(" ", "+");
                }
                catch (ParseException ex) {
                    throw new RuntimeException(ex);
                }
                String productFile = template.substring(0, i0) + ".vap";
                final String suri = productFile + "?timeRange=" + timeRange;
                Runnable run = new Runnable(){

                    public void run() {
                        try {
                            ScriptContext.createGui();
                            ScriptContext.plot(suri);
                            ((JFrame)ScriptContext.getViewWindow()).setDefaultCloseOperation(op);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(DemoPngWalk.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                };
                new Thread(run).start();
            }
        });
        JFrame frame = new JFrame("PNG Walk Tool");
        if (parent == null) {
            frame.setDefaultCloseOperation(3);
        } else {
            frame.setDefaultCloseOperation(2);
        }
        frame.setJMenuBar(DemoPngWalk.createMenuBar(tool, frame));
        frame.getContentPane().add(tool);
        frame.pack();
        frame.setVisible(true);
        return tool;
    }

    private static JMenuBar createMenuBar(final PngWalkTool1 tool, final JFrame f) {
        JMenuBar result = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(new AbstractAction(f.getDefaultCloseOperation() == 3 ? "Exit" : "Close"){

            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        result.add(fileMenu);
        final JMenu bookmarksMenu = new JMenu("Bookmarks");
        final BookmarksManager man = new BookmarksManager((Frame)f, true);
        man.getModel().addPropertyChangeListener("list", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                man.updateBookmarks(bookmarksMenu, tool.getSelector());
            }
        });
        man.setVisible(false);
        man.setPrefNode("pngwalk");
        man.updateBookmarks(bookmarksMenu, tool.getSelector());
        result.add(bookmarksMenu);
        return result;
    }
}

