/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.autoplot.pngwalk.ContextFlowView;
import org.autoplot.pngwalk.CoversWalkView;
import org.autoplot.pngwalk.DemoPngWalk;
import org.autoplot.pngwalk.GridPngWalkView;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.QualityControlPanel;
import org.autoplot.pngwalk.QualityControlRecord;
import org.autoplot.pngwalk.RowPngWalkView;
import org.autoplot.pngwalk.SinglePngWalkView;
import org.autoplot.pngwalk.SubrangeEditorDialog;
import org.autoplot.pngwalk.WalkImageSequence;
import org.autoplot.pngwalk.WalkUtil;
import org.das2.components.TearoffTabbedPane;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.util.ArgumentList;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.AppManager;
import org.virbo.autoplot.AutoplotUI;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.ScriptContext;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.autoplot.bookmarks.BookmarksManager;
import org.virbo.autoplot.bookmarks.Util;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.FileSystemUtil;
import org.virbo.datasource.URISplit;
import org.xml.sax.SAXException;

public final class PngWalkTool1
extends JPanel {
    private static boolean ENABLE_QUALITY_CONTROL;
    private QualityControlPanel qcPanel = null;
    public static final String PREF_RECENT = "pngWalkRecent";
    public PngWalkView[] views;
    TearoffTabbedPane tabs;
    WalkImageSequence seq;
    Pattern actionMatch = null;
    String actionCommand = null;
    static final Logger logger;
    private static final String RESOURCES = "/org/virbo/autoplot/resources/";
    public static final Icon WARNING_ICON;
    public static final Icon ERROR_ICON;
    public static final Icon BUSY_ICON;
    public static final Icon READY_ICON;
    public static final Icon IDLE_ICON;
    int returnTabIndex = 0;
    DatumRange pendingGoto = null;
    private transient PropertyChangeListener indexListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String item = PngWalkTool1.this.seq.currentImage().getUri().toString();
            for (int i = 0; i < PngWalkTool1.this.actionEnablers.size(); ++i) {
                boolean actionEnabled = PngWalkTool1.this.actionEnablers.get(i).isActionEnabled(item);
                PngWalkTool1.this.actionButtons.get(i).setEnabled(actionEnabled);
                if (!actionEnabled) continue;
                PngWalkTool1.this.actionButtons.get(i).setActionCommand(PngWalkTool1.this.actionCommand + " " + item);
            }
            if (PngWalkTool1.this.qcPanel != null && PngWalkTool1.this.seq.getQualityControlSequence() != null) {
                PngWalkTool1.this.qcPanel.displayRecord(PngWalkTool1.this.seq.getQualityControlSequence().getQualityControlRecord(PngWalkTool1.this.seq.getIndex()));
            }
        }
    };
    private transient PropertyChangeListener statusListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            PngWalkTool1.this.setStatus((String)evt.getNewValue());
        }
    };
    private transient PropertyChangeListener qcStatusListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (PngWalkTool1.this.seq.getQualityControlSequence() != null) {
                int[] n = PngWalkTool1.this.seq.getQualityControlSequence().getQCTotals();
                PngWalkTool1.this.qcPanel.setStatus(n[0], n[1], n[2], n[3]);
            }
        }
    };
    protected int thumbnailSize = 100;
    public static final String PROP_THUMBNAILSIZE = "thumbnailSize";
    protected String status = "initializing...";
    public static final String PROP_STATUS = "status";
    public static final ActionEnabler LOCAL_FILE_ENABLER;
    List<ActionEnabler> actionEnablers = new ArrayList<ActionEnabler>();
    List<String> actionCommands = new ArrayList<String>();
    List<JButton> actionButtons = new ArrayList<JButton>();
    private JPanel actionButtonsPanel;
    private DataSetSelector dataSetSelector1;
    private JButton editRangeButton;
    private JPanel jPanel1;
    private JButton jumpToFirstButton;
    private JButton jumpToLastButton;
    private JButton nextButton;
    private JButton nextSetButton;
    private JPanel pngsPanel;
    private JButton prevButton;
    private JButton prevSetButton;
    private JCheckBox showMissingCheckBox;
    private JLabel statusLabel;
    private JTextField timeFilterTextField;
    private JCheckBox useRangeCheckBox;

    public static void main(String[] args) {
        DataSetURI.init();
        System.err.println("this is pngwalk 20110114");
        ArgumentList alm = new ArgumentList("PngWalkTool1");
        alm.addOptionalSwitchArgument("nativeLAF", "n", "nativeLAF", alm.TRUE, "use the system look and feel (T or F)");
        alm.addOptionalSwitchArgument("mode", "m", "mode", "filmStrip", "initial display mode: grid, filmStrip, covers, contextFlow, etc");
        alm.addOptionalSwitchArgument("goto", "g", "goto", "", "start display at the beginning of this range, e.g. 2010-01-01");
        alm.addBooleanSwitchArgument("qualityControl", "q", "qualityControl", "enable quality control review mode");
        String home = System.getProperty("user.home") + System.getProperty("file.separator");
        String output = "file:" + home + "pngwalk" + System.getProperty("file.separator") + "product_$Y$m$d.png";
        alm.addOptionalPositionArgument(0, "template", output, "initial template to use.");
        alm.addOptionalSwitchArgument("template", "t", "template", output, "initial template to use.");
        alm.process(args);
        if (alm.getBooleanValue("nativeLAF")) {
            logger.fine("nativeLAF");
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ENABLE_QUALITY_CONTROL = alm.getBooleanValue("qualityControl");
        String template = alm.getValue("template");
        PngWalkTool1 pngWalkTool = PngWalkTool1.start(template, null);
        pngWalkTool.processArguments(alm);
    }

    private static String readPngwalkFile(String template) {
        URISplit split = URISplit.parse((String)template);
        InputStream in = null;
        try {
            String t;
            Properties p = new Properties();
            File local = FileSystemUtil.doDownload((String)split.file, (ProgressMonitor)new NullProgressMonitor());
            in = new FileInputStream(local);
            p.load(in);
            template = t = split.path + p.getProperty("product") + "_" + p.getProperty("timeFormat") + ".png";
        }
        catch (FileSystem.FileSystemOfflineException ex) {
            Logger.getLogger(PngWalkTool1.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PngWalkTool1.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException("File does not exist: " + template);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
        return template;
    }

    public static PngWalkTool1 start(String template, final Window parent) {
        final PngWalkTool1 tool = new PngWalkTool1();
        if (template != null) {
            if (template.endsWith(".pngwalk")) {
                template = PngWalkTool1.readPngwalkFile(template);
            }
            tool.setTemplate(template);
        }
        String home = System.getProperty("user.home") + System.getProperty("file.separator");
        String output = "file:" + home + "pngwalk" + System.getProperty("file.separator") + "product_$Y$m$d.png";
        String sdeft = "<bookmark-list>  <bookmark>     <title>User Bookdefault</title>     <url>" + output + "</url>  </bookmark></bookmark-list>";
        List<Bookmark> deft = null;
        try {
            deft = Bookmark.parseBookmarks(sdeft);
        }
        catch (SAXException ex) {
            Logger.getLogger(PngWalkTool1.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PngWalkTool1.class.getName()).log(Level.SEVERE, null, ex);
        }
        Util.loadRecent("pngwalkRecent", tool.dataSetSelector1, deft);
        ActionEnabler enabler = new ActionEnabler(){

            public boolean isActionEnabled(String filename) {
                int i1;
                String s = filename;
                String template = tool.getTemplate();
                int i0 = template.indexOf("_$Y");
                if (i0 == -1) {
                    i0 = template.indexOf("_%Y");
                }
                if ((i1 = s.indexOf(".png")) == -1 || i0 == -1) {
                    return false;
                }
                String productFile = template.substring(0, i0) + ".vap";
                try {
                    return WalkUtil.fileExists(productFile);
                }
                catch (FileSystem.FileSystemOfflineException ex) {
                    Logger.getLogger(DemoPngWalk.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(DemoPngWalk.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
        };
        String lap = "View in Autoplot";
        tool.addFileAction(enabler, "autoplot", new AbstractAction("View in Autoplot"){

            public void actionPerformed(ActionEvent e) {
                String suri;
                String productFile = null;
                if (tool.seq == null) {
                    productFile = null;
                    suri = null;
                } else {
                    int i0;
                    String s = tool.getSelectedFile();
                    String template = tool.getTemplate();
                    if (s.startsWith("file:/") && !s.startsWith("file:///") && template.startsWith("file:///")) {
                        s = "file:///" + s.substring(6);
                    }
                    if ((i0 = template.indexOf("_$Y")) == -1) {
                        i0 = template.indexOf("_%Y");
                    }
                    TimeParser tp = TimeParser.create(template);
                    String timeRange = s;
                    try {
                        DatumRange dr = tp.parse(timeRange).getTimeRange();
                        timeRange = dr.toString().replaceAll(" ", "+");
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                    productFile = template.substring(0, i0) + ".vap";
                    suri = productFile + "?timeRange=" + timeRange;
                }
                Runnable run = new Runnable(){

                    public void run() {
                        try {
                            ScriptContext.createGui();
                            if (suri != null) {
                                ScriptContext.plot(suri);
                            }
                            Window apWindow = ScriptContext.getViewWindow();
                            if (parent == null) {
                                apWindow.setVisible(true);
                            }
                            apWindow.toFront();
                            apWindow.repaint();
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(DemoPngWalk.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                };
                new Thread(run).start();
            }
        });
        JFrame frame = new JFrame("PNG Walk Viewer");
        frame.setIconImage(AutoplotUtil.getAutoplotIcon());
        frame.setJMenuBar(PngWalkTool1.createMenuBar(tool, frame));
        AppManager.getInstance().addApplication(tool);
        frame.getContentPane().add(tool);
        frame.addWindowListener(AppManager.getInstance().getWindowListener(tool));
        frame.pack();
        frame.setLocationRelativeTo(parent);
        frame.setVisible(true);
        return tool;
    }

    private static JMenuBar createMenuBar(final PngWalkTool1 tool, final JFrame f) {
        JMenuBar result = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(new AbstractAction("Close"){

            public void actionPerformed(ActionEvent e) {
                if (AppManager.getInstance().getApplicationCount() == 1) {
                    if (0 == JOptionPane.showConfirmDialog(tool, "Quit application?", "Quit PNG Walk", 2)) {
                        f.dispose();
                        AppManager.getInstance().closeApplication(tool);
                    }
                } else {
                    f.dispose();
                    AppManager.getInstance().closeApplication(tool);
                }
            }
        });
        fileMenu.add(new AbstractAction("Quit"){

            public void actionPerformed(ActionEvent e) {
                f.dispose();
                AppManager.getInstance().quit();
            }
        });
        result.add(fileMenu);
        BindingGroup bg = new BindingGroup();
        JMenu navMenu = new JMenu("Navigate");
        navMenu.add(new AbstractAction("Go To Date..."){

            public void actionPerformed(ActionEvent e) {
                DatumRange dr = tool.seq.getTimeSpan();
                if (dr == null) {
                    JOptionPane.showMessageDialog(tool, "File times are not available");
                    return;
                }
                String str = JOptionPane.showInputDialog(tool, "Select date to display", TimeDatumFormatter.DAYS.format(TimeUtil.prevMidnight(dr.min())));
                if (str != null) {
                    try {
                        DatumRange ds = DatumRangeUtil.parseTimeRange(str);
                        tool.seq.gotoSubrange(ds);
                    }
                    catch (ParseException ex) {
                        try {
                            double d = Units.us2000.parse(str).doubleValue(Units.us2000);
                            tool.seq.gotoSubrange(DatumRange.newDatumRange(d, d, Units.us2000));
                        }
                        catch (ParseException ex2) {
                            JOptionPane.showMessageDialog(tool, "parse error: " + ex2);
                        }
                        return;
                    }
                    catch (RuntimeException ex) {
                        tool.setStatus("warning: " + ex.toString());
                    }
                }
            }
        });
        navMenu.add(new AbstractAction("Previous Item"){

            public void actionPerformed(ActionEvent e) {
                tool.seq.skipBy(-1);
            }
        }).setAccelerator(KeyStroke.getKeyStroke(37, 0));
        navMenu.add(new AbstractAction("Next Item"){

            public void actionPerformed(ActionEvent e) {
                tool.seq.skipBy(1);
            }
        }).setAccelerator(KeyStroke.getKeyStroke(39, 0));
        result.add(navMenu);
        JMenu optionsMenu = new JMenu("Options");
        JCheckBoxMenuItem persMi = new JCheckBoxMenuItem("Use Perspective");
        bg.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)tool.views[4], (Property)BeanProperty.create((String)"perspective"), (Object)persMi, (Property)BeanProperty.create((String)"selected")));
        bg.bind();
        optionsMenu.add(persMi);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        JMenu thumbsizeMenu = new JMenu("Thumbnail Size");
        int[] sizes = new int[]{50, 100, 200, 400};
        for (int i = 0; i < sizes.length; ++i) {
            final int fsize = sizes[i];
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(new AbstractAction("" + fsize + " px"){

                public void actionPerformed(ActionEvent e) {
                    tool.setThumbnailSize(fsize);
                }
            });
            buttonGroup1.add(mi);
            if (tool.getThumbnailSize() == sizes[i]) {
                buttonGroup1.setSelected(mi.getModel(), true);
            }
            thumbsizeMenu.add(mi);
        }
        optionsMenu.add(thumbsizeMenu);
        result.add(optionsMenu);
        final JMenu bookmarksMenu = new JMenu("Bookmarks");
        final BookmarksManager man = new BookmarksManager((Frame)f, true);
        man.getModel().addPropertyChangeListener("list", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                man.updateBookmarks(bookmarksMenu, tool.getSelector());
            }
        });
        man.setVisible(false);
        man.setPrefNode("pngwalk");
        man.updateBookmarks(bookmarksMenu, tool.getSelector());
        result.add(bookmarksMenu);
        return result;
    }

    public PngWalkTool1() {
        this.initComponents();
        this.dataSetSelector1.setEnableDataSource(false);
        this.dataSetSelector1.setAcceptPattern("(?i).*(\\.gif|\\.png|\\.jpg)");
        this.dataSetSelector1.setSuggestFiles(false);
        this.dataSetSelector1.registerActionTrigger(".*\\.pngwalk", (Action)new AbstractAction("pngwalk"){

            public void actionPerformed(ActionEvent ev) {
                String template = PngWalkTool1.this.dataSetSelector1.getValue();
                if (template.endsWith(".pngwalk")) {
                    template = PngWalkTool1.readPngwalkFile(template);
                }
                PngWalkTool1.this.setTemplate(template);
            }
        });
        this.views = new PngWalkView[7];
        this.views[0] = new GridPngWalkView(null);
        this.views[1] = new RowPngWalkView(null);
        this.views[2] = new SinglePngWalkView(null);
        this.views[3] = new SinglePngWalkView(null);
        this.views[4] = new CoversWalkView(null);
        this.views[5] = new SinglePngWalkView(null);
        this.views[6] = new ContextFlowView(null);
        int SCROLLBAR_HEIGHT = 20;
        this.views[1].setMinimumSize(new Dimension(100, 100));
        this.views[4].setMinimumSize(new Dimension(100, 100));
        this.views[3].setPreferredSize(new Dimension(640, 480));
        final JSplitPane p = new JSplitPane(0, this.views[1], this.views[2]);
        p.setDividerLocation(this.getThumbnailSize() + 20);
        this.views[1].addPropertyChangeListener(PROP_THUMBNAILSIZE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                p.setDividerLocation((Integer)evt.getNewValue() + 20);
            }
        });
        final JSplitPane p2 = new JSplitPane(0, this.views[4], this.views[5]);
        p.setDividerLocation(this.getThumbnailSize() + 20);
        this.views[4].addPropertyChangeListener(PROP_THUMBNAILSIZE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                p2.setDividerLocation((Integer)evt.getNewValue() + 20);
            }
        });
        this.tabs = new TearoffTabbedPane();
        this.tabs.addTab("Single", new JScrollPane(this.views[3]));
        this.tabs.addTab("ContextFlow", this.views[6]);
        this.tabs.addTab("Grid", this.views[0]);
        this.tabs.addTab("Film Strip", p);
        this.tabs.addTab("Covers", p2);
        this.tabs.setSelectedIndex(3);
        for (int i = 0; i < this.views.length; ++i) {
            this.views[i].getMouseTarget().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int oldIndex = PngWalkTool1.this.tabs.getSelectedIndex();
                        if (oldIndex == 0) {
                            PngWalkTool1.this.tabs.setSelectedIndex(PngWalkTool1.this.returnTabIndex);
                        } else {
                            PngWalkTool1.this.tabs.setSelectedIndex(0);
                            PngWalkTool1.this.returnTabIndex = oldIndex;
                        }
                    }
                }
            });
        }
        this.nextButton.requestFocus();
        if (PngWalkTool1.isQualityControlEnabled()) {
            this.qcPanel = new QualityControlPanel();
            JSplitPane qcPane = new JSplitPane(1, true, this.tabs, this.qcPanel);
            qcPane.setResizeWeight(1.0);
            this.pngsPanel.add(qcPane);
            this.qcPanel.setWalkImageSequece(this.seq);
        } else {
            this.pngsPanel.add(this.tabs);
        }
        this.pngsPanel.revalidate();
        BindingGroup bc = new BindingGroup();
        for (int i = 0; i < this.views.length; ++i) {
            AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.views[i], (Property)BeanProperty.create((String)PROP_THUMBNAILSIZE), (Object)this, (Property)BeanProperty.create((String)PROP_THUMBNAILSIZE));
            bc.addBinding((Binding)b);
        }
        bc.bind();
    }

    private void processArguments(ArgumentList alm) {
        String tab = alm.getValue("mode");
        if (tab.equalsIgnoreCase("filmStrip")) {
            this.tabs.setSelectedIndex(3);
        } else if (tab.equalsIgnoreCase("single")) {
            this.tabs.setSelectedIndex(0);
        } else if (tab.equalsIgnoreCase("contextFlow")) {
            this.tabs.setSelectedIndex(1);
        } else if (tab.equalsIgnoreCase("grid")) {
            this.tabs.setSelectedIndex(2);
        } else if (tab.equalsIgnoreCase("film strip")) {
            this.tabs.setSelectedIndex(3);
        } else if (tab.equalsIgnoreCase("covers")) {
            this.tabs.setSelectedIndex(4);
        }
        String show = alm.getValue("goto");
        if (!show.equals("")) {
            try {
                if (this.seq.getTimeSpan() != null) {
                    this.seq.gotoSubrange(DatumRangeUtil.parseTimeRange(show));
                } else {
                    this.pendingGoto = DatumRangeUtil.parseTimeRange(show);
                }
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void setTemplate(String template) {
        if (template.contains("$") && !template.contains("%")) {
            template = template.replaceAll("\\$", "%");
        }
        this.dataSetSelector1.setValue(template);
        WalkImageSequence oldseq = this.seq;
        String surl = DataSetURI.fromUri((URI)DataSetURI.getResourceURI((String)template));
        try {
            this.seq = new WalkImageSequence(surl);
        }
        catch (Exception ex) {
            this.seq = null;
            ex.printStackTrace();
        }
        if (oldseq != null) {
            oldseq.removePropertyChangeListener("index", this.indexListener);
            oldseq.removePropertyChangeListener(PROP_STATUS, this.statusListener);
            if (ENABLE_QUALITY_CONTROL) {
                oldseq.removePropertyChangeListener("badgeChange", this.qcStatusListener);
            }
        }
        if (this.seq != null) {
            this.seq.addPropertyChangeListener("index", this.indexListener);
            this.seq.addPropertyChangeListener(PROP_STATUS, this.statusListener);
            if (ENABLE_QUALITY_CONTROL) {
                this.seq.addPropertyChangeListener("badgeChange", this.qcStatusListener);
            }
        }
        Runnable run = new Runnable(){

            public void run() {
                block13: {
                    try {
                        PngWalkTool1.this.seq.initialLoad();
                        if (PngWalkTool1.this.pendingGoto != null) {
                            PngWalkTool1.this.seq.gotoSubrange(PngWalkTool1.this.pendingGoto);
                            PngWalkTool1.this.pendingGoto = null;
                        }
                        ArrayList<String> urls = new ArrayList<String>();
                        List recent = PngWalkTool1.this.dataSetSelector1.getRecent();
                        recent.removeAll(Collections.singleton(PngWalkTool1.this.seq.getTemplate()));
                        for (String b : recent) {
                            urls.add(b);
                        }
                        urls.add(PngWalkTool1.this.seq.getTemplate());
                        PngWalkTool1.this.dataSetSelector1.setRecent(urls);
                        PngWalkTool1.this.useRangeCheckBox.setEnabled(PngWalkTool1.this.seq.getTimeSpan() != null);
                        PngWalkTool1.this.useRangeCheckBox.setSelected(false);
                        PngWalkTool1.this.editRangeButton.setEnabled(false);
                        PngWalkTool1.this.timeFilterTextField.setEnabled(false);
                        PngWalkTool1.this.timeFilterTextField.setText("");
                        PngWalkTool1.this.showMissingCheckBox.setEnabled(PngWalkTool1.this.seq.getTimeSpan() != null);
                        if (PngWalkTool1.this.seq.getTimeSpan() == null) {
                            PngWalkTool1.this.showMissingCheckBox.setEnabled(false);
                            PngWalkTool1.this.showMissingCheckBox.setSelected(false);
                        } else {
                            PngWalkTool1.this.seq.setShowMissing(PngWalkTool1.this.showMissingCheckBox.isSelected());
                        }
                        for (PngWalkView v : PngWalkTool1.this.views) {
                            v.setSequence(PngWalkTool1.this.seq);
                        }
                        if (PngWalkTool1.this.seq.size() == 0) {
                            PngWalkTool1.this.setStatus("warning: Done listing " + PngWalkTool1.this.seq.getTemplate() + ", and no files were found");
                        } else {
                            PngWalkTool1.this.indexListener.propertyChange(null);
                            if (PngWalkTool1.this.qcPanel != null) {
                                PngWalkTool1.this.qcPanel.setWalkImageSequece(PngWalkTool1.this.seq);
                                if (PngWalkTool1.this.seq.getIndex() < PngWalkTool1.this.seq.size()) {
                                    if (PngWalkTool1.this.seq.getQualityControlSequence() != null) {
                                        QualityControlRecord rec = PngWalkTool1.this.seq.getQualityControlSequence().getQualityControlRecord(PngWalkTool1.this.seq.getIndex());
                                        PngWalkTool1.this.qcPanel.displayRecord(rec);
                                        int[] n = PngWalkTool1.this.seq.getQualityControlSequence().getQCTotals();
                                        PngWalkTool1.this.qcPanel.setStatus(n[0], n[1], n[2], n[3]);
                                    }
                                } else {
                                    PngWalkTool1.this.qcPanel.setStatus(0, 0, 0, 0);
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        if (PngWalkTool1.this.getStatus().startsWith("error")) break block13;
                        PngWalkTool1.this.setStatus("error:" + e.getMessage());
                    }
                }
            }
        };
        new Thread(run).start();
    }

    public String getTemplate() {
        return this.seq.getTemplate();
    }

    public int getThumbnailSize() {
        return this.thumbnailSize;
    }

    public void setThumbnailSize(int thumbnailSize) {
        int oldThumbnailSize = this.thumbnailSize;
        this.thumbnailSize = thumbnailSize;
        this.firePropertyChange(PROP_THUMBNAILSIZE, oldThumbnailSize, thumbnailSize);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String message) {
        String oldStatus = this.status;
        this.status = message;
        if (message.startsWith("busy:")) {
            this.setMessage(BUSY_ICON, message.substring(5).trim());
            logger.info(message);
        } else if (message.startsWith("warning:")) {
            this.setMessage(WARNING_ICON, message.substring(8).trim());
            logger.warning(message);
        } else if (message.startsWith("error:")) {
            this.setMessage(ERROR_ICON, message.substring(6).trim());
            logger.severe(message);
        } else {
            logger.info(message);
            this.setMessage(message);
        }
        this.firePropertyChange(PROP_STATUS, oldStatus, message);
    }

    public void setMessage(String message) {
        this.statusLabel.setIcon(IDLE_ICON);
        this.statusLabel.setText(message);
    }

    public void setMessage(Icon icon, String message) {
        String myMess;
        if (message == null) {
            message = "<null>";
        }
        if ((myMess = message).length() > 100) {
            myMess = myMess.substring(0, 100) + "...";
        }
        this.statusLabel.setIcon(icon);
        this.statusLabel.setText(myMess);
        this.statusLabel.setToolTipText(message);
    }

    void addFileAction(ActionEnabler match, String actionCommand, Action abstractAction) {
        this.actionEnablers.add(match);
        this.actionCommands.add(actionCommand);
        JButton b = new JButton(abstractAction);
        this.actionButtons.add(b);
        this.actionButtonsPanel.add(b);
    }

    String getSelectedFile() {
        return DataSetURI.fromUri((URI)this.seq.currentImage().getUri());
    }

    DataSetSelector getSelector() {
        return this.dataSetSelector1;
    }

    public static boolean isQualityControlEnabled() {
        return ENABLE_QUALITY_CONTROL;
    }

    private void initComponents() {
        this.pngsPanel = new JPanel();
        this.timeFilterTextField = new JTextField();
        this.actionButtonsPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.prevSetButton = new JButton();
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.nextSetButton = new JButton();
        this.jumpToFirstButton = new JButton();
        this.jumpToLastButton = new JButton();
        this.dataSetSelector1 = new DataSetSelector();
        this.statusLabel = new JLabel();
        this.showMissingCheckBox = new JCheckBox();
        this.useRangeCheckBox = new JCheckBox();
        this.editRangeButton = new JButton();
        this.pngsPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.pngsPanel.setLayout(new BorderLayout());
        this.timeFilterTextField.setToolTipText("Enter a time range, for example a year like \"2009\", or month \"2009 may\", or \"2009-01-01 to 2009-03-10\"\n");
        this.timeFilterTextField.setEnabled(false);
        this.timeFilterTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PngWalkTool1.this.timeFilterTextFieldActionPerformed(evt);
            }
        });
        this.timeFilterTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PngWalkTool1.this.timeFilterTextFieldFocusLost(evt);
            }
        });
        this.actionButtonsPanel.setLayout(new FlowLayout(2));
        this.prevSetButton.setText("<<<");
        this.prevSetButton.setToolTipText("Skip 7");
        this.prevSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PngWalkTool1.this.prevSetButtonActionPerformed(evt);
            }
        });
        this.prevButton.setText("<");
        this.prevButton.setToolTipText("previous");
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PngWalkTool1.this.prevButtonActionPerformed(evt);
            }
        });
        this.nextButton.setText(">");
        this.nextButton.setToolTipText("next");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PngWalkTool1.this.nextButtonActionPerformed(evt);
            }
        });
        this.nextSetButton.setText(">>>");
        this.nextSetButton.setToolTipText("Skip 7");
        this.nextSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PngWalkTool1.this.nextSetButtonActionPerformed(evt);
            }
        });
        this.jumpToFirstButton.setText("|<");
        this.jumpToFirstButton.setToolTipText("jump to first");
        this.jumpToFirstButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PngWalkTool1.this.jumpToFirstButtonActionPerformed(evt);
            }
        });
        this.jumpToLastButton.setText(">|");
        this.jumpToLastButton.setToolTipText("jump to last");
        this.jumpToLastButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PngWalkTool1.this.jumpToLastButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jumpToFirstButton).addPreferredGap(0).add((Component)this.prevSetButton).addPreferredGap(0).add((Component)this.prevButton).add(139, 139, 139).add((Component)this.nextButton).addPreferredGap(0).add((Component)this.nextSetButton).addPreferredGap(0).add((Component)this.jumpToLastButton)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.prevButton).add((Component)this.nextButton).add((Component)this.nextSetButton).add((Component)this.prevSetButton).add((Component)this.jumpToFirstButton).add((Component)this.jumpToLastButton)));
        jPanel1Layout.linkSize(new Component[]{this.nextButton, this.nextSetButton, this.prevButton, this.prevSetButton}, 2);
        this.dataSetSelector1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PngWalkTool1.this.dataSetSelector1ActionPerformed(evt);
            }
        });
        this.statusLabel.setText("starting application...");
        this.showMissingCheckBox.setSelected(true);
        this.showMissingCheckBox.setText("Show Missing");
        this.showMissingCheckBox.setToolTipText("Insert placeholder images where there are gaps detected in the sequence");
        this.showMissingCheckBox.setEnabled(false);
        this.showMissingCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PngWalkTool1.this.showMissingCheckBoxItemStateChanged(evt);
            }
        });
        this.showMissingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PngWalkTool1.this.showMissingCheckBoxActionPerformed(evt);
            }
        });
        this.useRangeCheckBox.setText("Limit range to:");
        this.useRangeCheckBox.setToolTipText("Limit the time range of the images in the sequence.");
        this.useRangeCheckBox.setEnabled(false);
        this.useRangeCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PngWalkTool1.this.useRangeCheckBoxItemStateChanged(evt);
            }
        });
        this.editRangeButton.setText("Select...");
        this.editRangeButton.setEnabled(false);
        this.editRangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PngWalkTool1.this.editRangeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0, 30, Short.MAX_VALUE).add((Component)this.actionButtonsPanel, -2, 463, -2).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.useRangeCheckBox).addPreferredGap(0).add((Component)this.timeFilterTextField, -2, 236, -2).add(12, 12, 12).add((Component)this.editRangeButton).add(18, 18, 18).add((Component)this.showMissingCheckBox)).add((Component)this.dataSetSelector1, -1, 846, Short.MAX_VALUE)).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.statusLabel, -1, 858, Short.MAX_VALUE).addContainerGap()).add(2, (Component)this.pngsPanel, -1, 870, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pngsPanel, -1, 636, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.dataSetSelector1, -2, 27, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.timeFilterTextField, -2, -1, -2).add((Component)this.useRangeCheckBox).add((Component)this.editRangeButton).add((Component)this.showMissingCheckBox)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.actionButtonsPanel, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, 30, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.statusLabel)));
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.seq.skipBy(1);
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        this.seq.skipBy(-1);
    }

    private void nextSetButtonActionPerformed(ActionEvent evt) {
        this.seq.skipBy(7);
    }

    private void prevSetButtonActionPerformed(ActionEvent evt) {
        this.seq.skipBy(-7);
    }

    private void timeFilterTextFieldActionPerformed(ActionEvent evt) {
        try {
            this.timeFilterTextField.setBackground(this.dataSetSelector1.getBackground());
            DatumRange range = DatumRangeUtil.parseTimeRange(this.timeFilterTextField.getText());
            this.seq.setActiveSubrange(range);
        }
        catch (ParseException ex) {
            this.timeFilterTextField.setBackground(Color.PINK);
        }
    }

    private void timeFilterTextFieldFocusLost(FocusEvent evt) {
    }

    private void jumpToLastButtonActionPerformed(ActionEvent evt) {
        this.seq.last();
    }

    private void jumpToFirstButtonActionPerformed(ActionEvent evt) {
        this.seq.first();
    }

    private void dataSetSelector1ActionPerformed(ActionEvent evt) {
        String t = this.dataSetSelector1.getValue();
        if (t.endsWith(".pngwalk")) {
            t = PngWalkTool1.readPngwalkFile(t);
        }
        this.setTemplate(t);
    }

    private void showMissingCheckBoxItemStateChanged(ItemEvent evt) {
        this.seq.setShowMissing(evt.getStateChange() == 1);
    }

    private void editRangeButtonActionPerformed(ActionEvent evt) {
        Frame myFrame = (Frame)SwingUtilities.getWindowAncestor(this);
        SubrangeEditorDialog d = new SubrangeEditorDialog(myFrame, true);
        List<DatumRange> times = this.seq.getAllTimes();
        d.setTimeSpan(times);
        if (this.seq.isUseSubRange()) {
            List<DatumRange> sub = this.seq.getActiveSubrange();
            d.setStartIndex(times.indexOf(sub.get(0)));
            d.setEndIndex(times.indexOf(sub.get(sub.size() - 1)));
        }
        d.setVisible(true);
        if (d.isOkClicked()) {
            this.seq.setActiveSubrange(d.getStartIndex(), d.getEndIndex());
            DatumRange range = new DatumRange(times.get(d.getStartIndex()).min(), times.get(d.getEndIndex()).max());
            this.timeFilterTextField.setText(range.toString());
        }
    }

    private void useRangeCheckBoxItemStateChanged(ItemEvent evt) {
        boolean enable = evt.getStateChange() == 1;
        this.seq.setUseSubRange(enable);
        this.timeFilterTextField.setEnabled(enable);
        this.editRangeButton.setEnabled(enable);
        if (!enable) {
            return;
        }
        List<DatumRange> current = this.seq.getActiveSubrange();
        DatumRange range = DatumRangeUtil.union(current.get(0), current.get(current.size() - 1));
        if (range == null) {
            this.timeFilterTextField.setText("error");
        } else {
            this.timeFilterTextField.setText(range.toString());
        }
    }

    private void showMissingCheckBoxActionPerformed(ActionEvent evt) {
    }

    static {
        logger = Logger.getLogger("org.autoplot.pngwalk");
        WARNING_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/virbo/autoplot/resources/warning-icon.png"));
        ERROR_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/virbo/autoplot/resources/error-icon.png"));
        BUSY_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/virbo/autoplot/resources/spinner.gif"));
        READY_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/virbo/autoplot/resources/indProgress0.png"));
        IDLE_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/virbo/autoplot/resources/idle-icon.png"));
        LOCAL_FILE_ENABLER = new ActionEnabler(){

            public boolean isActionEnabled(String filename) {
                return DataSetURI.getResourceURI((String)filename).toString().startsWith("file:");
            }
        };
    }

    public static interface ActionEnabler {
        public boolean isActionEnabled(String var1);
    }
}

