/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.WriteCapability;
import org.virbo.autoplot.dom.DebugPropertyChangeSupport;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class QualityControlRecord {
    private boolean initialized = false;
    private TreeSet comments;
    private Status currentStatus;
    private Date changeDate;
    private ReviewComment newComment;
    private FileObject recordFile = null;
    private URI imageURI;
    private static URI qcFolder;
    private static FileSystem qcfs;
    private PropertyChangeSupport pcs = new DebugPropertyChangeSupport(this);
    public static final String PROP_STATUS = "status";
    private static Schema schema;
    private static Validator validator;
    private SimpleDateFormat utcDateFormat;
    private static final String XMLNS = "http://virbo.org/schema/pngwalkQC";
    private static Map<URI, QualityControlRecord> cache;
    private static URI cacheURI;

    private QualityControlRecord() {
        this.comments = new TreeSet();
        this.currentStatus = Status.UNKNOWN;
        this.utcDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.utcDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.changeDate = new Date();
    }

    private void initialize() {
        if (this.initialized || this.recordFile == null) {
            this.initialized = true;
            return;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.recordFile.getInputStream());
            if (validator != null) {
                validator.validate(new DOMSource(doc));
            }
            NodeList nodes = doc.getElementsByTagNameNS(XMLNS, "modifiedDate");
            Element e = (Element)nodes.item(0);
            String nodeVal = e.getChildNodes().item(0).getNodeValue();
            this.setChangeDate(this.utcDateFormat.parse(nodeVal));
            nodes = doc.getElementsByTagNameNS(XMLNS, "reviewComment");
            for (int i = 0; i < nodes.getLength(); ++i) {
                e = (Element)nodes.item(i);
                String reviewer = e.getAttribute("reviewer");
                Date reviewTime = this.utcDateFormat.parse(e.getAttribute("date"));
                Status reviewStatus = Status.fromString(e.getAttribute(PROP_STATUS));
                String ctxt = "";
                Node commentNode = e.getChildNodes().item(0);
                if (commentNode != null) {
                    ctxt = commentNode.getNodeValue();
                }
                this.appendComment(reviewer, reviewTime, ctxt, reviewStatus);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (SAXException ex) {
            System.err.println("XML failed to validate: " + this.recordFile.toString());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.err.println("Error when loading quality control record from XML");
            ex.printStackTrace();
        }
        this.initialized = true;
    }

    public static QualityControlRecord getRecord(URI imageURI) throws UnknownHostException, IOException {
        return QualityControlRecord.getRecord(imageURI, null);
    }

    public static synchronized QualityControlRecord getRecord(URI imageURI, URI qcFolder) throws UnknownHostException, IOException {
        QualityControlRecord rec = cache.get(imageURI);
        if (qcFolder != cacheURI) {
            if (qcFolder != null) {
                if (qcFolder != cacheURI) {
                    cache.clear();
                }
            } else if (cacheURI != null) {
                cache.clear();
            }
        }
        if (rec != null && qcFolder == cacheURI) {
            return rec;
        }
        rec = new QualityControlRecord();
        String imagePath = imageURI.getPath();
        String imageName = imagePath.substring(imagePath.lastIndexOf(47) + 1);
        if (qcFolder == null) {
            String s = imageURI.toString();
            qcFolder = URI.create(s.substring(0, s.lastIndexOf(47)));
        }
        FileSystem fs = null;
        try {
            fs = QualityControlRecord.getFileSystem(qcFolder);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(QualityControlRecord.class.getName()).log(Level.SEVERE, "Unknown host error when attempting to access quality control folder.", ex);
            throw ex;
        }
        catch (IOException ex) {
            Logger.getLogger(QualityControlRecord.class.getName()).log(Level.SEVERE, "I/O error while opening quality control folder", ex);
            throw ex;
        }
        FileObject testFile = null;
        for (Status s : new Status[]{Status.OK, Status.PROBLEM, Status.IGNORE}) {
            String recordName = imageName + s.filenameExtension();
            testFile = fs.getFileObject(recordName);
            if (testFile.exists()) {
                rec.currentStatus = s;
                break;
            }
            testFile = null;
        }
        if (testFile != null) {
            rec.recordFile = testFile;
        }
        rec.imageURI = imageURI;
        QualityControlRecord.qcFolder = qcFolder;
        cache.put(imageURI, rec);
        if (cacheURI != qcFolder) {
            cacheURI = qcFolder;
        }
        return rec;
    }

    private static FileSystem getFileSystem(URI uri) throws UnknownHostException, IOException {
        if (qcfs == null || qcFolder == null || !uri.equals(qcFolder)) {
            qcFolder = uri;
            qcfs = FileSystem.create(qcFolder);
        }
        return qcfs;
    }

    public void save() {
        if (this.currentStatus == Status.UNKNOWN) {
            throw new IllegalArgumentException("Cannot write QC file for record with status \"unknown\"");
        }
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            doc = builder.newDocument();
            Element root = doc.createElementNS(XMLNS, "qualityControlRecord");
            doc.appendChild(root);
            this.appendTextElement(doc, root, "currentStatus", this.currentStatus.toString());
            this.appendTextElement(doc, root, "modifiedDate", this.xmlFormattedDate(this.changeDate));
            this.appendTextElement(doc, root, "imageURI", this.imageURI.toString());
            if (this.newComment != null) {
                this.comments.add(this.newComment);
                this.newComment = null;
            }
            for (ReviewComment c : this.comments) {
                Element e = doc.createElementNS(XMLNS, "reviewComment");
                e.setAttribute("reviewer", c.reviewer);
                e.setAttribute("date", this.xmlFormattedDate(c.commentDate));
                e.setAttribute(PROP_STATUS, c.reviewStatus.toString());
                Text t = doc.createTextNode(c.commentText);
                e.appendChild(t);
                root.appendChild(e);
            }
        }
        catch (Exception ex) {
            System.err.println("Exception while building XML");
            ex.printStackTrace();
        }
        try {
            if (validator != null) {
                validator.validate(new DOMSource(doc));
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Internally generated XML failed to validate!", ex);
        }
        try {
            WriteCapability oldCap;
            OutputStream out;
            LSOutput output;
            LSSerializer serializer;
            WriteCapability write;
            FileObject oldRecordFile = null;
            Status oldStatus = Status.UNKNOWN;
            if (this.recordFile != null) {
                String n = this.recordFile.getNameExt();
                oldStatus = Status.fromString(n.substring(n.lastIndexOf(46) + 1));
            }
            if (this.recordFile == null || !oldStatus.toString().equals(this.currentStatus.toString())) {
                FileSystem fs;
                oldRecordFile = this.recordFile;
                try {
                    fs = QualityControlRecord.getFileSystem(qcFolder);
                }
                catch (UnknownHostException ex) {
                    Logger.getLogger(QualityControlRecord.class.getName()).log(Level.SEVERE, "Unknown host error when attempting to access quality control folder.", ex);
                    throw ex;
                }
                catch (IOException ex) {
                    Logger.getLogger(QualityControlRecord.class.getName()).log(Level.SEVERE, "I/O error while opening quality control folder", ex);
                    throw ex;
                }
                String n = this.imageURI.getPath();
                this.recordFile = fs.getFileObject(n.substring(n.lastIndexOf(47) + 1) + this.currentStatus.filenameExtension());
            }
            if ((write = this.recordFile.getCapability(WriteCapability.class)) != null) {
                DOMImplementation impl = doc.getImplementation();
                DOMImplementationLS ls = (DOMImplementationLS)impl.getFeature("LS", "3.0");
                serializer = ls.createLSSerializer();
                output = ls.createLSOutput();
                output.setEncoding("UTF-8");
                write.delete();
                out = write.getOutputStream();
                output.setByteStream(out);
                try {
                    if (serializer.getDomConfig().canSetParameter("format-pretty-print", Boolean.TRUE)) {
                        serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                    }
                }
                catch (Error e2) {
                    e2.printStackTrace();
                }
            } else {
                throw new IOException("file system is not writable: " + this.recordFile);
            }
            serializer.write(doc, output);
            out.close();
            if (oldRecordFile != null && !(oldCap = oldRecordFile.getCapability(WriteCapability.class)).delete()) {
                System.err.println("here 123545");
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while writing XML record.", ex);
        }
    }

    private void appendTextElement(Document doc, Element base, String name, String text) {
        Element e = doc.createElementNS(XMLNS, name);
        Text t = doc.createTextNode(text);
        e.appendChild(t);
        base.appendChild(e);
    }

    public String getCommentsHTML() {
        if (!this.initialized) {
            this.initialize();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        for (ReviewComment c : this.comments) {
            sb.append("<b>" + c.reviewer + "</b><br/>");
            switch (c.reviewStatus) {
                case OK: {
                    sb.append("<font color=\"green\">");
                    break;
                }
                case PROBLEM: {
                    sb.append("<font color=\"red\">");
                    break;
                }
                default: {
                    sb.append("<font color=\"gray\">");
                }
            }
            sb.append(DateFormat.getDateTimeInstance().format(c.commentDate));
            sb.append("</font><br/>");
            StringCharacterIterator ci = new StringCharacterIterator(c.commentText);
            char ch = ci.first();
            while (ch != '\uffff') {
                if (ch == '<') {
                    sb.append("&lt;");
                } else if (ch == '>') {
                    sb.append("&gt;");
                } else {
                    sb.append(ch);
                }
                ch = ci.next();
            }
            sb.append("<br/><hr/>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public Status getStatus() {
        return this.currentStatus;
    }

    public void setStatus(Status newStatus) {
        if (!this.initialized) {
            this.initialize();
        }
        Status oldStatus = this.currentStatus;
        this.currentStatus = newStatus;
        if (this.newComment != null) {
            this.newComment.reviewStatus = newStatus;
        }
        this.changeDate.setTime(System.currentTimeMillis());
        this.pcs.firePropertyChange(PROP_STATUS, (Object)oldStatus, (Object)newStatus);
    }

    private void setChangeDate(Date d) {
        this.changeDate = d;
    }

    public void setNewCommentText(String reviewer, String commentText) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.newComment == null) {
            this.newComment = new ReviewComment();
        }
        this.newComment.reviewer = reviewer;
        this.newComment.commentText = commentText;
        this.newComment.commentDate.setTime(System.currentTimeMillis());
        this.newComment.reviewStatus = this.currentStatus;
        this.changeDate.setTime(System.currentTimeMillis());
    }

    public String getNewCommentText() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.newComment == null || this.newComment.commentText == null) {
            return "";
        }
        return this.newComment.commentText;
    }

    public URI getImageURI() {
        return this.imageURI;
    }

    private String xmlFormattedDate(Date d) {
        StringBuilder dateStr = new StringBuilder(this.utcDateFormat.format(d));
        return dateStr.toString();
    }

    private void appendComment(String reviewer, Date when, String cText, Status status) {
        this.comments.add(new ReviewComment(reviewer, when, cText, status));
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    static {
        try {
            String language = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory factory = SchemaFactory.newInstance(language);
            URL schemaURL = QualityControlRecord.class.getResource("pngwalkQC.xsd");
            schema = factory.newSchema(schemaURL);
            validator = schema.newValidator();
        }
        catch (SAXException ex) {
            System.err.println("Error initializing QC XML schema");
            ex.printStackTrace();
        }
        cache = new HashMap<URI, QualityControlRecord>();
        cacheURI = null;
    }

    private static class ReviewComment
    implements Comparable {
        String reviewer;
        Date commentDate;
        String commentText;
        Status reviewStatus;

        public ReviewComment() {
            this(null, new Date(), null, Status.UNKNOWN);
        }

        public ReviewComment(String reviewer, Date commentDate, String commentText, Status status) {
            if (commentText == null) {
                commentText = "";
            }
            this.reviewer = reviewer;
            this.commentDate = commentDate;
            this.commentText = commentText;
            this.reviewStatus = status;
        }

        public int compareTo(Object other) {
            int i = this.commentDate.compareTo(((ReviewComment)other).commentDate);
            if (i == 0) {
                return this.commentText.compareTo(((ReviewComment)other).commentText);
            }
            return i;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReviewComment)) {
                return false;
            }
            return this.compareTo(obj) == 0 && this.commentText.equals(((ReviewComment)obj).commentText);
        }

        public int hashCode() {
            return this.commentDate.hashCode() * this.commentText.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OK("OK"),
        PROBLEM("Problem"),
        IGNORE("Ignore"),
        UNKNOWN("Unknown");

        private String sval;

        private Status(String s) {
            this.sval = s;
        }

        public String toString() {
            return this.sval;
        }

        public String filenameExtension() {
            return "." + this.sval.toLowerCase();
        }

        public static Status fromString(String s) {
            if (s.toLowerCase().equals("ok")) {
                return OK;
            }
            if (s.toLowerCase().equals("problem")) {
                return PROBLEM;
            }
            if (s.toLowerCase().equals("ignore")) {
                return IGNORE;
            }
            return UNKNOWN;
        }
    }
}

