/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;

public class ScalePerspectiveImageOp
implements BufferedImageOp {
    final int w;
    final int h;
    final int ssx;
    final int ssy;
    final int x1;
    final int y1;
    final double p;
    int nw;
    int nh;
    final int maxidx;
    private int w1;
    private int h1;
    private int rh1;
    private boolean reflect;

    public ScalePerspectiveImageOp(int w, int h, int x1, int y1, int w1, int h1, int rh1, int ssx, int ssy, double p, boolean reflect) {
        this.w = w;
        this.h = h;
        this.w1 = w1;
        this.h1 = h1;
        this.reflect = reflect;
        this.rh1 = rh1 * h / h1;
        this.x1 = x1;
        this.y1 = y1;
        this.p = p;
        this.nw = w1;
        this.nh = h1 + rh1;
        this.maxidx = this.nw * this.nh - 1;
        this.ssx = ssx == -1 ? Math.max(1, w / w1 / 2) : ssx;
        this.ssy = ssy == -1 ? (p != 0.0 ? 1 : Math.max(1, h / h1)) : ssy;
    }

    Shape getOutline(double x, double y) {
        GeneralPath path = new GeneralPath();
        Point2D dst = new Point2D.Float();
        dst = this.getPoint2D(new Point2D.Float(0.0f, 0.0f), dst);
        path.moveTo((float)dst.getX(), (float)dst.getY());
        dst = this.getPoint2D(new Point2D.Float(this.w, 0.0f), dst);
        path.lineTo((float)dst.getX(), (float)dst.getY());
        dst = this.getPoint2D(new Point2D.Float(this.w, this.h), dst);
        path.lineTo((float)dst.getX(), (float)dst.getY());
        dst = this.getPoint2D(new Point2D.Float(0.0f, this.h), dst);
        path.lineTo((float)dst.getX(), (float)dst.getY());
        dst = this.getPoint2D(new Point2D.Float(0.0f, 0.0f), dst);
        path.lineTo((float)dst.getX(), (float)dst.getY());
        path.transform(AffineTransform.getTranslateInstance(x, y));
        return path;
    }

    private final int index(int i, int j) {
        int ii = i + j * this.nw;
        ii = ii > this.maxidx ? this.maxidx : ii;
        ii = ii < 0 ? 0 : ii;
        return ii;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        int j;
        dest = new BufferedImage(this.nw, this.nh, 2);
        int[] rr = new int[this.nw * this.nh];
        int[] gg = new int[this.nw * this.nh];
        int[] bb = new int[this.nw * this.nh];
        int[] aa = new int[this.nw * this.nh];
        int[] nn = new int[this.nw * this.nh];
        boolean AVG = false;
        boolean BG_WEIGHT = true;
        boolean hasBg = true;
        int bgColor = src.getRGB(3, 3);
        if ((bgColor >> 24 & 0xFF) != 255) {
            hasBg = false;
        }
        if (src.getRGB(3, 3) != bgColor) {
            hasBg = false;
        }
        if (src.getRGB(3, this.h - 4) != bgColor) {
            hasBg = false;
        }
        if (src.getRGB(this.w - 4, 3) != bgColor) {
            hasBg = false;
        }
        if (src.getRGB(this.w - 4, this.h - 4) != bgColor) {
            hasBg = false;
        }
        int[] jj = new int[this.h / this.ssy + 1];
        for (int k1 = 0; k1 < this.h / this.ssy; ++k1) {
            jj[k1] = k1 * this.ssy;
        }
        jj[this.h / this.ssy] = this.h - 1;
        int[] ii = new int[this.w / this.ssx + 1];
        for (int k2 = 0; k2 < this.w / this.ssx; ++k2) {
            ii[k2] = k2 * this.ssx;
        }
        ii[this.w / this.ssx] = this.w - 1;
        for (int k1 = 0; k1 < jj.length; ++k1) {
            j = jj[k1];
            for (int k2 = 0; k2 < ii.length; ++k2) {
                int i = ii[k2];
                int color = src.getRGB(i, j);
                int i1 = this.x1 + i * this.w1 / this.w;
                double pp = this.p > 0.0 ? (double)i * this.p : (double)(i - this.w) * this.p;
                double hai = (double)this.h1 - 2.0 * pp;
                int j1 = this.y1 + (int)(pp + (double)j * (hai / (double)this.h));
                int didx = this.index(i1, j1);
                int weight = hasBg ? (color == bgColor ? 1 : 255) : color >> 24 & 0xFF;
                int n = didx;
                rr[n] = rr[n] + weight * ((color >> 16 & 0xFF) - 0);
                int n2 = didx;
                gg[n2] = gg[n2] + weight * ((color >> 8 & 0xFF) - 0);
                int n3 = didx;
                bb[n3] = bb[n3] + weight * ((color >> 0 & 0xFF) - 0);
                int n4 = didx;
                aa[n4] = aa[n4] + 255 * weight;
                int n5 = didx;
                nn[n5] = nn[n5] + weight;
                if (!this.reflect) continue;
                j1 = (int)(pp + hai + (double)(this.h - j) * (hai / (double)this.h));
                didx = this.index(i1, j1);
                weight = color >> 24 & 0xFF;
                double ww1 = Math.max(1.0, (double)weight * (0.4 / (double)this.rh1 * (double)(j - (this.h - this.rh1))));
                int n6 = didx;
                rr[n6] = rr[n6] + 255 * ((color >> 16 & 0xFF) - 0);
                int n7 = didx;
                gg[n7] = gg[n7] + 255 * ((color >> 8 & 0xFF) - 0);
                int n8 = didx;
                bb[n8] = bb[n8] + 255 * ((color >> 0 & 0xFF) - 0);
                int n9 = didx;
                aa[n9] = (int)((double)aa[n9] + 255.0 * ww1);
                int n10 = didx;
                nn[n10] = nn[n10] + 255;
            }
        }
        for (int i = 0; i < this.nw; ++i) {
            for (j = 0; j < this.nh; ++j) {
                int color;
                int didx = this.index(i, j);
                int n = nn[didx];
                if (n <= 0) continue;
                int weight = aa[didx] / nn[didx];
                if (hasBg) {
                    if (weight == 0) {
                        color = bgColor;
                    } else if (weight < 255) {
                        color = (weight << 24) + (rr[didx] / n + 0 << 16) + (gg[didx] / n + 0 << 8) + (bb[didx] / n + 0);
                    } else {
                        int rr1 = rr[didx] / n + 0;
                        if (rr1 == 0) {
                            // empty if block
                        }
                        color = (weight << 24) + (rr[didx] / n + 0 << 16) + (gg[didx] / n + 0 << 8) + (bb[didx] / n + 0);
                    }
                    dest.setRGB(i, j, color);
                    continue;
                }
                color = (weight << 24) + (rr[didx] / n + 0 << 16) + (gg[didx] / n + 0 << 8) + (bb[didx] / n + 0);
                dest.setRGB(i, j, color);
            }
        }
        return dest;
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle2D.Double(0.0, 0.0, src.getWidth(), src.getHeight());
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        return new BufferedImage(src.getWidth(), src.getHeight(), 2);
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        double i1 = this.x1 + (int)(srcPt.getX() * (double)this.w1 / (double)this.w);
        double pp = (int)Math.round(this.p > 0.0 ? srcPt.getX() * this.p : (srcPt.getX() - (double)this.w) * this.p);
        double j1 = this.y1 + (int)((srcPt.getY() * (1000.0 - pp * 2.0) + pp * (double)this.h) * (double)this.h1 / (double)this.h / 1000.0);
        if (dstPt == null) {
            dstPt = new Point2D.Double(i1, j1);
        } else {
            dstPt.setLocation(i1, j1);
        }
        return dstPt;
    }

    public RenderingHints getRenderingHints() {
        return new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }
}

