/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.autoplot.pngwalk.ScalePerspectiveImageOp;
import org.autoplot.pngwalk.WalkUtil;
import org.das2.datum.DatumRange;
import org.das2.system.RequestProcessor;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.URISplit;

public class WalkImage {
    public static final String PROP_STATUS_CHANGE = "status";
    public static final String PROP_BADGE_CHANGE = "badgeChange";
    public static final int THUMB_SIZE = 400;
    private static final int SQUASH_FACTOR = 10;
    private static final int LOADED_IMAGE_COUNT_LIMIT = 50;
    final String uriString;
    private URI imgURI;
    private BufferedImage im;
    private BufferedImage thumb;
    private BufferedImage squishedThumb;
    private String caption;
    private Status status;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final boolean haveThumbs400;
    private static BufferedImage missingImage = WalkImage.initMissingImage();
    private static final LinkedList<WalkImage> freshness = new LinkedList();
    DatumRange dr;

    public URI getUri() {
        if (this.imgURI != null) {
            return this.imgURI;
        }
        try {
            return new URI("");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public WalkImage(URI uri, boolean haveThumbs400) {
        this.imgURI = uri;
        this.haveThumbs400 = haveThumbs400;
        if (this.imgURI != null) {
            this.uriString = DataSetURI.fromUri((URI)uri);
            this.status = Status.UNKNOWN;
        } else {
            this.uriString = null;
            this.status = Status.MISSING;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    private void setStatus(Status s) {
        Status oldStatus = this.status;
        this.status = s;
        this.pcs.firePropertyChange(PROP_STATUS_CHANGE, (Object)oldStatus, (Object)this.status);
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public DatumRange getDatumRange() {
        return this.dr;
    }

    public void setDatumRange(DatumRange dr) {
        this.dr = dr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() {
        if (this.status == Status.MISSING) {
            return missingImage;
        }
        if (this.im == null && this.status != Status.IMAGE_LOADING) {
            this.loadImage();
        }
        LinkedList<WalkImage> linkedList = freshness;
        synchronized (linkedList) {
            freshness.remove(this);
            freshness.addFirst(this);
        }
        return this.im;
    }

    BufferedImage getImageIfLoaded() {
        return this.im;
    }

    public BufferedImage getThumbnail() {
        return this.getThumbnail(true);
    }

    public BufferedImage readImage(File f) throws IllegalArgumentException, IOException {
        BufferedImage im = ImageIO.read(f);
        if (im.getType() == 0) {
            BufferedImage imNew = new BufferedImage(im.getWidth(), im.getHeight(), 2);
            imNew.getGraphics().drawImage(im, 0, 0, null);
            im = imNew;
        }
        return im;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getThumbnailImmediately() {
        BufferedImage rawThumb;
        block11: {
            try {
                if (this.haveThumbs400) {
                    String s;
                    URI fsRoot = DataSetURI.toUri((String)(URISplit.parse((URI)this.imgURI).path + "thumbs400"));
                    FileSystem fs = FileSystem.create(fsRoot);
                    FileObject fo = fs.getFileObject((s = DataSetURI.fromUri((URI)this.imgURI)).substring(s.lastIndexOf(47) + 1));
                    File localFile = fo.getFile();
                    rawThumb = this.readImage(localFile);
                    if (rawThumb == null) {
                        throw new RuntimeException("Unable to read: " + localFile);
                    }
                    break block11;
                }
                throw new IOException("silly code to jump");
            }
            catch (IOException ex) {
                if (this.im == null) {
                    this.loadImage();
                    return;
                }
                rawThumb = this.im;
            }
            catch (IllegalArgumentException ex) {
                if (this.im == null) {
                    this.loadImageImmediately();
                    return;
                }
                rawThumb = this.im;
            }
        }
        double aspect = (double)rawThumb.getWidth() / (double)rawThumb.getHeight();
        int height = (int)Math.round(Math.sqrt(160000.0 / (aspect * aspect + 1.0)));
        int width = (int)Math.round((double)height * aspect);
        WalkImage walkImage = this;
        synchronized (walkImage) {
            this.thumb = WalkUtil.resizeImage(rawThumb, width, height);
            if (this.status == Status.THUMB_LOADING) {
                this.setStatus(Status.THUMB_LOADED);
            }
        }
    }

    public synchronized BufferedImage getThumbnail(boolean loadIfNeeded) {
        switch (this.status) {
            case THUMB_LOADING: {
                return null;
            }
            case THUMB_LOADED: {
                if (this.thumb == null) {
                    throw new RuntimeException("thumb should not be null");
                }
                return this.thumb;
            }
            case IMAGE_LOADED: {
                return this.thumb;
            }
            case ERROR: {
                return this.thumb;
            }
            case MISSING: {
                return missingImage;
            }
            case UNKNOWN: {
                if (!loadIfNeeded) {
                    return null;
                }
                this.setStatus(Status.THUMB_LOADING);
                return this.maybeReturnThumb(loadIfNeeded);
            }
            case IMAGE_LOADING: {
                return this.maybeReturnThumb(loadIfNeeded);
            }
        }
        throw new IllegalArgumentException("Encountered invalid status in walk image.");
    }

    private BufferedImage maybeReturnThumb(boolean loadIfNeeded) {
        if (this.thumb != null) {
            return this.thumb;
        }
        if (!loadIfNeeded) {
            return null;
        }
        Runnable r = new Runnable(){

            public void run() {
                WalkImage.this.getThumbnailImmediately();
            }
        };
        RequestProcessor.invokeLater(r);
        return null;
    }

    public BufferedImage getSquishedThumbnail() {
        return this.getSquishedThumbnail(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getSquishedThumbnail(boolean loadIfNeeded) {
        if (this.status == Status.MISSING) {
            return missingImage;
        }
        if (this.squishedThumb == null) {
            WalkImage walkImage = this;
            synchronized (walkImage) {
                if (this.thumb == null && this.getThumbnail(loadIfNeeded) == null) {
                    return null;
                }
                if (this.thumb != null) {
                    ScalePerspectiveImageOp resizeOp = new ScalePerspectiveImageOp(this.thumb.getWidth(), this.thumb.getHeight(), 0, 0, this.thumb.getWidth() / 10, this.thumb.getHeight(), 0, 1, 1, 0.0, false);
                    this.squishedThumb = resizeOp.filter(this.thumb, null);
                }
            }
        }
        return this.squishedThumb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImageImmediately() {
        try {
            URI fsRoot = DataSetURI.toUri((String)URISplit.parse((URI)this.imgURI).path);
            FileSystem fs = FileSystem.create(fsRoot);
            String s = DataSetURI.fromUri((URI)this.imgURI);
            FileObject fo = fs.getFileObject(s.substring(s.lastIndexOf(47) + 1));
            File localFile = fo.getFile();
            Thread.yield();
            this.im = this.readImage(localFile);
            if (this.im == null) {
                throw new RuntimeException("unable to read: " + localFile);
            }
            LinkedList<WalkImage> linkedList = freshness;
            synchronized (linkedList) {
                while (freshness.size() > 50) {
                    WalkImage old = freshness.getLast();
                    freshness.remove(old);
                    Logger.getLogger("org.autoplot.pngwalk.WalkImage").fine("unloading image for " + old);
                    old.im = null;
                    old.setStatus(Status.THUMB_LOADED);
                }
            }
            BufferedImage lthumb = null;
            WalkImage walkImage = this;
            synchronized (walkImage) {
                lthumb = this.thumb;
            }
            if (lthumb == null) {
                this.getThumbnailImmediately();
            }
            this.setStatus(Status.IMAGE_LOADED);
        }
        catch (Exception ex) {
            System.err.println("Error loading image file from " + DataSetURI.fromUri((URI)this.imgURI));
            Logger.getLogger(WalkImage.class.getName()).log(Level.SEVERE, null, ex);
            this.setStatus(Status.MISSING);
            throw new RuntimeException(ex);
        }
    }

    private void loadImage() {
        if (this.status == Status.IMAGE_LOADING || this.status == Status.IMAGE_LOADED) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                WalkImage.this.loadImageImmediately();
            }
        };
        this.setStatus(Status.IMAGE_LOADING);
        RequestProcessor.invokeLater(r);
    }

    private static BufferedImage initMissingImage() {
        BufferedImage missing = new BufferedImage(200, 200, 2);
        Graphics2D g2 = missing.createGraphics();
        g2.setColor(Color.BLACK);
        FontMetrics fm = g2.getFontMetrics(g2.getFont());
        String msg = "(Missing)";
        g2.drawString(msg, (200 - fm.stringWidth(msg)) / 2, 100);
        return missing;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public String toString() {
        return this.getCaption() == null ? this.uriString : this.getCaption();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        THUMB_LOADING,
        THUMB_LOADED,
        IMAGE_LOADING,
        IMAGE_LOADED,
        MISSING,
        ERROR;

    }
}

