/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.DataSetURI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WalkUtil {
    private static int firstIndexOf(String str, List<String> targets) {
        int i0 = Integer.MAX_VALUE;
        for (String t : targets) {
            int i = str.indexOf(t);
            if (i <= -1 || i >= i0) continue;
            i0 = i;
        }
        return i0 == Integer.MAX_VALUE ? -1 : i0;
    }

    protected static int splitIndex(String surl) {
        int i = WalkUtil.firstIndexOf(surl, Arrays.asList("%Y", "$Y", "%y", "$y", "$(", "%{", "*"));
        i = i != -1 ? surl.lastIndexOf(47, i) : surl.lastIndexOf(47);
        return i;
    }

    public static boolean fileExists(String surl) throws FileSystem.FileSystemOfflineException, URISyntaxException {
        FileSystem fs;
        int i = WalkUtil.splitIndex(surl);
        try {
            fs = FileSystem.create(DataSetURI.getResourceURI((String)surl.substring(0, i + 1)));
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(WalkUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return fs.getFileObject(surl.substring(i + 1)).exists();
    }

    public static List<URI> getFilesFor(String surl, String timeRange, List<DatumRange> timeRanges, boolean download, ProgressMonitor mon) throws IOException, ParseException, URISyntaxException {
        Object[] ss;
        int i;
        DatumRange dr = null;
        if (timeRange != null && timeRange.trim().length() > 0) {
            dr = DatumRangeUtil.parseTimeRange(timeRange);
        }
        String sansArgs = (i = surl.indexOf(63)) == -1 ? surl : surl.substring(0, i);
        i = WalkUtil.splitIndex(sansArgs);
        FileSystem fs = FileSystem.create(DataSetURI.getResourceURI((String)sansArgs.substring(0, i + 1)));
        String spec = sansArgs.substring(i + 1);
        spec = spec.replaceAll("\\*", ".*");
        spec = spec.replaceAll("\\?", ".");
        FileStorageModelNew fsm = null;
        if (TimeParser.isSpec(spec)) {
            fsm = FileStorageModelNew.create(fs, spec);
        }
        if (fsm != null) {
            ss = fsm.getNamesFor(dr);
        } else {
            if (spec.length() > 0 && spec.substring(1).contains("/")) {
                throw new IllegalArgumentException("nested wildcards (*/*) not supported");
            }
            ss = fs.listDirectory("/", spec);
        }
        Arrays.sort(ss);
        ArrayList<URI> result = new ArrayList<URI>(ss.length);
        timeRanges.clear();
        String dirsuri = DataSetURI.fromUri((URI)fs.getRootURI());
        for (i = 0; i < ss.length; ++i) {
            DatumRange dr2 = null;
            if (fsm != null) {
                dr2 = fsm.getRangeFor((String)ss[i]);
            }
            if (dr != null && dr2 != null && !dr.contains(dr2)) continue;
            if (fs.getFileObject((String)ss[i]).isLocal()) {
                result.add(new URI(DataSetURI.getResourceURI((String)dirsuri).toString() + (String)ss[i]));
            } else {
                result.add(fs.getRootURI().resolve((String)ss[i]));
            }
            timeRanges.add(dr2);
        }
        return result;
    }

    static String readFile(File pf) throws IOException {
        BufferedReader read = new BufferedReader(new FileReader(pf));
        String s = read.readLine();
        StringBuffer result = new StringBuffer();
        while (s != null) {
            result.append(s);
            result.append("\n");
            s = read.readLine();
        }
        read.close();
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeFile(File pf, String s) throws IOException {
        FileWriter write = null;
        try {
            write = new FileWriter(pf);
            write.write(s);
        }
        finally {
            if (write != null) {
                write.close();
            }
        }
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, originalImage.getType());
        Graphics2D g = resizedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }
}

