/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.tca;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.AbstractQFunction;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.capability.TimeSeriesBrowse;
import org.virbo.dsops.Ops;

public class UriTcaSource
extends AbstractQFunction {
    TimeSeriesBrowse tsb;
    QDataSet ds;
    QDataSet bundleDs;
    DataSource dss;
    Exception ex;
    QDataSet error;
    QDataSet errorNoDs;
    QDataSet nonValueDs;
    QDataSet nonMonoDs;
    QDataSet initialError;
    static final Logger logger = Logger.getLogger("virbo.autoplot.uritcasource");

    public UriTcaSource(String uri) throws Exception {
        logger.log(Level.FINE, "new tca source: {0}", uri);
        if (uri.startsWith("class:org.autoplot.tca.UriTcaSource:")) {
            throw new IllegalArgumentException("pass a URI to this, not class:org.autoplot.tca.UriTcaSource");
        }
        EnumerationUnits eu = new EnumerationUnits("UriTcaSource");
        this.error = DataSetUtil.asDataSet((Datum)eu.createDatum("Error"));
        this.errorNoDs = DataSetUtil.asDataSet((Datum)eu.createDatum("No Data"));
        this.nonValueDs = DataSetUtil.asDataSet((Datum)eu.createDatum(" "));
        this.nonMonoDs = DataSetUtil.asDataSet((Datum)eu.createDatum("Non Mono"));
        try {
            DataSource dss1 = DataSetURI.getDataSource((String)uri);
            this.initialError = null;
            this.tsb = (TimeSeriesBrowse)dss1.getCapability(TimeSeriesBrowse.class);
            this.dss = dss1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.initialError = DataSetUtil.asDataSet((Datum)eu.createDatum(ex.toString()));
        }
    }

    private void doRead() throws Exception {
        NullProgressMonitor mon = new NullProgressMonitor();
        if (this.tsb != null) {
            logger.log(Level.FINE, "reading TCAs from TSB {0}", this.tsb.getURI());
        } else {
            logger.log(Level.FINE, "reading TCAs from {0}", this.dss);
        }
        this.ds = this.dss.getDataSet((ProgressMonitor)mon);
        this.bundleDs = (QDataSet)this.ds.property("BUNDLE_1");
        if (this.bundleDs == null) {
            if (this.ds.rank() == 1) {
                DDataSet bds1 = DDataSet.createRank2((int)1, (int)0);
                String name = (String)this.ds.property("NAME");
                String label = (String)this.ds.property("LABEL");
                bds1.putProperty("NAME", 0, (Object)(name == null ? "ds0" : name));
                bds1.putProperty("LABEL", 0, (Object)(label == null ? (name == null ? "" : name) : label));
                this.bundleDs = bds1;
            } else {
                DDataSet bds1 = DDataSet.createRank2((int)this.ds.length(0), (int)0);
                QDataSet dep1 = (QDataSet)this.ds.property("DEPEND_1");
                Units u = dep1 == null ? Units.dimensionless : SemanticOps.getUnits((QDataSet)dep1);
                for (int i = 0; i < this.ds.length(0); ++i) {
                    String c = "";
                    String name = dep1 != null ? u.createDatum(dep1.value(i)).toString() : (String)this.ds.property("NAME");
                    String label = (String)this.ds.property("LABEL");
                    bds1.putProperty("NAME", i, (Object)("ds" + i));
                    bds1.putProperty("LABEL", i, (Object)(label == null ? (name == null ? "" : name) : label));
                }
                this.bundleDs = bds1;
            }
        }
        if (this.tsb == null) {
            this.tsb = (TimeSeriesBrowse)this.dss.getCapability(TimeSeriesBrowse.class);
        }
        logger.log(Level.FINE, "  doRead got: {0}", this.ds);
    }

    public QDataSet value(QDataSet parm) {
        if (this.initialError != null && this.ds == null) {
            return new JoinDataSet(this.error);
        }
        Datum d = DataSetUtil.asDatum((QDataSet)parm.slice(0));
        QDataSet context = (QDataSet)parm.property("CONTEXT_0", 0);
        QDataSet deltaMinus = (QDataSet)parm.property("DELTA_MINUS", 0);
        QDataSet deltaPlus = (QDataSet)parm.property("DELTA_PLUS", 0);
        boolean read = false;
        if (this.tsb == null) {
            read = false;
        } else {
            DatumRange dr = this.tsb.getTimeRange();
            if (!DatumRangeUtil.sloppyContains(dr, d)) {
                while (d.ge(dr.max())) {
                    dr = dr.next();
                    read = true;
                }
                while (d.lt(dr.min())) {
                    dr = dr.previous();
                    read = true;
                }
                if (read) {
                    if (context != null) {
                        dr = DatumRangeUtil.union(dr, DataSetUtil.asDatumRange((QDataSet)context, (boolean)true));
                    }
                    this.tsb.setTimeRange(dr);
                }
            }
        }
        try {
            QDataSet result;
            if (read) {
                this.doRead();
                read = false;
            }
            if (this.ds == null) {
                return new JoinDataSet(this.errorNoDs);
            }
            QDataSet dep0 = SemanticOps.xtagsDataSet((QDataSet)this.ds);
            QDataSet d0 = parm.slice(0);
            if (!SemanticOps.isMonotonic((QDataSet)dep0)) {
                logger.fine("dataset dependence is not monotonic");
                return new JoinDataSet(this.nonMonoDs);
            }
            QDataSet findex = Ops.findex((QDataSet)dep0, (QDataSet)d0);
            if (findex.value() >= -0.5 && findex.value() < (double)dep0.length() - 0.5) {
                int ii = (int)(findex.value() + 0.5);
                result = this.ds.slice(ii);
            } else if (findex.value() > (double)(dep0.length() - 1) && Ops.ge((QDataSet)Ops.add((QDataSet)dep0.slice(dep0.length() - 1), (QDataSet)deltaMinus), (QDataSet)d0).value() == 1.0) {
                result = this.ds.slice(dep0.length() - 1);
            } else if (findex.value() < 0.0 && Ops.le((QDataSet)Ops.subtract((QDataSet)dep0.slice(0), (QDataSet)deltaPlus), (QDataSet)d0).value() == 1.0) {
                result = this.ds.slice(0);
            } else if (this.tsb == null) {
                JoinDataSet result1 = new JoinDataSet(this.nonValueDs);
                for (int i = 1; i < this.ds.length(0); ++i) {
                    result1.join(this.nonValueDs);
                }
                result = result1;
            } else {
                JoinDataSet result1 = new JoinDataSet(this.error);
                for (int i = 1; i < this.ds.length(0); ++i) {
                    result1.join(this.error);
                }
                result = result1;
            }
            if (result.rank() == 0) {
                result = new JoinDataSet(result);
            }
            ((MutablePropertyDataSet)result).putProperty("BUNDLE_0", (Object)this.bundleDs);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new JoinDataSet(this.error);
        }
    }

    public synchronized QDataSet exampleInput() {
        Datum t0;
        Units tu;
        String label;
        if (this.initialError != null) {
            label = "???";
            tu = Units.us2000;
            t0 = ((Units)tu).createDatum(0);
        } else if (this.tsb != null) {
            t0 = this.tsb.getTimeRange().min();
            tu = t0.getUnits();
            label = "Time";
        } else {
            try {
                if (this.ds == null) {
                    this.doRead();
                }
                QDataSet dep0 = (QDataSet)this.ds.property("DEPEND_0");
                t0 = DataSetUtil.asDatum((QDataSet)dep0.slice(0));
                tu = t0.getUnits();
                label = "???";
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        DDataSet inputDescriptor = DDataSet.createRank2((int)1, (int)0);
        inputDescriptor.putProperty("LABEL", 0, (Object)label);
        inputDescriptor.putProperty("UNITS", 0, (Object)tu);
        DRank0DataSet q = DataSetUtil.asDataSet((Datum)t0);
        MutablePropertyDataSet ret = (MutablePropertyDataSet)Ops.bundle(null, (QDataSet)q);
        inputDescriptor.putProperty("CADENCE", (Object)DataSetUtil.asDataSet((Datum)Units.seconds.createDatum(1)));
        ret.putProperty("BUNDLE_0", (Object)inputDescriptor);
        return ret;
    }
}

