/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.das2.util.AboutUtil;
import org.virbo.autoplot.AutoplotUtil;

public class APSplash
extends JFrame {
    private static APSplash instance = null;
    private Handler handler;
    private JLabel messageLabel;

    public static String getVersion() {
        try {
            String tag = AboutUtil.getReleaseTag(APSplash.class);
            if (tag == null) {
                return "untagged_version";
            }
            return tag;
        }
        catch (IOException ex) {
            return "untagged_version";
        }
    }

    public Handler getLogHandler() {
        if (this.handler == null) {
            this.handler = this.createhandler();
        }
        return this.handler;
    }

    private Handler createhandler() {
        Handler result = new Handler(){

            public void publish(LogRecord logRecord) {
                APSplash.this.messageLabel.setText(logRecord.getMessage());
                APSplash.this.messageLabel.paint(APSplash.this.messageLabel.getGraphics());
            }

            public void flush() {
            }

            public void close() {
            }
        };
        return result;
    }

    private static ImageIcon getSplashImage() {
        URL url = APSplash.class.getResource("/splash.png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public static synchronized APSplash getInstance() {
        if (instance == null) {
            instance = new APSplash();
        }
        return instance;
    }

    public static void showSplash() {
        APSplash.getInstance();
        instance.setVisible(true);
        instance.paint(instance.getGraphics());
        APSplash.checkTime("showSplash");
    }

    public static void checkTime(String msg) {
    }

    public static void hideSplash() {
        APSplash.getInstance();
        instance.setVisible(false);
        APSplash.checkTime("hideSplash");
    }

    public APSplash() {
        this.setUndecorated(true);
        this.setIconImage(AutoplotUtil.getAutoplotIcon());
        this.setTitle("Starting Autoplot");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(APSplash.getSplashImage()), "Center");
        Box bottomPanel = Box.createHorizontalBox();
        this.messageLabel = new JLabel("");
        this.messageLabel.setMinimumSize(new Dimension(200, 10));
        bottomPanel.add(this.messageLabel);
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(new JLabel("version " + APSplash.getVersion() + "   ", 4));
        panel.add((Component)bottomPanel, "South");
        this.setContentPane(panel);
        this.pack();
        this.setLocationRelativeTo(null);
    }
}

