/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DomOps;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSourceUtil;

public class AggregateUrisDialog2
extends JPanel {
    private final Application dom;
    private final DataSetSelector dataSetSelector;
    private JRadioButton allUrisB;
    private JTextArea allUrisTA;
    private ButtonGroup buttonGroup1;
    private JRadioButton focusUriB;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private DataSetSelector previewDataSetSelector;

    public AggregateUrisDialog2(Application dom, DataSetSelector sel) {
        this.initComponents();
        this.dom = dom;
        this.dataSetSelector = sel;
        this.previewDataSetSelector.setHidePlayButton(true);
        String s = this.dataSetSelector.getValue();
        String agg = DataSourceUtil.makeAggregation((String)s);
        if (agg != null) {
            this.previewDataSetSelector.setValue(agg);
        } else {
            this.jLabel5.setText(this.jLabel5.getText() + "  (Unable to create aggregation spec, couldn't find yyyymmdd.)");
            this.previewDataSetSelector.setValue(s);
        }
        Font f = this.previewDataSetSelector.getEditor().getFont().deriveFont(8.0f);
        this.previewDataSetSelector.getEditor().setFont(f);
        Application dom2 = (Application)dom.copy();
        DomOps.aggregateAll(dom2);
        this.allUrisTA.setText("");
        for (DataSourceFilter dsf : dom2.getDataSourceFilters()) {
            if (dsf.getUri().startsWith("vap+internal:")) continue;
            this.allUrisTA.insert(dsf.getUri() + "\n", this.allUrisTA.getCaretPosition());
        }
        this.allUrisTA.setEditable(false);
    }

    public JRadioButton getAllUrisB() {
        return this.allUrisB;
    }

    public JRadioButton getFocusUriB() {
        return this.focusUriB;
    }

    public void doAction() {
        if (this.allUrisB.isSelected()) {
            DataSourceFilter[] dsfs;
            Application dom2 = (Application)this.dom.copy();
            DomOps.aggregateAll(dom2);
            this.dom.syncTo(dom2);
            for (DataSourceFilter dsf : dsfs = this.dom.getDataSourceFilters()) {
                dsf.getController().update();
            }
            SwingUtilities.getWindowAncestor(this).setVisible(false);
        } else if (this.focusUriB.isSelected()) {
            String s = this.previewDataSetSelector.getEditor().getText();
            this.dataSetSelector.setValue(s);
            this.dataSetSelector.maybePlot(false);
            SwingUtilities.getWindowAncestor(this).setVisible(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.previewDataSetSelector = new DataSetSelector();
        this.jScrollPane1 = new JScrollPane();
        this.allUrisTA = new JTextArea();
        this.focusUriB = new JRadioButton();
        this.allUrisB = new JRadioButton();
        this.jLabel4.setText("<html>Autoplot has two ways of turning URIs of single files into aggregations that will combine data when the first dimension is time.  An aggregation URI is one with wildcards (like $Y for year) that allows Autoplot to fetch multiple files to cover a time range.</html> ");
        this.jLabel4.setVerticalAlignment(1);
        this.jLabel5.setText("<html>Autoplot has attempted to make an aggregated URI from the focus URI.  Pressing okay will accept the new URI:</html>");
        this.jLabel5.setVerticalAlignment(1);
        this.jLabel6.setText("<html>Autoplot has attempted to form aggregations for all the URIs on the canvas.  Pressing okay will accept these changes.  Here you can review the replacement URIs:</html>");
        this.jLabel6.setVerticalAlignment(1);
        this.allUrisTA.setColumns(20);
        this.allUrisTA.setFont(this.allUrisTA.getFont().deriveFont(8.0f));
        this.allUrisTA.setRows(5);
        this.allUrisTA.setText("vap+dat:http://autoplot.org/data/autoplot.dat\n");
        this.jScrollPane1.setViewportView(this.allUrisTA);
        this.buttonGroup1.add(this.focusUriB);
        this.focusUriB.setSelected(true);
        this.focusUriB.setText("Focus URI");
        this.buttonGroup1.add(this.allUrisB);
        this.allUrisB.setText("All URIs");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(12, 12, 12).add((Component)this.previewDataSetSelector, -1, 718, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.focusUriB).add(70, 70, 70).add((Component)this.jLabel5, -1, 574, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(12, 12, 12).add((Component)this.jScrollPane1, -1, 718, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.allUrisB).add(84, 84, 84).add((Component)this.jLabel6, -1, 575, Short.MAX_VALUE))).addContainerGap()).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4, -1, 730, Short.MAX_VALUE).addContainerGap())));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(98, 98, 98).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel5, -2, -1, -2).add((Component)this.focusUriB)).addPreferredGap(0).add((Component)this.previewDataSetSelector, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel6, -2, -1, -2).add((Component)this.allUrisB)).addPreferredGap(0).add((Component)this.jScrollPane1, -2, -1, -2).addContainerGap(40, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4, -2, -1, -2).addContainerGap(258, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
    }
}

