/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class AppManager {
    private static AppManager instance;
    List<Object> apps = new ArrayList<Object>();

    public static synchronized AppManager getInstance() {
        if (instance == null) {
            instance = new AppManager();
        }
        return instance;
    }

    public void addApplication(Object app) {
        this.apps.add(app);
    }

    public void closeApplication(Object app) {
        this.apps.remove(app);
        if (this.apps.isEmpty()) {
            System.exit(0);
        }
    }

    public void quit() {
        System.exit(0);
    }

    public WindowListener getWindowListener(final Object app, final Action closeAction) {
        return new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                if (closeAction != null) {
                    closeAction.actionPerformed(new ActionEvent(this, e.getID(), "close"));
                }
                e.getWindow().dispose();
            }

            public void windowClosed(WindowEvent e) {
                AppManager.this.closeApplication(app);
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        };
    }

    public WindowListener getWindowListener(Object app) {
        return this.getWindowListener(app, null);
    }

    public int getApplicationCount() {
        return this.apps.size();
    }
}

