/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import com.cottagesystems.jdiskhog.JDiskHogPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.CSH;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.autoplot.help.AutoplotHelpSystem;
import org.autoplot.pngwalk.CreatePngWalk;
import org.autoplot.pngwalk.PngWalkTool1;
import org.das2.DasApplication;
import org.das2.components.DasProgressPanel;
import org.das2.components.TearoffTabbedPane;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.dasml.DOMBuilder;
import org.das2.dasml.SerializeUtil;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasPlot;
import org.das2.system.RequestProcessor;
import org.das2.util.AboutUtil;
import org.das2.util.ArgumentList;
import org.das2.util.ExceptionHandler;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.APSplash;
import org.virbo.autoplot.AddDataSourcePanel;
import org.virbo.autoplot.AggregateUrisDialog;
import org.virbo.autoplot.AppManager;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.AxisPanel;
import org.virbo.autoplot.CanvasSizePanel;
import org.virbo.autoplot.DataPanel;
import org.virbo.autoplot.EventThreadResponseMonitor;
import org.virbo.autoplot.FontAndColorsDialog;
import org.virbo.autoplot.GettingStartedPanel;
import org.virbo.autoplot.GuiSupport;
import org.virbo.autoplot.JythonUtil;
import org.virbo.autoplot.LayoutListener;
import org.virbo.autoplot.LayoutPanel;
import org.virbo.autoplot.MetadataPanel;
import org.virbo.autoplot.MoveCacheDialog;
import org.virbo.autoplot.PersistentStateSupport;
import org.virbo.autoplot.PlotStylePanel;
import org.virbo.autoplot.RecentUrisDialog;
import org.virbo.autoplot.RunScriptPanel;
import org.virbo.autoplot.ScriptContext;
import org.virbo.autoplot.Util;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.autoplot.bookmarks.BookmarksManager;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DomOps;
import org.virbo.autoplot.dom.OptionsPrefsController;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotController;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.scriptconsole.GuiExceptionHandler;
import org.virbo.autoplot.scriptconsole.JythonScriptPanel;
import org.virbo.autoplot.scriptconsole.LogConsole;
import org.virbo.autoplot.server.RequestHandler;
import org.virbo.autoplot.server.RequestListener;
import org.virbo.autoplot.state.UndoRedoSupport;
import org.virbo.autoplot.util.TickleTimer;
import org.virbo.datasource.AutoplotSettings;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanelUtil;
import org.virbo.datasource.DataSourceRegistry;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.HtmlResponseIOException;
import org.virbo.datasource.SourceTypesBrowser;
import org.virbo.datasource.TimeRangeEditor;
import org.virbo.datasource.URISplit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoplotUI
extends JFrame {
    private static final String TAB_SCRIPT = "script";
    final String TAB_TOOLTIP_CANVAS = "<html>Canvas tab contains the plot and plot elements.<br>Click on plot elements to select.<br>%s</html>";
    final String TAB_TOOLTIP_AXES = "<html>Adjust selected plot axes.<br>%s<html>";
    final String TAB_TOOLTIP_LOGCONSOLE = "<html>Log console displays log messages and stdout/stderr.<br>%s</html>";
    final String TAB_TOOLTIP_STYLE = "<html>Adjust selected plot element's colors, shapes, and other style settings.<br>%s</html>";
    final String TAB_TOOLTIP_LAYOUT = "<html>Inspect the canvas layout and property bindings, and<br>provides access to all plot elements.<br>%s</html>";
    final String TAB_TOOLTIP_DATA = "<html>Specify valid ranges and apply additional operations to data.<br>%s</html>";
    final String TAB_TOOLTIP_METADATA = "<html>Inspect selected element's metadata and data statistics.<br>%s</html>";
    final String TAB_TOOLTIP_SCRIPT = "<html>Editor panel for Jython scripts and data sources.<br>%s</html>";
    final String TABS_TOOLTIP = "Right-click or drag to undock.";
    public static final String CARD_DATA_SET_SELECTOR = "card2";
    public static final String CARD_TIME_RANGE_SELECTOR = "card1";
    TearoffTabbedPane tabs;
    ApplicationModel applicationModel;
    Application dom;
    PersistentStateSupport stateSupport;
    UndoRedoSupport undoRedoSupport;
    TickleTimer tickleTimer;
    GuiSupport support;
    LayoutListener autoLayout;
    transient PersistentStateSupport.SerializationStrategy serStrategy = new PersistentStateSupport.SerializationStrategy(){

        public Element serialize(Document document, ProgressMonitor monitor) {
            DOMBuilder builder = new DOMBuilder(AutoplotUI.this.applicationModel);
            Element element = builder.serialize(document, DasProgressPanel.createFramed("Serializing Application"));
            return element;
        }

        public void deserialize(Document document, ProgressMonitor monitor) {
            Element element = document.getDocumentElement();
            SerializeUtil.processElement(element, AutoplotUI.this.applicationModel);
        }
    };
    private static final Logger logger = Logger.getLogger("org.virbo.autoplot");
    private JythonScriptPanel scriptPanel;
    private DataPanel dataPanel;
    private LayoutPanel layoutPanel;
    private JScrollPane layoutPanel1;
    private LogConsole logConsole;
    private RequestListener rlistener;
    private JDialog fontAndColorsDialog = null;
    private BookmarksManager bookmarksManager = null;
    private AutoplotHelpSystem helpSystem;
    private static final String RESOURCES = "/org/virbo/autoplot/resources/";
    public static final Icon WARNING_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/virbo/autoplot/resources/warning-icon.png"));
    public static final Icon ERROR_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/virbo/autoplot/resources/error-icon.png"));
    public static final Icon BUSY_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/virbo/autoplot/resources/spinner.gif"));
    public static final Icon READY_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/virbo/autoplot/resources/indProgress0.png"));
    public static final Icon IDLE_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/virbo/autoplot/resources/idle-icon.png"));
    private TimeRangeEditor timeRangeEditor;
    private List<JComponent> expertMenuItems = new ArrayList<JComponent>();
    private JMenu expertMenu;
    JMenu addDataFromMenu = null;
    private transient PropertyChangeListener optionsListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("layoutVisible")) {
                if (Boolean.TRUE.equals(ev.getNewValue())) {
                    int idx;
                    if (AutoplotUI.this.layoutPanel == null) {
                        AutoplotUI.this.layoutPanel = new LayoutPanel();
                        AutoplotUI.this.layoutPanel.setApplication(AutoplotUI.this.dom);
                    }
                    if ((idx = AutoplotUI.this.tabs.indexOfTab("style")) == -1) {
                        idx = AutoplotUI.this.tabs.getTabCount();
                    }
                    AutoplotUI.this.tabs.insertTab("layout", null, AutoplotUI.this.layoutPanel, String.format("<html>Inspect the canvas layout and property bindings, and<br>provides access to all plot elements.<br>%s</html>", "Right-click or drag to undock."), idx + 1);
                } else if (AutoplotUI.this.layoutPanel != null) {
                    AutoplotUI.this.tabs.remove(AutoplotUI.this.layoutPanel);
                }
            } else if (ev.getPropertyName().equals("dataVisible")) {
                if (Boolean.TRUE.equals(ev.getNewValue())) {
                    int idx;
                    if (AutoplotUI.this.dataPanel == null) {
                        AutoplotUI.this.dataPanel = new DataPanel(AutoplotUI.this.applicationModel.dom);
                    }
                    if ((idx = AutoplotUI.this.tabs.indexOfTab("metadata")) == -1) {
                        idx = AutoplotUI.this.tabs.getTabCount();
                    }
                    AutoplotUI.this.tabs.insertTab("data", null, AutoplotUI.this.dataPanel, String.format("<html>Specify valid ranges and apply additional operations to data.<br>%s</html>", "Right-click or drag to undock."), idx);
                } else if (AutoplotUI.this.dataPanel != null) {
                    AutoplotUI.this.tabs.remove(AutoplotUI.this.dataPanel);
                }
            } else if (ev.getPropertyName().equals("useTimeRangeEditor")) {
                if (Boolean.TRUE.equals(ev.getNewValue())) {
                    ((CardLayout)AutoplotUI.this.timeRangePanel.getLayout()).show(AutoplotUI.this.timeRangePanel, AutoplotUI.CARD_TIME_RANGE_SELECTOR);
                } else {
                    ((CardLayout)AutoplotUI.this.timeRangePanel.getLayout()).show(AutoplotUI.this.timeRangePanel, AutoplotUI.CARD_DATA_SET_SELECTOR);
                }
            }
        }
    };
    private JMenuItem EditOptions;
    private JMenuItem aboutAutoplotMenuItem;
    private JMenuItem aboutDas2MenuItem;
    private ButtonGroup addressBarButtonGroup;
    private JMenu addressBarMenu;
    private JSeparator aggSeparator;
    private JMenuItem aggregateMenuItem;
    private JCheckBoxMenuItem autoLabellingCheckBoxMenuItem;
    private JCheckBoxMenuItem autoLayoutCheckBoxMenuItem;
    private JMenu autoMenu;
    private JCheckBoxMenuItem autoRangingCheckBoxMenuItem;
    private JMenuItem autoplotHelpMenuItem;
    private JMenuItem autoplotHomepageButton;
    private JMenu bookmarksMenu;
    private JMenu cacheMenu;
    private JMenuItem canvasSizeMenuItem;
    private JMenuItem copyDataSetURLMenuItem;
    private JMenuItem copyImageMenuItem;
    private JMenuItem createPngWalkMenuItem;
    private JSeparator createPngWalkSeparator;
    private JCheckBoxMenuItem dataPanelCheckBoxMenuItem;
    protected DataSetSelector dataSetSelector;
    private JRadioButtonMenuItem dataSetSelectorMenuItem;
    private JMenuItem decodeURLItem;
    private JCheckBoxMenuItem doyCB;
    private JCheckBoxMenuItem drawAntiAliasMenuItem;
    private JCheckBoxMenuItem drawGridCheckBox;
    private JMenuItem editDomMenuItem;
    private JSeparator editDomSeparator;
    private JMenu editMenu;
    private JMenu enableFeatureMenu;
    private JMenuItem exceptionReport;
    private JMenu fileMenu;
    private JMenuItem fixLayoutMenuItem;
    private JMenuItem fontsAndColorsMenuItem;
    private JMenuItem gettingStartedMenuItem;
    private JMenu helpMenu;
    private JMenuItem inspectVapFileMenuItem;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem7;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JSeparator jSeparator3;
    private JCheckBoxMenuItem layoutPanelCheckBoxMenuItem;
    private JCheckBoxMenuItem logConsoleMenuItem;
    private JCheckBoxMenuItem nnCb;
    private JMenu optionsMenu;
    private JCheckBoxMenuItem overRenderingMenuItem;
    private JMenuItem pasteDataSetURLMenuItem;
    private org.das2.dasml.PersistentStateSupport persistentStateSupport1;
    private JMenu plotStyleMenu;
    private JMenuItem pngWalkMenuItem;
    private JMenuItem redoMenuItem;
    private JMenu renderingOptionsMenu;
    private JMenuItem resetZoomMenuItem;
    private JCheckBoxMenuItem scriptPanelMenuItem;
    private JCheckBoxMenuItem serverCheckBoxMenuItem;
    private JCheckBoxMenuItem specialEffectsMenuItem;
    private JLabel statusLabel;
    private JTextField statusTextField;
    private JPanel tabbedPanelContainer;
    private JCheckBoxMenuItem textAntiAlias;
    private JMenu textSizeMenu;
    private JPanel timeRangePanel;
    private JRadioButtonMenuItem timeRangeSelectorMenuItem;
    private JMenu toolsMenu;
    private JMenuItem undoMenuItem;
    private JMenu undoMultipleMenu;
    private JMenu viewMenu;
    private JMenuItem zoomInMenuItem;
    private JMenuItem zoomOutMenuItem;
    private BindingGroup bindingGroup;

    public AutoplotUI(ApplicationModel model) {
        APSplash.checkTime("init 0");
        AutoplotHelpSystem.initialize((Component)this.getRootPane());
        this.helpSystem = AutoplotHelpSystem.getHelpSystem();
        DasApplication.getDefaultApplication().setMainFrame(this);
        if (DasApplication.getDefaultApplication().isHeadless()) {
            model.setExceptionHandler(DasApplication.getDefaultApplication().getExceptionHandler());
        } else {
            model.setExceptionHandler(new GuiExceptionHandler());
        }
        if (!ScriptContext.isModelInitialized()) {
            ScriptContext.setApplicationModel(model);
            ScriptContext.setView(this);
        }
        model.setResizeRequestListener(new ApplicationModel.ResizeRequestListener(){

            public void resize(int w, int h) {
                AutoplotUI.this.resizeForCanvasSize(w, h);
            }
        });
        APSplash.checkTime("init 10");
        this.dom = model.getDocumentModel();
        this.support = new GuiSupport(this);
        this.applicationModel = model;
        this.undoRedoSupport = new UndoRedoSupport(this.applicationModel);
        this.undoRedoSupport.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.refreshUndoRedoLabel();
            }
        });
        this.applicationModel.addPropertyChangeListener("vapFile", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.updateFrameTitle();
            }
        });
        this.undoRedoSupport.addPropertyChangeListener("depth", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.updateFrameTitle();
            }
        });
        APSplash.checkTime("init 20");
        FileSystem.settings().addPropertyChangeListener("offline", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.updateFrameTitle();
            }
        });
        if (model.getExceptionHandler() instanceof GuiExceptionHandler) {
            ((GuiExceptionHandler)model.getExceptionHandler()).setUndoRedoSupport(this.undoRedoSupport);
        }
        this.initComponents();
        this.expertMenuItems.add(this.editDomMenuItem);
        this.expertMenuItems.add(this.editDomSeparator);
        this.expertMenuItems.add(this.inspectVapFileMenuItem);
        this.expertMenuItems.add(this.renderingOptionsMenu);
        this.expertMenuItems.add(this.enableFeatureMenu);
        this.expertMenuItems.add(this.autoMenu);
        this.expertMenuItems.add(this.pngWalkMenuItem);
        this.expertMenuItems.add(this.createPngWalkMenuItem);
        this.expertMenuItems.add(this.createPngWalkSeparator);
        this.expertMenuItems.add(this.aggSeparator);
        this.expertMenuItems.add(this.aggregateMenuItem);
        this.expertMenuItems.add(this.decodeURLItem);
        this.jMenuBar1.add(Box.createHorizontalGlue());
        this.expertMenu = new JMenu("Expert");
        JMenuItem mi = new JMenuItem(new AbstractAction("Basic Mode"){

            public void actionPerformed(ActionEvent e) {
                AutoplotUI.this.setExpertMode(false);
            }
        });
        mi.setToolTipText("Basic mode allows for browsing products composed by data providers");
        this.expertMenu.add(mi);
        mi = new JMenuItem(new AbstractAction("Expert Mode"){

            public void actionPerformed(ActionEvent e) {
                AutoplotUI.this.setExpertMode(true);
            }
        });
        mi.setToolTipText("Expert allows composing new products and scripting");
        this.expertMenu.add(mi);
        this.expertMenu.setToolTipText("<html>Toggle between expert and basic mode.<br>Basic mode allows for browsing products composed by data providers<br>Expert allows composing new products and scripting");
        this.jMenuBar1.add(this.expertMenu);
        KeyChain.getDefault().setParentGUI(this);
        APSplash.checkTime("init 25");
        this.timeRangeEditor = new TimeRangeEditor();
        this.timeRangePanel.add((Component)this.timeRangeEditor, CARD_TIME_RANGE_SELECTOR);
        this.timeRangeEditor.setDataSetSelectorPeer(this.dataSetSelector);
        this.timeRangeEditor.setAlternatePeer("Switch to Data Set Selector", CARD_DATA_SET_SELECTOR);
        this.dataSetSelector.setAlternatePeer("Switch to Time Range Editor", CARD_TIME_RANGE_SELECTOR);
        this.dom.getController().addPropertyChangeListener("focusUri", this.timeRangeEditor.getUriFocusListener());
        this.statusTextField.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.statusTextField.setOpaque(false);
        this.statusLabel.setIcon(IDLE_ICON);
        this.support.addKeyBindings((JPanel)this.getContentPane());
        APSplash.checkTime("init 30");
        this.dataSetSelector.setMonitorFactory(this.dom.getController().getMonitorFactory());
        this.dataSetSelector.registerBrowseTrigger("vap\\+internal:(.*)", (Action)new AbstractAction("internal"){

            public void actionPerformed(ActionEvent ev) {
                GuiSupport.editPlotElement(AutoplotUI.this.applicationModel, AutoplotUI.this);
            }
        });
        this.dataSetSelector.registerActionTrigger("bookmarks:(.*)", (Action)new AbstractAction("bookmarks"){

            public void actionPerformed(ActionEvent ev) {
                String bookmarksFile = AutoplotUI.this.dataSetSelector.getValue().substring("bookmarks:".length());
                if (bookmarksFile.endsWith("/") || bookmarksFile.endsWith(".")) {
                    DataSetSelector source = (DataSetSelector)ev.getSource();
                    source.showFileSystemCompletions(true, false, "[^\\s]+(\\.(?i)(xml))$");
                } else {
                    AutoplotUI.this.support.importBookmarks(bookmarksFile);
                    AutoplotUI.this.applicationModel.addRecent(AutoplotUI.this.dataSetSelector.getValue());
                }
            }
        });
        this.dataSetSelector.registerBrowseTrigger("bookmarks:(.*)", (Action)new AbstractAction("bookmarks"){

            public void actionPerformed(ActionEvent ev) {
                DataSetSelector source = (DataSetSelector)ev.getSource();
                source.showFileSystemCompletions(false, true, "[^\\s]+\\.xml");
            }
        });
        this.dataSetSelector.registerActionTrigger("pngwalk:(.*)", (Action)new AbstractAction("pngwalk"){

            public void actionPerformed(ActionEvent ev) {
                String pngwalk = AutoplotUI.this.dataSetSelector.getValue().substring("pngwalk:".length());
                if (pngwalk.endsWith("/") || pngwalk.endsWith(".")) {
                    DataSetSelector source = (DataSetSelector)ev.getSource();
                    source.showFileSystemCompletions(true, false, "[^\\s]+(\\.(?i)(jpg|png|gif))$");
                } else {
                    PngWalkTool1.start(pngwalk, AutoplotUI.this);
                    AutoplotUI.this.applicationModel.addRecent(AutoplotUI.this.dataSetSelector.getValue());
                }
            }
        });
        this.dataSetSelector.registerBrowseTrigger("pngwalk:(.*)", (Action)new AbstractAction("pngwalk"){

            public void actionPerformed(ActionEvent ev) {
                DataSetSelector source = (DataSetSelector)ev.getSource();
                source.showFileSystemCompletions(true, false, "[^\\s]+(\\.(?i)(jpg|png|gif))$");
            }
        });
        this.dataSetSelector.registerActionTrigger("(.*)\\.pngwalk", (Action)new AbstractAction("pngwalk"){

            public void actionPerformed(ActionEvent ev) {
                String pngwalk = AutoplotUI.this.dataSetSelector.getValue();
                PngWalkTool1.start(pngwalk, AutoplotUI.this);
                AutoplotUI.this.applicationModel.addRecent(AutoplotUI.this.dataSetSelector.getValue());
            }
        });
        this.dataSetSelector.registerActionTrigger("script:(.*)", (Action)new AbstractAction(TAB_SCRIPT){

            public void actionPerformed(ActionEvent ev) {
                String script = AutoplotUI.this.dataSetSelector.getValue().substring("script:".length());
                if (!(script.endsWith(".jy") || script.endsWith(".JY") || script.endsWith(".py") || script.endsWith(".PY"))) {
                    DataSetSelector source = (DataSetSelector)ev.getSource();
                    source.showFileSystemCompletions(false, true, "[^\\s]+\\.jy");
                } else {
                    try {
                        File ff = DataSetURI.getFile((URI)DataSetURI.getURI((String)script), (ProgressMonitor)new DasProgressPanel("downloading script"));
                        RunScriptPanel pp = new RunScriptPanel();
                        pp.loadFile(ff);
                        int r = JOptionPane.showConfirmDialog(AutoplotUI.this, pp, "Load script", 2);
                        if (r == 0) {
                            if (pp.getToolsCB().isSelected()) {
                                File tools = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "tools");
                                File cpTo = new File(tools, ff.getName());
                                if (!ff.equals(cpTo)) {
                                    if (!Util.copyFile(ff, cpTo)) {
                                        AutoplotUI.this.setStatus("warning: unable to copy file");
                                    } else {
                                        AutoplotUI.this.setStatus("copied file to " + cpTo);
                                        AutoplotUI.this.reloadTools();
                                    }
                                } else {
                                    AutoplotUI.this.setStatus("warning: file is already in tools");
                                }
                            }
                            if (AutoplotUI.this.scriptPanel != null && !AutoplotUI.this.scriptPanel.isDirty()) {
                                AutoplotUI.this.scriptPanel.loadFile(ff);
                            }
                            AutoplotUI.this.applicationModel.addRecent(AutoplotUI.this.dataSetSelector.getValue());
                            RunScriptPanel.runScript(AutoplotUI.this.applicationModel, ff, new DasProgressPanel("Running script " + ff));
                        }
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.dataSetSelector.registerBrowseTrigger("script:(.*)", (Action)new AbstractAction(TAB_SCRIPT){

            public void actionPerformed(ActionEvent ev) {
                DataSetSelector source = (DataSetSelector)ev.getSource();
                source.showFileSystemCompletions(false, true, "[^\\s]+\\.jy");
            }
        });
        URISplit.setOtherSchemes(Arrays.asList(TAB_SCRIPT, "pngwalk", "bookmarks"));
        APSplash.checkTime("init 40");
        final ApplicationController appController = this.applicationModel.getDocumentModel().getController();
        appController.addDas2PeerChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PlotController plotController = (PlotController)e.getNewValue();
                ApplicationController controller = plotController.getApplication().getController();
                GuiSupport.addPlotContextMenuItems(controller, plotController.getDasPlot(), plotController, plotController.getPlot());
                GuiSupport.addAxisContextMenuItems(controller, plotController.getDasPlot(), plotController, plotController.getPlot(), plotController.getPlot().getXaxis());
                GuiSupport.addAxisContextMenuItems(controller, plotController.getDasPlot(), plotController, plotController.getPlot(), plotController.getPlot().getYaxis());
                GuiSupport.addAxisContextMenuItems(controller, plotController.getDasPlot(), plotController, plotController.getPlot(), plotController.getPlot().getZaxis());
            }
        });
        appController.addPropertyChangeListener("focusUri", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.dataSetSelector.setValue(appController.getFocusUri());
            }
        });
        this.dataSetSelector.setValue(this.dom.getController().getFocusUri());
        appController.addPropertyChangeListener("status", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.setStatus(appController.getStatus());
            }
        });
        this.applicationModel.getCanvas().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                logger.fine("focus to canvas");
                if (AutoplotUI.this.stateSupport.getCurrentFile() != null) {
                    AutoplotUI.this.dataSetSelector.setValue(AutoplotUI.this.stateSupport.getCurrentFile());
                }
                super.focusGained(e);
            }
        });
        APSplash.checkTime("init 50");
        this.setIconImage(AutoplotUtil.getAutoplotIcon());
        this.stateSupport = AutoplotUI.getPersistentStateSupport(this, this.applicationModel);
        this.fillFileMenu();
        APSplash.checkTime("init 53");
        AppManager.getInstance().addApplication(this);
        this.addWindowListener(AppManager.getInstance().getWindowListener(this, new AbstractAction("close"){

            public void actionPerformed(ActionEvent e) {
                if (AutoplotUI.this == ScriptContext.getViewWindow()) {
                    ScriptContext.close();
                }
            }
        }));
        this.applicationModel.addPropertyChangeListener("vapFile", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AutoplotUI.this.stateSupport.setCurrentFile((String)e.getNewValue());
            }
        });
        this.applicationModel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("recent")) {
                    final ArrayList<String> urls = new ArrayList<String>();
                    List<Bookmark> recent = AutoplotUI.this.applicationModel.getRecent();
                    for (Bookmark b : recent) {
                        urls.add(((Bookmark.Item)b).getUri());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AutoplotUI.this.dataSetSelector.setRecent(urls);
                        }
                    });
                } else if (evt.getPropertyName().equals("bookmarks")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AutoplotUI.this.updateBookmarks();
                        }
                    });
                }
            }
        });
        this.autoLayout = new LayoutListener(model);
        APSplash.checkTime("init 55");
        APSplash.checkTime("init 60");
        this.dataSetSelector.addPropertyChangeListener("message", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AutoplotUI.this.setStatus(AutoplotUI.this.dataSetSelector.getMessage());
            }
        });
        this.tabs = new TearoffTabbedPane();
        this.applicationModel.getCanvas().setFitted(true);
        JScrollPane scrollPane = new JScrollPane(this.applicationModel.getCanvas());
        scrollPane.getViewport().setBackground(new JLabel().getBackground());
        this.tabs.insertTab("canvas", null, scrollPane, String.format("<html>Canvas tab contains the plot and plot elements.<br>Click on plot elements to select.<br>%s</html>", "Right-click or drag to undock."), 0);
        this.tabs.validate();
        this.tabbedPanelContainer.add((Component)this.tabs, "Center");
        this.tabs.requestFocus();
        APSplash.checkTime("init 70");
        ApplicationModel fmodel = model;
        this.addAxes().run();
        this.addStyle().run();
        this.addFeatures(fmodel);
        ArrayList<String> uris = new ArrayList<String>();
        List<Bookmark> recent = this.applicationModel.getRecent();
        APSplash.checkTime("init 80");
        for (Bookmark b : recent) {
            uris.add(((Bookmark.Item)b).getUri());
        }
        this.dataSetSelector.setRecent(uris);
        Runnable run = new Runnable(){

            public void run() {
                AutoplotUI.this.updateBookmarks();
            }
        };
        this.invokeLater(-1, false, run);
        APSplash.checkTime("init 90");
        this.addTools();
        this.addBindings();
        this.pack();
        this.dom.getOptions().addPropertyChangeListener(this.optionsListener);
        APSplash.checkTime("init 100");
        if (AutoplotUtil.getProperty("os.name", "").startsWith("Mac OS")) {
            this.applicationModel.getCanvas().resizeAllComponents();
            this.applicationModel.getCanvas().repaint();
            this.applicationModel.getCanvas().paintImmediately(0, 0, 1000, 1000);
        }
        APSplash.checkTime("init 110");
        run = new Runnable(){

            public void run() {
                try {
                    JythonUtil.createInterpreter(true, false);
                }
                catch (IOException ex) {
                    Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.invokeLater(1000, false, run);
    }

    private Runnable addAxes() {
        return new Runnable(){

            public void run() {
                final JScrollPane sp = new JScrollPane();
                AutoplotUI.this.tabs.insertTab("axes", null, sp, String.format("<html>Adjust selected plot axes.<br>%s<html>", "Right-click or drag to undock."), 1);
                AutoplotUI.this.invokeLater(-1, true, new Runnable(){

                    public void run() {
                        AxisPanel c = new AxisPanel(AutoplotUI.this.applicationModel);
                        sp.setViewportView(c);
                    }
                });
            }
        };
    }

    private Runnable addStyle() {
        return new Runnable(){

            public void run() {
                final JScrollPane sp = new JScrollPane();
                AutoplotUI.this.tabs.insertTab("style", null, sp, String.format("<html>Adjust selected plot element's colors, shapes, and other style settings.<br>%s</html>", "Right-click or drag to undock."), 2);
                AutoplotUI.this.invokeLater(-1, true, new Runnable(){

                    public void run() {
                        PlotStylePanel c = new PlotStylePanel(AutoplotUI.this.applicationModel);
                        sp.setViewportView(c);
                    }
                });
            }
        };
    }

    private void addDataSource() throws HeadlessException {
        String jar;
        AddDataSourcePanel add = new AddDataSourcePanel();
        int r = JOptionPane.showConfirmDialog(this, add, "Add Data Source", 2);
        if (r == 0 && (jar = add.getDataSetSelector().getValue()).endsWith("jar")) {
            try {
                DataSourceRegistry.getInstance().registerDataSourceJar(null, new URL(jar));
            }
            catch (IOException ex) {
                Logger.getLogger(AddDataSourcePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static List<String> cleanMessages(List<String> messages) {
        messages = new ArrayList<String>(messages);
        LinkedList<String> result = new LinkedList<String>(messages);
        for (String s : messages) {
            if (!s.equals("Delete Plot")) continue;
            result.remove("Delete Plot Element");
        }
        return result;
    }

    private void addFeatures(ApplicationModel model) {
        JScrollPane fdataPane;
        JScrollPane flayoutPane;
        if (model.getDocumentModel().getOptions().isLayoutVisible()) {
            flayoutPane = new JScrollPane();
            this.tabs.insertTab("layout", null, flayoutPane, String.format("<html>Inspect the canvas layout and property bindings, and<br>provides access to all plot elements.<br>%s</html>", "Right-click or drag to undock."), this.tabs.getTabCount());
        } else {
            flayoutPane = null;
        }
        this.layoutPanel1 = flayoutPane;
        if (model.getDocumentModel().getOptions().isDataVisible()) {
            fdataPane = new JScrollPane();
            this.tabs.insertTab("data", null, fdataPane, String.format("<html>Specify valid ranges and apply additional operations to data.<br>%s</html>", "Right-click or drag to undock."), this.tabs.getTabCount());
        } else {
            fdataPane = null;
        }
        final JScrollPane fmetadataPane = new JScrollPane();
        this.tabs.insertTab("metadata", null, fmetadataPane, String.format("<html>Inspect selected element's metadata and data statistics.<br>%s</html>", "Right-click or drag to undock."), this.tabs.getTabCount());
        this.invokeLater(-1, true, new Runnable(){

            public void run() {
                if (flayoutPane != null) {
                    LayoutPanel lui = new LayoutPanel();
                    AutoplotUI.this.layoutPanel = lui;
                    flayoutPane.setViewportView(lui);
                    lui.setApplication(AutoplotUI.this.dom);
                }
                if (fdataPane != null) {
                    DataPanel dp = new DataPanel(AutoplotUI.this.dom);
                    AutoplotUI.this.dataPanel = dp;
                    fdataPane.setViewportView(dp);
                    dp.doBindings();
                }
                MetadataPanel mdp = new MetadataPanel(AutoplotUI.this.applicationModel);
                fmetadataPane.setViewportView(mdp);
            }
        });
        if (model.getDocumentModel().getOptions().isScriptVisible()) {
            this.scriptPanel = new JythonScriptPanel(this.applicationModel, this.dataSetSelector);
            this.tabs.addTab(TAB_SCRIPT, null, this.scriptPanel, String.format("<html>Editor panel for Jython scripts and data sources.<br>%s</html>", "Right-click or drag to undock."));
            this.scriptPanelMenuItem.setSelected(true);
        }
        if (model.getDocumentModel().getOptions().isLogConsoleVisible()) {
            this.initLogConsole();
        }
        this.tickleTimer = new TickleTimer(300L, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (AutoplotUI.this.dom.getController().isValueAdjusting()) {
                    AutoplotUI.this.tickleTimer.tickle("app value was adjusting");
                    return;
                }
                LinkedHashMap<Object, Object> changes = new LinkedHashMap<Object, Object>();
                AutoplotUI.this.dom.getController().pendingChanges(changes);
                if (changes.size() > 0) {
                    AutoplotUI.this.tickleTimer.tickle("app had pending changes");
                    return;
                }
                List messages = AutoplotUI.this.tickleTimer.getMessages();
                if (messages.size() > 1) {
                    if ((messages = AutoplotUI.cleanMessages(messages)).size() == 1) {
                        AutoplotUI.this.undoRedoSupport.pushState(evt, (String)messages.get(0));
                    } else {
                        AutoplotUI.this.undoRedoSupport.pushState(evt, null);
                    }
                } else if (messages.size() == 1) {
                    if (((String)messages.get(0)).contains(" from ")) {
                        AutoplotUI.this.undoRedoSupport.pushState(evt);
                    } else {
                        AutoplotUI.this.undoRedoSupport.pushState(evt, (String)messages.get(0));
                    }
                } else {
                    logger.fine("tickleTimer contained no messages.");
                }
                AutoplotUI.this.stateSupport.markDirty();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AutoplotUI.this.refreshUndoRedoLabel();
                    }
                });
            }
        });
        this.applicationModel.dom.getController().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (AutoplotUI.this.dom.getController().isValueAdjusting()) {
                    return;
                }
                logger.log(Level.FINER, "state change: {0}", evt);
                if (!(AutoplotUI.this.stateSupport.isOpening() || AutoplotUI.this.stateSupport.isSaving() || AutoplotUI.this.applicationModel.isRestoringState())) {
                    if (evt.getActionCommand().startsWith("label: ")) {
                        AutoplotUI.this.tickleTimer.tickle(evt.getActionCommand().substring("label: ".length()));
                    } else {
                        AutoplotUI.this.tickleTimer.tickle(evt.getActionCommand() + " from " + evt.getSource());
                    }
                }
            }
        });
        this.applicationModel.dom.getController().addPropertyChangeListener("dataSourceFilter", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DataSourceFilter dsf = (DataSourceFilter)evt.getNewValue();
                if (dsf == null) {
                    AutoplotUI.this.dataSetSelector.setValue("");
                } else {
                    String uri = dsf.getUri();
                    if (uri != null) {
                        AutoplotUI.this.dataSetSelector.setValue(uri);
                    } else {
                        AutoplotUI.this.dataSetSelector.setValue("");
                    }
                }
            }
        });
    }

    protected void refreshUndoRedoLabel() {
        assert (EventQueue.isDispatchThread());
        String t = this.undoRedoSupport.getUndoLabel();
        this.undoMenuItem.setEnabled(t != null);
        this.undoMenuItem.setText(t == null ? "Undo" : t);
        this.undoMenuItem.setToolTipText(t == null ? "" : this.undoRedoSupport.getUndoDescription());
        String tt = this.undoRedoSupport.getRedoLabel();
        this.redoMenuItem.setEnabled(tt != null);
        this.redoMenuItem.setText(tt == null ? "Redo" : tt);
        this.redoMenuItem.setToolTipText(tt == null ? "" : this.undoRedoSupport.getRedoDescription());
        this.undoRedoSupport.refreshUndoMultipleMenu(this.undoMultipleMenu);
    }

    public TearoffTabbedPane getTabs() {
        return this.tabs;
    }

    private void bind(BindingGroup bc, Object src, String srcProperty, Object dst, String dstProperty) {
        BeanProperty dstbp;
        BeanProperty srcbp = BeanProperty.create((String)srcProperty);
        if (!srcbp.isReadable(src)) {
            System.err.println("not readable: " + srcProperty + " of " + src);
        }
        if (!(dstbp = BeanProperty.create((String)dstProperty)).isReadable(dst)) {
            System.err.println("not readable: " + dstProperty + " of " + dst);
        }
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)src, (Property)srcbp, (Object)dst, (Property)dstbp));
    }

    private void addBindings() {
        Runnable run = new Runnable(){

            public void run() {
                BindingGroup bc = new BindingGroup();
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "drawAntiAlias", AutoplotUI.this.drawAntiAliasMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "textAntiAlias", AutoplotUI.this.textAntiAlias, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "specialEffects", AutoplotUI.this.specialEffectsMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "overRendering", AutoplotUI.this.overRenderingMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "drawGrid", AutoplotUI.this.drawGridCheckBox, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "autolabelling", AutoplotUI.this.autoLabellingCheckBoxMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "autolayout", AutoplotUI.this.autoLayoutCheckBoxMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "autoranging", AutoplotUI.this.autoRangingCheckBoxMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "dataVisible", AutoplotUI.this.dataPanelCheckBoxMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "layoutVisible", AutoplotUI.this.layoutPanelCheckBoxMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "dayOfYear", AutoplotUI.this.doyCB, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "nearestNeighbor", AutoplotUI.this.nnCb, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "useTimeRangeEditor", AutoplotUI.this.timeRangeSelectorMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom, "timeRange", AutoplotUI.this.timeRangeEditor, "range");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "dayOfYear", AutoplotUI.this.timeRangeEditor, "useDoy");
                bc.bind();
                AutoplotUI.this.dom.addPropertyChangeListener("bindings", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        BindingModel[] bms = AutoplotUI.this.dom.getBindings();
                        boolean isBound = false;
                        for (int i = 0; i < bms.length; ++i) {
                            if (!bms[i].getSrcProperty().equals("timeRange")) continue;
                            isBound = true;
                        }
                        if (isBound) {
                            AutoplotUI.this.dom.getController().bind(AutoplotUI.this.dom, "timeRange", AutoplotUI.this.dataSetSelector, "timeRange");
                        } else {
                            AutoplotUI.this.dom.getController().unbind(AutoplotUI.this.dom, "timeRange", AutoplotUI.this.dataSetSelector, "timeRange");
                            AutoplotUI.this.dataSetSelector.setTimeRange(null);
                        }
                    }
                });
            }
        };
        this.invokeLater(-1, true, run);
        this.dataSetSelector.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.applicationModel.setDataSourceURL(AutoplotUI.this.dataSetSelector.getValue());
            }
        });
    }

    public void plotUri(String uri) {
        this.dataSetSelector.setValue(uri);
        this.dataSetSelector.maybePlot(false);
    }

    private Action getAddPanelAction() {
        return new AbstractAction("Add Plot..."){

            public void actionPerformed(ActionEvent e) {
                AutoplotUI.this.support.addPlotElement();
            }
        };
    }

    private synchronized JMenu getAddDataFromMenu() {
        JMenu result = new JMenu("Add Plot From");
        result.add(new JMenuItem("looking up discoverable sources..."));
        this.addDataFromMenu = result;
        RequestProcessor.invokeLater(new Runnable(){

            public void run() {
                AutoplotUI.this.fillAddDataFromMenu();
            }
        });
        return result;
    }

    private void fillAddDataFromMenuImmediately(List<String> exts) {
        this.addDataFromMenu.removeAll();
        for (String ext : exts) {
            if (ext.startsWith(".")) {
                ext = ext.substring(1);
            }
            final String fext = ext;
            AbstractAction a = new AbstractAction(ext){

                public void actionPerformed(ActionEvent e) {
                    try {
                        String uri = "vap+" + fext + ":";
                        String refuri = AutoplotUI.this.dataSetSelector.getEditor().getText();
                        if (refuri.startsWith(uri)) {
                            AutoplotUI.this.dataSetSelector.browseSourceType();
                        } else {
                            AutoplotUI.this.dataSetSelector.setValue(uri);
                            AutoplotUI.this.dataSetSelector.maybePlot(true);
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            JMenuItem item = new JMenuItem(a);
            this.addDataFromMenu.add(item);
        }
    }

    private void fillAddDataFromMenu() {
        final List exts = DataSourceEditorPanelUtil.getDiscoverableExtensions();
        Runnable run = new Runnable(){

            public void run() {
                AutoplotUI.this.fillAddDataFromMenuImmediately(exts);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void fillFileMenu() {
        ArrayList<JComponent> expertItems = new ArrayList<JComponent>();
        expertItems.add(new JMenuItem(this.support.createNewApplicationAction()));
        expertItems.add(new JMenuItem(this.support.createCloneApplicationAction()));
        this.fileMenu.add((Component)expertItems.get(0));
        this.fileMenu.add((Component)expertItems.get(1));
        JMenuItem mi = new JMenuItem(this.support.createNewDOMAction());
        expertItems.add(mi);
        mi.setToolTipText("Reset application to initial state");
        this.fileMenu.add(mi);
        this.fileMenu.add(new JSeparator());
        APSplash.checkTime("init 51");
        this.fileMenu.add(this.getAddDataFromMenu());
        APSplash.checkTime("init 52");
        mi = new JMenuItem(this.getAddPanelAction());
        mi.setToolTipText("Add a new plot or overplot to the application");
        expertItems.add(mi);
        this.fileMenu.add(mi);
        mi = new JMenuItem(this.dataSetSelector.getOpenLocalAction());
        mi.setToolTipText("Open local data file");
        expertItems.add(mi);
        this.fileMenu.add(mi);
        mi = new JMenuItem(new AbstractAction("Open Recent..."){

            public void actionPerformed(ActionEvent e) {
                RecentUrisDialog dia = new RecentUrisDialog((Frame)SwingUtilities.getWindowAncestor(AutoplotUI.this.fileMenu), true);
                dia.setExpertMode(AutoplotUI.this.isExpertMode());
                dia.setVisible(true);
                if (dia.isCancelled()) {
                    return;
                }
                String suri = dia.getSelectedURI();
                if (suri != null) {
                    AutoplotUI.this.dataSetSelector.setValue(suri);
                    AutoplotUI.this.dataSetSelector.maybePlot(dia.getModifiers());
                }
            }
        });
        mi.setToolTipText("Open recent URIs dialog");
        this.fileMenu.add(mi);
        this.fileMenu.add(new JSeparator());
        mi = new JMenuItem(this.dataSetSelector.getOpenLocalVapAction());
        mi.setToolTipText("Open local .vap application state file");
        this.fileMenu.add(mi);
        mi = new JMenuItem(this.stateSupport.createSaveAsAction());
        mi.setToolTipText("Save the application state to a file");
        this.fileMenu.add(mi);
        mi = new JMenuItem(this.stateSupport.createSaveAction());
        mi.setToolTipText("Save the application state to a file");
        this.fileMenu.add(mi);
        this.fileMenu.addSeparator();
        mi = new JMenuItem(DasCanvas.PRINT_ACTION);
        mi.setToolTipText("Print to printer");
        this.fileMenu.add(mi);
        JMenu printToMenu = new JMenu("Print to");
        printToMenu.setToolTipText("Print to file");
        this.fileMenu.add(printToMenu);
        JMenuItem item = new JMenuItem(GuiSupport.getPrintAction(this.dom, "pdf"));
        item.setText("PDF...");
        printToMenu.add(item);
        item = new JMenuItem(GuiSupport.getPrintAction(this.dom, "svg"));
        item.setText("SVG...");
        printToMenu.add(item);
        item = new JMenuItem(GuiSupport.getPrintAction(this.dom, "png"));
        item.setText("PNG...");
        printToMenu.add(item);
        this.fileMenu.addSeparator();
        item = new JMenuItem(this.support.getDumpDataAction2(this.dom));
        item.setToolTipText("Export the data that has the focus");
        expertItems.add(item);
        this.fileMenu.add(item);
        JSeparator dumpSep = new JSeparator();
        expertItems.add(dumpSep);
        this.fileMenu.add(dumpSep);
        this.fileMenu.add(new AbstractAction("Close"){

            public void actionPerformed(ActionEvent ev) {
                int opt;
                if (AppManager.getInstance().getApplicationCount() == 1 && (opt = JOptionPane.showConfirmDialog(AutoplotUI.this, "Quit application?", "Quit Autoplot", 1)) != 0) {
                    if (opt == 1) {
                        AutoplotUI.this.dom.getController().reset();
                        return;
                    }
                    return;
                }
                AutoplotUI.this.dispose();
                ScriptContext.close();
                AppManager.getInstance().closeApplication(AutoplotUI.this);
            }
        });
        this.fileMenu.add(new AbstractAction("Quit"){

            public void actionPerformed(ActionEvent ev) {
                AutoplotUI.this.dispose();
                AppManager.getInstance().quit();
            }
        });
        this.expertMenuItems.addAll(expertItems);
    }

    public void resetAction(String name, Action a) {
        for (int i = 0; i < this.fileMenu.getItemCount(); ++i) {
            JMenuItem item = this.fileMenu.getItem(i);
            if (item == null || !item.getText().equals(name)) continue;
            this.fileMenu.getItem(i).setAction(a);
        }
    }

    private void initLogConsole() throws SecurityException {
        this.logConsole = new LogConsole();
        this.logConsole.setScriptContext(Collections.singletonMap("dom", this.applicationModel.dom));
        this.logConsole.turnOffConsoleHandlers();
        this.logConsole.logConsoleMessages();
        Handler h = this.logConsole.getHandler();
        Logger.getLogger("das2").setLevel(Level.INFO);
        Logger.getLogger("das2").addHandler(h);
        Logger.getLogger("virbo").setLevel(Level.ALL);
        Logger.getLogger("virbo").addHandler(h);
        Logger.getLogger("vap").setLevel(Level.ALL);
        Logger.getLogger("vap").addHandler(h);
        Logger.getLogger("console").setLevel(Level.ALL);
        Logger.getLogger("console").addHandler(h);
        this.setMessage("log console added");
        this.tabs.addTab("console", null, this.logConsole, String.format("<html>Log console displays log messages and stdout/stderr.<br>%s</html>", "Right-click or drag to undock."));
        this.applicationModel.getDocumentModel().getOptions().setLogConsoleVisible(true);
        if (this.applicationModel.getExceptionHandler() instanceof GuiExceptionHandler) {
            ((GuiExceptionHandler)this.applicationModel.getExceptionHandler()).setLogConsole(this.logConsole);
        }
        this.logConsoleMenuItem.setSelected(true);
    }

    private void initServer() {
        String result = JOptionPane.showInputDialog(this, "Select port for server.  This port will accept jython commands to control receive services from the application", 12345);
        if (result == null) {
            return;
        }
        int iport = Integer.parseInt(result);
        this.setupServer(iport, this.applicationModel);
    }

    private void stopServer() {
        if (this.rlistener != null) {
            this.rlistener.stopListening();
        }
        this.rlistener = null;
    }

    private ProgressMonitor getStatusBarProgressMonitor(final String finishMessage) {
        return new NullProgressMonitor(){

            public void setProgressMessage(String message) {
                AutoplotUI.this.setStatus(BUSY_ICON, message);
            }

            public void finished() {
                AutoplotUI.this.setStatus(IDLE_ICON, finishMessage);
            }
        };
    }

    private void plotUrl(String surl) {
        try {
            Logger.getLogger("ap").log(Level.FINE, "plotUrl({0})", surl);
            URISplit split = URISplit.parse((String)surl);
            ProgressMonitor mon = this.getStatusBarProgressMonitor("Finished loading " + surl);
            if (!(split.file != null && (split.file.endsWith(".vap") || split.file.endsWith(".vapx")) || "true".equals(AutoplotUtil.getProperty("java.awt.headless", "false")))) {
                try {
                    DataSetURI.getDataSourceFactory((URI)DataSetURI.getURIValid((String)surl), (ProgressMonitor)mon);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalArgumentException ex) {
                    SourceTypesBrowser browser = new SourceTypesBrowser();
                    browser.getDataSetSelector().setValue(DataSetURI.fromUri((URI)DataSetURI.getResourceURI((String)surl)));
                    int r = JOptionPane.showConfirmDialog(this, browser, "Select Data Source Type", 2);
                    if (r == 0) {
                        surl = browser.getUri();
                        this.dataSetSelector.getEditor().setText(surl);
                        this.dataSetSelector.setValue(surl);
                        this.dataSetSelector.maybePlot(true);
                        return;
                    }
                    return;
                }
            }
            this.applicationModel.resetDataSetSourceURL(surl, mon);
            if (split.file != null && (split.file.endsWith(".vap") || split.file.endsWith(".vapx"))) {
                this.tickleTimer.tickle();
            }
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof HtmlResponseIOException) {
                this.setStatus(ERROR_ICON, "Html response from URI: " + surl);
                HtmlResponseIOException htmlEx = (HtmlResponseIOException)ex.getCause();
                if (htmlEx.getURL() != null) {
                    final String link = htmlEx.getURL().toString();
                    JPanel p = new JPanel(new BorderLayout());
                    p.add((Component)new JLabel("<html>Unable to open URI: <br>" + surl + "<br><br>" + ex.getCause().getMessage() + "<br><a href=\"" + link + "\">" + link + "</a><br>"), "Center");
                    JPanel p1 = new JPanel(new BorderLayout());
                    p1.add((Component)new JButton(new AbstractAction("View Page"){

                        public void actionPerformed(ActionEvent ev) {
                            AutoplotUtil.openBrowser(link);
                        }
                    }), "East");
                    p.add((Component)p1, "South");
                    JOptionPane.showMessageDialog(this, p);
                } else {
                    JOptionPane.showMessageDialog(this, "<html>Unable to open URI: <br>" + surl + "<br><br>" + ex.getCause());
                }
            }
            if (ex.getCause() != null && ex.getCause() instanceof IOException) {
                this.setStatus(ERROR_ICON, "Unable to open URI: " + surl);
                JOptionPane.showMessageDialog(this, "<html>Unable to open URI: <br>" + surl + "<br><br>" + ex.getCause());
            }
            this.applicationModel.getExceptionHandler().handleUncaught(ex);
            String msg = ex.getMessage();
            if (msg == null) {
                msg = ex.toString();
            }
            this.setStatus(ERROR_ICON, msg);
        }
    }

    private void plotAnotherUrl() {
        this.plotAnotherUrl(this.dataSetSelector.getValue());
    }

    private void plotAnotherUrl(String surl) {
        try {
            Logger.getLogger("ap").log(Level.FINE, "plotAnotherUrl({0})", surl);
            PlotElement panel = this.dom.getController().addPlotElement(null, null);
            this.dom.getController().getDataSourceFilterFor(panel).setUri(surl);
            this.dom.getController().setPlotElement(panel);
        }
        catch (RuntimeException ex) {
            this.applicationModel.getExceptionHandler().handleUncaught(ex);
            this.setStatus(ERROR_ICON, ex.getMessage());
        }
    }

    private void overplotAnotherUrl() {
        this.overplotAnotherUrl(this.dataSetSelector.getValue());
    }

    private void overplotAnotherUrl(String surl) {
        try {
            Logger.getLogger("ap").log(Level.FINE, "overplotAnotherUrl({0})", surl);
            PlotElement panel = this.dom.getController().addPlotElement(this.dom.getController().getPlot(), null);
            this.dom.getController().getDataSourceFilterFor(panel).setUri(surl);
            this.dom.getController().setPlotElement(panel);
        }
        catch (RuntimeException ex) {
            this.applicationModel.getExceptionHandler().handleUncaught(ex);
            this.setStatus(ERROR_ICON, ex.getMessage());
        }
    }

    public void resizeForCanvasSize(int w, int h) {
        Window parentToAdjust = SwingUtilities.isDescendingFrom(this.applicationModel.getCanvas(), this) ? this : SwingUtilities.getWindowAncestor(this.applicationModel.getCanvas());
        Dimension dout = parentToAdjust.getSize();
        Dimension din = this.applicationModel.getCanvas().getSize();
        dout.width += w - din.width;
        dout.height += h - din.height;
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Dimension screenSize = gc.getBounds().getSize();
        if (w < 640 || h < 480) {
            this.applicationModel.dom.getCanvases(0).setFitted(false);
            this.setStatus("warning: canvas is no longer fitted, see options->plot style->canvas size");
            this.applicationModel.dom.getCanvases(0).setHeight(h);
            this.applicationModel.dom.getCanvases(0).setWidth(w);
        } else if ((double)dout.width > screenSize.getWidth() || (double)dout.height > screenSize.getHeight()) {
            Object[] options = new String[]{"Scale to fit display", "Use scrollbars"};
            int i = JOptionPane.showOptionDialog(this, "Canvas size doesn't fit well on this display.", "Incompatible Canvas Size", 0, 1, ERROR_ICON, options, options[1]);
            if (i != -1) {
                if (i == 0) {
                    int nh;
                    int nw;
                    double aspect = 1.0 * (double)h / (double)w;
                    if (1.0 * screenSize.getHeight() / screenSize.getWidth() > aspect) {
                        nw = screenSize.width * 4 / 5;
                        nh = (int)((double)nw * aspect);
                    } else {
                        nh = screenSize.height * 4 / 5;
                        nw = (int)((double)nh / aspect);
                    }
                    ((Component)parentToAdjust).setSize(nw, nh);
                } else if (i == 1) {
                    this.applicationModel.dom.getCanvases(0).setFitted(false);
                    this.setStatus("warning: canvas is no longer fitted, see options->plot style->canvas size");
                    this.applicationModel.dom.getCanvases(0).setHeight(h);
                    this.applicationModel.dom.getCanvases(0).setWidth(w);
                }
            }
        } else {
            ((Component)parentToAdjust).setSize(dout.width, dout.height);
        }
    }

    public void setStatus(String message) {
        if (message.startsWith("busy:")) {
            this.setMessage(BUSY_ICON, message.substring(5).trim());
            logger.info(message);
        } else if (message.startsWith("warning:")) {
            this.setMessage(WARNING_ICON, message.substring(8).trim());
            logger.warning(message);
        } else if (message.startsWith("error:")) {
            this.setMessage(ERROR_ICON, message.substring(6).trim());
            logger.severe(message);
        } else {
            logger.info(message);
            this.setMessage(message);
        }
    }

    public void setStatus(Icon icon, String message) {
        if (ERROR_ICON == icon) {
            logger.severe(message);
        } else if (WARNING_ICON == icon) {
            logger.warning(message);
        } else {
            logger.info(message);
        }
        this.setMessage(icon, message);
    }

    private void clearCache() {
        if (JOptionPane.showConfirmDialog(this, "delete all cached files?", "clear cache", 2) == 0) {
            try {
                if (this.applicationModel.clearCache()) {
                    this.setStatus("cache cleared");
                } else {
                    this.setStatus(ERROR_ICON, "unable to clear cache");
                    JOptionPane.showMessageDialog(this, "unable to clear cache");
                }
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(this, "unable to clear cache: " + ex.getMessage());
            }
        }
    }

    private void maybeCreateBookmarksManager() {
        if (this.bookmarksManager == null) {
            this.bookmarksManager = new BookmarksManager((Frame)this, false);
            AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.applicationModel, (Property)BeanProperty.create((String)"bookmarks"), (Object)this.bookmarksManager.getModel(), (Property)BeanProperty.create((String)"list"));
            b.bind();
            this.bookmarksManager.getModel().addPropertyChangeListener("bookmark", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    AutoplotUI.this.updateBookmarks();
                }
            });
        }
    }

    protected BookmarksManager getBookmarksManager() {
        return this.bookmarksManager;
    }

    private void updateBookmarks() {
        this.maybeCreateBookmarksManager();
        if (!this.bookmarksManager.hasPrefNode("bookmarks")) {
            if (this.bookmarksManager.hasPrefNode("autoplot")) {
                this.bookmarksManager.setPrefNode("autoplot");
                if (this.bookmarksManager.getModel().getList() == null) {
                    this.setStatus("importing legacy bookmarks");
                    this.bookmarksManager.setPrefNode("autoplot");
                    List<Bookmark> bookmarks = this.applicationModel.getLegacyBookmarks();
                    this.bookmarksManager.getModel().setList(bookmarks);
                }
                this.bookmarksManager.resetPrefNode("bookmarks");
            } else {
                this.setStatus("loading initial demo bookmarks");
                List<Bookmark> bookmarks = this.applicationModel.getLegacyBookmarks();
                this.bookmarksManager.getModel().setList(bookmarks);
                this.bookmarksManager.resetPrefNode("bookmarks");
            }
        }
        this.bookmarksManager.setPrefNode("bookmarks");
        this.bookmarksMenu.removeAll();
        JMenuItem item = this.bookmarksMenu.add(new AbstractAction("Export Recent..."){

            public void actionPerformed(ActionEvent e) {
                AutoplotUI.this.support.exportRecent(AutoplotUI.this);
            }
        });
        item.setToolTipText("Export recent URIs to a bookmarks file.  (There is no method for importing recent URIs.)");
        this.bookmarksMenu.add(new JSeparator());
        this.bookmarksManager.updateBookmarks(this.bookmarksMenu, this.dataSetSelector);
        this.bookmarksManager.getModel().addPropertyChangeListener("list", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.bookmarksManager.updateBookmarks(AutoplotUI.this.bookmarksMenu, AutoplotUI.this.dataSetSelector);
            }
        });
    }

    public static PersistentStateSupport getPersistentStateSupport(final AutoplotUI parent, final ApplicationModel applicationModel) {
        final PersistentStateSupport stateSupport = new PersistentStateSupport(parent, null, "vap"){

            protected void saveImpl(File f, String scheme) throws IOException {
                applicationModel.doSave(f, scheme);
                applicationModel.addRecent(f.toURI().toString());
                parent.setStatus("saved " + f);
            }

            protected void openImpl(File file) throws IOException {
                applicationModel.doOpen(file);
                parent.setStatus("opened " + file);
            }
        };
        stateSupport.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                if (stateSupport.isCurrentFileOpened()) {
                    String label = stateSupport.getCurrentFile() + " " + (stateSupport.isDirty() ? "*" : "");
                    parent.setMessage(label);
                }
            }
        });
        return stateSupport;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.persistentStateSupport1 = new org.das2.dasml.PersistentStateSupport();
        this.addressBarButtonGroup = new ButtonGroup();
        this.statusLabel = new JLabel();
        this.tabbedPanelContainer = new JPanel();
        this.statusTextField = new JTextField();
        this.timeRangePanel = new JPanel();
        this.dataSetSelector = new DataSetSelector();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.editMenu = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.redoMenuItem = new JMenuItem();
        this.undoMultipleMenu = new JMenu();
        this.editDomSeparator = new JSeparator();
        this.editDomMenuItem = new JMenuItem();
        this.EditOptions = new JMenuItem();
        this.inspectVapFileMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.pasteDataSetURLMenuItem = new JMenuItem();
        this.copyDataSetURLMenuItem = new JMenuItem();
        this.copyImageMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.resetZoomMenuItem = new JMenuItem();
        this.zoomInMenuItem = new JMenuItem();
        this.zoomOutMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.renderingOptionsMenu = new JMenu();
        this.textAntiAlias = new JCheckBoxMenuItem();
        this.drawAntiAliasMenuItem = new JCheckBoxMenuItem();
        this.specialEffectsMenuItem = new JCheckBoxMenuItem();
        this.overRenderingMenuItem = new JCheckBoxMenuItem();
        this.drawGridCheckBox = new JCheckBoxMenuItem();
        this.doyCB = new JCheckBoxMenuItem();
        this.nnCb = new JCheckBoxMenuItem();
        this.plotStyleMenu = new JMenu();
        this.fontsAndColorsMenuItem = new JMenuItem();
        this.canvasSizeMenuItem = new JMenuItem();
        this.enableFeatureMenu = new JMenu();
        this.scriptPanelMenuItem = new JCheckBoxMenuItem();
        this.logConsoleMenuItem = new JCheckBoxMenuItem();
        this.serverCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.dataPanelCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.layoutPanelCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.textSizeMenu = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.addressBarMenu = new JMenu();
        this.dataSetSelectorMenuItem = new JRadioButtonMenuItem();
        this.timeRangeSelectorMenuItem = new JRadioButtonMenuItem();
        this.autoMenu = new JMenu();
        this.autoRangingCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.autoLabellingCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.autoLayoutCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.bookmarksMenu = new JMenu();
        this.toolsMenu = new JMenu();
        this.cacheMenu = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.pngWalkMenuItem = new JMenuItem();
        this.createPngWalkMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.fixLayoutMenuItem = new JMenuItem();
        this.createPngWalkSeparator = new JSeparator();
        this.aggregateMenuItem = new JMenuItem();
        this.aggSeparator = new JSeparator();
        this.decodeURLItem = new JMenuItem();
        this.exceptionReport = new JMenuItem();
        this.helpMenu = new JMenu();
        this.autoplotHelpMenuItem = new JMenuItem();
        this.gettingStartedMenuItem = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.aboutDas2MenuItem = new JMenuItem();
        this.autoplotHomepageButton = new JMenuItem();
        this.aboutAutoplotMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Autoplot");
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont((float)this.statusLabel.getFont().getSize() - 2.0f));
        this.statusLabel.setText("starting...");
        this.statusLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AutoplotUI.this.statusLabelMouseClicked(evt);
            }
        });
        this.tabbedPanelContainer.setLayout(new BorderLayout());
        this.statusTextField.setEditable(false);
        this.statusTextField.setFont(this.statusTextField.getFont().deriveFont((float)this.statusTextField.getFont().getSize() - 2.0f));
        this.statusTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.statusLabel, (Property)ELProperty.create((String)"${text}"), (Object)this.statusTextField, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.statusTextField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AutoplotUI.this.statusTextFieldMouseClicked(evt);
            }
        });
        this.timeRangePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.timeRangePanel.setLayout(new CardLayout());
        this.dataSetSelector.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.dataSetSelector.setPromptText("Enter data location or select a bookmark");
        this.dataSetSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.dataSetSelectorActionPerformed(evt);
            }
        });
        this.timeRangePanel.add((Component)this.dataSetSelector, CARD_DATA_SET_SELECTOR);
        this.fileMenu.setText("File");
        this.jMenuBar1.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.undoMenuItem.setAction(this.undoRedoSupport.getUndoAction());
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.undoMenuItem.setText("Undo");
        this.undoMenuItem.setToolTipText("Undo the last operation");
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem.setAction(this.undoRedoSupport.getRedoAction());
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.redoMenuItem.setText("Redo");
        this.redoMenuItem.setToolTipText("Redo the last undone operation");
        this.editMenu.add(this.redoMenuItem);
        this.undoMultipleMenu.setText("Undo...");
        this.editMenu.add(this.undoMultipleMenu);
        this.editMenu.add(this.editDomSeparator);
        this.editDomMenuItem.setText("Edit DOM");
        this.editDomMenuItem.setToolTipText("Edit the application state using the property editor");
        this.editDomMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.editDomMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editDomMenuItem);
        this.EditOptions.setText("Options...");
        this.EditOptions.setToolTipText("Edit user options like background colors and fonts");
        this.EditOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.EditOptionsActionPerformed(evt);
            }
        });
        this.editMenu.add(this.EditOptions);
        this.inspectVapFileMenuItem.setText("Inspect Vap File...");
        this.inspectVapFileMenuItem.setToolTipText("View a vap file from a local disk in the property editor");
        this.inspectVapFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.inspectVapFileMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.inspectVapFileMenuItem);
        this.editMenu.add(this.jSeparator1);
        this.pasteDataSetURLMenuItem.setText("Paste URI");
        this.pasteDataSetURLMenuItem.setToolTipText("Paste a data address in the system clipboard into the address bar");
        this.pasteDataSetURLMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.pasteDataSetURLMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.pasteDataSetURLMenuItem);
        this.copyDataSetURLMenuItem.setText("Copy URI");
        this.copyDataSetURLMenuItem.setToolTipText("Copy the data address in the address bar into the system clipboard");
        this.copyDataSetURLMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.copyDataSetURLMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyDataSetURLMenuItem);
        this.copyImageMenuItem.setText("Copy Image To Clipboard");
        this.copyImageMenuItem.setToolTipText("Copy the canvas image into the system clipboard.");
        this.copyImageMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.copyImageMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyImageMenuItem);
        this.jMenuBar1.add(this.editMenu);
        this.viewMenu.setText("View");
        this.resetZoomMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.resetZoomMenuItem.setText("Reset Zoom");
        this.resetZoomMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.resetZoomMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.resetZoomMenuItem);
        this.zoomInMenuItem.setText("Zoom In");
        this.zoomInMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.zoomInMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.zoomInMenuItem);
        this.zoomOutMenuItem.setText("Zoom Out");
        this.zoomOutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.zoomOutMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.zoomOutMenuItem);
        this.jMenuBar1.add(this.viewMenu);
        this.optionsMenu.setText("Options");
        this.renderingOptionsMenu.setText("Rendering Options");
        this.textAntiAlias.setSelected(true);
        this.textAntiAlias.setText("Text Antialias");
        this.textAntiAlias.setToolTipText("Enable/Disable Text Antialiasing");
        this.textAntiAlias.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.textAntiAliasActionPerformed(evt);
            }
        });
        this.renderingOptionsMenu.add(this.textAntiAlias);
        this.drawAntiAliasMenuItem.setSelected(true);
        this.drawAntiAliasMenuItem.setText("Graphics Antialias");
        this.drawAntiAliasMenuItem.setToolTipText("Enable/Disable Graphics Antialiasing");
        this.drawAntiAliasMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.drawAntiAliasMenuItemActionPerformed(evt);
            }
        });
        this.renderingOptionsMenu.add(this.drawAntiAliasMenuItem);
        this.specialEffectsMenuItem.setText("Special Effects");
        this.specialEffectsMenuItem.setToolTipText("Enable animated axes and other visual clues");
        this.specialEffectsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.specialEffectsMenuItemActionPerformed(evt);
            }
        });
        this.renderingOptionsMenu.add(this.specialEffectsMenuItem);
        this.overRenderingMenuItem.setSelected(true);
        this.overRenderingMenuItem.setText("Over-Rendering");
        this.overRenderingMenuItem.setToolTipText("Render (and load) data outside plot bounds to improve appearance.");
        this.renderingOptionsMenu.add(this.overRenderingMenuItem);
        this.drawGridCheckBox.setSelected(true);
        this.drawGridCheckBox.setText("Draw Grid");
        this.drawGridCheckBox.setToolTipText("Draw gridlines at major ticks");
        this.renderingOptionsMenu.add(this.drawGridCheckBox);
        this.doyCB.setText("Day of Year Labels");
        this.doyCB.setToolTipText("Use Day of Year instead of Year-Month-Day for labels");
        this.renderingOptionsMenu.add(this.doyCB);
        this.nnCb.setText("Nearest Neighbor Spectrograms");
        this.nnCb.setToolTipText("Use Nearest Neighbor rebinning for new spectrograms");
        this.renderingOptionsMenu.add(this.nnCb);
        this.optionsMenu.add(this.renderingOptionsMenu);
        this.plotStyleMenu.setText("Plot Style");
        this.fontsAndColorsMenuItem.setText("Fonts and Colors...");
        this.fontsAndColorsMenuItem.setToolTipText("Edit canvas font and colors");
        this.fontsAndColorsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.fontsAndColorsMenuItemActionPerformed(evt);
            }
        });
        this.plotStyleMenu.add(this.fontsAndColorsMenuItem);
        this.canvasSizeMenuItem.setText("Canvas Size...");
        this.canvasSizeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.canvasSizeMenuItemActionPerformed(evt);
            }
        });
        this.plotStyleMenu.add(this.canvasSizeMenuItem);
        this.optionsMenu.add(this.plotStyleMenu);
        this.enableFeatureMenu.setText("Enable Feature");
        this.scriptPanelMenuItem.setText("Script Panel");
        this.scriptPanelMenuItem.setToolTipText("Script Panel adds a tab that displays scripts used for the jython data source.  It also provides a way to create new jython sources.");
        this.scriptPanelMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.scriptPanelMenuItemActionPerformed(evt);
            }
        });
        this.enableFeatureMenu.add(this.scriptPanelMenuItem);
        this.logConsoleMenuItem.setText("Log Console");
        this.logConsoleMenuItem.setToolTipText("Add a tab that receives and displays messages posted to the java logging system.  ");
        this.logConsoleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.logConsoleMenuItemActionPerformed(evt);
            }
        });
        this.enableFeatureMenu.add(this.logConsoleMenuItem);
        this.serverCheckBoxMenuItem.setText("Server");
        this.serverCheckBoxMenuItem.setToolTipText("<html> Start up back end server that allows commands to be send to Autoplot via a port. </html>");
        this.serverCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.serverCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.enableFeatureMenu.add(this.serverCheckBoxMenuItem);
        this.dataPanelCheckBoxMenuItem.setText("Data Panel");
        this.dataPanelCheckBoxMenuItem.setToolTipText("The data panel allows for explicitly setting valid range and fill values for the dataset, and additional controls for data reduction before plotting. ");
        this.enableFeatureMenu.add(this.dataPanelCheckBoxMenuItem);
        this.layoutPanelCheckBoxMenuItem.setText("Layout Panel");
        this.layoutPanelCheckBoxMenuItem.setToolTipText("Enables the layout panel, which shows all the plots and plot elements in thier relative positions.\n");
        this.enableFeatureMenu.add(this.layoutPanelCheckBoxMenuItem);
        this.optionsMenu.add(this.enableFeatureMenu);
        this.textSizeMenu.setText("Text Size");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItem1.setText("Bigger");
        this.jMenuItem1.setToolTipText("Make canvas font bigger");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.textSizeMenu.add(this.jMenuItem1);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItem2.setText("Smaller");
        this.jMenuItem2.setToolTipText("Make canvas font smaller");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.textSizeMenu.add(this.jMenuItem2);
        this.optionsMenu.add(this.textSizeMenu);
        this.addressBarMenu.setText("Address Bar");
        this.dataSetSelectorMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.addressBarButtonGroup.add(this.dataSetSelectorMenuItem);
        this.dataSetSelectorMenuItem.setSelected(true);
        this.dataSetSelectorMenuItem.setText("Data Set Selector");
        this.dataSetSelectorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.dataSetSelectorMenuItemActionPerformed(evt);
            }
        });
        this.addressBarMenu.add(this.dataSetSelectorMenuItem);
        this.timeRangeSelectorMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.addressBarButtonGroup.add(this.timeRangeSelectorMenuItem);
        this.timeRangeSelectorMenuItem.setText("Time Range Selector");
        this.timeRangeSelectorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.timeRangeSelectorMenuItemActionPerformed(evt);
            }
        });
        this.addressBarMenu.add(this.timeRangeSelectorMenuItem);
        this.optionsMenu.add(this.addressBarMenu);
        this.autoMenu.setText("Auto");
        this.autoRangingCheckBoxMenuItem.setSelected(true);
        this.autoRangingCheckBoxMenuItem.setText("AutoRanging");
        this.autoRangingCheckBoxMenuItem.setToolTipText("Allow automatic axis range setting.  Range is based on metadata hints and data range.");
        this.autoMenu.add(this.autoRangingCheckBoxMenuItem);
        this.autoLabellingCheckBoxMenuItem.setSelected(true);
        this.autoLabellingCheckBoxMenuItem.setText("AutoLabelling");
        this.autoLabellingCheckBoxMenuItem.setToolTipText("Allow automatic setting of axis labels based on metadata. ");
        this.autoMenu.add(this.autoLabellingCheckBoxMenuItem);
        this.autoLayoutCheckBoxMenuItem.setSelected(true);
        this.autoLayoutCheckBoxMenuItem.setText("AutoLayout");
        this.autoLayoutCheckBoxMenuItem.setToolTipText("<html><p>Allow the application to reposition axes so labels are not clipped and unused space is reduced.  </P><p>Axes can be positioned manually by turning off this option, then hold shift down to enable plot corner drag anchors.</p></html>");
        this.autoLayoutCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.autoLayoutCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.autoMenu.add(this.autoLayoutCheckBoxMenuItem);
        this.optionsMenu.add(this.autoMenu);
        this.jMenuBar1.add(this.optionsMenu);
        this.bookmarksMenu.setText("Bookmarks");
        this.jMenuBar1.add(this.bookmarksMenu);
        this.toolsMenu.setText("Tools");
        this.cacheMenu.setText("Cache");
        this.jMenuItem3.setText("Manage Files...");
        this.jMenuItem3.setToolTipText("Manage cache of downloaded data files.");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.cacheMenu.add(this.jMenuItem3);
        this.jMenuItem4.setText("Clear Cache");
        this.jMenuItem4.setToolTipText("Delete all downloaded data files.");
        this.jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.cacheMenu.add(this.jMenuItem4);
        this.jMenuItem7.setText("Move Cache...");
        this.jMenuItem7.setToolTipText("Move file cache to new location");
        this.jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.cacheMenu.add(this.jMenuItem7);
        this.toolsMenu.add(this.cacheMenu);
        this.toolsMenu.add(this.jSeparator3);
        this.pngWalkMenuItem.setText("PNG Walk Viewer");
        this.pngWalkMenuItem.setToolTipText("Bring up the PNG Walk tool to browse a set of images.");
        this.pngWalkMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.pngWalkMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.pngWalkMenuItem);
        this.createPngWalkMenuItem.setText("Create PNG Walk...");
        this.createPngWalkMenuItem.setToolTipText("Create a series of images, and start the PNG Walk tool to browse the images.");
        this.createPngWalkMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.createPngWalkMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.createPngWalkMenuItem);
        this.toolsMenu.add(this.jSeparator2);
        this.fixLayoutMenuItem.setText("Fix Layout");
        this.fixLayoutMenuItem.setToolTipText("Run new layout routine that removes spaces between plots");
        this.fixLayoutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.fixLayoutMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.fixLayoutMenuItem);
        this.toolsMenu.add(this.createPngWalkSeparator);
        this.aggregateMenuItem.setText("Aggregate...");
        this.aggregateMenuItem.setToolTipText("Combine files into a time series");
        this.aggregateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.aggregateMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.aggregateMenuItem);
        this.toolsMenu.add(this.aggSeparator);
        this.decodeURLItem.setText("Decode URL");
        this.decodeURLItem.setToolTipText("Decode the URL escapes to correct the URL\n");
        this.decodeURLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.decodeURLItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.decodeURLItem);
        this.exceptionReport.setText("Provide Feedback...");
        this.exceptionReport.setToolTipText("Send feedback to application support");
        this.exceptionReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.exceptionReportActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.exceptionReport);
        this.jMenuBar1.add(this.toolsMenu);
        this.helpMenu.setText("Help");
        this.helpMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.helpMenuActionPerformed(evt);
            }
        });
        CSH.setHelpIDString((Component)this.autoplotHelpMenuItem, (String)"aphelp_main");
        this.autoplotHelpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.autoplotHelpMenuItem.setText("Help Contents...");
        this.autoplotHelpMenuItem.setToolTipText("Start up help system");
        this.autoplotHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.autoplotHelpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.autoplotHelpMenuItem);
        this.gettingStartedMenuItem.setText("Getting Started...");
        this.gettingStartedMenuItem.setToolTipText("Bring up the getting started dialog");
        this.gettingStartedMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.gettingStartedMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.gettingStartedMenuItem);
        this.jMenuItem5.setText("Release Notes");
        this.jMenuItem5.setToolTipText("View release notes");
        this.jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.jMenuItem5);
        this.aboutDas2MenuItem.setText("Das2 Homepage");
        this.aboutDas2MenuItem.setToolTipText("Browse the Das2 homepage, which provides graphics and interactivity.");
        this.aboutDas2MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.aboutDas2MenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutDas2MenuItem);
        this.autoplotHomepageButton.setText("Autoplot Homepage");
        this.autoplotHomepageButton.setToolTipText("Browse the Autoplot homepage");
        this.autoplotHomepageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.autoplotHomepageButtonActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.autoplotHomepageButton);
        this.aboutAutoplotMenuItem.setText("About Autoplot");
        this.aboutAutoplotMenuItem.setToolTipText("Show information about this release");
        this.aboutAutoplotMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.aboutAutoplotMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutAutoplotMenuItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.timeRangePanel, -1, 700, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.statusLabel, -2, 16, -2).add(4, 4, 4).add((Component)this.statusTextField, -1, 692, Short.MAX_VALUE))).addContainerGap()).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.tabbedPanelContainer, -1, 724, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.timeRangePanel, -2, 31, -2).addPreferredGap(0, 578, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.statusLabel).add((Component)this.statusTextField, -2, -1, -2))).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(48, 48, 48).add((Component)this.tabbedPanelContainer, -1, 569, Short.MAX_VALUE).add(20, 20, 20))));
        this.bindingGroup.bind();
        this.pack();
    }

    private void copyImageMenuItemActionPerformed(ActionEvent evt) {
        this.support.doCopyDataSetImage();
    }

    private void copyDataSetURLMenuItemActionPerformed(ActionEvent evt) {
        this.support.doCopyDataSetURL();
    }

    private void pasteDataSetURLMenuItemActionPerformed(ActionEvent evt) {
        this.support.doPasteDataSetURL();
    }

    private void dataSetSelectorActionPerformed(ActionEvent evt) {
        String uri = this.dataSetSelector.getValue();
        ((GuiExceptionHandler)this.applicationModel.getExceptionHandler()).setFocusURI(uri);
        if (this.isExpertMode()) {
            if ((evt.getModifiers() & 2) == 2) {
                this.plotAnotherUrl();
            } else if ((evt.getModifiers() & 1) == 1) {
                this.overplotAnotherUrl();
            } else {
                this.plotUrl(uri);
            }
        } else {
            this.dom.getController().reset();
            this.plotUrl(uri);
        }
    }

    private void zoomOutMenuItemActionPerformed(ActionEvent evt) {
        DasPlot p = this.dom.getController().getPlot().getController().getDasPlot();
        DatumRange dr = DatumRangeUtil.rescale(p.getXAxis().getDatumRange(), -0.333, 1.333);
        p.getXAxis().setDatumRange(dr);
    }

    private void zoomInMenuItemActionPerformed(ActionEvent evt) {
        DasPlot p = this.dom.getController().getPlot().getController().getDasPlot();
        DatumRange dr = DatumRangeUtil.rescale(p.getXAxis().getDatumRange(), 0.25, 0.75);
        p.getXAxis().setDatumRange(dr);
    }

    private void resetZoomMenuItemActionPerformed(ActionEvent evt) {
        this.dom.getController().getPlot().getController().resetZoom(true, true, true);
    }

    private void fontsAndColorsMenuItemActionPerformed(ActionEvent evt) {
        if (this.fontAndColorsDialog == null) {
            this.fontAndColorsDialog = new FontAndColorsDialog((Frame)this, false, this.applicationModel);
        }
        this.fontAndColorsDialog.setVisible(true);
    }

    private void specialEffectsMenuItemActionPerformed(ActionEvent evt) {
        this.applicationModel.getDocumentModel().getOptions().setSpecialEffects(this.specialEffectsMenuItem.isSelected());
    }

    private void drawAntiAliasMenuItemActionPerformed(ActionEvent evt) {
        this.applicationModel.getDocumentModel().getOptions().setDrawAntiAlias(this.drawAntiAliasMenuItem.isSelected());
    }

    private void textAntiAliasActionPerformed(ActionEvent evt) {
        this.applicationModel.getDocumentModel().getOptions().setTextAntiAlias(this.textAntiAlias.isSelected());
    }

    private void aboutAutoplotMenuItemActionPerformed(ActionEvent evt) {
        try {
            StringBuilder buffy = new StringBuilder();
            buffy.append("<html>\n");
            URL aboutHtml = AutoplotUI.class.getResource("aboutAutoplot.html");
            if (aboutHtml != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(aboutHtml.openStream()));
                String s = reader.readLine();
                while (s != null) {
                    buffy.append(s);
                    s = reader.readLine();
                }
                reader.close();
            }
            buffy.append("<h2>Build Information:</h2>");
            buffy.append("<ul>");
            buffy.append("<li>release tag: ").append(AboutUtil.getReleaseTag()).append("</li>");
            List<String> bi = Util.getBuildInfos();
            for (String ss : bi) {
                buffy.append("    <li>").append(ss);
            }
            buffy.append("</ul>");
            buffy.append("<h2>Runtime Information:</h2>");
            String javaVersion = System.getProperty("java.version");
            String arch = System.getProperty("os.arch");
            DecimalFormat nf = new DecimalFormat("0.0");
            String mem = nf.format(Runtime.getRuntime().maxMemory() / 0x100000L);
            String tmem = nf.format(Runtime.getRuntime().totalMemory() / 0x100000L);
            String fmem = nf.format(Runtime.getRuntime().freeMemory() / 0x100000L);
            String pwd = new File("foo.txt").getAbsoluteFile().getParent();
            String aboutContent = "<ul><li>Java version: " + javaVersion + "<li>max memory (Mb): " + mem + "<li>total memory (Mb): " + tmem + "<li>free memory (Mb): " + fmem + "<li>arch: " + arch + "<li>pwd: " + pwd + "</ul>";
            buffy.append(aboutContent);
            buffy.append("</html>");
            JLabel label = new JLabel(buffy.toString());
            JScrollPane pane = new JScrollPane(label, 20, 30);
            pane.getVerticalScrollBar().setUnitIncrement(12);
            pane.setPreferredSize(new Dimension(label.getPreferredSize().width + 50, 480));
            JOptionPane.showMessageDialog(this, pane);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void aboutDas2MenuItemActionPerformed(ActionEvent evt) {
        AutoplotUtil.openBrowser("http://das2.org");
    }

    private void autoplotHomepageButtonActionPerformed(ActionEvent evt) {
        AutoplotUtil.openBrowser("http://autoplot.org/");
    }

    private void helpMenuActionPerformed(ActionEvent evt) {
    }

    private void scriptPanelMenuItemActionPerformed(ActionEvent evt) {
        this.applicationModel.getDocumentModel().getOptions().setScriptVisible(this.scriptPanelMenuItem.isSelected());
        if (this.scriptPanelMenuItem.isSelected() && this.scriptPanel == null) {
            this.scriptPanel = new JythonScriptPanel(this.applicationModel, this.dataSetSelector);
            this.tabs.insertTab(TAB_SCRIPT, null, this.scriptPanel, String.format("<html>Editor panel for Jython scripts and data sources.<br>%s</html>", "Right-click or drag to undock."), 4);
        } else {
            JOptionPane.showMessageDialog(this.rootPane, "The feature will be disabled next time the application is run.");
        }
    }

    private void logConsoleMenuItemActionPerformed(ActionEvent evt) {
        this.applicationModel.getDocumentModel().getOptions().setLogConsoleVisible(this.logConsoleMenuItem.isSelected());
        if (this.applicationModel.getDocumentModel().getOptions().isLogConsoleVisible() && this.logConsole == null) {
            this.initLogConsole();
        } else {
            if (this.logConsole != null) {
                this.logConsole.undoLogConsoleMessages();
            }
            JOptionPane.showMessageDialog(this.rootPane, "The feature will be disabled next time the application is run.");
        }
    }

    private void serverCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.applicationModel.getDocumentModel().getOptions().setServerEnabled(this.serverCheckBoxMenuItem.isSelected());
        if (this.applicationModel.getDocumentModel().getOptions().isServerEnabled()) {
            this.initServer();
        } else {
            this.stopServer();
            JOptionPane.showMessageDialog(this.rootPane, "<html>The server will not be stopped completely.<br>https://sourceforge.net/tracker/?func=detail&aid=3441071&group_id=199733&atid=970682");
        }
        this.serverCheckBoxMenuItem.setSelected(this.rlistener != null);
        this.applicationModel.getDocumentModel().getOptions().setServerEnabled(this.rlistener != null);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.applicationModel.increaseFontSize();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.applicationModel.decreaseFontSize();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        JDiskHogPanel panel = new JDiskHogPanel(this);
        panel.scan(new File(AutoplotSettings.settings().resolveProperty("fscache")));
        JDialog dia = new JDialog(this, "Manage Cache", true);
        dia.add(panel);
        dia.pack();
        dia.setVisible(true);
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        this.clearCache();
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        try {
            String release = AboutUtil.getReleaseTag();
            if (release != null) {
                String surl = "http://autoplot.org/Autoplot_Change_Log#" + release;
                AutoplotUtil.openBrowser(surl);
            } else {
                JOptionPane.showMessageDialog(this, "This is an untagged release.");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void editDomMenuItemActionPerformed(ActionEvent evt) {
        PropertyEditor edit = new PropertyEditor(this.applicationModel.dom);
        edit.showDialog(this, "DOM Properties", new ImageIcon(this.getClass().getResource("logoA16x16.png")).getImage());
    }

    private void statusLabelMouseClicked(MouseEvent evt) {
        this.statusLabel.setIcon(null);
        this.statusTextField.setText("");
    }

    private void inspectVapFileMenuItemActionPerformed(ActionEvent evt) {
        this.support.doInspectVap();
    }

    private void autoLayoutCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.autoLayoutCheckBoxMenuItem.isSelected()) {
            this.applicationModel.doAutoLayout();
        }
    }

    private void autoplotHelpMenuItemActionPerformed(ActionEvent evt) {
        this.helpSystem.displayHelpFromEvent(evt);
    }

    private void pngWalkMenuItemActionPerformed(ActionEvent evt) {
        PngWalkTool1.start(null, this);
    }

    private void createPngWalkMenuItemActionPerformed(ActionEvent evt) {
        Runnable run = new Runnable(){

            public void run() {
                try {
                    CreatePngWalk.doIt(AutoplotUI.this.applicationModel.dom, null);
                }
                catch (IOException ex) {
                    AutoplotUI.this.setStatus(ERROR_ICON, "Unable to create PNG Walk: " + ex.getMessage());
                    AutoplotUI.this.applicationModel.showMessage("<html>Unable to create PNG Walk:<br>" + ex.getMessage(), "PNG Walk Error", 2);
                    ex.printStackTrace();
                    return;
                }
                catch (Exception ex) {
                    Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
            }
        };
        RequestProcessor.invokeLater(run);
    }

    private void aggregateMenuItemActionPerformed(ActionEvent evt) {
        AggregateUrisDialog dia = new AggregateUrisDialog(this.dom, this.dataSetSelector);
        JOptionPane.showConfirmDialog(this.rootPane, dia, "Aggregate URIs", 2);
    }

    private void decodeURLItemActionPerformed(ActionEvent evt) {
        String s = this.dataSetSelector.getEditor().getText();
        s = DataSourceUtil.unescape((String)s);
        this.dataSetSelector.getEditor().setText(s);
    }

    private void statusTextFieldMouseClicked(MouseEvent evt) {
        this.statusLabelMouseClicked(evt);
    }

    private void gettingStartedMenuItemActionPerformed(ActionEvent evt) {
        String uri;
        GettingStartedPanel gettingStartedPanel = new GettingStartedPanel();
        int result = JOptionPane.showConfirmDialog(this, gettingStartedPanel, "Getting Started", 2, -1);
        if (result == 0 && (uri = gettingStartedPanel.getInitialUri().trim()).length() > 0) {
            this.plotUri(uri);
        }
    }

    private void exceptionReportActionPerformed(ActionEvent evt) {
        ExceptionHandler eh = this.applicationModel.getExceptionHandler();
        if (eh == null || !(eh instanceof GuiExceptionHandler)) {
            new GuiExceptionHandler().submitRuntimeException(new RuntimeException("user-generated comment"), false);
        } else {
            ((GuiExceptionHandler)eh).submitRuntimeException(new RuntimeException("user-generated comment"), false);
        }
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        String newv;
        MoveCacheDialog dia = new MoveCacheDialog();
        if (JOptionPane.showConfirmDialog(this, dia, "Move Cache", 2) == 0 && !(newv = dia.getNewDir().getText()).equals(AutoplotSettings.settings().getFscache())) {
            Runnable run = new Runnable(){

                public void run() {
                    File fnewv = new File(newv);
                    if (!fnewv.exists() && !fnewv.mkdirs()) {
                        JOptionPane.showMessageDialog(AutoplotUI.this, "Unable to move cache, couldn't create new folder.");
                        return;
                    }
                    AutoplotUI.this.applicationModel.moveCache(fnewv);
                }
            };
            new Thread(run).start();
        }
    }

    private void canvasSizeMenuItemActionPerformed(ActionEvent evt) {
        CanvasSizePanel p = new CanvasSizePanel();
        p.getResizeRadioButton().setSelected(this.dom.getCanvases(0).isFitted());
        p.getHeightTextField().setValue(this.dom.getCanvases(0).getHeight());
        p.getWidthTextField().setValue(this.dom.getCanvases(0).getWidth());
        if (JOptionPane.showConfirmDialog(this, p, "Set Canvas Size", 2) == 0) {
            if (p.getResizeRadioButton().isSelected()) {
                this.dom.getCanvases(0).setFitted(true);
            } else {
                this.dom.getCanvases(0).setWidth((Integer)p.getWidthTextField().getValue());
                this.dom.getCanvases(0).setHeight((Integer)p.getHeightTextField().getValue());
                this.dom.getCanvases(0).setFitted(false);
            }
        }
    }

    private void dataSetSelectorMenuItemActionPerformed(ActionEvent evt) {
        if (this.dataSetSelectorMenuItem.isSelected()) {
            ((CardLayout)this.timeRangePanel.getLayout()).show(this.timeRangePanel, CARD_DATA_SET_SELECTOR);
            this.dom.getOptions().setUseTimeRangeEditor(false);
        }
    }

    private void timeRangeSelectorMenuItemActionPerformed(ActionEvent evt) {
        if (this.timeRangeSelectorMenuItem.isSelected()) {
            ((CardLayout)this.timeRangePanel.getLayout()).show(this.timeRangePanel, CARD_TIME_RANGE_SELECTOR);
            this.dom.getOptions().setUseTimeRangeEditor(true);
        }
    }

    private void EditOptionsActionPerformed(ActionEvent evt) {
        PropertyEditor edit = new PropertyEditor(this.applicationModel.dom.getOptions());
        edit.showDialog(this, "DOM User Options", new ImageIcon(this.getClass().getResource("logoA16x16.png")).getImage());
    }

    private void fixLayoutMenuItemActionPerformed(ActionEvent evt) {
        Runnable run = new Runnable(){

            public void run() {
                DomOps.newCanvasLayout(AutoplotUI.this.dom);
            }
        };
        new Thread(run, "canvas layout").start();
    }

    private void updateFrameTitle() {
        String isoffline;
        String suri = this.applicationModel.getVapFile();
        String title0 = "Autoplot";
        String string = isoffline = FileSystem.settings().isOffline() ? " (offline)" : "";
        if (suri == null) {
            this.setTitle(title0 + isoffline);
        } else {
            boolean dirty;
            URISplit split = URISplit.parse((String)suri);
            boolean bl = dirty = this.undoRedoSupport.getDepth() > 1;
            if (split.path != null && split.file != null) {
                String titleStr = split.file.substring(split.path.length()) + (dirty ? "*" : "");
                this.setTitle(titleStr + " - " + title0 + isoffline);
            } else {
                System.err.println("Unable to get path from: " + suri);
                this.setTitle("??? - " + title0 + isoffline);
            }
        }
    }

    private static void raiseApplicationWindow(Frame frame) {
        System.err.println("bring to front");
        frame.setVisible(true);
        int state = frame.getExtendedState();
        frame.setExtendedState(state &= 0xFFFFFFFE);
        frame.setAlwaysOnTop(true);
        frame.toFront();
        frame.requestFocus();
        frame.setAlwaysOnTop(false);
        System.err.println("done bring to front");
    }

    private static void addSingleInstanceListener(final ArgumentList alm, final AutoplotUI app) {
        SingleInstanceService sis;
        try {
            sis = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
        }
        catch (UnavailableServiceException ex) {
            sis = null;
        }
        if (sis == null) {
            logger.fine("not running with webstart");
            return;
        }
        SingleInstanceListener sisL = new SingleInstanceListener(){

            public void newActivation(String[] argv) {
                String url;
                alm.process(argv);
                boolean raise = false;
                final JFrame frame = (JFrame)ScriptContext.getViewWindow();
                if (frame != null) {
                    AutoplotUI.raiseApplicationWindow(frame);
                }
                if ((url = alm.getValue("URL")) == null) {
                    int action = JOptionPane.showConfirmDialog(ScriptContext.getViewWindow(), "<html>Autoplot is already running.<br>Start another window?", "Reenter Autoplot", 0);
                    if (action == 0) {
                        app.support.newApplication();
                    } else {
                        raise = true;
                    }
                } else {
                    String action = (String)JOptionPane.showInputDialog(ScriptContext.getViewWindow(), String.format("<html>Autoplot is already running.<br>Replace URI, replacing data with<br>%s?", url), "Replace URI", 3, new ImageIcon(this.getClass().getResource("/logo64x64.png")), new String[]{"New Window", "Replace"}, "Replace");
                    if (action.equals("Replace")) {
                        app.applicationModel.setDataSourceURL(url);
                        raise = true;
                    } else if (action.equals("New Window")) {
                        ApplicationModel nmodel = app.support.newApplication();
                        nmodel.setDataSourceURL(url);
                    }
                }
                if (raise && frame != null) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            AutoplotUI.raiseApplicationWindow(frame);
                        }
                    });
                }
            }
        };
        sis.addSingleInstanceListener(sisL);
    }

    public static void main(String[] args) {
        String initialURL;
        final ArgumentList alm = new ArgumentList("AutoplotUI");
        alm.addOptionalPositionArgument(0, "URL", null, "initial URL to load");
        alm.addOptionalSwitchArgument("bookmarks", null, "bookmarks", null, "bookmarks to load");
        alm.addOptionalSwitchArgument("port", "p", "port", "-1", "enable scripting via this port");
        alm.addBooleanSwitchArgument("scriptPanel", "s", "scriptPanel", "enable script panel");
        alm.addBooleanSwitchArgument("logConsole", "l", "logConsole", "enable log console");
        alm.addOptionalSwitchArgument("nativeLAF", "n", "nativeLAF", alm.TRUE, "use the system look and feel (T or F)");
        alm.addOptionalSwitchArgument("open", "o", "open", null, "open this URI (to support javaws)");
        alm.addOptionalSwitchArgument("print", null, "print", "", "print this URI (to support javaws)");
        alm.addOptionalSwitchArgument(TAB_SCRIPT, null, TAB_SCRIPT, "", "run this script after starting.  Arguments following are passed into the script as sys.argv");
        alm.addOptionalSwitchArgument("mode", "m", "mode", "expert", "start in basic (browse,reduced) mode or expert mode");
        alm.addBooleanSwitchArgument("eventThreadMonitor", null, "eventThreadMonitor", "monitor the event thread for long unresponsive pauses");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-print")) {
                args[i] = "--print";
            }
            if (!args[i].equals("-open")) continue;
            args[i] = "--open";
        }
        final ArrayList<String> scriptArgs = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            int j;
            if (args.length <= i || !args[i - 1].equals("--script")) continue;
            ArrayList<String> apArgs = new ArrayList<String>();
            for (j = 0; j <= i; ++j) {
                apArgs.add(args[j]);
            }
            for (j = i; j < args.length; ++j) {
                scriptArgs.add(args[j]);
            }
            args = apArgs.toArray(new String[apArgs.size()]);
            break;
        }
        alm.process(args);
        String welcome = "welcome to autoplot";
        try {
            String tag = AboutUtil.getReleaseTag(APSplash.class);
            if (tag != null) {
                welcome = welcome + " (" + tag + ")";
            }
        }
        catch (IOException ex) {
            Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
        System.err.println(welcome);
        logger.info(welcome);
        final ApplicationModel model = new ApplicationModel();
        if (alm.getValue("URL") != null) {
            initialURL = alm.getValue("URL");
            logger.log(Level.FINE, "setting initial URL to >>>{0}<<<", initialURL);
        } else if (alm.getValue("open") != null) {
            initialURL = alm.getValue("open");
            logger.log(Level.FINE, "setting initial URL to >>>{0}<<<", initialURL);
        } else {
            initialURL = null;
        }
        final String bookmarks = alm.getValue("bookmarks");
        if (alm.getBooleanValue("scriptPanel")) {
            logger.fine("enable scriptPanel");
            model.getDocumentModel().getOptions().setScriptVisible(true);
        }
        if (alm.getBooleanValue("logConsole")) {
            logger.fine("enable scriptPanel");
            model.getDocumentModel().getOptions().setLogConsoleVisible(true);
        }
        if (alm.getBooleanValue("nativeLAF")) {
            logger.fine("nativeLAF");
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.fine("invokeLater()");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                String script;
                boolean server;
                AutoplotUI app;
                logger.fine("enter invokeLater");
                final boolean headless = "true".equals(System.getProperty("java.awt.headless"));
                if (!headless) {
                    logger.addHandler(APSplash.getInstance().getLogHandler());
                    APSplash.showSplash();
                } else {
                    System.err.println("this is autoplot " + APSplash.getVersion());
                }
                APSplash.checkTime("init -100");
                OptionsPrefsController opc = new OptionsPrefsController(model.dom.getOptions());
                opc.loadPreferences();
                APSplash.checkTime("init -90");
                APSplash.showSplash();
                model.addDasPeersToApp();
                APSplash.checkTime("init -80");
                if (!headless) {
                    APSplash.showSplash();
                }
                APSplash.checkTime("init -80");
                if (!headless) {
                    app = new AutoplotUI(model);
                    boolean addSingleInstanceListener = true;
                    if (addSingleInstanceListener) {
                        AutoplotUI.addSingleInstanceListener(alm, app);
                    }
                } else {
                    app = null;
                }
                boolean bl = server = !alm.getValue("port").equals("-1");
                if (server) {
                    int iport = Integer.parseInt(alm.getValue("port"));
                    app.setupServer(iport, model);
                    model.getDocumentModel().getOptions().setServerEnabled(true);
                }
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public void uncaughtException(Thread t, Throwable e) {
                        Logger.getLogger("virbo.autoplot").log(Level.SEVERE, "runtime exception: " + e, e);
                        app.setStatus(ERROR_ICON, "caught exception: " + e.toString());
                        if (e instanceof InconvertibleUnitsException) {
                            return;
                        }
                        model.getExceptionHandler().handleUncaught(e);
                    }
                });
                if (alm.getValue("mode").equals("basic")) {
                    app.setExpertMode(false);
                }
                if (!headless) {
                    logger.fine("UI.setVisible(true)");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            app.applicationModel.canvas.repaint();
                            app.setVisible(true);
                            if (alm.getBooleanValue("eventThreadMonitor")) {
                                new EventThreadResponseMonitor().start();
                            }
                        }
                    });
                    logger.fine("UI is visible");
                    APSplash.hideSplash();
                }
                if (!headless && initialURL != null) {
                    app.dataSetSelector.setValue(initialURL);
                    app.dataSetSelector.maybePlot(false);
                }
                if (bookmarks != null) {
                    Runnable run = new Runnable(){

                        public void run() {
                            try {
                                URL url = new URL(bookmarks);
                                System.err.println("Reading bookmarks from " + url);
                                Document doc = AutoplotUtil.readDoc(url.openStream());
                                Bookmark.parseBookmarks(doc.getDocumentElement());
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                model.getExceptionHandler().handleUncaught(ex);
                            }
                        }
                    };
                    new Thread(run, "LoadBookmarksThread").start();
                }
                if (!(script = alm.getValue(AutoplotUI.TAB_SCRIPT)).equals("")) {
                    if (app != null) {
                        app.setStatus("running script " + script);
                    }
                    Runnable run = new Runnable(){

                        public void run() {
                            try {
                                ScriptContext.setApplicationModel(model);
                                JythonUtil.runScript(model, script, scriptArgs.toArray(new String[scriptArgs.size()]));
                                if (app != null) {
                                    app.setStatus("ready");
                                }
                                if (headless && !server) {
                                    AppManager.getInstance().quit();
                                }
                            }
                            catch (IOException ex) {
                                throw new IllegalArgumentException(ex);
                            }
                        }
                    };
                    new Thread(run, "batchRunScriptThread").start();
                } else if (app != null) {
                    app.setStatus("ready");
                }
            }
        });
    }

    private void setupServer(int port, final ApplicationModel model) {
        this.rlistener = new RequestListener();
        this.rlistener.setPort(port);
        final RequestHandler rhandler = new RequestHandler();
        this.rlistener.addPropertyChangeListener("requestCount", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    if (AutoplotUI.this.rlistener == null) {
                        logger.log(Level.FINE, "the server is no longer listening");
                        return;
                    }
                    Socket socket = AutoplotUI.this.rlistener.getSocket();
                    logger.log(Level.FINE, "connection from {0}", socket);
                    rhandler.handleRequest(socket.getInputStream(), model, socket.getOutputStream());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.rlistener.startListening();
    }

    public void setMessage(String message) {
        this.setMessage(IDLE_ICON, message);
    }

    public void setMessage(Icon icon, String message) {
        String myMess;
        if (message == null) {
            message = "<null>";
        }
        if ((myMess = message).length() > 100) {
            myMess = myMess.substring(0, 100) + "...";
        }
        final String fmyMess = myMess = myMess.replaceAll("\n", "");
        final String fmessage = message;
        final Icon ficon = icon;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AutoplotUI.this.statusLabel.setIcon(ficon);
                AutoplotUI.this.statusTextField.setText(fmyMess);
                AutoplotUI.this.statusTextField.setToolTipText(fmessage);
            }
        });
    }

    private void sleep(int millis) {
        if (millis == 0) {
            return;
        }
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IllegalArgumentException("delay on event thread");
            }
            if (millis == -1) {
                millis = 500;
            }
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void invokeLater(final int delayMillis, final boolean evt, final Runnable run) {
        Runnable sleepRun = new Runnable(){

            public void run() {
                AutoplotUI.this.sleep(delayMillis);
                if (evt) {
                    SwingUtilities.invokeLater(run);
                } else {
                    run.run();
                }
            }
        };
        RequestProcessor.invokeLater(sleepRun);
    }

    private void addTools() {
        RequestProcessor.invokeLater(new Runnable(){

            public void run() {
                AutoplotUI.this.sleep(-1);
                AutoplotUI.this.reloadTools();
            }
        });
    }

    public void reloadTools() {
        List<Bookmark> tools;
        int i;
        int isep = -1;
        for (i = 0; i < this.toolsMenu.getMenuComponentCount(); ++i) {
            Component c = this.toolsMenu.getMenuComponent(i);
            if (!(c instanceof JSeparator) || !"userSep".equals(c.getName())) continue;
            isep = i;
            break;
        }
        if (isep > -1) {
            for (i = this.toolsMenu.getMenuComponentCount() - 1; i > isep; --i) {
                this.toolsMenu.remove(this.toolsMenu.getMenuComponent(i));
            }
        }
        if ((tools = this.loadTools()).size() > 0 && isep == -1) {
            JSeparator userSep = new JSeparator();
            userSep.setName("userSep");
            this.toolsMenu.add(userSep);
            isep = this.toolsMenu.getMenuComponentCount();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Iterator i$ = tools.iterator();
                while (i$.hasNext()) {
                    Bookmark t;
                    final Bookmark tt = t = (Bookmark)i$.next();
                    final String suri = ((Bookmark.Item)tt).getUri();
                    AbstractAction a = new AbstractAction(t.getTitle()){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                if ((e.getModifiers() & 2) != 2) {
                                    JythonUtil.invokeScriptSoon(DataSetURI.getURL((String)suri), AutoplotUI.this.applicationModel.getDocumentModel(), AutoplotUI.this.getStatusBarProgressMonitor("done running script"));
                                } else {
                                    AutoplotUI.this.plotUri("script:" + ((Bookmark.Item)tt).getUri());
                                }
                            }
                            catch (MalformedURLException ex) {
                                Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    };
                    JMenuItem ji = new JMenuItem(a);
                    ji.setToolTipText("<html>" + suri + "<br>press ctrl to inspect");
                    AutoplotUI.this.toolsMenu.add(ji);
                }
            }
        });
    }

    private List<Bookmark> loadTools() {
        ArrayList<Bookmark> tools = new ArrayList<Bookmark>();
        File toolsDir = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "tools");
        if (toolsDir.exists()) {
            File[] ff = toolsDir.listFiles();
            for (int i = 0; i < ff.length; ++i) {
                Bookmark.Item book = new Bookmark.Item(ff[i].toURI().toString());
                String toolLabel = ff[i].getName();
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(ff[i]));
                    String s = reader.readLine();
                    while (s != null && s.startsWith("#")) {
                        if (s.startsWith("# label:")) {
                            toolLabel = s.substring(9).trim();
                        }
                        s = reader.readLine();
                    }
                    reader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                book.setTitle(toolLabel);
                tools.add(book);
            }
        } else if (!toolsDir.mkdirs()) {
            System.err.println("failed to make tools directory");
        }
        return tools;
    }

    public UndoRedoSupport getUndoRedoSupport() {
        return this.undoRedoSupport;
    }

    public DataSetSelector getDataSetSelector() {
        return this.dataSetSelector;
    }

    public void basicMode() {
        this.setExpertMode(false);
    }

    public void setExpertMode(boolean expert) {
        this.autoMenu.setVisible(expert);
        for (JComponent mi : this.expertMenuItems) {
            mi.setVisible(expert);
        }
        this.expertMenu.setText(expert ? "Expert" : "Basic");
        this.dataSetSelector.getEditor().setEditable(expert);
        this.dataSetSelector.getEditor().setEnabled(expert);
        if (this.dataPanel != null) {
            this.dataPanel.setExpertMode(expert);
        }
        for (Plot p : this.dom.getPlots()) {
            p.getController().setExpertMode(expert);
        }
        if (this.scriptPanel != null) {
            if (expert) {
                this.tabs.add(TAB_SCRIPT, this.scriptPanel);
            } else {
                this.tabs.remove(this.scriptPanel);
            }
        }
        if (this.logConsole != null) {
            if (expert) {
                this.tabs.add("console", this.logConsole);
            } else {
                this.tabs.remove(this.logConsole);
            }
        }
        if (this.layoutPanel1 != null) {
            if (expert) {
                this.tabs.add("layout", this.layoutPanel1);
            } else {
                this.tabs.remove(this.layoutPanel1);
            }
        }
        this.dataSetSelector.setExpertMode(expert);
    }

    public boolean isExpertMode() {
        return this.expertMenuItems.get(0).isVisible();
    }

    public boolean isBasicMode() {
        return !this.expertMenuItems.get(0).isVisible();
    }
}

