/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import javax.swing.SwingUtilities;

public final class EventThreadResponseMonitor {
    long lastPost;
    long response;
    String pending;
    int testFrequency = 300;
    int warnLevel = 500;

    public void start() {
        new Thread(this.createRunnable(), "eventThreadResponseMonitor").start();
    }

    public static synchronized String dumpPendingEvents() {
        StringBuilder buf = new StringBuilder();
        LinkedList<AWTEvent> queue = new LinkedList<AWTEvent>();
        EventQueue instance = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (instance.peekEvent() != null) {
            buf.append("---------------------------------------------------------------\n");
        }
        while (instance.peekEvent() != null) {
            AWTEvent evt;
            try {
                evt = instance.getNextEvent();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            buf.append("[ ").append(evt.getSource()).append("->").append(evt).append("]\n");
            queue.add(evt);
        }
        if (instance.peekEvent() != null) {
            buf.append("-----e--n--d-----------------------------------------------------");
        }
        while (queue.size() > 0) {
            instance.postEvent((AWTEvent)queue.remove());
        }
        return buf.toString();
    }

    Runnable createRunnable() {
        this.lastPost = System.currentTimeMillis();
        return new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            long nextPost = EventThreadResponseMonitor.this.lastPost + (long)EventThreadResponseMonitor.this.testFrequency;
                            long sleep = nextPost - System.currentTimeMillis();
                            while (sleep > 0L) {
                                Thread.sleep(sleep);
                                sleep = nextPost - System.currentTimeMillis();
                            }
                            EventThreadResponseMonitor.this.lastPost = System.currentTimeMillis();
                            SwingUtilities.invokeAndWait(EventThreadResponseMonitor.this.responseRunnable());
                        }
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        continue;
                    }
                    break;
                }
            }
        };
    }

    Runnable responseRunnable() {
        return new Runnable(){

            public void run() {
                EventThreadResponseMonitor.this.response = System.currentTimeMillis();
                long levelms = EventThreadResponseMonitor.this.response - EventThreadResponseMonitor.this.lastPost;
                if (levelms > (long)EventThreadResponseMonitor.this.warnLevel) {
                    System.err.printf("CURRENT EVENT QUEUE CLEAR TIME: %5.3f sec\n", (double)levelms / 1000.0);
                    if (EventThreadResponseMonitor.this.pending != null) {
                        System.err.printf("events pending:\n", new Object[0]);
                        System.err.printf(EventThreadResponseMonitor.this.pending, new Object[0]);
                    }
                }
            }
        };
    }

    public static void main(String[] args) {
        new EventThreadResponseMonitor().start();
    }
}

