/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.virbo.ascii.AsciiTableDataSourceFormatEditorPanel;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.DataSourceController;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceFormat;
import org.virbo.datasource.DataSourceFormatEditorPanel;
import org.virbo.datasource.DataSourceRegistry;
import org.virbo.datasource.URISplit;

public class ExportDataPanel
extends JPanel {
    DataSourceFormatEditorPanel editorPanel = null;
    private JButton additionalOptionsButton;
    private ButtonGroup buttonGroup1;
    private JButton chooseFileB;
    private JTextField filenameTF;
    private JComboBox formatDL;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JRadioButton originalDataB;
    private JRadioButton processedDataB;
    private JRadioButton processedWithinXRangeB;
    private JLabel warningMessageLabel;

    public ExportDataPanel() {
        this.initComponents();
    }

    public void setDataSet(Application model) {
        QDataSet processedDataSet;
        DataSourceController dsc = model.getController().getDataSourceFilter().getController();
        if (dsc.getFillDataSet() != null) {
            String name = (String)dsc.getFillDataSet().property("NAME");
            if (name != null) {
                this.filenameTF.setText(name.toLowerCase());
            }
            this.originalDataB.setToolTipText(String.format("<html>%s<br>%s</html>", this.originalDataB.getToolTipText(), dsc.getFillDataSet()));
        }
        if ((processedDataSet = model.getController().getPlotElement().getController().getDataSet()) != null) {
            if (!processedDataSet.equals(dsc.getFillDataSet())) {
                this.processedDataB.setToolTipText(String.format("<html>%s<br>%s</html>", this.processedDataB.getToolTipText(), processedDataSet));
            } else {
                this.processedDataB.setToolTipText(String.format("<html>%s</html>", "No processing is done to the dataset before plotting"));
                this.processedDataB.setEnabled(false);
            }
        } else {
            this.processedDataB.setEnabled(false);
        }
    }

    public boolean isFormatPlotElement() {
        return this.processedDataB.isSelected();
    }

    public boolean isFormatPlotElementAndTrim() {
        return this.processedWithinXRangeB.isSelected();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel2 = new JLabel();
        this.processedDataB = new JRadioButton();
        this.originalDataB = new JRadioButton();
        this.formatDL = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.filenameTF = new JTextField();
        this.chooseFileB = new JButton();
        this.additionalOptionsButton = new JButton();
        this.warningMessageLabel = new JLabel();
        this.processedWithinXRangeB = new JRadioButton();
        this.jLabel2.setText("Select Output Format:");
        this.buttonGroup1.add(this.processedDataB);
        this.processedDataB.setText("Processed Data or Component");
        this.processedDataB.setToolTipText("Data as displayed, including slice and other operations.  This is the loaded data, and may extend past plot boundaries.\n");
        this.buttonGroup1.add(this.originalDataB);
        this.originalDataB.setSelected(true);
        this.originalDataB.setText("Original Data");
        this.originalDataB.setToolTipText("Data read in from data source");
        this.formatDL.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.formatDL.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ExportDataPanel.this.formatDLItemStateChanged(evt);
            }
        });
        this.formatDL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.formatDLActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Select Data to Export:");
        this.jLabel3.setText("Filename:");
        this.filenameTF.setText("data");
        this.chooseFileB.setText("Select...");
        this.chooseFileB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.chooseFileBActionPerformed(evt);
            }
        });
        this.additionalOptionsButton.setText("Additional options for output format...");
        this.additionalOptionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.additionalOptionsButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.processedWithinXRangeB);
        this.processedWithinXRangeB.setText("Processed Data within X Axis Range");
        this.processedWithinXRangeB.setToolTipText("Processed data, but also trim to the data to the X axis bounds.\n");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.originalDataB)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.processedDataB))).add(22, 22, 22)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.processedWithinXRangeB).addContainerGap(351, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jLabel3).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.additionalOptionsButton).addPreferredGap(0, 274, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.formatDL, 0, -1, Short.MAX_VALUE)).add((Component)this.jLabel2).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.filenameTF, -2, 508, -2))).addPreferredGap(0).add((Component)this.chooseFileB).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.warningMessageLabel, -1, 602, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.originalDataB).addPreferredGap(0).add((Component)this.processedDataB).addPreferredGap(0).add((Component)this.processedWithinXRangeB).addPreferredGap(0).add((Component)this.warningMessageLabel, -2, 23, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.formatDL, -2, -1, -2).addPreferredGap(1).add((Component)this.jLabel3).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.filenameTF, -2, -1, -2).add((Component)this.chooseFileB)).addPreferredGap(0).add((Component)this.additionalOptionsButton).addContainerGap(94, Short.MAX_VALUE)));
    }

    private void chooseFileBActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        List exts = DataSourceRegistry.getInstance().getFormatterExtensions();
        FileFilter deflt = null;
        Iterator i$ = exts.iterator();
        while (i$.hasNext()) {
            String ext;
            final String ex = ext = (String)i$.next();
            FileFilter ff = new FileFilter(){

                public boolean accept(File f) {
                    if (f.toString() == null) {
                        return false;
                    }
                    return f.toString().endsWith(ex) || f.isDirectory();
                }

                public String getDescription() {
                    return "*" + ex;
                }
            };
            if (ext.equals(".qds")) {
                deflt = ff;
            }
            chooser.addChoosableFileFilter(ff);
        }
        chooser.setFileFilter(deflt);
        int r = chooser.showSaveDialog(this);
        if (r == 0) {
            DataSourceFormat format;
            String s = chooser.getSelectedFile().toString();
            String ext = DataSetURI.getExt((String)s);
            if (ext == null) {
                ext = "";
            }
            if ((format = DataSourceRegistry.getInstance().getFormatByExt(ext)) == null) {
                if (chooser.getFileFilter().getDescription().startsWith("*.")) {
                    ext = chooser.getFileFilter().getDescription().substring(1);
                    format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                    if (format == null) {
                        JOptionPane.showMessageDialog(this, "No formatter for extension: " + ext);
                        return;
                    }
                    s = s + ext;
                } else {
                    JOptionPane.showMessageDialog(this, "No formatter for extension: " + ext);
                    return;
                }
            }
            this.filenameTF.setText(s);
            this.formatDL.setSelectedItem("." + ext);
        }
    }

    private void formatDLActionPerformed(ActionEvent evt) {
        String ff = this.filenameTF.getText();
        if (!ff.endsWith((String)this.formatDL.getSelectedItem())) {
            int ii;
            int ii2 = ff.lastIndexOf("/");
            if (ii2 == -1) {
                ii2 = 0;
            }
            if ((ii = ff.lastIndexOf(".")) > -1 && ii > ii2) {
                this.filenameTF.setText(ff.substring(0, ii) + this.formatDL.getSelectedItem());
            }
        }
    }

    private void formatDLItemStateChanged(ItemEvent evt) {
        String ss = (String)evt.getItem();
        if (ss.equals(".txt") || ss.equals(".dat")) {
            this.editorPanel = new AsciiTableDataSourceFormatEditorPanel();
            String t = this.getFilenameTF().getText();
            if (t.contains("/")) {
                this.editorPanel.setURI(this.getFilenameTF().getText());
            }
        } else if (ss.equals(".csv")) {
            this.editorPanel = null;
        } else {
            Object oeditorPanel = DataSourceRegistry.getInstance().getDataSourceFormatEditorByExt(ss);
            if (oeditorPanel != null) {
                String t;
                if (oeditorPanel instanceof String) {
                    this.editorPanel = (DataSourceFormatEditorPanel)DataSourceRegistry.getInstanceFromClassName((String)((String)oeditorPanel));
                    if (this.editorPanel == null) {
                        throw new IllegalArgumentException("unable to create instance: " + oeditorPanel);
                    }
                } else {
                    this.editorPanel = (DataSourceFormatEditorPanel)oeditorPanel;
                }
                if ((t = this.getFilenameTF().getText()).contains("/")) {
                    this.editorPanel.setURI(this.getFilenameTF().getText());
                }
            } else {
                this.editorPanel = null;
            }
        }
        this.additionalOptionsButton.setEnabled(this.editorPanel != null);
    }

    private void additionalOptionsButtonActionPerformed(ActionEvent evt) {
        JPanel j = this.editorPanel.getPanel();
        JOptionPane.showConfirmDialog(this, j, "Additional Options", 2);
    }

    public JTextField getFilenameTF() {
        return this.filenameTF;
    }

    public JComboBox getFormatDL() {
        return this.formatDL;
    }

    public DataSourceFormatEditorPanel getDataSourceFormatEditorPanel() {
        return this.editorPanel;
    }

    void setFile(String currentFileString) {
        URISplit split = URISplit.parse((String)currentFileString);
        this.filenameTF.setText(split.file);
        this.formatDLActionPerformed(null);
        if (this.editorPanel != null) {
            this.editorPanel.setURI(currentFileString);
        }
    }

    void setTsb(boolean b) {
        if (b) {
            this.warningMessageLabel.setText("Exporting data at native resolution.");
            this.warningMessageLabel.setToolTipText("<html>This data comes from a reader that can return data at multiple resolutions.  Data will be reread at native resolution before writing output.</html>");
        }
    }
}

