/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import external.PlotCommand;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.system.RequestProcessor;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.InteractiveInterpreter;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.AutoplotUI;
import org.virbo.autoplot.dom.Application;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceUtil;

public class JythonUtil {
    public static InteractiveInterpreter createInterpreter(boolean appContext, boolean sandbox) throws IOException {
        InteractiveInterpreter interp = org.virbo.jythonsupport.JythonUtil.createInterpreter((boolean)sandbox);
        if (appContext) {
            interp.execfile(JythonUtil.class.getResource("appContextImports.py").openStream(), "appContextImports.py");
        }
        interp.set("monitor", (Object)new NullProgressMonitor());
        interp.set("plotx", (PyObject)new PlotCommand());
        return interp;
    }

    public static InteractiveInterpreter createInterpreter(boolean appContext, boolean sandbox, Application dom, ProgressMonitor mon) throws IOException {
        InteractiveInterpreter interp = JythonUtil.createInterpreter(appContext, sandbox);
        if (dom != null) {
            interp.set("dom", (Object)dom);
        }
        if (mon != null) {
            interp.set("monitor", (Object)mon);
        } else {
            interp.set("monitor", (Object)new NullProgressMonitor());
        }
        interp.set("plotx", (PyObject)new PlotCommand());
        return interp;
    }

    protected static void runScript(ApplicationModel model, String script, String[] argv) throws IOException {
        if (argv == null) {
            argv = new String[]{""};
        }
        PySystemState.initialize((Properties)PySystemState.getBaseProperties(), null, (String[])argv);
        InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, model.getDocumentModel(), new NullProgressMonitor());
        System.err.println();
        interp.exec("params=dict()");
        int iargv = -1;
        for (String s : argv) {
            int ieq = s.indexOf("=");
            if (ieq > 0) {
                String snam = s.substring(0, ieq).trim();
                if (DataSourceUtil.isJavaIdentifier((String)snam)) {
                    String sval = s.substring(ieq + 1).trim();
                    interp.exec("params['" + snam + "']='" + sval + "'");
                    continue;
                }
                if (snam.startsWith("-")) {
                    System.err.println("script arguments should not start with -, they should be name=value");
                }
                System.err.println("bad parameter: " + snam);
                continue;
            }
            if (iargv >= 0) {
                interp.exec("params['arg_" + iargv + "']='" + s + "'");
                ++iargv;
                continue;
            }
            ++iargv;
        }
        URL url = DataSetURI.getURL((String)script);
        InputStream in = url.openStream();
        interp.execfile(in);
        in.close();
    }

    public static void invokeScriptSoon(URL url) {
        JythonUtil.invokeScriptSoon(url, null, new NullProgressMonitor());
    }

    public static void invokeScriptSoon(final URL url, final Application dom, ProgressMonitor mon1) {
        final ProgressMonitor mon = mon1 == null ? new NullProgressMonitor() : mon1;
        Runnable run = new Runnable(){

            public void run() {
                try {
                    InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, dom, mon);
                    System.err.println("invokeScriptSoon(" + url + ")");
                    interp.execfile(url.openStream(), url.toString());
                    mon.finished();
                }
                catch (IOException ex) {
                    Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        RequestProcessor.invokeLater(run);
    }
}

