/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.graph.DasPlot;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.AddPlotsDialog;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.BindToHiddenDialog;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.Column;
import org.virbo.autoplot.dom.DomOps;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.PlotElementStyle;
import org.virbo.autoplot.dom.Row;
import org.virbo.autoplot.layout.LayoutConstants;
import org.virbo.autoplot.util.CanvasLayoutPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutPanel
extends JPanel {
    Map<Component, JPopupMenu> contextMenus = null;
    Action removeBindingsAction = new AbstractAction("Remove Bindings"){

        public void actionPerformed(ActionEvent e) {
            Plot domPlot = LayoutPanel.this.app.getController().getPlot();
            List<PlotElement> elements = LayoutPanel.this.app.getController().getPlotElementsFor(domPlot);
            for (PlotElement element : elements) {
                LayoutPanel.this.app.getController().unbind(element);
            }
            LayoutPanel.this.app.getController().unbind(domPlot);
        }
    };
    Action deletePlotAction = new AbstractAction("Delete Plot"){

        public void actionPerformed(ActionEvent e) {
            List<Object> os = LayoutPanel.this.canvasLayoutPanel1.getSelectedComponents();
            for (Object o : os) {
                if (LayoutPanel.this.app.getPlots().length > 1) {
                    Plot domPlot = null;
                    if (o instanceof Component) {
                        domPlot = LayoutPanel.this.app.getController().getPlotFor((Component)o);
                    }
                    if (domPlot == null) continue;
                    List<PlotElement> plotElements = LayoutPanel.this.app.getController().getPlotElementsFor(domPlot);
                    for (PlotElement pan : plotElements) {
                        if (LayoutPanel.this.app.getPlotElements().length > 1) {
                            LayoutPanel.this.app.getController().deletePlotElement(pan);
                            continue;
                        }
                        LayoutPanel.this.app.getController().setStatus("warning: the last panel may not be deleted");
                    }
                    LayoutPanel.this.app.getController().deletePlot(domPlot);
                    continue;
                }
                LayoutPanel.this.app.getController().setStatus("warning: last plot may not be deleted");
            }
        }
    };
    Action addPlotsAction = new AbstractAction("Add Plots..."){

        public void actionPerformed(ActionEvent e) {
            AddPlotsDialog dia = new AddPlotsDialog();
            dia.getNumberOfColumnsSpinner().setModel(new SpinnerNumberModel(1, 1, 5, 1));
            dia.getNumberOfRowsSpinner().setModel(new SpinnerNumberModel(1, 1, 5, 1));
            if (0 == JOptionPane.showConfirmDialog(LayoutPanel.this.panelListComponent, dia, "Add Plots", 2, -1, new ImageIcon(AutoplotUtil.getAutoplotIcon()))) {
                int nr = (Integer)dia.getNumberOfRowsSpinner().getValue();
                int nc = (Integer)dia.getNumberOfColumnsSpinner().getValue();
                if (nr > 5 || nc > 5) {
                    JOptionPane.showMessageDialog(LayoutPanel.this, "No more than 5 rows or columns can be added at once.");
                } else {
                    LayoutPanel.this.app.getController().addPlots(nr, nc, dia.isAbove() ? LayoutConstants.ABOVE : LayoutConstants.BELOW);
                }
            }
        }
    };
    transient ListSelectionListener plotElementSelectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent e) {
            if (LayoutPanel.this.panelListComponent.getValueIsAdjusting()) {
                return;
            }
            if (LayoutPanel.this.panelListComponent.getSelectedValues().length == 1 && !LayoutPanel.this.app.getController().isValueAdjusting()) {
                PlotElement p = (PlotElement)LayoutPanel.this.panelListComponent.getSelectedValue();
                Plot plot = LayoutPanel.this.app.getController().getPlotFor(p);
                LayoutPanel.this.app.getController().setPlot(plot);
                LayoutPanel.this.app.getController().setPlotElement(p);
            }
        }
    };
    Application app;
    transient PropertyChangeListener plotElementsListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.updatePlotElementList();
        }
    };
    transient PropertyChangeListener bindingsListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.updateBindingList();
        }
    };
    private transient PropertyChangeListener plotListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            Plot plot = LayoutPanel.this.app.getController().getPlot();
            if (plot == null) {
                return;
            }
            List<PlotElement> p = LayoutPanel.this.app.getController().getPlotElementsFor(plot);
            List<PlotElement> allElements = Arrays.asList(LayoutPanel.this.app.getPlotElements());
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i = 0; i < p.size(); ++i) {
                if (!p.get(i).isActive()) continue;
                indices.add(allElements.indexOf(p.get(i)));
            }
            int[] iindices = new int[indices.size()];
            for (int i = 0; i < indices.size(); ++i) {
                iindices[i] = (Integer)indices.get(i);
            }
            LayoutPanel.this.panelListComponent.setSelectedIndices(iindices);
            DasPlot dasPlot = LayoutPanel.this.app.getController().getPlot().getController().getDasPlot();
            LayoutPanel.this.canvasLayoutPanel1.setSelectedComponents(Collections.singletonList(dasPlot));
            LayoutPanel.this.canvasLayoutPanel1.setComponent(dasPlot);
        }
    };
    private transient PropertyChangeListener panelListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            PlotElement p = LayoutPanel.this.app.getController().getPlotElement();
            List<PlotElement> allElements = Arrays.asList(LayoutPanel.this.app.getPlotElements());
            LayoutPanel.this.panelListComponent.setSelectedIndex(allElements.indexOf(p));
        }
    };
    private JMenuItem addHiddenMenuItem;
    private JMenuItem addPlotsBelowMenuItem;
    private JPopupMenu bindingActionsMenu;
    private JList bindingListComponent;
    private CanvasLayoutPanel canvasLayoutPanel1;
    private JMenuItem deleteBindingsMenuItem;
    private JMenuItem deleteMenuItem;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList panelListComponent;
    private JPopupMenu plotActionsMenu;
    private JMenu plotMenu;
    private JMenu plotsMenu;
    private JMenuItem propertiesMenuItem;
    private JMenuItem removeBindingsMenuItem;
    private JMenuItem swapMenuItem;

    public LayoutPanel() {
        this.initComponents();
        this.canvasLayoutPanel1.addPropertyChangeListener("component", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Plot plot = LayoutPanel.this.app.getController().getPlotFor((Component)LayoutPanel.this.canvasLayoutPanel1.getComponent());
                if (plot != null) {
                    LayoutPanel.this.app.getController().setPlot(plot);
                }
            }
        });
        this.panelListComponent.addListSelectionListener(this.plotElementSelectionListener);
        this.createPopupMenus();
        MouseListener popupTrigger = this.createPopupTrigger();
        this.canvasLayoutPanel1.addMouseListener(popupTrigger);
        this.panelListComponent.addMouseListener(popupTrigger);
        this.bindingListComponent.addMouseListener(popupTrigger);
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this, "layoutPanel");
    }

    private MouseListener createPopupTrigger() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JPopupMenu menu;
                if (e.isPopupTrigger() && (menu = LayoutPanel.this.contextMenus.get(e.getComponent())) != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                JPopupMenu menu;
                if (e.isPopupTrigger() && (menu = LayoutPanel.this.contextMenus.get(e.getComponent())) != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
    }

    private synchronized void createPopupMenus() {
        this.contextMenus = new HashMap<Component, JPopupMenu>();
        this.contextMenus.put(this.canvasLayoutPanel1, this.plotActionsMenu);
        JPopupMenu panelContextMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem(new AbstractAction("Edit Plot Element Properties"){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor edit;
                Object[] os = LayoutPanel.this.panelListComponent.getSelectedValues();
                PlotElement p = (PlotElement)LayoutPanel.this.panelListComponent.getSelectedValue();
                if (os.length == 0) {
                    return;
                }
                if (os.length == 1) {
                    edit = new PropertyEditor(p);
                } else {
                    Object[] peers = new PlotElement[os.length];
                    for (int i = 0; i < os.length; ++i) {
                        peers[i] = (PlotElement)os[i];
                    }
                    edit = PropertyEditor.createPeersEditor(p, peers);
                }
                edit.showDialog(LayoutPanel.this);
            }
        });
        item.setToolTipText("edit the plot element or elements");
        panelContextMenu.add(item);
        item = new JMenuItem(new AbstractAction("Edit Plot Element Style Properties"){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor edit;
                Object[] os = LayoutPanel.this.panelListComponent.getSelectedValues();
                PlotElement p = (PlotElement)LayoutPanel.this.panelListComponent.getSelectedValue();
                if (os.length == 0) {
                    return;
                }
                if (os.length == 1) {
                    edit = new PropertyEditor(p.getStyle());
                } else {
                    Object[] peers = new PlotElementStyle[os.length];
                    for (int i = 0; i < os.length; ++i) {
                        peers[i] = ((PlotElement)os[i]).getStyle();
                    }
                    edit = PropertyEditor.createPeersEditor(p.getStyle(), peers);
                }
                edit.showDialog(LayoutPanel.this);
            }
        });
        item.setToolTipText("edit the style of plot element or elements");
        panelContextMenu.add(item);
        item = new JMenuItem(new AbstractAction("Delete Plot Element"){

            public void actionPerformed(ActionEvent e) {
                Object[] os;
                for (Object o : os = LayoutPanel.this.panelListComponent.getSelectedValues()) {
                    PlotElement element = (PlotElement)o;
                    LayoutPanel.this.app.getController().deletePlotElement(element);
                }
            }
        });
        panelContextMenu.add(item);
        this.contextMenus.put(this.panelListComponent, panelContextMenu);
        this.contextMenus.put(this.bindingListComponent, this.bindingActionsMenu);
    }

    public void setApplication(Application app) {
        this.app = app;
        this.updatePlotElementList();
        this.updateBindingList();
        this.canvasLayoutPanel1.setContainer(app.getController().getDasCanvas());
        this.canvasLayoutPanel1.addComponentType(DasPlot.class, Color.BLUE);
        app.getController().bind(app.getOptions(), "background", this.canvasLayoutPanel1, "background");
        app.addPropertyChangeListener("plotElements", this.plotElementsListener);
        app.addPropertyChangeListener("bindings", this.bindingsListener);
        app.getController().addPropertyChangeListener("plot", this.plotListener);
        app.getController().addPropertyChangeListener("plotElement", this.panelListener);
    }

    private void updatePlotElementList() {
        AbstractListModel elementsList = new AbstractListModel(){
            Object[] foo;
            {
                this.foo = LayoutPanel.this.app.getPlotElements();
            }

            public int getSize() {
                return this.foo.length;
            }

            public Object getElementAt(int index) {
                return this.foo[index];
            }
        };
        this.panelListComponent.setModel(elementsList);
        this.panelListComponent.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                PlotElement val = (PlotElement)value;
                if (val != null && val.getController() != null && val.getController().getRenderer() != null) {
                    Icon icon = val.getController().getRenderer().getListIcon();
                    label.setIcon(icon);
                    val.getController().getRenderer().addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            LayoutPanel.this.panelListComponent.repaint();
                        }
                    });
                }
                return label;
            }
        });
    }

    private void updateBindingList() {
        AbstractListModel elementsList = new AbstractListModel(){
            Object[] foo;
            {
                this.foo = LayoutPanel.this.app.getBindings();
            }

            public int getSize() {
                return this.foo.length;
            }

            public Object getElementAt(int index) {
                return this.foo[index];
            }
        };
        this.bindingListComponent.setModel(elementsList);
    }

    private List<Plot> getSelectedPlots() {
        Plot domPlot;
        List<Object> os = this.canvasLayoutPanel1.getSelectedComponents();
        ArrayList<Plot> result = new ArrayList<Plot>();
        for (Object o : os) {
            if (this.app.getPlots().length <= 1) continue;
            Plot domPlot2 = null;
            if (o instanceof Component) {
                domPlot2 = this.app.getController().getPlotFor((Component)o);
            }
            if (domPlot2 == null) continue;
            result.add(domPlot2);
        }
        Object o = this.canvasLayoutPanel1.getComponent();
        if (o instanceof Component && (domPlot = this.app.getController().getPlotFor((Component)o)) != null) {
            result.remove(domPlot);
            result.add(0, domPlot);
        }
        return result;
    }

    private void initComponents() {
        this.plotActionsMenu = new JPopupMenu();
        this.plotMenu = new JMenu();
        this.propertiesMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem(this.deletePlotAction);
        this.addPlotsBelowMenuItem = new JMenuItem(this.addPlotsAction);
        this.removeBindingsMenuItem = new JMenuItem(this.removeBindingsAction);
        this.plotsMenu = new JMenu();
        this.swapMenuItem = new JMenuItem();
        this.addHiddenMenuItem = new JMenuItem();
        this.bindingActionsMenu = new JPopupMenu();
        this.deleteBindingsMenuItem = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.canvasLayoutPanel1 = new CanvasLayoutPanel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.panelListComponent = new JList();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.bindingListComponent = new JList();
        this.plotMenu.setText("Plot");
        this.propertiesMenuItem.setText("Properties...");
        this.propertiesMenuItem.setToolTipText("edit plot properties");
        this.propertiesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.propertiesMenuItemActionPerformed(evt);
            }
        });
        this.plotMenu.add(this.propertiesMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.plotMenu.add(this.deleteMenuItem);
        this.addPlotsBelowMenuItem.setText("Add Plots...");
        this.addPlotsBelowMenuItem.setToolTipText("Add a grid of plots below or above the selected plot");
        this.addPlotsBelowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.addPlotsBelowMenuItemActionPerformed(evt);
            }
        });
        this.plotMenu.add(this.addPlotsBelowMenuItem);
        this.removeBindingsMenuItem.setText("Remove Bindings");
        this.removeBindingsMenuItem.setToolTipText("Remove bindings to other parts of the application");
        this.plotMenu.add(this.removeBindingsMenuItem);
        this.plotActionsMenu.add(this.plotMenu);
        this.plotsMenu.setText("Canvas");
        this.swapMenuItem.setText("Swap Position");
        this.swapMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.swapMenuItemActionPerformed(evt);
            }
        });
        this.plotsMenu.add(this.swapMenuItem);
        this.addHiddenMenuItem.setText("Add Hidden Plot...");
        this.addHiddenMenuItem.setToolTipText("Add hidden plot for this plot/plots to bind plots together.\n");
        this.addHiddenMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.addHiddenMenuItemActionPerformed(evt);
            }
        });
        this.plotsMenu.add(this.addHiddenMenuItem);
        this.plotActionsMenu.add(this.plotsMenu);
        this.bindingActionsMenu.setToolTipText("Binding actions");
        this.deleteBindingsMenuItem.setText("Delete Selected Bindings");
        this.deleteBindingsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.deleteBindingsMenuItemActionPerformed(evt);
            }
        });
        this.bindingActionsMenu.add(this.deleteBindingsMenuItem);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Plots [?]"));
        this.jPanel1.setToolTipText("Layout of plots on the canvas");
        this.canvasLayoutPanel1.setText("canvasLayoutPanel1");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.canvasLayoutPanel1, -1, 296, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (Component)this.canvasLayoutPanel1, -1, 133, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Plot Elements [?]"));
        this.jPanel2.setToolTipText("List of plot elements (renderings of data) on the canvas");
        this.panelListComponent.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.panelListComponent);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 320, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 264, Short.MAX_VALUE));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Bindings [?]"));
        this.jPanel3.setToolTipText("List of connections between DOM properties");
        this.bindingListComponent.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.bindingListComponent);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 296, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 98, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE)).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE));
    }

    private void propertiesMenuItemActionPerformed(ActionEvent evt) {
        DasPlot component = (DasPlot)this.canvasLayoutPanel1.getComponent();
        Plot domPlot = this.app.getController().getPlotFor(component);
        if (domPlot == null) {
            this.app.getController().setStatus("warning: nothing selected");
            return;
        }
        List<Object> components = this.canvasLayoutPanel1.getSelectedComponents();
        Object[] plots = new Plot[components.size()];
        for (int i = 0; i < components.size(); ++i) {
            plots[i] = this.app.getController().getPlotFor((Component)components.get(i));
        }
        if (components.size() > 1) {
            PropertyEditor edit = PropertyEditor.createPeersEditor(domPlot, plots);
            edit.showDialog(this);
        } else {
            PropertyEditor edit = new PropertyEditor(domPlot);
            edit.showDialog(this);
        }
    }

    private void swapMenuItemActionPerformed(ActionEvent evt) {
        List<Plot> plots = this.getSelectedPlots();
        if (plots.size() == 2) {
            DomOps.swapPosition(plots.get(0), plots.get(1));
            this.app.getController().setStatus("swapped " + plots.get(0) + " and " + plots.get(1));
        } else {
            this.app.getController().setStatus("warning: select two plots");
        }
    }

    private void addPlotsBelowMenuItemActionPerformed(ActionEvent evt) {
    }

    private void addHiddenMenuItemActionPerformed(ActionEvent evt) {
        BindToHiddenDialog dia = new BindToHiddenDialog();
        int op = JOptionPane.showConfirmDialog(this, dia, "Add hidden plot for binding", 2, -1);
        if (op == 0) {
            DatumRange range;
            String lock = "Add hidden plot";
            List<Plot> plots = this.getSelectedPlots();
            if (plots.size() == 0) {
                return;
            }
            this.app.getController().registerPendingChange(this, "Add hidden plot");
            this.app.getController().performingChange(this, "Add hidden plot");
            Column col = DomOps.getOrCreateSelectedColumn(this.app, this.getSelectedPlots(), true);
            Row row = DomOps.getOrCreateSelectedRow(this.app, this.getSelectedPlots(), true);
            Plot p = this.app.getController().addPlot(row, col);
            p.setVisible(false);
            p.getXaxis().setVisible(false);
            p.getYaxis().setVisible(false);
            Plot[] bottomTopPlots = DomOps.bottomAndTopMostPlot(this.app, plots);
            if (dia.getCondenseColorBarsCB().isSelected()) {
                p.getZaxis().setVisible(true);
                for (Plot p1 : plots) {
                    p1.getZaxis().setVisible(false);
                }
                p.getZaxis().setVisible(true);
            } else {
                p.getZaxis().setVisible(false);
            }
            if (dia.getxAxisCB().isSelected()) {
                range = this.getSelectedPlots().get(0).getXaxis().getRange();
                boolean log = this.getSelectedPlots().get(0).getXaxis().isLog();
                for (Plot p1 : this.getSelectedPlots()) {
                    range = DatumRangeUtil.union(range, p1.getXaxis().getRange());
                    log = log && p1.getXaxis().isLog();
                }
                for (Plot p1 : this.getSelectedPlots()) {
                    p.getXaxis().setRange(range);
                    if (!log) {
                        p1.getXaxis().setLog(log);
                    }
                    this.app.getController().bind(p.getXaxis(), "range", p1.getXaxis(), "range");
                    p.getXaxis().setLog(log);
                    this.app.getController().bind(p.getXaxis(), "log", p1.getXaxis(), "log");
                }
            }
            if (dia.getyAxisCB().isSelected()) {
                range = this.getSelectedPlots().get(0).getYaxis().getRange();
                boolean log = this.getSelectedPlots().get(0).getYaxis().isLog();
                for (Plot p1 : this.getSelectedPlots()) {
                    range = DatumRangeUtil.union(range, p1.getYaxis().getRange());
                    log = log && p1.getYaxis().isLog();
                }
                for (Plot p1 : this.getSelectedPlots()) {
                    p.getYaxis().setRange(range);
                    if (!log) {
                        p1.getYaxis().setLog(log);
                    }
                    this.app.getController().bind(p.getYaxis(), "range", p1.getYaxis(), "range");
                    p.getYaxis().setLog(log);
                    this.app.getController().bind(p.getYaxis(), "log", p1.getYaxis(), "log");
                }
            }
            if (dia.getzAxisCB().isSelected()) {
                range = this.getSelectedPlots().get(0).getZaxis().getRange();
                boolean log = this.getSelectedPlots().get(0).getZaxis().isLog();
                for (Plot p1 : this.getSelectedPlots()) {
                    range = DatumRangeUtil.union(range, p1.getZaxis().getRange());
                    log = log && p1.getZaxis().isLog();
                }
                for (Plot p1 : this.getSelectedPlots()) {
                    p.getZaxis().setRange(range);
                    if (!log) {
                        p1.getZaxis().setLog(log);
                    }
                    this.app.getController().bind(p.getZaxis(), "range", p1.getZaxis(), "range");
                    p.getZaxis().setLog(log);
                    this.app.getController().bind(p.getZaxis(), "log", p1.getZaxis(), "log");
                }
            }
            if (dia.getCondenseColorBarsCB().isSelected()) {
                for (Plot p1 : this.getSelectedPlots()) {
                    this.app.getController().bind(p, "colortable", p1, "colortable");
                }
            }
            if (dia.getCondenseXAxisLabelsCB().isSelected()) {
                String t = plots.get(0).getTitle();
                for (Plot p1 : this.getSelectedPlots()) {
                    p1.getXaxis().setDrawTickLabels(false);
                    p1.getXaxis().setLabel("");
                    p1.setTitle("");
                    Row r = this.app.getCanvases(0).getController().getRowFor(p1);
                    r.setTop(r.getTop().replaceAll("(.*)\\+([\\d\\.]+)em(.*)", "$1+0.5em"));
                    r.setBottom(r.getBottom().replaceAll("(.*)\\-([\\d\\.]+)em", "$1-0.5em"));
                }
                bottomTopPlots[1].setTitle(t);
                bottomTopPlots[0].getXaxis().setDrawTickLabels(true);
            }
            this.app.getController().changePerformed(this, "Add hidden plot");
        }
    }

    private void deleteBindingsMenuItemActionPerformed(ActionEvent evt) {
        Object[] bindings;
        for (Object o : bindings = this.bindingListComponent.getSelectedValues()) {
            BindingModel b = (BindingModel)o;
            this.app.getController().deleteBinding(b);
        }
    }
}

