/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.datum.Datum;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.system.RequestProcessor;
import org.das2.util.CombinedTreeModel;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.DataSourceController;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.PlotElementController;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.MetadataModel;
import org.virbo.dsutil.AutoHistogram;
import org.virbo.dsutil.PropertiesTreeModel;
import org.virbo.metatree.NameValueTreeModel;

public class MetadataPanel
extends JPanel {
    ApplicationModel applicationModel;
    Application dom;
    CombinedTreeModel tree;
    TreeModel dsTree;
    TreeModel componentDataSetTree = null;
    DataSourceFilter bindToDataSourceFilter = null;
    PlotElement bindToPlotElement = null;
    private QDataSet dsTreeDs;
    private QDataSet componentDs;
    transient PropertyChangeListener propertiesListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("rawProperties")) {
                MetadataPanel.this.updateProperties();
            }
        }
    };
    transient PropertyChangeListener fillListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("fillDataSet")) {
                MetadataPanel.this.updateStatistics();
            }
        }
    };
    transient PropertyChangeListener componentListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("dataSet")) {
                MetadataPanel.this.updateComponentDataSet();
            }
        }
    };
    boolean statisticsDirty;
    private JScrollPane jScrollPane1;
    private JTree metaDataTree;

    public MetadataPanel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.dom = applicationModel.getDocumentModel();
        this.initComponents();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MetadataPanel.this.metaDataTree.setModel(null);
            }
        });
        this.dom.getController().addPropertyChangeListener("dataSourceFilter", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MetadataPanel.this.bindToDataSourceFilter(MetadataPanel.this.dom.getController().getDataSourceFilter());
            }
        });
        this.dom.getController().addPropertyChangeListener("plotElement", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MetadataPanel.this.bindToPlotElement(MetadataPanel.this.dom.getController().getPlotElement());
            }
        });
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        if (dsf != null) {
            this.bindToDataSourceFilter(dsf);
        }
        this.updateProperties();
        this.updateStatistics();
        this.updateComponentDataSet();
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this, "metadataPanel");
    }

    private void bindToDataSourceFilter(DataSourceFilter dsf) {
        if (this.bindToDataSourceFilter != null) {
            DataSourceController dsc = this.bindToDataSourceFilter.getController();
            dsc.removePropertyChangeListener(this.propertiesListener);
            dsc.removePropertyChangeListener(this.fillListener);
        }
        dsf.getController().addPropertyChangeListener("rawProperties", this.propertiesListener);
        dsf.getController().addPropertyChangeListener("fillDataSet", this.fillListener);
        this.bindToDataSourceFilter = dsf;
        this.updateProperties();
        this.updateStatistics();
    }

    private void bindToPlotElement(PlotElement pe) {
        if (this.bindToPlotElement != null) {
            PlotElementController pec = this.bindToPlotElement.getController();
            pec.removePropertyChangeListener(this.componentListener);
        }
        pe.getController().addPropertyChangeListener("dataSet", this.componentListener);
        this.bindToPlotElement = pe;
        this.updateComponentDataSet();
    }

    private void updateProperties() {
        try {
            DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
            DataSourceController dsfc = null;
            DataSource dataSource = null;
            if (dsf != null) {
                dsfc = dsf.getController();
                dataSource = dsfc.getDataSource();
            }
            if (dsfc == null) {
                String label = "(data source controller is null)";
                this.tree = new CombinedTreeModel(label);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MetadataPanel.this.metaDataTree.setModel(MetadataPanel.this.tree);
                    }
                });
            } else if (dataSource != null) {
                NameValueTreeModel dsrcMeta;
                this.tree = new CombinedTreeModel("" + dataSource.getURI());
                Map<String, Object> meta = dsfc.getRawProperties();
                MetadataModel model = dataSource.getMetadataModel();
                String root = "Metadata";
                if (model != null && !model.getLabel().equals("")) {
                    root = root + "(" + model.getLabel() + ")";
                }
                if ((dsrcMeta = NameValueTreeModel.create((Object)root, meta)) != null) {
                    SwingUtilities.invokeLater(new Runnable((TreeModel)dsrcMeta){
                        final /* synthetic */ TreeModel val$dsrcMeta;
                        {
                            this.val$dsrcMeta = treeModel;
                        }

                        public void run() {
                            MetadataPanel.this.tree.mountTree(this.val$dsrcMeta, 10);
                            MetadataPanel.this.metaDataTree.setModel(MetadataPanel.this.tree);
                        }
                    });
                }
            } else {
                String label = "(no data source)";
                if (dsfc.getDataSet() != null) {
                    label = "dataset";
                }
                this.tree = new CombinedTreeModel(label);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MetadataPanel.this.metaDataTree.setModel(MetadataPanel.this.tree);
                    }
                });
            }
        }
        catch (Exception e) {
            this.tree = new CombinedTreeModel("Exception: " + e);
            this.applicationModel.getExceptionHandler().handle(e);
        }
    }

    private void updateComponentDataSet() {
        Runnable run = new Runnable(){

            public void run() {
                MetadataPanel.this.updateComponentDataSetPropertiesView();
            }
        };
        RequestProcessor.invokeLater(run);
    }

    private String format(double d) {
        if (Math.abs(Math.log(d) / Math.log(10.0)) < 3.0) {
            DecimalFormat df1 = new DecimalFormat("0.00");
            return df1.format(d);
        }
        DecimalFormat df = new DecimalFormat("0.00E0");
        return df.format(d);
    }

    private void updateStatistics() {
        this.statisticsDirty = true;
        Runnable run = new Runnable(){

            public void run() {
                if (MetadataPanel.this.statisticsDirty) {
                    MetadataPanel.this.updateStatisticsImmediately();
                    MetadataPanel.this.updateDataSetPropertiesView();
                }
            }
        };
        RequestProcessor.invokeLater(run);
    }

    private synchronized void updateDataSetPropertiesView() {
        TreeModel unmount;
        assert (!EventQueue.isDispatchThread());
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        QDataSet ds = dsf.getController().getDataSet();
        if (ds == null) {
            unmount = this.dsTree;
            this.dsTree = NameValueTreeModel.create((Object)"Dataset", Collections.singletonMap("dataset", "(no dataset)"));
            this.dsTreeDs = null;
        } else if (ds != this.dsTreeDs) {
            unmount = this.dsTree;
            this.dsTree = new PropertiesTreeModel("Dataset= ", ds, 20);
            this.dsTreeDs = ds;
        } else {
            unmount = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (unmount != null) {
                    MetadataPanel.this.tree.unmountTree(unmount);
                }
                MetadataPanel.this.tree.mountTree(MetadataPanel.this.dsTree, 30);
            }
        });
    }

    private synchronized void updateComponentDataSetPropertiesView() {
        TreeModel unmount;
        assert (!EventQueue.isDispatchThread());
        PlotElement pe = this.dom.getController().getPlotElement();
        if (pe == null) {
            unmount = this.componentDataSetTree;
            this.componentDataSetTree = NameValueTreeModel.create((Object)"Processed Dataset", Collections.singletonMap("dataset", "(no dataset)"));
            this.componentDs = null;
        } else {
            QDataSet ds = pe.getController().getDataSet();
            if (ds == null) {
                unmount = this.componentDataSetTree;
                this.componentDataSetTree = NameValueTreeModel.create((Object)"Processed Dataset", Collections.singletonMap("dataset", "(no dataset)"));
                this.componentDs = null;
            } else if (ds != this.componentDs) {
                unmount = this.componentDataSetTree;
                this.componentDataSetTree = new PropertiesTreeModel("Processed Dataset= ", ds, 20);
                this.componentDs = ds;
            } else {
                unmount = null;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (unmount != null) {
                    MetadataPanel.this.tree.unmountTree(unmount);
                }
                MetadataPanel.this.tree.mountTree(MetadataPanel.this.componentDataSetTree, 40);
            }
        });
    }

    private synchronized void updateStatisticsImmediately() {
        assert (!EventQueue.isDispatchThread());
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        final LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        QDataSet ds = dsf.getController().getDataSet();
        if (ds == null) {
            map.put("dataset", "(no dataset)");
        } else {
            QDataSet dep0;
            Object cadence;
            QDataSet hist = dsf.getController().getHistogram();
            map.put("Histogram", (String)hist);
            if (hist != null) {
                RankZeroDataSet moments = AutoHistogram.moments((QDataSet)hist);
                long validCount = (Long)moments.property("validCount");
                long invalidCount = (Long)moments.property("invalidCount");
                map.put("# invalid", "" + invalidCount + " of " + String.valueOf(validCount + invalidCount));
                String s = validCount > 0L ? String.valueOf(moments) : "";
                map.put("Mean", s);
                s = validCount > 1L && moments.property("stddev") != null ? String.valueOf(DatumUtil.asOrderOneUnits(DataSetUtil.asDatum((RankZeroDataSet)((RankZeroDataSet)moments.property("stddev"))))) : "";
                map.put("Std Dev", s);
                QDataSet range = AutoHistogram.simpleRange((QDataSet)hist);
                map.put("min", (String)range.slice(0));
                map.put("max", (String)range.slice(1));
            }
            if ((cadence = (dep0 = (QDataSet)ds.property("DEPEND_0")) == null ? DataSetUtil.asDataSet((double)1.0) : (RankZeroDataSet)dep0.property("CADENCE")) != null) {
                Datum d = DatumUtil.asOrderOneUnits(DataSetUtil.asDatum((RankZeroDataSet)cadence));
                Units u = d.getUnits();
                map.put("Cadence", this.format(d.doubleValue(u)) + " " + u);
            } else {
                map.put("Cadence", "null");
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MetadataPanel.this.tree.mountTree((TreeModel)NameValueTreeModel.create((Object)"Statistics", (Map)map), 20);
            }
        });
        this.statisticsDirty = false;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.metaDataTree = new JTree();
        this.jScrollPane1.setViewportView(this.metaDataTree);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 285, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 254, Short.MAX_VALUE));
    }
}

