/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.das2.dasml.PersistentStateSupport;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.ApplicationModel;

public class SaveAsDialog
extends Dialog {
    PersistentStateSupport stateSupport;
    ApplicationModel application;
    private JCheckBox bookmarkCB;
    private JCheckBox embedDataCB;
    private JTextField fileNameTextField;
    private JLabel jLabel1;
    private JButton okayButton;
    private JButton pick;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public SaveAsDialog(Frame parent, PersistentStateSupport stateSupport, ApplicationModel application, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.stateSupport = stateSupport;
        this.application = application;
    }

    private void initComponents() {
        this.pick = new JButton();
        this.fileNameTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.embedDataCB = new JCheckBox();
        this.bookmarkCB = new JCheckBox();
        this.okayButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SaveAsDialog.this.closeDialog(evt);
            }
        });
        this.pick.setText("Choose");
        this.pick.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SaveAsDialog.this.pickActionPerformed(evt);
            }
        });
        this.fileNameTextField.setText("jTextField1");
        this.jLabel1.setText("Filename");
        this.embedDataCB.setText("embed data within file");
        this.embedDataCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.embedDataCB.setMargin(new Insets(0, 0, 0, 0));
        this.bookmarkCB.setText("add to bookmarks");
        this.bookmarkCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.bookmarkCB.setMargin(new Insets(0, 0, 0, 0));
        this.okayButton.setText("OK");
        this.okayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SaveAsDialog.this.okayButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1, -2, 94, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.fileNameTextField, -1, 285, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pick)).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bookmarkCB).addPreferredGap(0, 200, Short.MAX_VALUE).add((Component)this.okayButton)).add((Component)this.embedDataCB)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.pick).add((Component)this.fileNameTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.embedDataCB).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.bookmarkCB).add((Component)this.okayButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void okayButtonActionPerformed(ActionEvent evt) {
        this.application.setUseEmbeddedDataSet(this.embedDataCB.isSelected());
        this.stateSupport.setCurrentFile(new File(this.fileNameTextField.getText()));
        if (this.bookmarkCB.isSelected()) {
            this.application.addBookmark(this.fileNameTextField.getText());
        }
        this.stateSupport.createSaveAsAction().actionPerformed(evt);
    }

    private void pickActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(this.stateSupport.getCurrentFile());
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            this.fileNameTextField.setText(chooser.getSelectedFile().toString());
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new SaveAsDialog(new Frame(), null, null, true).setVisible(true);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isEmbedData() {
        return this.embedDataCB.isSelected();
    }

    public void setEmbedData(boolean embedData) {
        boolean oldEmbedData = this.embedDataCB.isSelected();
        this.embedDataCB.setSelected(embedData);
        this.propertyChangeSupport.firePropertyChange("embedData", (Object)oldEmbedData, (Object)embedData);
    }

    public boolean isBookmark() {
        return this.bookmarkCB.isSelected();
    }

    public void setBookmark(boolean bookmark) {
        boolean oldBookmark = this.isBookmark();
        this.bookmarkCB.setSelected(bookmark);
        this.propertyChangeSupport.firePropertyChange("bookmark", (Object)oldBookmark, (Object)bookmark);
    }
}

