/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.bookmarks;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.das2.util.Base64;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Bookmark {
    public static final String MSG_NO_REMOTE = "(remote not available)";
    public static final String MSG_REMOTE = "(remote)";
    public static final String MSG_NOT_LOADED = "(remote not loaded)";
    private static final Logger logger = Logger.getLogger("autoplot.bookmarks");
    private String title;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected String description;
    protected ImageIcon icon = null;
    public static final String PROP_ICON = "icon";
    public static final String PROP_PARENT = "parent";
    private Folder parent = null;

    public static List<Bookmark> parseBookmarks(String data) throws SAXException, IOException {
        return Bookmark.parseBookmarks(data, 0);
    }

    public static List<Bookmark> parseBookmarks(String data, int depth) throws SAXException, IOException {
        try {
            BufferedReader in = new BufferedReader(new StringReader(data));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(in);
            Document document = builder.parse(source);
            List<Bookmark> books = Bookmark.parseBookmarks(document.getDocumentElement(), depth);
            return books;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<Bookmark> parseBookmarks(URL url) throws SAXException, IOException {
        try {
            File file = DataSetURI.downloadResourceAsTempFile((URL)url, (ProgressMonitor)new NullProgressMonitor());
            BufferedReader in = new BufferedReader(new FileReader(file));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(in);
            Document document = builder.parse(source);
            return Bookmark.parseBookmarks(document.getDocumentElement());
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Bookmark parseBookmark(String data) throws SAXException, IOException {
        try {
            BufferedReader in = new BufferedReader(new StringReader(data));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(in);
            Document document = builder.parse(source);
            String vers = document.getDocumentElement().getAttribute("version");
            return Bookmark.parseBookmark(document.getDocumentElement(), vers, 1);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bookmark parseBookmark(Node element, String vers, int remoteLevel) throws UnsupportedEncodingException, IOException {
        void var9_18;
        void var9_15;
        NodeList nl;
        String uri = null;
        String s = null;
        String title = null;
        ImageIcon icon = null;
        String description = null;
        if (element.getNodeName().equals("bookmark")) {
            if (vers.equals("")) {
                nl = ((Element)element).getElementsByTagName("url");
                s = ((Text)nl.item(0).getFirstChild()).getData();
                uri = URLDecoder.decode(s, "UTF-8");
            } else {
                nl = ((Element)element).getElementsByTagName("uri");
                if (nl.getLength() == 0) {
                    nl = ((Element)element).getElementsByTagName("url");
                }
                uri = s = ((Text)nl.item(0).getFirstChild()).getData();
            }
        } else {
            uri = null;
        }
        nl = ((Element)element).getElementsByTagName("title");
        if (nl.getLength() > 0) {
            if (!nl.item(0).hasChildNodes()) {
                if (uri == null) {
                    title = "(untitled)";
                } else {
                    System.err.println("Using URI for title because title is empty: " + uri);
                    title = uri;
                }
            } else {
                s = ((Text)nl.item(0).getFirstChild()).getData();
                title = vers.equals("") ? URLDecoder.decode(s, "UTF-8") : s;
            }
        } else {
            title = "(untitled)";
        }
        nl = ((Element)element).getElementsByTagName(PROP_ICON);
        if (nl.getLength() > 0) {
            s = ((Text)nl.item(0).getFirstChild()).getData();
            icon = new ImageIcon(Bookmark.decodeImage(s));
        }
        if ((nl = ((Element)element).getElementsByTagName("description")).getLength() > 0) {
            Node node = nl.item(0).getFirstChild();
            if (node == null) {
                description = "";
            } else {
                s = ((Text)node).getData();
                String string = description = vers.equals("") ? URLDecoder.decode(s, "UTF-8") : s;
            }
        }
        if (element.getNodeName().equals("bookmark")) {
            Item item = new Item(uri);
            item.setTitle(title);
            if (icon != null) {
                item.setIcon(icon);
            }
            if (description == null) return item;
            item.setDescription(description);
            return item;
        }
        if (!element.getNodeName().equals("bookmark-folder")) return null;
        Object var9_11 = null;
        Node remoteUrlNode = ((Element)element).getAttributes().getNamedItem("remoteUrl");
        String remoteUrl = null;
        int remoteStatus = -1;
        boolean remoteRemote = false;
        if (remoteUrlNode != null) {
            String string = remoteUrl = vers.equals("") ? URLDecoder.decode(remoteUrlNode.getNodeValue(), "UTF-8") : remoteUrlNode.getNodeValue();
            if (remoteLevel > 0) {
                System.err.println(String.format("Reading in remote bookmarks folder \"%s\" from %s", title, remoteUrl));
                InputStream in = null;
                try {
                    URL rurl = new URL(remoteUrl);
                    try {
                        URI ruri = rurl.toURI();
                        URI parentUri = FileSystemUtil.isCacheable(ruri);
                        if (parentUri != null) {
                            FileSystem fd = FileSystem.create(parentUri);
                            FileObject fo = fd.getFileObject(parentUri.relativize(ruri).toString());
                            in = fo.getInputStream();
                        } else {
                            in = new FileInputStream(DataSetURI.downloadResourceAsTempFile((URL)rurl, (ProgressMonitor)new NullProgressMonitor()));
                        }
                    }
                    catch (URISyntaxException ex) {
                        in = new FileInputStream(DataSetURI.downloadResourceAsTempFile((URL)rurl, (ProgressMonitor)new NullProgressMonitor()));
                    }
                    ByteArrayOutputStream boas = new ByteArrayOutputStream();
                    WritableByteChannel dest = Channels.newChannel(boas);
                    ReadableByteChannel src = Channels.newChannel(in);
                    DataSourceUtil.transfer((ReadableByteChannel)src, (WritableByteChannel)dest);
                    in.close();
                    in = null;
                    String sin = new String(boas.toByteArray());
                    if (!sin.startsWith("<book") && !sin.startsWith("<?xml")) {
                        System.err.println("not a bookmark xml file: " + rurl);
                        throw new IllegalArgumentException("not a bookmark xml file: " + rurl);
                    }
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    InputSource source = new InputSource(new StringReader(sin));
                    Document document = builder.parse(source);
                    XPathFactory factory = XPathFactory.newInstance();
                    XPath xpath = factory.newXPath();
                    Object o = xpath.evaluate("/bookmark-list/bookmark-folder/bookmark-list", document, XPathConstants.NODESET);
                    nl = (NodeList)o;
                    Element flist = (Element)nl.item(0);
                    if (flist == null) {
                        List list = Collections.emptyList();
                        String remoteUrl2 = (String)xpath.evaluate("/bookmark-list/bookmark-folder/@remoteUrl", document, XPathConstants.STRING);
                        if (remoteUrl2.length() > 0) {
                            remoteRemote = true;
                        }
                    } else {
                        String vers1 = (String)xpath.evaluate("/bookmark-list/@version", document, XPathConstants.STRING);
                        List<Bookmark> list = Bookmark.parseBookmarks(flist, vers1, remoteLevel - 1);
                    }
                }
                catch (XPathExpressionException ex) {
                    Logger.getLogger(Bookmark.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SAXException ex) {
                    Logger.getLogger(Bookmark.class.getName()).log(Level.SEVERE, null, ex);
                    ex.printStackTrace();
                }
                catch (ParserConfigurationException ex) {
                    Logger.getLogger(Bookmark.class.getName()).log(Level.SEVERE, null, ex);
                    ex.printStackTrace();
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if ((var9_15 == null || var9_15.size() == 0) & !remoteRemote) {
                    System.err.println("unable to parse bookmarks at " + remoteUrl);
                    System.err.println("Maybe using local copy");
                    remoteStatus = 1;
                } else {
                    remoteStatus = 0;
                }
            }
        } else if (remoteUrlNode == null) {
            remoteStatus = 0;
        }
        if (!(remoteUrl != null && remoteStatus != -1 || var9_15 != null && var9_15.size() != 0)) {
            nl = ((Element)element).getElementsByTagName("bookmark-list");
            if (nl.getLength() == 0) {
                if (remoteStatus != -1) throw new IllegalArgumentException("bookmark-folder should contain one bookmark-list");
                List list = Collections.emptyList();
            } else {
                Element flist = (Element)nl.item(0);
                List<Bookmark> list = Bookmark.parseBookmarks(flist, vers, remoteLevel);
            }
        }
        Folder book = new Folder(title);
        if (icon != null) {
            book.setIcon(icon);
        }
        if (remoteUrl != null) {
            book.setRemoteUrl(remoteUrl);
        }
        if (description != null) {
            book.setDescription(description);
        }
        book.remoteStatus = remoteStatus;
        book.getBookmarks().addAll((Collection<Bookmark>)var9_18);
        for (int i = 0; i < var9_18.size(); ++i) {
            ((Bookmark)var9_18.get(i)).setParent(book);
        }
        return book;
    }

    public static List<Bookmark> parseBookmarks(Element root) {
        String vers = root.getAttribute("version");
        return Bookmark.parseBookmarks(root, vers, 1);
    }

    public static List<Bookmark> parseBookmarks(Element root, int remoteLevel) {
        logger.log(Level.FINE, "parseBookmarks {0}", remoteLevel);
        String vers = root.getAttribute("version");
        return Bookmark.parseBookmarks(root, vers, remoteLevel);
    }

    public static List<Bookmark> parseBookmarks(Element root, String vers, int remoteLevel) {
        if (vers == null) {
            vers = root.getAttribute("version");
        }
        if (!root.getNodeName().equals("bookmark-list")) {
            throw new IllegalArgumentException(String.format("Expected XML element to be \"bookmark-list\" not \"%s\"", root.getNodeName()));
        }
        ArrayList<Bookmark> result = new ArrayList<Bookmark>();
        NodeList list = root.getChildNodes();
        Bookmark lastBook = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!(n instanceof Element)) continue;
            try {
                Bookmark book = Bookmark.parseBookmark(n, vers, remoteLevel);
                result.add(book);
                lastBook = book;
                continue;
            }
            catch (Exception ex) {
                try {
                    Bookmark.parseBookmark(n, vers, remoteLevel);
                }
                catch (UnsupportedEncodingException ex1) {
                    Logger.getLogger(Bookmark.class.getName()).log(Level.SEVERE, null, ex1);
                }
                catch (IOException ex1) {
                    Logger.getLogger(Bookmark.class.getName()).log(Level.SEVERE, null, ex1);
                }
                System.err.println("## bookmark number=" + i);
                ex.printStackTrace();
                System.err.println("last bookmark parsed:" + lastBook);
            }
        }
        return result;
    }

    public static String formatBooksOld(List<Bookmark> bookmarks) {
        StringBuilder buf = new StringBuilder();
        buf.append("<bookmark-list>\n");
        for (Bookmark o : bookmarks) {
            buf.append(Bookmark.formatBookmark(o));
        }
        buf.append("</bookmark-list>\n");
        return buf.toString();
    }

    public static String formatBooks(List<Bookmark> bookmarks) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Bookmark.formatBooks(baos, bookmarks);
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void formatBooks(OutputStream out, List<Bookmark> bookmarks) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element e = doc.createElement("bookmark-list");
            e.setAttribute("version", "1.1");
            for (Bookmark o : bookmarks) {
                Bookmark.formatBookmark(doc, e, o);
            }
            doc.appendChild(e);
            DOMImplementationLS ls = (DOMImplementationLS)doc.getImplementation().getFeature("LS", "3.0");
            LSOutput output = ls.createLSOutput();
            output.setEncoding("UTF-8");
            output.setByteStream(out);
            LSSerializer serializer = ls.createLSSerializer();
            try {
                if (serializer.getDomConfig().canSetParameter("format-pretty-print", Boolean.TRUE)) {
                    serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                }
            }
            catch (Error error) {
                error.printStackTrace();
            }
            serializer.write(doc, output);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String encodeImage(BufferedImage image) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", out);
        out.size();
        return Base64.encodeBytes(out.toByteArray());
    }

    private static BufferedImage decodeImage(String data) throws IOException {
        byte[] bd = Base64.decode(data);
        return ImageIO.read(new ByteArrayInputStream(bd));
    }

    public static void formatBookmark(Document doc, Element parent, Bookmark bookmark) throws IOException {
        if (bookmark instanceof Item) {
            Item b = (Item)bookmark;
            Element book = doc.createElement("bookmark");
            Element title = doc.createElement("title");
            title.appendChild(doc.createTextNode(b.getTitle()));
            book.appendChild(title);
            Element url = doc.createElement("uri");
            url.appendChild(doc.createTextNode(b.getUri()));
            book.appendChild(url);
            if (b.icon != null) {
                Element icon = doc.createElement(PROP_ICON);
                icon.appendChild(doc.createTextNode(Bookmark.encodeImage((BufferedImage)b.icon.getImage())));
                book.appendChild(icon);
            }
            if (b.description != null) {
                Element desc = doc.createElement("description");
                desc.appendChild(doc.createTextNode(b.getDescription()));
                book.appendChild(desc);
            }
            parent.appendChild(book);
        } else if (bookmark instanceof Folder) {
            Folder f = (Folder)bookmark;
            Element folder = doc.createElement("bookmark-folder");
            if (f.getRemoteUrl() != null) {
                folder.setAttribute("remoteUrl", f.getRemoteUrl());
            }
            Element titleEle = doc.createElement("title");
            titleEle.appendChild(doc.createTextNode(f.getTitle()));
            folder.appendChild(titleEle);
            if (f.icon != null) {
                Element icon = doc.createElement(PROP_ICON);
                icon.appendChild(doc.createTextNode(Bookmark.encodeImage((BufferedImage)f.getIcon().getImage())));
                folder.appendChild(icon);
            }
            if (f.description != null) {
                Element desc = doc.createElement("description");
                desc.appendChild(doc.createTextNode(f.getDescription()));
                folder.appendChild(desc);
            }
            Element list = doc.createElement("bookmark-list");
            for (Bookmark book : f.getBookmarks()) {
                Bookmark.formatBookmark(doc, list, book);
            }
            folder.appendChild(list);
            parent.appendChild(folder);
        }
    }

    public static String formatBookmark(Bookmark bookmark) {
        try {
            StringBuilder buf = new StringBuilder();
            if (bookmark instanceof Item) {
                Item b = (Item)bookmark;
                buf.append("  <bookmark>\n");
                buf.append("     <title>").append(URLEncoder.encode(b.getTitle(), "UTF-8")).append("</title>\n");
                if (b.icon != null) {
                    buf.append("     <icon>").append(Bookmark.encodeImage((BufferedImage)b.icon.getImage())).append("</icon>\n");
                }
                if (b.description != null) {
                    buf.append("     <description>").append(URLEncoder.encode(b.getDescription(), "UTF-8")).append("</description>\n");
                }
                buf.append("     <url>").append(URLEncoder.encode(b.getUri(), "UTF-8")).append("</url>\n");
                buf.append("  </bookmark>\n");
            } else if (bookmark instanceof Folder) {
                Folder f = (Folder)bookmark;
                String title = f.getTitle();
                if (f.getRemoteUrl() != null) {
                    buf.append("  <bookmark-folder remoteUrl=\"").append(URLEncoder.encode(f.getRemoteUrl(), "UTF-8")).append("\">\n");
                } else {
                    buf.append("  <bookmark-folder>\n");
                }
                buf.append("    <title>").append(URLEncoder.encode(title, "UTF-8")).append("</title>\n");
                if (f.icon != null) {
                    buf.append("     <icon>").append(Bookmark.encodeImage((BufferedImage)f.icon.getImage())).append("</icon>\n");
                }
                if (f.description != null) {
                    buf.append("     <description>").append(URLEncoder.encode(f.getDescription(), "UTF-8")).append("</description>\n");
                }
                buf.append(Bookmark.formatBooksOld(f.getBookmarks()));
                buf.append("  </bookmark-folder>\n");
            }
            return buf.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        FileReader in = new FileReader("/home/jbf/CDAWebShort.xml");
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource source = new InputSource(in);
        Document document = builder.parse(source);
        List<Bookmark> bs = Bookmark.parseBookmarks(document.getDocumentElement());
        for (Bookmark b : bs) {
            System.err.println("bookmark: " + b);
            if (!(b instanceof Folder)) continue;
            System.err.println(" -->" + ((Folder)b).getBookmarks());
        }
    }

    private Bookmark(String title) {
        this.title = title;
    }

    public String toString() {
        return this.title;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.propertyChangeSupport.firePropertyChange("title", oldTitle, title);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldValue = this.description;
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", oldValue, description);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        ImageIcon oldIcon = this.icon;
        this.icon = icon;
        this.propertyChangeSupport.firePropertyChange(PROP_ICON, oldIcon, icon);
    }

    public Folder getParent() {
        return this.parent;
    }

    public void setParent(Folder parent) {
        Folder old = this.parent;
        this.parent = parent;
        this.propertyChangeSupport.firePropertyChange(PROP_PARENT, old, parent);
    }

    public abstract Bookmark copy();

    public static class Item
    extends Bookmark {
        private String uri;

        public Item(String suri) {
            super(suri);
            this.uri = suri;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            String oldUrl = this.uri;
            this.uri = uri;
            this.propertyChangeSupport.firePropertyChange("uri", oldUrl, uri);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                Item that = (Item)obj;
                return that.uri.equals(this.uri) && (that.getParent() == null || this.getParent() == null || that.getParent().getTitle().equals(this.getParent().getTitle()));
            }
            return false;
        }

        public Bookmark copy() {
            Item result = new Item(this.getUri());
            result.setTitle(this.getTitle());
            result.description = this.description;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Folder
    extends Bookmark {
        List<Bookmark> bookmarks;
        String remoteUrl = null;
        int remoteStatus = -1;

        public void setRemoteUrl(String url) {
            this.remoteUrl = url;
        }

        public String getRemoteUrl() {
            return this.remoteUrl;
        }

        public void setRemoteStatus(int status) {
            this.remoteStatus = status;
        }

        public int getRemoteStatus() {
            return this.remoteStatus;
        }

        public Folder(String title) {
            super(title);
            this.bookmarks = new ArrayList<Bookmark>();
        }

        public Folder(String title, String remoteUrl) {
            super(title);
            this.remoteUrl = remoteUrl;
            this.bookmarks = new ArrayList<Bookmark>();
        }

        public List<Bookmark> getBookmarks() {
            return this.bookmarks;
        }

        public int hashCode() {
            return ((Object)this.bookmarks).hashCode() + (this.remoteUrl != null ? this.remoteUrl.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Folder) {
                Folder that = (Folder)obj;
                return ((Object)that.bookmarks).equals(this.bookmarks) && that.getTitle().equals(this.getTitle()) && (that.getParent() == null || this.getParent() != null && that.getParent().getTitle().equals(this.getParent().getTitle()));
            }
            return false;
        }

        @Override
        public Bookmark copy() {
            Folder result = new Folder(this.getTitle());
            result.description = this.description;
            result.remoteUrl = this.remoteUrl;
            result.remoteStatus = this.remoteStatus;
            result.bookmarks = new ArrayList<Bookmark>(this.bookmarks);
            return result;
        }
    }
}

