/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.bookmarks;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.autoplot.bookmarks.BookmarksManager;
import org.virbo.datasource.DataSetURI;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksManagerModel {
    private static final Logger logger = Logger.getLogger("autoplot.bookmarks");
    protected List<Bookmark> list = null;
    public static final String PROP_LIST = "list";
    public static final String PROP_BOOKMARK = "bookmark";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected void doImport(Component c) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "bookmarks files (*.xml)";
            }
        });
        int r = chooser.showOpenDialog(c);
        if (r == 0) {
            try {
                List<Bookmark> importBook = Bookmark.parseBookmarks(AutoplotUtil.readDoc(new FileInputStream(chooser.getSelectedFile())).getDocumentElement());
                ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.list.size());
                for (int i = 0; i < this.list.size(); ++i) {
                    newList.add(i, this.list.get(i).copy());
                }
                this.mergeList(importBook, newList);
                this.setList(newList);
            }
            catch (SAXException ex) {
                Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected void doExport(Component c) {
        this.doExport(c, this.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExport(Component c, List<Bookmark> list) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "bookmarks files (*.xml)";
            }
        });
        int r = chooser.showSaveDialog(c);
        if (r == 0) {
            FileOutputStream out = null;
            try {
                File f = chooser.getSelectedFile();
                if (!f.toString().endsWith(".xml")) {
                    f = new File(f.toString() + ".xml");
                }
                out = new FileOutputStream(f);
                Bookmark.formatBooks(out, list);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(BookmarksManagerModel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    public List<Bookmark> getList() {
        return this.list;
    }

    public void setList(List<Bookmark> list) {
        logger.log(Level.FINE, "setting list to {0}", list);
        this.list = list;
        this.propertyChangeSupport.firePropertyChange(PROP_LIST, null, list);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public TreeModel getTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Bookmarks");
        DefaultTreeModel model = new DefaultTreeModel(root);
        if (this.list != null) {
            this.addChildNodes(root, this.list);
        }
        return model;
    }

    Bookmark.Folder getFolder(List<Bookmark> newList, Bookmark context) {
        for (int i = 0; i < newList.size(); ++i) {
            Bookmark.Folder sub;
            Bookmark item = newList.get(i);
            if (item.equals(context)) {
                return (Bookmark.Folder)item;
            }
            if (!(item instanceof Bookmark.Folder) || (sub = this.getFolder(((Bookmark.Folder)item).getBookmarks(), context)) == null) continue;
            return sub;
        }
        return null;
    }

    void addBookmarks(List<Bookmark> bookmarks, Bookmark context, boolean insert) {
        ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.list.size());
        for (Bookmark b : this.list) {
            newList.add(b.copy());
        }
        boolean containsFolder = false;
        for (Bookmark b : bookmarks) {
            containsFolder = containsFolder || b instanceof Bookmark.Folder;
        }
        if (context == null) {
            if (newList.contains(null)) {
                newList.addAll(newList.indexOf(null) + (insert ? 0 : 1), bookmarks);
            } else {
                newList.addAll(bookmarks);
            }
        } else if (context instanceof Bookmark.Folder) {
            Bookmark.Folder newFolder = this.getFolder(newList, context);
            newFolder.getBookmarks().addAll(bookmarks);
        } else if (newList.contains(context)) {
            newList.addAll(newList.indexOf(context) + (insert ? 0 : 1), bookmarks);
        } else {
            boolean isAdded = false;
            for (Bookmark b : newList) {
                if (!(b instanceof Bookmark.Folder)) continue;
                List<Bookmark> bs = ((Bookmark.Folder)b).getBookmarks();
                if (isAdded || !bs.contains(context)) continue;
                bs.addAll(bs.indexOf(context) + (insert ? 0 : 1), bookmarks);
                isAdded = true;
            }
            if (!isAdded) {
                newList.addAll(bookmarks);
            }
        }
        this.setList(newList);
    }

    void addBookmark(Bookmark bookmark, Bookmark context) {
        this.addBookmarks(Collections.singletonList(bookmark), context, false);
    }

    void insertBookmark(Bookmark bookmark, Bookmark context) {
        this.addBookmarks(Collections.singletonList(bookmark), context, true);
    }

    private Bookmark findItem(List<Bookmark> oldList, String title, boolean findFolder) {
        for (int i = 0; i < oldList.size(); ++i) {
            Bookmark item = oldList.get(i);
            boolean isFolder = item instanceof Bookmark.Folder;
            if (findFolder != isFolder || !oldList.get(i).getTitle().equals(title)) continue;
            return item;
        }
        return null;
    }

    public void mergeList(List<Bookmark> src, List<Bookmark> dest) {
        if (src.size() == 0) {
            return;
        }
        for (int i = 0; i < src.size(); ++i) {
            Bookmark old;
            Bookmark item = src.get(i);
            if (item instanceof Bookmark.Folder) {
                String folderName = item.getTitle();
                old = (Bookmark.Folder)this.findItem(dest, folderName, true);
                if (old != null) {
                    this.mergeList(((Bookmark.Folder)item).getBookmarks(), ((Bookmark.Folder)old).getBookmarks());
                    continue;
                }
                dest.add(item);
                continue;
            }
            String id = item.getTitle();
            old = (Bookmark.Item)this.findItem(dest, id, false);
            if (old != null) {
                if (!((Bookmark.Item)old).equals(item)) continue;
                continue;
            }
            dest.add(item);
        }
    }

    void fireBookmarkChange(Bookmark book) {
        this.propertyChangeSupport.firePropertyChange(PROP_BOOKMARK, null, book);
    }

    TreePath getPathFor(Bookmark b, TreeModel model, TreePath root) {
        if (root == null) {
            return null;
        }
        Object parent = root.getLastPathComponent();
        int childCount = model.getChildCount(parent);
        for (int ii = 0; ii < childCount; ++ii) {
            TreePath childResult;
            Object child = model.getChild(parent, ii);
            if (b.equals(((DefaultMutableTreeNode)child).getUserObject())) {
                b.equals(((DefaultMutableTreeNode)child).getUserObject());
                return root.pathByAddingChild(child);
            }
            if (model.getChildCount(child) <= 0 || (childResult = this.getPathFor(b, model, root.pathByAddingChild(child))) == null) continue;
            return childResult;
        }
        return null;
    }

    Bookmark.Folder removeBookmarks(Bookmark.Folder folder, Bookmark book) {
        ArrayList<Bookmark> newList = new ArrayList<Bookmark>(folder.getBookmarks().size());
        for (Bookmark b : folder.getBookmarks()) {
            newList.add(b.copy());
        }
        for (int i = 0; i < newList.size(); ++i) {
            Bookmark bookmark = (Bookmark)newList.get(i);
            if (bookmark instanceof Bookmark.Folder) {
                if (bookmark.equals(book)) {
                    newList.set(i, null);
                    continue;
                }
                bookmark = this.removeBookmarks((Bookmark.Folder)bookmark, book);
                newList.set(i, bookmark);
                continue;
            }
            if (!bookmark.equals(book)) continue;
            newList.set(i, null);
        }
        newList.removeAll(Collections.singleton(null));
        Bookmark.Folder result = new Bookmark.Folder(folder.getTitle());
        result.bookmarks = newList;
        return result;
    }

    void removeBookmarks(List<Bookmark> bookmarks) {
        ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.list.size());
        for (Bookmark b : this.list) {
            newList.add(b.copy());
        }
        for (Bookmark bookmark : bookmarks) {
            if (newList.contains(bookmark)) {
                newList.remove(bookmark);
                continue;
            }
            int i = 0;
            for (Bookmark b2 : newList) {
                if (b2 instanceof Bookmark.Folder) {
                    b2 = this.removeBookmarks((Bookmark.Folder)b2, bookmark);
                    newList.set(i, b2);
                } else {
                    newList.set(i, null);
                }
                ++i;
            }
        }
        newList.removeAll(Collections.singleton(null));
        this.setList(newList);
    }

    void removeBookmark(Bookmark bookmark) {
        this.removeBookmarks(Collections.singletonList(bookmark));
    }

    private void addChildNodes(MutableTreeNode parent, List<Bookmark> bookmarks) {
        for (Bookmark b : bookmarks) {
            String node = b.toString();
            if (b instanceof Bookmark.Folder && ((Bookmark.Folder)b).remoteUrl != null) {
                node = node + " (remote)";
            }
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(b);
            parent.insert(child, parent.getChildCount());
            if (!(b instanceof Bookmark.Folder)) continue;
            List<Bookmark> kids = ((Bookmark.Folder)b).getBookmarks();
            if (kids.size() == 0) {
                child.insert(new DefaultMutableTreeNode("(empty)"), 0);
                continue;
            }
            this.addChildNodes(child, kids);
        }
    }

    protected Bookmark getSelectedBookmark(TreeModel model, TreePath path) {
        if (path == null || path.getPathCount() == 1) {
            return null;
        }
        Object sel = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        if (sel.equals("(empty)")) {
            return this.getSelectedBookmark(model, path.getParentPath());
        }
        return (Bookmark)sel;
    }

    protected List<Bookmark> getSelectedBookmarks(TreeModel model, TreePath[] paths) {
        ArrayList<Bookmark> result = new ArrayList<Bookmark>();
        if (paths == null) {
            return result;
        }
        for (TreePath path : paths) {
            if (path == null) {
                return null;
            }
            if (path.getPathCount() == 1) {
                return this.list;
            }
            Object sel = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            Bookmark b = sel.equals("(empty)") ? this.getSelectedBookmark(model, path.getParentPath()) : (Bookmark)sel;
            if (b == null) continue;
            result.add(b);
        }
        return result;
    }

    void doImportUrl(Component c) {
        String ansr = null;
        URL url = null;
        boolean okay = false;
        while (!okay) {
            String s = ansr == null ? JOptionPane.showInputDialog(c, "Enter the URL of a bookmarks file:", "") : JOptionPane.showInputDialog(c, "Whoops, Enter the URL of a bookmarks file:", ansr);
            if (s == null) {
                return;
            }
            try {
                ansr = s;
                url = new URL(s);
                okay = true;
            }
            catch (MalformedURLException ex) {}
        }
        try {
            Document doc = AutoplotUtil.readDoc(url.openStream());
            List<Bookmark> importBook = Bookmark.parseBookmarks(doc.getDocumentElement());
            this.importList(importBook);
        }
        catch (SAXException ex) {
            Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(BookmarksManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void importList(List<Bookmark> books) {
        ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            newList.add(i, this.list.get(i).copy());
        }
        this.mergeList(books, newList);
        this.setList(newList);
    }

    public void addRemoteBookmarks(String surl) throws MalformedURLException, SAXException, ParserConfigurationException, IOException {
        this.addRemoteBookmarks(surl, null);
    }

    public void addRemoteBookmarks(String surl, Bookmark selectedBookmark) throws MalformedURLException, SAXException, ParserConfigurationException, IOException {
        try {
            File ff = DataSetURI.downloadResourceAsTempFile((URL)new URL(surl), (ProgressMonitor)new NullProgressMonitor());
            Document doc = AutoplotUtil.readDoc(new FileInputStream(ff));
            ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.list.size());
            for (int i = 0; i < this.list.size(); ++i) {
                newList.add(i, this.list.get(i).copy());
            }
            List<Bookmark> importBook = Bookmark.parseBookmarks(doc.getDocumentElement());
            ArrayList<Bookmark> copy = new ArrayList<Bookmark>();
            for (int i = 0; i < importBook.size(); ++i) {
                Bookmark m = importBook.get(i);
                if (!(m instanceof Bookmark.Folder)) continue;
                ((Bookmark.Folder)m).setRemoteUrl(surl);
                ((Bookmark.Folder)m).setTitle(m.getTitle());
                copy.add(m);
            }
            this.mergeList(copy, newList);
            this.setList(newList);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(BookmarksManagerModel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

