/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.bookmarks.Bookmark;
import org.virbo.datasource.AutoplotSettings;
import org.virbo.datasource.DataSetSelector;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static void loadRecent(String nodeName, final DataSetSelector sel, List<Bookmark> deft) {
        boolean ok;
        File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
        if (!f2.exists() && !(ok = f2.mkdirs())) {
            throw new RuntimeException("unable to create folder " + f2);
        }
        final File f = new File(f2, nodeName + ".xml");
        if (f.exists()) {
            try {
                List<Bookmark> recent = Bookmark.parseBookmarks(AutoplotUtil.readDoc(new FileInputStream(f)).getDocumentElement());
                Util.setRecent(sel, recent);
            }
            catch (SAXException ex) {
                Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(ApplicationModel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        sel.addPropertyChangeListener("recent", new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent evt) {
                PrintStream fout = null;
                try {
                    fout = new PrintStream(f);
                    Bookmark.formatBooks(fout, Util.getRecent(sel));
                    fout.close();
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    fout.close();
                }
            }
        });
    }

    public static List<Bookmark> getRecent(DataSetSelector sel) {
        List ls = sel.getRecent();
        ArrayList<Bookmark> result = new ArrayList<Bookmark>();
        for (int i = 0; i < ls.size(); ++i) {
            result.add(new Bookmark.Item((String)ls.get(i)));
        }
        return result;
    }

    public static void setRecent(DataSetSelector sel, List<Bookmark> recent) {
        ArrayList<String> result = new ArrayList<String>();
        for (Bookmark b : recent) {
            if (!(b instanceof Bookmark.Item)) continue;
            result.add(((Bookmark.Item)b).getUri());
        }
        sel.setRecent(result);
    }
}

