/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.ArrayNodeDiff;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.Canvas;
import org.virbo.autoplot.dom.Connector;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.Diff;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Options;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.PropertyChangeDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends DomNode {
    public static final DatumRange DEFAULT_TIME_RANGE = DatumRangeUtil.parseTimeRangeValid("2010-01-01");
    protected List<DataSourceFilter> dataSourceFilters = Arrays.asList(new DataSourceFilter[0]);
    public static final String PROP_DATASOURCEFILTERS = "dataSourceFilters";
    public static final String PROP_PLOT_ELEMENTS = "plotElements";
    protected List<PlotElement> plotElements = new LinkedList<PlotElement>();
    public static final String PROP_PLOTS = "plots";
    protected List<Plot> plots = new LinkedList<Plot>();
    public static final String PROP_CANVASES = "canvases";
    protected List<Canvas> canvases = new LinkedList<Canvas>();
    ApplicationController controller;
    protected Options options = new Options();
    protected DatumRange timeRange = DEFAULT_TIME_RANGE;
    public static final String PROP_TIMERANGE = "timeRange";
    protected List<BindingModel> bindings = Collections.emptyList();
    public static final String PROP_BINDINGS = "bindings";
    protected List<Connector> connectors = Collections.EMPTY_LIST;
    public static final String PROP_CONNECTORS = "connectors";

    public DataSourceFilter[] getDataSourceFilters() {
        return this.dataSourceFilters.toArray(new DataSourceFilter[this.dataSourceFilters.size()]);
    }

    public void setDataSourceFilters(DataSourceFilter[] dataSourceFilters) {
        DataSourceFilter[] oldDataSourceFilters = this.dataSourceFilters.toArray(new DataSourceFilter[this.dataSourceFilters.size()]);
        this.dataSourceFilters = Arrays.asList(dataSourceFilters);
        this.propertyChangeSupport.firePropertyChange(PROP_DATASOURCEFILTERS, oldDataSourceFilters, dataSourceFilters);
    }

    public DataSourceFilter getDataSourceFilters(int index) {
        return this.dataSourceFilters.get(index);
    }

    public void setDataSourceFilters(int index, DataSourceFilter newDataSourceFilter) {
        DataSourceFilter oldDataSourceFilters = this.dataSourceFilters.get(index);
        this.dataSourceFilters.set(index, newDataSourceFilter);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_DATASOURCEFILTERS, index, oldDataSourceFilters, newDataSourceFilter);
    }

    public PlotElement[] getPlotElements() {
        return this.plotElements.toArray(new PlotElement[this.plotElements.size()]);
    }

    public void setPlotElements(PlotElement[] pele) {
        PlotElement[] old = this.plotElements.toArray(new PlotElement[this.plotElements.size()]);
        this.plotElements = Arrays.asList(pele);
        this.propertyChangeSupport.firePropertyChange(PROP_PLOT_ELEMENTS, old, pele);
    }

    public PlotElement getPlotElements(int index) {
        return this.plotElements.get(index);
    }

    public void setPlotElements(int index, PlotElement pele) {
        PlotElement old = this.plotElements.get(index);
        this.plotElements.set(index, pele);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_PLOT_ELEMENTS, index, old, pele);
    }

    public Plot[] getPlots() {
        return this.plots.toArray(new Plot[this.plots.size()]);
    }

    public void setPlots(Plot[] plots) {
        Plot[] oldPlots = this.plots.toArray(new Plot[this.plots.size()]);
        this.plots = Arrays.asList(plots);
        this.propertyChangeSupport.firePropertyChange(PROP_PLOTS, oldPlots, plots);
    }

    public Plot getPlots(int index) {
        return this.plots.get(index);
    }

    public void setPlots(int index, Plot newPlots) {
        Plot oldPlots = this.plots.get(index);
        this.plots.set(index, newPlots);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_PLOTS, index, oldPlots, newPlots);
    }

    public Canvas[] getCanvases() {
        return this.canvases.toArray(new Canvas[this.canvases.size()]);
    }

    public void setCanvases(Canvas[] canvases) {
        Canvas[] old = this.canvases.toArray(new Canvas[this.canvases.size()]);
        this.canvases = Arrays.asList(canvases);
        this.propertyChangeSupport.firePropertyChange(PROP_CANVASES, old, canvases);
    }

    public Canvas getCanvases(int index) {
        return this.canvases.get(index);
    }

    public void setCanvases(int index, Canvas newCanvas) {
        Canvas old = this.canvases.get(index);
        this.canvases.set(index, newCanvas);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_PLOTS, index, old, newCanvas);
    }

    public ApplicationController getController() {
        return this.controller;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(DatumRange timeRange) {
        if (timeRange == null) {
            throw new IllegalArgumentException("timeRange set to null");
        }
        DatumRange oldTimeRange = this.timeRange;
        this.timeRange = timeRange;
        this.propertyChangeSupport.firePropertyChange(PROP_TIMERANGE, oldTimeRange, timeRange);
    }

    public BindingModel[] getBindings() {
        BindingModel[] result = this.bindings.toArray(new BindingModel[this.bindings.size()]);
        return result;
    }

    public void setBindings(BindingModel[] bindings) {
        BindingModel[] oldBindings = this.getBindings();
        this.bindings = Arrays.asList(bindings);
        this.propertyChangeSupport.firePropertyChange(PROP_BINDINGS, oldBindings, bindings);
    }

    public BindingModel getBindings(int index) {
        return this.bindings.get(index);
    }

    public void setBindings(int index, BindingModel newBinding) {
        BindingModel oldBinding = this.bindings.get(index);
        this.bindings.set(index, newBinding);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_BINDINGS, index, oldBinding, newBinding);
    }

    public Connector[] getConnectors() {
        Connector[] result = this.connectors.toArray(new Connector[this.connectors.size()]);
        return result;
    }

    public void setConnectors(Connector[] connectors) {
        Connector[] oldConnectors = this.getConnectors();
        this.connectors = Arrays.asList(connectors);
        this.propertyChangeSupport.firePropertyChange(PROP_CONNECTORS, oldConnectors, connectors);
    }

    public Connector getConnectors(int index) {
        return this.connectors.get(index);
    }

    public void setConnectors(int index, Connector newConnector) {
        Connector oldConnector = this.connectors.get(index);
        this.connectors.set(index, newConnector);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_CONNECTORS, index, oldConnector, newConnector);
    }

    @Override
    public DomNode copy() {
        Application result = (Application)super.copy();
        result.controller = null;
        result.options = (Options)this.getOptions().copy();
        DataSourceFilter[] DataSourceFiltersCopy = this.getDataSourceFilters();
        for (int i = 0; i < DataSourceFiltersCopy.length; ++i) {
            DataSourceFiltersCopy[i] = (DataSourceFilter)DataSourceFiltersCopy[i].copy();
        }
        result.setDataSourceFilters(DataSourceFiltersCopy);
        Plot[] plotsCopy = this.getPlots();
        for (int i = 0; i < plotsCopy.length; ++i) {
            plotsCopy[i] = (Plot)plotsCopy[i].copy();
        }
        result.setPlots(plotsCopy);
        PlotElement[] peleCopy = this.getPlotElements();
        for (int i = 0; i < peleCopy.length; ++i) {
            peleCopy[i] = (PlotElement)peleCopy[i].copy();
        }
        result.setPlotElements(peleCopy);
        Connector[] connectorsCopy = this.getConnectors();
        System.arraycopy(connectorsCopy, 0, connectorsCopy, 0, connectorsCopy.length);
        result.setConnectors(connectorsCopy);
        Canvas[] canvasesCopy = this.getCanvases();
        for (int i = 0; i < canvasesCopy.length; ++i) {
            canvasesCopy[i] = (Canvas)canvasesCopy[i].copy();
        }
        result.setCanvases(canvasesCopy);
        return result;
    }

    @Override
    public List<DomNode> childNodes() {
        ArrayList<DomNode> result = new ArrayList<DomNode>();
        result.addAll(this.plots);
        result.addAll(this.plotElements);
        result.addAll(this.dataSourceFilters);
        result.addAll(this.canvases);
        result.add(this.options);
        return result;
    }

    @Override
    public void syncTo(DomNode n) {
        this.syncTo(n, new ArrayList<String>());
    }

    @Override
    public void syncTo(DomNode n, List<String> exclude) {
        super.syncTo(n, exclude);
        if (this.controller != null) {
            this.controller.syncTo((Application)n, exclude);
        }
    }

    private void addArrayDiffs(String property, Object[] thata, Object[] thisa, List<Diff> result) {
        int i;
        if (thata.length > thisa.length) {
            for (i = thata.length - 1; i >= thisa.length; --i) {
                result.add(new ArrayNodeDiff(property, ArrayNodeDiff.Action.Delete, thata[i], i));
            }
        }
        if (thata.length < thisa.length) {
            for (i = thisa.length - 1; i < thisa.length; ++i) {
                result.add(new ArrayNodeDiff(property, ArrayNodeDiff.Action.Insert, thisa[i], i));
            }
        }
    }

    @Override
    public List<Diff> diffs(DomNode node) {
        int i;
        Application that = (Application)node;
        ArrayList<Diff> result = new ArrayList<Diff>();
        this.addArrayDiffs(PROP_DATASOURCEFILTERS, this.getDataSourceFilters(), that.getDataSourceFilters(), result);
        this.addArrayDiffs(PROP_PLOT_ELEMENTS, this.getPlotElements(), that.getPlotElements(), result);
        this.addArrayDiffs(PROP_PLOTS, this.getPlots(), that.getPlots(), result);
        this.addArrayDiffs(PROP_CANVASES, this.getCanvases(), that.getCanvases(), result);
        this.addArrayDiffs(PROP_BINDINGS, this.getBindings(), that.getBindings(), result);
        this.addArrayDiffs(PROP_CONNECTORS, this.getConnectors(), that.getConnectors(), result);
        for (i = 0; i < Math.min(this.dataSourceFilters.size(), that.dataSourceFilters.size()); ++i) {
            DataSourceFilter thisDataSourceFilter = this.dataSourceFilters.get(i);
            DataSourceFilter thatDataSourceFilter = that.dataSourceFilters.get(i);
            result.addAll(DomUtil.childDiffs("dataSourceFilters[" + i + "]", thatDataSourceFilter.diffs(thisDataSourceFilter)));
        }
        for (i = 0; i < Math.min(this.canvases.size(), that.canvases.size()); ++i) {
            Canvas thisCanvas = this.canvases.get(i);
            Canvas thatCanvas = that.canvases.get(i);
            result.addAll(DomUtil.childDiffs("Canvases[" + i + "]", thatCanvas.diffs(thisCanvas)));
        }
        for (i = 0; i < Math.min(this.plots.size(), that.plots.size()); ++i) {
            Plot thisPlot = this.plots.get(i);
            Plot thatPlot = that.plots.get(i);
            result.addAll(DomUtil.childDiffs("plots[" + i + "]", thatPlot.diffs(thisPlot)));
        }
        for (i = 0; i < Math.min(this.plotElements.size(), that.plotElements.size()); ++i) {
            result.addAll(DomUtil.childDiffs("plotElements[" + i + "]", that.getPlotElements(i).diffs(this.plotElements.get(i))));
        }
        result.addAll(DomUtil.childDiffs("options", this.getOptions().diffs(that.getOptions())));
        if (!that.timeRange.equals(this.timeRange)) {
            result.add(new PropertyChangeDiff(PROP_TIMERANGE, this.timeRange, that.timeRange));
        }
        return result;
    }
}

