/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.Axis;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomNodeController;
import org.virbo.autoplot.dom.Plot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisController
extends DomNodeController {
    DasAxis dasAxis;
    private Application dom;
    Plot plot;
    Axis axis;
    private static final Object PENDING_RANGE_TWEAK = "pendingRangeTweak";
    private PropertyChangeListener rangeChangeListener = new PropertyChangeListener(){

        private DatumRange logCheckRange(DatumRange range, boolean log) {
            Units u = range.getUnits();
            double dmin = range.min().doubleValue(u);
            double dmax = range.max().doubleValue(u);
            boolean changed = false;
            if (log && dmax <= 0.0) {
                dmax = 1000.0;
                changed = true;
            }
            if (log && dmin <= 0.0) {
                dmin = dmax / 10000.0;
                changed = true;
            }
            if (changed) {
                return new DatumRange(dmin, dmax, u);
            }
            return range;
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            if (((AxisController)AxisController.this).dom.controller.isValueAdjusting() || AxisController.this.valueIsAdjusting()) {
                return;
            }
            if (evt.getPropertyName().equals("range") || evt.getPropertyName().equals("log")) {
                AxisController.this.axis.setAutoRange(false);
            }
            if (evt.getPropertyName().equals("label")) {
                AxisController.this.axis.setAutoLabel(false);
            }
            if (evt.getPropertyName().equals("log") || evt.getPropertyName().equals("range")) {
                if (AxisController.this.isPendingChanges()) {
                    return;
                }
                DatumRange oldRange = AxisController.this.axis.range;
                DatumRange range = this.logCheckRange(AxisController.this.axis.range, AxisController.this.axis.log);
                if (!range.equals(oldRange)) {
                    AxisController.this.changesSupport.registerPendingChange(this, PENDING_RANGE_TWEAK);
                    AxisController.this.changesSupport.performingChange(this, PENDING_RANGE_TWEAK);
                    AxisController.this.axis.setRange(range);
                    AxisController.this.changesSupport.changePerformed(this, PENDING_RANGE_TWEAK);
                }
            }
        }
    };

    public AxisController(Application dom, Plot plot, Axis axis, DasAxis dasAxis) {
        super(axis);
        this.dom = dom;
        this.dasAxis = dasAxis;
        this.plot = plot;
        this.axis = axis;
        axis.controller = this;
        this.bindTo(dasAxis);
        axis.addPropertyChangeListener(this.rangeChangeListener);
    }

    public boolean valueIsAdjusting() {
        return super.isValueAdjusting() || this.dasAxis.valueIsAdjusting();
    }

    public void setRangeAutomatically(DatumRange range, boolean log) {
        this.axis.range = range;
        this.axis.log = log;
        this.axis.setRange(range);
        this.axis.setLog(log);
        this.axis.setAutoRange(true);
    }

    public void setLabelAutomatically(String label) {
        this.axis.setLabel(label);
        this.axis.setAutoLabel(true);
    }

    public final synchronized void bindTo(DasAxis p) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.axis, "range", p, "datumRange");
        ac.bind(this.axis, "log", p, "log");
        ac.bind(this.axis, "label", p, "label", this.plot.getController().labelContextConverter(this.axis));
        ac.bind(this.axis, "drawTickLabels", p, "tickLabelsVisible");
        ac.bind(this.axis, "visible", p, "visible");
    }

    public DasAxis getDasAxis() {
        return this.dasAxis;
    }

    void syncTo(DomNode n, List<String> exclude) {
        DasAxis.Lock lock = null;
        if (this.dasAxis != null) {
            lock = this.dasAxis.mutatorLock();
            lock.lock();
        }
        Axis that = (Axis)n;
        if (!exclude.contains("log")) {
            this.axis.setLog(that.isLog());
        }
        if (!exclude.contains("range")) {
            this.axis.setRange(that.getRange());
        }
        if (!exclude.contains("label")) {
            this.axis.setLabel(that.getLabel());
        }
        if (!exclude.contains("autoRange")) {
            this.axis.setAutoRange(that.isAutoRange());
        }
        if (!exclude.contains("autoLabel")) {
            this.axis.setAutoLabel(that.isAutoLabel());
        }
        if (!exclude.contains("drawTickLabels")) {
            this.axis.setDrawTickLabels(that.isDrawTickLabels());
        }
        if (!exclude.contains("visible")) {
            this.axis.setVisible(that.isVisible());
        }
        if (lock != null) {
            lock.unlock();
        }
    }
}

