/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.virbo.autoplot.dom.DebugPropertyChangeSupport;
import org.virbo.autoplot.dom.Diff;
import org.virbo.autoplot.dom.PropertyChangeDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomNode
implements Cloneable {
    protected String id = "";
    public static final String PROP_ID = "id";
    protected PropertyChangeSupport propertyChangeSupport = new DebugPropertyChangeSupport(this);

    public DomNode copy() {
        try {
            DomNode result = (DomNode)this.clone();
            result.propertyChangeSupport = new DebugPropertyChangeSupport(result);
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void syncTo(DomNode n) {
        this.id = n.id;
    }

    public void syncTo(DomNode n, List<String> exclude) {
        if (!exclude.contains(PROP_ID)) {
            this.id = n.id;
        }
    }

    public List<DomNode> childNodes() {
        return Collections.emptyList();
    }

    public List<Diff> diffs(DomNode that) {
        ArrayList<Diff> result = new ArrayList<Diff>();
        boolean b = that.id.equals(this.id);
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_ID, that.id, this.id));
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String oldId = this.id;
        this.id = id;
        this.propertyChangeSupport.firePropertyChange(PROP_ID, oldId, id);
    }

    public String toString() {
        return this.id;
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }
}

