/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.awt.Color;
import java.awt.Font;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.beans.BeansUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.jdesktop.beansbinding.Converter;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ArrayNodeDiff;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.ChangesSupport;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.Diff;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.PropertyChangeDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomUtil {
    public static final Converter STRING_TO_FONT = new Converter(){

        public Object convertForward(Object value) {
            return Font.decode((String)value);
        }

        public Object convertReverse(Object value) {
            return DomUtil.encodeFont((Font)value);
        }
    };
    public static final Converter STRING_TO_COLOR = new Converter(){

        public Object convertForward(Object value) {
            return Color.decode((String)value);
        }

        public Object convertReverse(Object value) {
            return DomUtil.encodeColor((Color)value);
        }
    };
    public static final Converter AUTO_TO_COLOR = new Converter(){

        public Object convertForward(Object value) {
            boolean b = (Boolean)value;
            return b ? Color.WHITE : Color.LIGHT_GRAY;
        }

        public Object convertReverse(Object value) {
            return Color.WHITE.equals(value);
        }
    };

    public static String abbreviateRight(String s, int len) {
        if (s == null) {
            return "<null>";
        }
        if (s.length() > len) {
            s = "..." + s.substring(s.length() - len);
        }
        return s;
    }

    static List<String> childProperties(List<String> exclude, String string) {
        ArrayList<String> result = new ArrayList<String>();
        int n = string.length() + 1;
        for (String e : exclude) {
            if (!e.startsWith(string + ".")) continue;
            result.add(e.substring(n));
        }
        return result;
    }

    static List<DomNode> dataSourceUsages(Application app, String id) {
        ArrayList<DomNode> result = new ArrayList<DomNode>();
        for (PlotElement plotElement : app.getPlotElements()) {
            if (!plotElement.getDataSourceFilterId().equals(id)) continue;
            result.add(plotElement);
        }
        for (DomNode domNode : app.getDataSourceFilters()) {
            for (DataSourceFilter dsfp : ((DataSourceFilter)domNode).getController().getParentSources()) {
                if (dsfp == null || !dsfp.getId().equals(id)) continue;
                result.add(domNode);
            }
        }
        return result;
    }

    private static Object setGetPropertyInt(DomNode node, String propertyName, boolean setit, boolean getClass, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String[] props = propertyName.split("\\.", -2);
        Pattern indexedPattern = Pattern.compile("([a-zA-Z_]+)\\[(\\d+)\\]");
        Object thisNode = node;
        Object result = null;
        block0: for (int iprop = 0; iprop < props.length; ++iprop) {
            String name;
            String prop1 = props[iprop];
            Matcher m = indexedPattern.matcher(prop1);
            PropertyDescriptor[] pds = BeansUtil.getPropertyDescriptors(thisNode.getClass());
            if (m.matches()) {
                name = m.group(1);
                int idx = Integer.valueOf(m.group(2));
                for (int i = 0; i < pds.length; ++i) {
                    if (!pds[i].getName().equals(name)) continue;
                    Object thisValue = ((IndexedPropertyDescriptor)pds[i]).getIndexedReadMethod().invoke(thisNode, idx);
                    if (iprop == props.length - 1) {
                        if (setit) {
                            ((IndexedPropertyDescriptor)pds[i]).getIndexedWriteMethod().invoke(thisNode, idx, value);
                        } else {
                            if (getClass) {
                                return ((IndexedPropertyDescriptor)pds[i]).getPropertyType();
                            }
                            return thisValue;
                        }
                    }
                    thisNode = thisValue;
                    continue block0;
                }
                continue;
            }
            name = prop1;
            for (int i = 0; i < pds.length; ++i) {
                if (!pds[i].getName().equals(name)) continue;
                Object thisValue = pds[i].getReadMethod().invoke(thisNode, new Object[0]);
                if (iprop == props.length - 1) {
                    if (setit) {
                        pds[i].getWriteMethod().invoke(thisNode, value);
                    } else {
                        if (getClass) {
                            return pds[i].getPropertyType();
                        }
                        return thisValue;
                    }
                }
                thisNode = thisValue;
                continue block0;
            }
        }
        if (!setit && result == null) {
            throw new IllegalArgumentException("unable to find property \"" + propertyName + "\" in " + node);
        }
        return result;
    }

    public static Object getPropertyValue(DomNode node, String propertyName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return DomUtil.setGetPropertyInt(node, propertyName, false, false, null);
    }

    public static void setPropertyValue(DomNode node, String propertyName, Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        DomUtil.setGetPropertyInt(node, propertyName, true, false, val);
    }

    public static Class getPropertyType(DomNode node, String propertyName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Class)DomUtil.setGetPropertyInt(node, propertyName, false, true, null);
    }

    static List<DomNode> rowUsages(Application app, String rowId) {
        ArrayList<DomNode> result = new ArrayList<DomNode>();
        for (Plot p : app.getPlots()) {
            if (!p.getRowId().equals(rowId)) continue;
            result.add(p);
        }
        return result;
    }

    private static DatumRange round(DatumRange range) {
        Datum w0;
        Datum w = range.width();
        Datum base = w0 = DatumUtil.asOrderOneUnits(w);
        Units hu = w0.getUnits();
        base = range.getUnits().isConvertableTo(Units.us2000) ? TimeUtil.prevMidnight(range.min()) : w.getUnits().createDatum(0);
        double min10 = Math.round(range.min().subtract(base).doubleValue(w0.getUnits()));
        double max10 = Math.round(range.max().subtract(base).doubleValue(w0.getUnits()));
        return new DatumRange(base.add(Datum.create(min10, hu)), base.add(Datum.create(max10, hu)));
    }

    public static String describe(DatumRange init, DatumRange fin) {
        if (init.getUnits().isConvertableTo(fin.getUnits())) {
            String scaleString = "";
            if (UnitsUtil.isTimeLocation(fin.getUnits())) {
                Datum scale = DatumUtil.asOrderOneUnits(DomUtil.round(fin).width());
                scaleString = " to " + scale;
            }
            if (init.contains(fin)) {
                return "zoom in" + scaleString;
            }
            if (fin.contains(init)) {
                return "zoom out" + scaleString;
            }
            if (init.intersects(fin)) {
                return "pan";
            }
            return "scan";
        }
        return "" + DomUtil.round(init) + " -> " + DomUtil.round(fin);
    }

    public static Object parseObject(Object context, String s) {
        PropertyEditor edit = BeansUtil.findEditor(context.getClass());
        if (edit == null) {
            return context;
        }
        edit.setValue(context);
        edit.setAsText(s);
        Object result = edit.getValue();
        return result;
    }

    public static String formatObject(Object obj) {
        PropertyEditor edit = BeansUtil.findEditor(obj.getClass());
        if (edit == null) {
            return "";
        }
        edit.setValue(obj);
        String result = edit.getAsText();
        return result;
    }

    public static DomNode getElementById(DomNode root, String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (id.equals("")) {
            throw new IllegalArgumentException("id be zero-length string");
        }
        if (root.getId().equals(id)) {
            return root;
        }
        for (DomNode n : root.childNodes()) {
            if (n.getId().equals(id)) {
                return n;
            }
            DomNode nn = DomUtil.getElementById(n, id);
            if (nn == null) continue;
            return nn;
        }
        return null;
    }

    public static List<DomNode> findElementsById(DomNode root, String regex) {
        Pattern p = Pattern.compile(regex);
        if (regex == null || regex.equals("")) {
            throw new IllegalArgumentException("id cannot be null or zero-length string");
        }
        ArrayList<DomNode> result = new ArrayList<DomNode>();
        if (p.matcher(root.getId()).matches()) {
            result.add(root);
        }
        for (DomNode n : root.childNodes()) {
            if (p.matcher(n.getId()).matches()) {
                result.add(n);
            }
            result.addAll(DomUtil.findElementsById(n, regex));
        }
        return result;
    }

    public static <T> ArrayList<T> asArrayList(T ... a) {
        return new ArrayList<T>(Arrays.asList(a));
    }

    public static Diff childDiff(String childName, Diff diff) {
        if (diff instanceof PropertyChangeDiff) {
            PropertyChangeDiff pcd = (PropertyChangeDiff)diff;
            return new PropertyChangeDiff(childName + "." + pcd.propertyName, pcd.oldVal, pcd.newVal);
        }
        if (diff instanceof ArrayNodeDiff) {
            ArrayNodeDiff d = (ArrayNodeDiff)diff;
            return new ArrayNodeDiff(childName + "." + d.propertyName, d.action, d.node, d.index, d.toIndex);
        }
        return null;
    }

    public static List<Diff> childDiffs(String childName, List<Diff> diffs) {
        ArrayList<Diff> result = new ArrayList<Diff>();
        for (Diff diff : diffs) {
            Diff r1 = DomUtil.childDiff(childName, diff);
            if (r1 == null) continue;
            result.add(r1);
        }
        return result;
    }

    public static int indexOf(List<Object> nodes, Object node) {
        boolean isDomNode = node instanceof DomNode;
        if (!isDomNode) {
            return nodes.indexOf(node);
        }
        for (int i = 0; i < nodes.size(); ++i) {
            DomNode n1 = (DomNode)nodes.get(i);
            if (n1 == node) {
                return i;
            }
            String id = n1.getId();
            if (id.equals("") || !id.equals(((DomNode)node).id)) continue;
            return i;
        }
        return -1;
    }

    public static List<Diff> getArrayDiffs(String property, Object[] nodes1, Object[] nodes2) {
        int i;
        LinkedList<Diff> result = new LinkedList<Diff>();
        ArrayList<Object> node1List = new ArrayList<Object>(Arrays.asList(nodes1));
        ArrayList<Object> node2List = new ArrayList<Object>(Arrays.asList(nodes2));
        ArrayList<Object> deleteList = new ArrayList<Object>();
        int i2 = 0;
        for (Object o : nodes2) {
            if (DomUtil.indexOf(node2List, o) != i2) {
                deleteList.add(o);
                new IllegalArgumentException("two nodes have the same ID: " + o).printStackTrace();
            }
            ++i2;
        }
        for (Object o : nodes2) {
            if (DomUtil.indexOf(node1List, o) != -1) continue;
            deleteList.add(o);
        }
        boolean isDomNode = DomNode.class.isAssignableFrom(nodes1.getClass().getComponentType());
        for (int i3 = 0; i3 < deleteList.size(); ++i3) {
            int idx = DomUtil.indexOf(node2List, deleteList.get(i3));
            result.add(new ArrayNodeDiff(property, ArrayNodeDiff.Action.Delete, node2List.get(idx), idx));
            node2List.remove(idx);
        }
        ArrayList<Object> addList = new ArrayList<Object>();
        for (Object o : nodes1) {
            if (DomUtil.indexOf(node2List, o) != -1) continue;
            addList.add(o);
        }
        for (i = 0; i < addList.size(); ++i) {
            int idx = -1;
            idx = DomUtil.indexOf(node1List, addList.get(i));
            if (nodes1[idx] instanceof DomNode) {
                result.add(new ArrayNodeDiff(property, ArrayNodeDiff.Action.Insert, ((DomNode)nodes1[idx]).copy(), idx));
            } else {
                result.add(new ArrayNodeDiff(property, ArrayNodeDiff.Action.Insert, nodes1[idx], idx));
            }
            node2List.add(idx, nodes1[idx]);
        }
        if (isDomNode) {
            for (i = 0; i < node1List.size(); ++i) {
                result.addAll(DomUtil.childDiffs(property + "[" + i + "]", DomUtil.getDiffs((DomNode)node1List.get(i), (DomNode)node2List.get(i))));
            }
        }
        return result;
    }

    public static List<Diff> getDiffs(DomNode node1, DomNode node2) {
        return DomUtil.getDiffs(node1, node2, null);
    }

    public static List<Diff> getDiffs(DomNode node1, DomNode node2, List<String> exclude) {
        String[] props = BeansUtil.getPropertyNames(node1.getClass());
        PropertyDescriptor[] pds = BeansUtil.getPropertyDescriptors(node1.getClass());
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].equals("controller") || exclude != null && exclude.contains(props[i])) continue;
            try {
                Object val1 = pds[i].getReadMethod().invoke((Object)node1, new Object[0]);
                Object val2 = pds[i].getReadMethod().invoke((Object)node2, new Object[0]);
                if (pds[i] instanceof IndexedPropertyDescriptor) {
                    diffs.addAll(DomUtil.getArrayDiffs(props[i], (DomNode[])val1, (DomNode[])val2));
                    continue;
                }
                if (DomNode.class.isAssignableFrom(pds[i].getReadMethod().getReturnType())) {
                    diffs.addAll(DomUtil.childDiffs(props[i], ((DomNode)val1).diffs((DomNode)val2)));
                    continue;
                }
                if (val1 == val2 || val1 != null && val1.equals(val2)) continue;
                diffs.add(new PropertyChangeDiff(props[i], val2, val1));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return diffs;
    }

    public static void syncTo(DomNode node1, DomNode node2) {
        List<Diff> diffs = node2.diffs(node1);
        for (Diff d : diffs) {
            d.doDiff(node1);
        }
    }

    public static void syncTo(DomNode node1, DomNode node2, List<String> exclude) {
        List<Diff> diffs = node2.diffs(node1);
        for (Diff d : diffs) {
            if (exclude.contains(d.propertyName())) continue;
            d.doDiff(node1);
        }
    }

    public static String encodeColor(Color c) {
        return "#" + Integer.toHexString(c.getRGB() & 0xFFFFFF);
    }

    public static String encodeFont(Font f) {
        String style = "-";
        if (f.isBold()) {
            style = style + "bold";
        }
        if (f.isItalic()) {
            style = style + "italic";
        }
        String result = f.getFamily();
        if (style.length() > 1) {
            result = result + style;
        }
        return result + "-" + f.getSize();
    }

    public static boolean oneFamily(List<PlotElement> elementsIn) {
        if (elementsIn.size() == 0) {
            return false;
        }
        ArrayList<PlotElement> elements = new ArrayList<PlotElement>(elementsIn);
        PlotElement pe = (PlotElement)elements.get(0);
        if (pe.getController().getParentPlotElement() != null) {
            pe = pe.getController().getParentPlotElement();
        }
        elements.remove(pe);
        elements.removeAll(pe.getController().getChildPlotElements());
        return elements.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateDom(Application application, List<String> problems) {
        ChangesSupport.DomLock lock = null;
        if (application.getController() != null) {
            lock = application.getController().mutatorLock();
            lock.lock("Validate DOM");
        }
        try {
            DomNode p;
            int i;
            for (i = 0; i < application.getBindings().length; ++i) {
                BindingModel b = application.getBindings(i);
                if (DomUtil.getElementById(application, b.getSrcId()) == null) {
                    problems.add("unable to find source " + b.getSrcId() + " for binding " + i);
                }
                if (DomUtil.getElementById(application, b.getDstId()) != null) continue;
                problems.add("unable to find dest " + b.getSrcId() + " for binding " + i);
            }
            for (i = 0; i < application.getDataSourceFilters().length; ++i) {
                DataSourceFilter dsf = application.getDataSourceFilters(i);
                String uri = dsf.getUri();
                if (uri == null || !uri.startsWith("vap+internal:") || uri.length() <= 13) continue;
                String[] dep = uri.substring(13).split(",");
                for (int j = 0; j < dep.length; ++j) {
                    if (DomUtil.getElementById(application, dep[j]) != null) continue;
                    problems.add("unable to find dsf " + dep[j] + " for dsf " + dsf.getId());
                }
            }
            for (i = 0; i < application.getPlotElements().length; ++i) {
                p = application.getPlotElements(i);
                if (DomUtil.getElementById(application, ((PlotElement)p).getPlotId()) == null) {
                    problems.add("unable to find plot " + ((PlotElement)p).getPlotId() + " for plot element " + p.getId());
                }
                if (DomUtil.getElementById(application, ((PlotElement)p).getDataSourceFilterId()) != null) continue;
                problems.add("unable to find data " + ((PlotElement)p).getDataSourceFilterId() + " for plot element " + p.getId());
            }
            for (i = 0; i < application.getPlots().length; ++i) {
                p = application.getPlots(i);
                if (DomUtil.getElementById(application, ((Plot)p).getRowId()) == null) {
                    problems.add("unable to find row " + ((Plot)p).getRowId() + " for plot " + p.getId());
                }
                if (DomUtil.getElementById(application, ((Plot)p).getColumnId()) != null) continue;
                problems.add("unable to find column " + ((Plot)p).getColumnId() + " for plot  " + p.getId());
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return problems.size() == 0;
    }

    public static boolean structureChanges(Application dom, Application state) {
        if (dom.bindings.size() != state.bindings.size()) {
            return true;
        }
        if (dom.connectors.size() != state.connectors.size()) {
            return true;
        }
        if (dom.dataSourceFilters.size() != state.dataSourceFilters.size()) {
            return true;
        }
        if (dom.plots.size() != state.plots.size()) {
            return true;
        }
        if (dom.plotElements.size() != state.plotElements.size()) {
            return true;
        }
        for (int i = 0; i < dom.plots.size(); ++i) {
            Plot pd = dom.plots.get(i);
            Plot ps = state.plots.get(i);
            if (!pd.getXaxis().getRange().getUnits().isConvertableTo(ps.getXaxis().getRange().getUnits())) {
                return true;
            }
            if (!pd.getYaxis().getRange().getUnits().isConvertableTo(ps.getYaxis().getRange().getUnits())) {
                return true;
            }
            if (pd.getZaxis().getRange().getUnits().isConvertableTo(ps.getZaxis().getRange().getUnits())) continue;
            return true;
        }
        return false;
    }

    public static List<PlotElement> getPlotElementsFor(Application application, Plot plot) {
        String id = plot.getId();
        ArrayList<PlotElement> result = new ArrayList<PlotElement>();
        for (PlotElement p : application.getPlotElements()) {
            if (!p.getPlotId().equals(id)) continue;
            result.add(p);
        }
        return result;
    }

    public static boolean nodeHasProperty(DomNode node1, String property) {
        String[] props = BeansUtil.getPropertyNames(node1.getClass());
        PropertyDescriptor[] pds = BeansUtil.getPropertyDescriptors(node1.getClass());
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].equals(property)) continue;
            return true;
        }
        return false;
    }
}

