/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.BoxZoomMouseModule;
import org.das2.event.ZoomPanMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.jdesktop.beansbinding.Converter;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.RenderTypeUtil;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.Axis;
import org.virbo.autoplot.dom.AxisController;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.Canvas;
import org.virbo.autoplot.dom.ChangesSupport;
import org.virbo.autoplot.dom.Column;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DomNodeController;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.Row;
import org.virbo.autoplot.util.DateTimeDatumFormatter;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotController
extends DomNodeController {
    Application dom;
    Plot plot;
    private DasPlot dasPlot;
    private DasColorBar dasColorBar;
    public List<PlotElement> pdListen = new LinkedList<PlotElement>();
    private static final Logger logger = Logger.getLogger(PlotController.class.getName());
    public PropertyChangeListener rowColListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (PlotController.this.dasPlot != null && evt.getPropertyName().equals("rowId")) {
                Row row;
                String id = (String)evt.getNewValue();
                Row row2 = row = id.length() == 0 ? null : (Row)DomUtil.getElementById(PlotController.this.dom, id);
                if (row == null) {
                    row = PlotController.this.dom.controller.getCanvas().marginRow;
                }
                DasRow dasRow = row.controller.getDasRow();
                PlotController.this.dasPlot.setRow(dasRow);
                PlotController.this.plot.getXaxis().getController().getDasAxis().setRow(dasRow);
                PlotController.this.plot.getYaxis().getController().getDasAxis().setRow(dasRow);
                PlotController.this.plot.getZaxis().getController().getDasAxis().setRow(dasRow);
            } else if (PlotController.this.dasPlot != null && evt.getPropertyName().equals("columnId")) {
                Column col;
                String id = (String)evt.getNewValue();
                Column column = col = id.length() == 0 ? null : (Column)DomUtil.getElementById(PlotController.this.dom, id);
                if (col == null) {
                    col = PlotController.this.dom.controller.getCanvas().marginColumn;
                }
                DasColumn dasColumn = col.controller.getDasColumn();
                PlotController.this.dasPlot.setColumn(dasColumn);
                PlotController.this.plot.getXaxis().getController().getDasAxis().setColumn(dasColumn);
                PlotController.this.plot.getYaxis().getController().getDasAxis().setColumn(dasColumn);
                DasColumn c = DasColorBar.getColorBarColumn(dasColumn);
                PlotController.this.dasColorBar.setColumn(c);
            }
        }
    };
    public static final String PROP_AUTOBINDING = "autoBinding";
    protected boolean autoBinding = true;
    private PropertyChangeListener labelListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("title")) {
                PlotController.this.plot.setAutoLabel(false);
            }
        }
    };
    private PropertyChangeListener ticksURIListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ticksURI")) {
                if (((String)evt.getNewValue()).length() > 0) {
                    String dasAddress = "class:org.autoplot.tca.UriTcaSource:" + evt.getNewValue();
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDataPath(dasAddress);
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDrawTca(true);
                    PlotController.this.plot.getXaxis().setLabel("%{RANGE}");
                } else {
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDataPath("");
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDrawTca(false);
                    PlotController.this.plot.getXaxis().setLabel("");
                }
            }
        }
    };
    private PropertyChangeListener listener = new PropertyChangeListener(){

        public String toString() {
            return "" + PlotController.this;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() instanceof DasAxis) {
                DasAxis axis = (DasAxis)e.getSource();
                Axis domAxis = PlotController.this.getDomAxis(axis);
                if (domAxis == null) {
                    return;
                }
                if ((e.getPropertyName().equals("units") || e.getPropertyName().equals("datumRange")) && axis.getDrawTca() && domAxis.getLabel().length() == 0) {
                    domAxis.setLabel("%{RANGE}");
                }
                if (e.getPropertyName().equals("units") || e.getPropertyName().equals("datumRange") || e.getPropertyName().equals("label")) {
                    PlotController.this.updateAxisFormatter(axis);
                }
                if (((DasAxis)e.getSource()).valueIsAdjusting()) {
                    return;
                }
                if (PlotController.this.plot.isIsotropic()) {
                    PlotController.this.checkIsotropic(axis);
                }
            } else if (e.getPropertyName().equals("focusRenderer")) {
                List<PlotElement> eles = PlotController.this.dom.controller.getPlotElementsFor(PlotController.this.plot);
                PlotElement fe = null;
                for (PlotElement ele : eles) {
                    if (ele.getController().getRenderer() != e.getNewValue()) continue;
                    fe = ele;
                }
                if (fe != null) {
                    PlotController.this.dom.controller.setPlotElement(fe);
                }
            }
        }
    };
    PropertyChangeListener plotDefaultsListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            PlotElement pele = (PlotElement)evt.getSource();
            List<PlotElement> pp = PlotController.this.dom.getController().getPlotElementsFor(PlotController.this.plot);
            if (!pp.contains(pele)) {
                System.err.println("Plot " + PlotController.this.plot + "doesn't contain the source plotElement " + PlotController.this.plotElement + " see bug 2992903");
                return;
            }
            pp.remove(pele);
            if (pele.isAutoRenderType() && pp.size() == 0) {
                PlotController.this.setAutoBinding(true);
            }
            PlotController.this.doPlotElementDefaultsChange(pele);
        }
    };
    PropertyChangeListener renderTypeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            PlotController.this.checkRenderType();
        }
    };
    PlotElement plotElement;
    private PropertyChangeListener plotElementDataSetListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String title;
            String shortContextStr;
            String contextStr;
            QDataSet pds = PlotController.this.plotElement.getController().getDataSet();
            if (pds != null) {
                String[] ss;
                shortContextStr = contextStr = DataSetUtil.contextAsString((QDataSet)pds);
                if (!contextStr.equals("") && (ss = contextStr.split("=")).length == 2) {
                    shortContextStr = ss[1];
                }
            } else {
                contextStr = "";
                shortContextStr = "";
            }
            if (PlotController.this.plot.getTitle().contains("CONTEXT")) {
                title = DomNodeController.insertString(PlotController.this.plot.getTitle(), "CONTEXT", contextStr);
                PlotController.this.dasPlot.setTitle(title);
            }
            if (PlotController.this.plot.getYaxis().getLabel().contains("CONTEXT")) {
                title = DomNodeController.insertString(PlotController.this.plot.getYaxis().getLabel(), "CONTEXT", shortContextStr);
                PlotController.this.dasPlot.getYAxis().setLabel(title);
            }
            if (PlotController.this.plot.getXaxis().getLabel().contains("CONTEXT")) {
                title = DomNodeController.insertString(PlotController.this.plot.getXaxis().getLabel(), "CONTEXT", shortContextStr);
                PlotController.this.dasPlot.getXAxis().setLabel(title);
            }
        }
    };
    Converter contextConverter = new Converter(){

        public Object convertForward(Object value) {
            String title = (String)value;
            if (title.contains("%{CONTEXT}")) {
                QDataSet ds;
                String contextStr = "";
                if (PlotController.this.plotElement != null && PlotController.this.plotElement.getController() != null && (ds = PlotController.this.plotElement.getController().getDataSet()) != null) {
                    contextStr = DataSetUtil.contextAsString((QDataSet)ds);
                }
                title = title.replaceAll("%\\{CONTEXT\\}", contextStr);
            }
            return title;
        }

        public Object convertReverse(Object value) {
            String[] ss;
            String title = (String)value;
            String ptitle = PlotController.this.plot.getTitle();
            if (ptitle.contains("%{CONTEXT}") && title.startsWith((ss = ptitle.split("%\\{CONTEXT\\}", -2))[0]) && title.endsWith(ss[1])) {
                return ptitle;
            }
            return title;
        }
    };
    protected JMenuItem plotElementPropsMenuItem = null;
    public static final String PROP_PLOTELEMENTPROPSMENUITEM = "plotElementPropsMenuItem";
    private JMenuItem[] expertMenuItems;

    public PlotController(Application dom, Plot domPlot, DasPlot dasPlot, DasColorBar colorbar) {
        this(dom, domPlot);
        this.dasPlot = dasPlot;
        this.dasColorBar = colorbar;
        dasPlot.addPropertyChangeListener(this.listener);
        dasPlot.getXAxis().addPropertyChangeListener(this.listener);
        dasPlot.getYAxis().addPropertyChangeListener(this.listener);
    }

    public PlotController(Application dom, Plot plot) {
        super(plot);
        this.dom = dom;
        this.plot = plot;
        this.plot.addPropertyChangeListener("isotropic", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (PlotController.this.plot.isIsotropic()) {
                    PlotController.this.checkIsotropic(null);
                }
            }
        });
        this.plot.addPropertyChangeListener("title", this.labelListener);
        this.plot.addPropertyChangeListener("ticksURI", this.ticksURIListener);
        dom.options.addPropertyChangeListener("dayOfYear", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DasAxis update = PlotController.this.plot.getXaxis().controller.dasAxis;
                PlotController.this.updateAxisFormatter(update);
            }
        });
        plot.controller = this;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public boolean isAutoBinding() {
        return this.autoBinding;
    }

    public void setAutoBinding(boolean autoBinding) {
        boolean oldAutoBinding = this.autoBinding;
        this.autoBinding = autoBinding;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTOBINDING, oldAutoBinding, autoBinding);
    }

    private Canvas getCanvasForPlot() {
        Canvas[] cc;
        for (Canvas c : cc = this.dom.getCanvases()) {
            for (Row r : c.getRows()) {
                if (!r.getId().equals(this.plot.getRowId())) continue;
                return c;
            }
        }
        return null;
    }

    protected void createDasPeer(Canvas canvas, Row domRow, Column domColumn) {
        Application application = this.dom;
        DatumRange x = this.plot.xaxis.range;
        DatumRange y = this.plot.yaxis.range;
        DasAxis xaxis = new DasAxis(x.min(), x.max(), 2);
        DasAxis yaxis = new DasAxis(y.min(), y.max(), 3);
        xaxis.setEnableHistory(false);
        yaxis.setEnableHistory(false);
        if (UnitsUtil.isTimeLocation(xaxis.getUnits())) {
            xaxis.setUserDatumFormatter(new DateTimeDatumFormatter(this.dom.getController().getApplication().getOptions().isDayOfYear() ? 1 : 0));
        } else {
            xaxis.setUserDatumFormatter(null);
        }
        if (UnitsUtil.isTimeLocation(yaxis.getUnits())) {
            yaxis.setUserDatumFormatter(new DateTimeDatumFormatter(this.dom.getController().getApplication().getOptions().isDayOfYear() ? 1 : 0));
        } else {
            yaxis.setUserDatumFormatter(null);
        }
        this.plot.setRowId(domRow.getId());
        DasRow row = domRow.controller.getDasRow();
        this.plot.addPropertyChangeListener("rowId", this.rowColListener);
        this.plot.addPropertyChangeListener("columnId", this.rowColListener);
        DasColumn col = domColumn.controller.getDasColumn();
        DasPlot dasPlot1 = new DasPlot(xaxis, yaxis);
        dasPlot1.setPreviewEnabled(true);
        DatumRange colorRange = new DatumRange(0.0, 100.0, Units.dimensionless);
        DasColorBar colorbar = new DasColorBar(colorRange.min(), colorRange.max(), false);
        colorbar.addFocusListener(application.controller.focusAdapter);
        colorbar.setFillColor(new Color(0, true));
        colorbar.setEnableHistory(false);
        DasCanvas dasCanvas = canvas.controller.getDasCanvas();
        dasCanvas.add(dasPlot1, row, col);
        dasPlot1.getXAxis().setPlot(dasPlot1);
        dasPlot1.getYAxis().setPlot(dasPlot1);
        BoxZoomMouseModule boxmm = (BoxZoomMouseModule)dasPlot1.getDasMouseInputAdapter().getModuleByLabel("Box Zoom");
        dasPlot1.getDasMouseInputAdapter().setPrimaryModule(boxmm);
        dasCanvas.add(colorbar, dasPlot1.getRow(), DasColorBar.getColorBarColumn(dasPlot1.getColumn()));
        ZoomPanMouseModule zoomPan = new ZoomPanMouseModule((DasCanvasComponent)dasPlot1, dasPlot1.getXAxis(), dasPlot1.getYAxis());
        dasPlot1.getDasMouseInputAdapter().setSecondaryModule(zoomPan);
        ZoomPanMouseModule zoomPanX = new ZoomPanMouseModule((DasCanvasComponent)dasPlot1.getXAxis(), dasPlot1.getXAxis(), null);
        dasPlot1.getXAxis().getDasMouseInputAdapter().setSecondaryModule(zoomPanX);
        ZoomPanMouseModule zoomPanY = new ZoomPanMouseModule((DasCanvasComponent)dasPlot1.getYAxis(), null, dasPlot1.getYAxis());
        dasPlot1.getYAxis().getDasMouseInputAdapter().setSecondaryModule(zoomPanY);
        ZoomPanMouseModule zoomPanZ = new ZoomPanMouseModule((DasCanvasComponent)colorbar, null, colorbar);
        colorbar.getDasMouseInputAdapter().setSecondaryModule(zoomPanZ);
        dasCanvas.revalidate();
        dasCanvas.repaint();
        ApplicationController ac = application.controller;
        ac.layoutListener.listenTo(dasPlot1);
        ac.layoutListener.listenTo(colorbar);
        new AxisController(application, this.plot, this.plot.getXaxis(), xaxis);
        new AxisController(application, this.plot, this.plot.getYaxis(), yaxis);
        new AxisController(application, this.plot, this.plot.getZaxis(), colorbar);
        this.bindTo(dasPlot1);
        logger.log(Level.FINE, "add focus listener to {0}", dasPlot1);
        dasPlot1.addFocusListener(ac.focusAdapter);
        dasPlot1.getXAxis().addFocusListener(ac.focusAdapter);
        dasPlot1.getYAxis().addFocusListener(ac.focusAdapter);
        dasPlot1.addPropertyChangeListener("focusRenderer", ac.rendererFocusListener);
        ac.bind(application.getOptions(), "drawGrid", dasPlot1, "drawGrid");
        ac.bind(application.getOptions(), "drawMinorGrid", dasPlot1, "drawMinorGrid");
        ac.bind(application.getOptions(), "flipColorbarLabel", this.plot.getZaxis().getController().dasAxis, "flipLabel");
        ac.bind(application.getOptions(), "ticklen", dasPlot1.getXAxis(), "tickLength");
        ac.bind(application.getOptions(), "ticklen", dasPlot1.getYAxis(), "tickLength");
        ac.bind(application.getOptions(), "ticklen", colorbar, "tickLength");
        ac.bind(this.plot, "legendPosition", dasPlot1, "legendPosition");
        ac.bind(application.getOptions(), "overRendering", dasPlot1, "overSize");
        ac.bind(this.plot, "visible", dasPlot1, "visible");
        ac.bind(this.plot, "colortable", colorbar, "type");
        dasPlot1.addPropertyChangeListener(this.listener);
        dasPlot1.getXAxis().addPropertyChangeListener(this.listener);
        dasPlot1.getYAxis().addPropertyChangeListener(this.listener);
        this.plot.addPropertyChangeListener("isotropic", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (PlotController.this.plot.isIsotropic()) {
                    PlotController.this.checkIsotropic(null);
                }
            }
        });
        if (this.plot.getTicksURI().length() > 0) {
            String dasAddress = "class:org.autoplot.tca.UriTcaSource:" + this.plot.getTicksURI();
            dasPlot1.getXAxis().setDataPath(dasAddress);
            dasPlot1.getXAxis().setDrawTca(true);
            this.plot.getXaxis().setLabel("%{RANGE}");
        }
        this.dasPlot = dasPlot1;
        this.dasColorBar = colorbar;
        this.dasPlot.setEnableRenderPropertiesAction(false);
        application.controller.maybeAddContextMenus(this);
    }

    private Axis getDomAxis(DasAxis axis) {
        Axis domAxis = this.plot.xaxis.controller.dasAxis == axis ? this.plot.xaxis : (this.plot.yaxis.controller.dasAxis == axis ? this.plot.yaxis : (this.plot.zaxis.controller.dasAxis == axis ? this.plot.zaxis : null));
        return domAxis;
    }

    private void updateAxisFormatter(DasAxis axis) {
        if (UnitsUtil.isTimeLocation(axis.getUnits()) && !axis.getLabel().contains("%{RANGE}")) {
            axis.setUserDatumFormatter(new DateTimeDatumFormatter(this.dom.getController().getApplication().getOptions().isDayOfYear() ? 1 : 0));
        } else {
            axis.setUserDatumFormatter(null);
        }
    }

    public DasColorBar getDasColorBar() {
        return this.dasColorBar;
    }

    public DasPlot getDasPlot() {
        return this.dasPlot;
    }

    private static void logCheck(Axis a) {
        if (a.isLog() && a.getRange().min().doubleValue(a.getRange().getUnits()) <= 0.0) {
            a.setLog(false);
        }
    }

    public void resetZoom(boolean x, boolean y, boolean z) {
        List<PlotElement> elements = this.dom.controller.getPlotElementsFor(this.plot);
        if (elements.size() == 0) {
            return;
        }
        Plot newSettings = null;
        boolean haveTsb = false;
        for (PlotElement p : elements) {
            DataSourceFilter dsf;
            Plot plot1 = p.getPlotDefaults();
            if (!p.isActive() || !plot1.getXaxis().isAutoRange()) continue;
            if (newSettings == null) {
                newSettings = (Plot)plot1.copy();
            } else {
                try {
                    newSettings.xaxis.range = DatumRangeUtil.union(newSettings.xaxis.range, plot1.getXaxis().getRange());
                    newSettings.xaxis.log &= plot1.xaxis.log;
                    newSettings.yaxis.range = DatumRangeUtil.union(newSettings.yaxis.range, plot1.getYaxis().getRange());
                    newSettings.yaxis.log &= plot1.yaxis.log;
                    newSettings.zaxis.range = DatumRangeUtil.union(newSettings.zaxis.range, plot1.getZaxis().getRange());
                    newSettings.zaxis.log &= plot1.zaxis.log;
                }
                catch (InconvertibleUnitsException ex) {
                    logger.info("plot elements on the same plot have inconsistent units");
                }
            }
            if ((dsf = this.dom.controller.getDataSourceFilterFor(p)) == null || dsf.getController() == null || dsf.getController().tsb == null) continue;
            haveTsb = true;
        }
        if (newSettings == null) {
            this.plot.getXaxis().setAutoRange(true);
            this.plot.getYaxis().setAutoRange(true);
            this.plot.getZaxis().setAutoRange(true);
            return;
        }
        if (x) {
            PlotController.logCheck(newSettings.getXaxis());
            this.plot.getXaxis().setLog(newSettings.getXaxis().isLog());
            this.plot.getXaxis().setRange(newSettings.getXaxis().getRange());
            this.plot.getXaxis().setAutoRange(true);
            if (haveTsb) {
                this.plot.getXaxis().getController().dasAxis.setScanRange(null);
            } else {
                this.plot.getXaxis().getController().dasAxis.setScanRange(this.plot.getXaxis().getRange());
            }
        }
        if (y) {
            PlotController.logCheck(newSettings.getYaxis());
            this.plot.getYaxis().setLog(newSettings.getYaxis().isLog());
            this.plot.getYaxis().setRange(newSettings.getYaxis().getRange());
            this.plot.getYaxis().setAutoRange(true);
        }
        if (z) {
            PlotController.logCheck(newSettings.getZaxis());
            this.plot.getZaxis().setLog(newSettings.getZaxis().isLog());
            this.plot.getZaxis().setRange(newSettings.getZaxis().getRange());
            this.plot.getZaxis().setAutoRange(true);
        }
    }

    private void checkRenderType() {
        if (this.dom.getController().isValueAdjusting()) {
            return;
        }
        boolean needsColorbar = false;
        for (PlotElement p : this.dom.getController().getPlotElementsFor(this.plot)) {
            if (!RenderTypeUtil.needsColorbar(p.getRenderType())) continue;
            needsColorbar = true;
        }
        this.dasColorBar.setVisible(needsColorbar);
        this.plot.getZaxis().setVisible(needsColorbar);
    }

    void addPlotElement(PlotElement p) {
        this.addPlotElement(p, true);
    }

    synchronized List<Integer> indecesOfPlotElements() {
        ArrayList<Integer> indeces = new ArrayList<Integer>(this.dom.plotElements.size());
        for (int i = 0; i < this.dom.plotElements.size(); ++i) {
            if (!this.dom.getPlotElements(i).getPlotId().equals(this.plot.getId())) continue;
            indeces.add(i);
        }
        return indeces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void moveToStackBottom(PlotElement p) {
        ChangesSupport.DomLock lock = this.dom.getController().mutatorLock();
        lock.lock("Move to Stack Bottom");
        try {
            int i;
            int ploc;
            int bottom;
            if (!p.getPlotId().equals(this.plot.getId())) {
                throw new IllegalArgumentException("this is not my plot");
            }
            PlotElement[] newPes = this.dom.getPlotElements();
            for (bottom = 0; bottom < newPes.length && !newPes[bottom].getPlotId().equals(p.getPlotId()); ++bottom) {
            }
            for (ploc = 0; ploc < newPes.length && newPes[ploc] != p; ++ploc) {
            }
            if (ploc > bottom) {
                for (i = ploc; i > bottom; --i) {
                    newPes[i] = newPes[i - 1];
                }
                newPes[bottom] = p;
            }
            for (i = 0; i < newPes.length; ++i) {
                System.err.println(this.dom.getPlotElements(i) + "(" + this.dom.getPlotElements(i).getPlotId() + ")" + " " + newPes[i] + "(" + newPes[i].getPlotId() + ")");
            }
            this.dom.setPlotElements(newPes);
        }
        finally {
            lock.unlock();
        }
    }

    public void toBottom(PlotElement p) {
        this.moveToStackBottom(p);
        DasPlot pp = p.getController().getDasPlot();
        Renderer r = p.getController().getRenderer();
        pp.removeRenderer(r);
        pp.addRenderer(0, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void moveToStackTop(PlotElement p) {
        ChangesSupport.DomLock lock = this.dom.getController().mutatorLock();
        lock.lock("Move to Stack Top");
        try {
            int i;
            int ploc;
            int top;
            if (!p.getPlotId().equals(this.plot.getId())) {
                throw new IllegalArgumentException("this is not my plot");
            }
            PlotElement[] newPes = this.dom.getPlotElements();
            for (top = newPes.length - 1; top >= 0 && !newPes[top].getPlotId().equals(p.getPlotId()); --top) {
            }
            for (ploc = 0; ploc < newPes.length && newPes[ploc] != p; ++ploc) {
            }
            if (ploc < top) {
                for (i = ploc; i < top; ++i) {
                    newPes[i] = newPes[i + 1];
                }
                newPes[top] = p;
            }
            for (i = 0; i < newPes.length; ++i) {
                System.err.println(this.dom.getPlotElements(i) + "(" + this.dom.getPlotElements(i).getPlotId() + ")" + " " + newPes[i] + "(" + newPes[i].getPlotId() + ")");
            }
            this.dom.setPlotElements(newPes);
        }
        finally {
            lock.unlock();
        }
    }

    synchronized void addPlotElement(PlotElement p, boolean reset) {
        boolean toTop;
        Renderer rr = p.controller.getRenderer();
        if (rr instanceof SpectrogramRenderer) {
            ((SpectrogramRenderer)rr).setColorBar(this.getDasColorBar());
        } else if (rr instanceof SeriesRenderer) {
            ((SeriesRenderer)rr).setColorBar(this.getDasColorBar());
        }
        boolean bl = toTop = rr != null && !(rr instanceof SpectrogramRenderer);
        if (rr != null) {
            if (!toTop) {
                this.dasPlot.addRenderer(0, rr);
            } else {
                this.dasPlot.addRenderer(rr);
            }
        }
        RenderType rt = p.getRenderType();
        p.plotId = this.plot.getId();
        if (reset) {
            p.controller.doResetRenderType(rt);
        }
        this.doPlotElementDefaultsChange(p);
        if (!this.pdListen.contains(p)) {
            p.addPropertyChangeListener("plotDefaults", this.plotDefaultsListener);
            p.addPropertyChangeListener("renderType", this.renderTypeListener);
            this.pdListen.add(p);
        }
        p.setPlotId(this.plot.getId());
        this.checkRenderType();
        if (rr != null && toTop) {
            this.moveToStackTop(p);
        }
    }

    public Plot contextOverview() {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Context Overview");
        Plot domPlot = this.plot;
        ApplicationController controller = this.dom.getController();
        Plot that = controller.copyPlotAndPlotElements(domPlot, null, false, false);
        that.setTitle("");
        controller.bind(domPlot.getZaxis(), "range", that.getZaxis(), "range");
        controller.bind(domPlot.getZaxis(), "log", that.getZaxis(), "log");
        controller.bind(domPlot.getZaxis(), "label", that.getZaxis(), "label");
        controller.addConnector(domPlot, that);
        that.getController().resetZoom(true, true, false);
        lock.unlock();
        return that;
    }

    synchronized void removePlotElement(PlotElement p) {
        Renderer rr = p.controller.getRenderer();
        if (rr != null) {
            this.dasPlot.removeRenderer(rr);
        }
        if (rr instanceof SpectrogramRenderer) {
            ((SpectrogramRenderer)rr).setColorBar(null);
        } else if (rr instanceof SeriesRenderer) {
            ((SeriesRenderer)rr).setColorBar(null);
        }
        this.doPlotElementDefaultsChange(null);
        p.removePropertyChangeListener("plotDefaults", this.plotDefaultsListener);
        p.removePropertyChangeListener("renderType", this.renderTypeListener);
        this.pdListen.remove(p);
        if (!p.getPlotId().equals("")) {
            p.setPlotId("");
        }
        this.checkRenderType();
    }

    private void doPlotElementDefaultsChange(PlotElement pele) {
        BindingModel existingBinding;
        List<BindingModel> bms;
        if (pele != null && this.isAutoBinding()) {
            this.doCheckBindings(this.plot, pele.getPlotDefaults());
        }
        if ((bms = this.dom.getController().findBindings(this.dom, "timeRange", null, "range")).contains(existingBinding = this.dom.getController().findBinding(this.dom, "timeRange", this.plot.xaxis, "range")) && bms.size() > 1) {
            this.plot.getXaxis().setAutoRange(false);
        }
        if (DomUtil.oneFamily(this.dom.getController().getPlotElementsFor(this.plot))) {
            PlotElement p = this.dom.getController().getPlotElementsFor(this.plot).get(0);
            if (!p.getParent().equals("") && p.getController().getParentPlotElement() != null) {
                p = p.getController().getParentPlotElement();
            }
            if (!p.getParent().equals("") && p.getController().getParentPlotElement() == null) {
                logger.log(Level.WARNING, "reference to non-existent parent in {0}", p);
            }
            if (this.plotElement != null) {
                this.plotElement.getController().removePropertyChangeListener("dataSet", this.plotElementDataSetListener);
            }
            this.plotElement = p;
            this.plotElement.getController().addPropertyChangeListener("dataSet", this.plotElementDataSetListener);
            if (pele == null || pele.getPlotDefaults().getXaxis().isAutoRange()) {
                if (this.plot.isAutoLabel()) {
                    this.plot.setTitle(p.getPlotDefaults().getTitle());
                }
                if (this.plot.getXaxis().isAutoLabel()) {
                    this.plot.getXaxis().setLabel(p.getPlotDefaults().getXaxis().getLabel());
                }
                if (this.plot.getYaxis().isAutoLabel()) {
                    this.plot.getYaxis().setLabel(p.getPlotDefaults().getYaxis().getLabel());
                }
                if (this.plot.getZaxis().isAutoLabel()) {
                    this.plot.getZaxis().setLabel(p.getPlotDefaults().getZaxis().getLabel());
                }
                if (this.plot.getXaxis().isAutoRange() && this.plot.getYaxis().isAutoRange()) {
                    this.plot.setIsotropic(p.getPlotDefaults().isIsotropic());
                }
            }
        }
        if (this.dom.getController().getPlotElementsFor(this.plot).size() == 0) {
            // empty if block
        }
        if (pele == null || pele.getPlotDefaults().getXaxis().isAutoRange()) {
            this.resetZoom(this.plot.getXaxis().isAutoRange(), this.plot.getYaxis().isAutoRange(), this.plot.getZaxis().isAutoRange());
        }
    }

    protected void doPlotElementDefaultsUnitsChange(PlotElement e) {
        DatumRange dr;
        DatumRange elerange = e.getPlotDefaults().getXaxis().getRange();
        DatumRange range = this.plot.getXaxis().getRange();
        if (elerange.getUnits() != range.getUnits() && range.getUnits() == Units.dimensionless) {
            dr = UnitsUtil.isTimeLocation(elerange.getUnits()) ? DatumRangeUtil.parseTimeRangeValid("2010-01-01") : new DatumRange(range.min().doubleValue(Units.dimensionless), range.max().doubleValue(Units.dimensionless), elerange.getUnits());
            this.plot.getXaxis().setRange(dr);
        }
        elerange = e.getPlotDefaults().getYaxis().getRange();
        range = this.plot.getYaxis().getRange();
        if (!UnitsUtil.isTimeLocation(elerange.getUnits()) && elerange.getUnits() != range.getUnits() && range.getUnits() == Units.dimensionless) {
            dr = UnitsUtil.isTimeLocation(elerange.getUnits()) ? DatumRangeUtil.parseTimeRangeValid("2010-01-01") : new DatumRange(range.min().doubleValue(Units.dimensionless), range.max().doubleValue(Units.dimensionless), elerange.getUnits());
            this.plot.getYaxis().setRange(dr);
        }
        elerange = e.getPlotDefaults().getZaxis().getRange();
        range = this.plot.getZaxis().getRange();
        if (!UnitsUtil.isTimeLocation(elerange.getUnits()) && elerange.getUnits() != range.getUnits() && range.getUnits() == Units.dimensionless) {
            dr = UnitsUtil.isTimeLocation(elerange.getUnits()) ? DatumRangeUtil.parseTimeRangeValid("2010-01-01") : new DatumRange(range.min().doubleValue(Units.dimensionless), range.max().doubleValue(Units.dimensionless), elerange.getUnits());
            this.plot.getZaxis().setRange(dr);
        }
    }

    private void doCheckBindings(Plot plot, Plot newSettings) {
        boolean shouldBindX = false;
        boolean shouldSetAxisRange = false;
        List<BindingModel> bms = this.dom.getController().findBindings(this.dom, "timeRange", null, "range");
        BindingModel bm = this.dom.getController().findBinding(this.dom, "timeRange", plot.getXaxis(), "range");
        if (bm != null) {
            bms.remove(bm);
        }
        if (!plot.isAutoBinding()) {
            return;
        }
        if (!plot.getXaxis().isAutoRange()) {
            boolean bl = shouldBindX = bm != null;
            if (bm != null && !newSettings.getXaxis().getRange().getUnits().isConvertableTo(plot.getXaxis().getRange().getUnits())) {
                shouldBindX = false;
                logger.finer("remove timerange binding that would cause inconvertable units");
            }
            plot.getXaxis().setAutoRange(true);
        }
        if (!newSettings.getXaxis().isLog() && plot.getXaxis().isAutoRange()) {
            if (bms.size() == 0 && UnitsUtil.isTimeLocation(newSettings.getXaxis().getRange().getUnits())) {
                this.dom.setTimeRange(newSettings.getXaxis().getRange());
                shouldBindX = true;
                shouldSetAxisRange = true;
            }
            if (!plot.getXaxis().isAutoRange()) {
                plot.getXaxis().setAutoRange(true);
            }
            DatumRange xrange = newSettings.getXaxis().getRange();
            if (this.dom.timeRange.getUnits().isConvertableTo(xrange.getUnits()) && UnitsUtil.isTimeLocation(xrange.getUnits())) {
                if (this.dom.controller.isConnected(plot)) {
                    logger.log(Level.FINER, "not binding because plot is connected: {0}", plot);
                } else if (this.dom.timeRange.intersects(xrange)) {
                    double reqOverlap = UnitsUtil.isTimeLocation(this.dom.timeRange.getUnits()) ? 0.01 : 0.8;
                    DatumRange droverlap = DatumRangeUtil.sloppyIntersection(xrange, this.dom.timeRange);
                    try {
                        double overlap = droverlap.width().divide(this.dom.timeRange.width()).doubleValue(Units.dimensionless);
                        if (overlap > 1.0) {
                            overlap = 1.0 / overlap;
                        }
                        if (overlap > reqOverlap) {
                            shouldBindX = true;
                            logger.finer("binding axis because there is significant overlap");
                            this.dom.getController().setStatus("binding axis because there is significant overlap");
                        }
                    }
                    catch (InconvertibleUnitsException ex) {
                        shouldBindX = false;
                    }
                    catch (IllegalArgumentException ex) {
                        shouldBindX = false;
                    }
                }
            }
        }
        if (shouldBindX && !plot.getColumnId().equals(this.dom.getCanvases(0).getMarginColumn().getId())) {
            logger.log(Level.FINER, "not binding because plot is not attached to marginRow: {0}", plot.getXaxis());
            shouldBindX = false;
            this.dom.getController().setStatus("not binding axis because plot is not attached to marginRow");
        }
        if (bm == null && shouldBindX) {
            logger.log(Level.FINER, "add binding because ranges overlap: {0}", plot.getXaxis());
            plot.getXaxis().setLog(false);
            this.dom.getController().bind(this.dom, "timeRange", plot.getXaxis(), "range");
        } else if (bm != null && !shouldBindX) {
            logger.log(Level.FINER, "remove binding: {0}", bm);
            this.dom.getController().deleteBinding(bm);
        }
        plot.setAutoBinding(false);
    }

    void deleteDasPeer() {
        final DasPlot p = this.getDasPlot();
        final DasColorBar cb = this.getDasColorBar();
        final DasCanvas c = p.getCanvas();
        if (c != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    c.remove(p);
                    c.remove(cb);
                }
            });
        }
    }

    private void checkIsotropic(DasAxis axis) {
        Datum scalex = this.dasPlot.getXAxis().getDatumRange().width().divide(this.dasPlot.getXAxis().getDLength());
        Datum scaley = this.dasPlot.getYAxis().getDatumRange().width().divide(this.dasPlot.getYAxis().getDLength());
        if (!scalex.getUnits().isConvertableTo(scaley.getUnits()) || this.dasPlot.getXAxis().isLog() || this.dasPlot.getYAxis().isLog()) {
            return;
        }
        if (axis == null) {
            DasAxis dasAxis = axis = scalex.gt(scaley) ? this.dasPlot.getXAxis() : this.dasPlot.getYAxis();
        }
        if (axis == this.dasPlot.getXAxis() || axis == this.dasPlot.getYAxis()) {
            DatumRange otherRange;
            Datum otherScale;
            Datum scale;
            double expand;
            DasAxis otherAxis = this.dasPlot.getYAxis();
            if (axis == this.dasPlot.getYAxis()) {
                otherAxis = this.dasPlot.getXAxis();
            }
            if (Math.abs(expand = ((scale = axis.getDatumRange().width().divide(axis.getDLength())).divide(otherScale = (otherRange = otherAxis.getDatumRange()).width().divide(otherAxis.getDLength())).doubleValue(Units.dimensionless) - 1.0) / 2.0) > 1.0E-4) {
                DatumRange newOtherRange = DatumRangeUtil.rescale(otherRange, 0.0 - expand, 1.0 + expand);
                otherAxis.setDatumRange(newOtherRange);
            }
        }
    }

    Converter labelContextConverter(final Axis axis) {
        return new Converter(){

            public Object convertForward(Object value) {
                String title = (String)value;
                if (title.contains("%{CONTEXT}")) {
                    String[] ss;
                    QDataSet ds;
                    String contextStr = "";
                    if (PlotController.this.plotElement != null && PlotController.this.plotElement.getController() != null && (ds = PlotController.this.plotElement.getController().getDataSet()) != null && !(contextStr = DataSetUtil.contextAsString((QDataSet)ds)).equals("") && (ss = contextStr.split("=")).length == 2) {
                        contextStr = ss[1];
                    }
                    title = title.replaceAll("%\\{CONTEXT\\}", contextStr);
                }
                return title;
            }

            public Object convertReverse(Object value) {
                String[] ss;
                String title = (String)value;
                String ptitle = axis.getLabel();
                if (ptitle.contains("%{CONTEXT}") && title.startsWith((ss = ptitle.split("%\\{CONTEXT\\}", -2))[0]) && title.endsWith(ss[1])) {
                    return ptitle;
                }
                return title;
            }
        };
    }

    private synchronized void bindTo(DasPlot p) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plot, "title", p, "title", this.contextConverter);
        ac.bind(this.plot, "context", p, "context");
    }

    public BindingModel[] getBindings() {
        return this.dom.controller.getBindingsFor(this.plot);
    }

    public BindingModel getBindings(int index) {
        return this.getBindings()[index];
    }

    public JMenuItem getPlotElementPropsMenuItem() {
        return this.plotElementPropsMenuItem;
    }

    public void setPlotElementPropsMenuItem(JMenuItem pelePropsMenuItem) {
        JMenuItem old = this.plotElementPropsMenuItem;
        this.plotElementPropsMenuItem = pelePropsMenuItem;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOTELEMENTPROPSMENUITEM, old, pelePropsMenuItem);
    }

    public Application getApplication() {
        return this.dom;
    }

    public String toString() {
        return this.plot + " controller";
    }

    public void setTitleAutomatically(String title) {
        this.plot.setTitle(title);
        this.plot.setAutoLabel(true);
    }

    public void setExpertMenuItems(JMenuItem[] items) {
        this.expertMenuItems = items;
    }

    public JMenuItem[] getExpertMenuItems() {
        return this.expertMenuItems;
    }

    public void setExpertMode(boolean expert) {
        for (JMenuItem mi : this.expertMenuItems) {
            mi.setVisible(expert);
        }
    }
}

