/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import org.das2.datum.DatumRange;
import org.das2.datum.UnitsUtil;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.datasource.capability.TimeSeriesBrowse;

public class PlotElementControllerUtil {
    public static DatumRange getTimeRange(Application dom, PlotElement pe) {
        DataSourceFilter dsf = dom.getController().getDataSourceFilterFor(pe);
        if (dsf == null) {
            return null;
        }
        TimeSeriesBrowse tsb = dsf.getController().getTsb();
        if (tsb != null) {
            return tsb.getTimeRange();
        }
        DatumRange dr = null;
        if (pe.getPlotDefaults() != null && pe.getPlotDefaults().getXaxis() != null) {
            dr = pe.getPlotDefaults().getXaxis().getRange();
        }
        if (dr == null) {
            return null;
        }
        if (UnitsUtil.isTimeLocation(dr.getUnits())) {
            return dr;
        }
        return null;
    }
}

