/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasRow;
import org.virbo.autoplot.dom.Canvas;
import org.virbo.autoplot.dom.DomNodeController;
import org.virbo.autoplot.dom.Row;

public class RowController
extends DomNodeController {
    Row row;
    DasRow dasRow;
    Canvas canvas;

    RowController(Row row) {
        super(row);
        this.row = row;
        row.controller = this;
    }

    protected void createDasPeer(Canvas canvas, DasRow parent) {
        DasCanvas c = canvas.controller.getDasCanvas();
        this.dasRow = DasRow.create(c, parent, this.row.getTop(), this.row.getBottom());
        final List<String> minList = Arrays.asList("minimum", "emMinimum", "ptMinimum");
        final List<String> maxList = Arrays.asList("maximum", "emMaximum", "ptMaximum");
        PropertyChangeListener list = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (maxList.contains(evt.getPropertyName())) {
                    RowController.this.row.setBottom(DasDevicePosition.formatLayoutStr(RowController.this.dasRow, false));
                } else if (minList.contains(evt.getPropertyName())) {
                    RowController.this.row.setTop(DasDevicePosition.formatLayoutStr(RowController.this.dasRow, true));
                }
            }
        };
        this.dasRow.addPropertyChangeListener(list);
        list = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    double[] dd = DasDevicePosition.parseFormatStr((String)evt.getNewValue());
                    if (evt.getPropertyName().equals("top")) {
                        RowController.this.dasRow.setMin(dd[0], dd[1], (int)dd[2]);
                    } else if (evt.getPropertyName().equals("bottom")) {
                        RowController.this.dasRow.setMax(dd[0], dd[1], (int)dd[2]);
                    }
                }
                catch (ParseException ex) {
                    Logger.getLogger(RowController.class.getName()).log(Level.WARNING, "parse exception: {0}", ex);
                    RowController.this.row.setTop(DasDevicePosition.formatLayoutStr(RowController.this.dasRow, true));
                    RowController.this.row.setBottom(DasDevicePosition.formatLayoutStr(RowController.this.dasRow, false));
                }
            }
        };
        this.row.addPropertyChangeListener("bottom", list);
        this.row.addPropertyChangeListener("top", list);
        this.canvas = canvas;
    }

    public DasRow getDasRow() {
        return this.dasRow;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }
}

