/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.dataset.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.ChangesSupport;
import org.virbo.autoplot.dom.DataSourceController;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.PlotElementController;
import org.virbo.autoplot.util.DateTimeDatumFormatter;
import org.virbo.autoplot.util.TickleTimer;
import org.virbo.dataset.QDataSet;

public class TimeSeriesBrowseController {
    PlotElement p;
    DasAxis xAxis;
    DasPlot plot;
    Plot domPlot;
    PlotElementController panelController;
    DataSourceController dataSourceController;
    DataSourceFilter dsf;
    private ChangesSupport changesSupport;
    private static final String PENDING_AXIS_DIRTY = "tsbAxisDirty";
    private static final String PENDING_TIMERANGE_DIRTY = "tsbTimerangeDirty";
    private static final Logger logger = Logger.getLogger("ap.tsb");
    TickleTimer updateTsbTimer;
    PropertyChangeListener timeSeriesBrowseListener;
    private DomNode listenNode = null;
    private String listenProp = null;
    protected DatumRange timeRange = null;
    public static final String PROP_TIMERANGE = "timeRange";
    protected Datum resolution = null;
    public static final String PROP_RESOLUTION = "resolution";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    TimeSeriesBrowseController(DataSourceController dataSourceController, PlotElement p) {
        this.changesSupport = new ChangesSupport(this.propertyChangeSupport, this);
        this.updateTsbTimer = new TickleTimer(100L, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (TimeSeriesBrowseController.this.dsf.getController().getApplication().getController().isValueAdjusting()) {
                    TimeSeriesBrowseController.this.updateTsbTimer.tickle();
                    return;
                }
                TimeSeriesBrowseController.this.updateTsb(false);
                TimeSeriesBrowseController.this.changesSupport.changePerformed(this, TimeSeriesBrowseController.PENDING_AXIS_DIRTY);
                TimeSeriesBrowseController.this.changesSupport.changePerformed(this, TimeSeriesBrowseController.PENDING_TIMERANGE_DIRTY);
            }
        });
        this.dsf = dataSourceController.dsf;
        this.dataSourceController = dataSourceController;
        if (p != null) {
            this.p = p;
            this.domPlot = this.dsf.getController().getApplication().getController().getPlotFor(p);
            this.panelController = p.getController();
        } else {
            System.err.println("no plotElement provided, better come back to set up from timerange.");
        }
        if (p != null) {
            this.plot = this.panelController.getDasPlot();
            this.xAxis = this.panelController.getDasPlot().getXAxis();
        }
    }

    private boolean isBoundTimeRange(BindingModel[] bms, String dstId) {
        for (int i = 0; i < bms.length; ++i) {
            if (!bms[i].getSrcProperty().equals(PROP_TIMERANGE) || !bms[i].getDstProperty().equals("range") || bms[i].getDstId().equals(dstId)) continue;
            return true;
        }
        return false;
    }

    protected void setupGen(DomNode node, final String property) {
        this.timeSeriesBrowseListener = new PropertyChangeListener(){

            public String toString() {
                return "" + TimeSeriesBrowseController.this;
            }

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals(property)) {
                    TimeSeriesBrowseController.this.changesSupport.registerPendingChange(this, TimeSeriesBrowseController.PENDING_TIMERANGE_DIRTY);
                    DatumRange dr = (DatumRange)e.getNewValue();
                    TimeSeriesBrowseController.this.setTimeRange(UnitsUtil.isTimeLocation(dr.getUnits()) ? dr : null);
                    TimeSeriesBrowseController.this.updateTsbTimer.tickle();
                }
            }
        };
        if (!DomUtil.nodeHasProperty(node, property)) {
            throw new IllegalArgumentException("node " + node + " doesn't have property: " + property);
        }
        try {
            Class<?> c = node.getClass();
            PropertyDescriptor pd = new PropertyDescriptor(property, c);
            Method getter = pd.getReadMethod();
            this.setTimeRange((DatumRange)getter.invoke((Object)node, new Object[0]));
            this.dsf.getController().getTsb().setTimeRange(this.getTimeRange());
            node.addPropertyChangeListener(property, this.timeSeriesBrowseListener);
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(TimeSeriesBrowseController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(TimeSeriesBrowseController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(TimeSeriesBrowseController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(TimeSeriesBrowseController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.listenNode = node;
        this.listenProp = property;
    }

    protected void setup(boolean valueWasAdjusting) {
        boolean setTsbInitialResolution = true;
        if (setTsbInitialResolution) {
            DatumRange tr = this.dataSourceController.getTsb().getTimeRange();
            this.setTimeRange(tr);
            if (this.domPlot.getXaxis().isAutoRange() && !valueWasAdjusting) {
                BindingModel[] bms = this.dsf.getController().getApplication().getBindings();
                DatumRange appRange = this.dsf.getController().getApplication().getTimeRange();
                if (appRange.getUnits().isConvertableTo(tr.getUnits()) && this.isBoundTimeRange(bms, this.domPlot.getXaxis().getId())) {
                    this.plot.getXAxis().resetRange(appRange);
                } else {
                    this.plot.getXAxis().resetRange(tr);
                }
                this.plot.getXAxis().setUserDatumFormatter(new DateTimeDatumFormatter(this.dsf.getController().getApplication().getOptions().isDayOfYear() ? 1 : 0));
                this.domPlot.getXaxis().setAutoRange(true);
                this.plot.getXAxis().setScanRange(null);
            }
            this.updateTsb(true);
            this.changesSupport.changePerformed(this, PENDING_AXIS_DIRTY);
        }
        this.timeSeriesBrowseListener = new PropertyChangeListener(){

            public String toString() {
                return "" + TimeSeriesBrowseController.this;
            }

            public void propertyChange(PropertyChangeEvent e) {
                if (TimeSeriesBrowseController.this.plot.getXAxis().valueIsAdjusting()) {
                    return;
                }
                if (e.getPropertyName().equals("datumRange")) {
                    TimeSeriesBrowseController.this.changesSupport.registerPendingChange(this, TimeSeriesBrowseController.PENDING_AXIS_DIRTY);
                    DatumRange dr = (DatumRange)e.getNewValue();
                    TimeSeriesBrowseController.this.setTimeRange(UnitsUtil.isTimeLocation(dr.getUnits()) ? dr : null);
                    TimeSeriesBrowseController.this.updateTsbTimer.tickle();
                }
            }
        };
        this.plot.getXAxis().addPropertyChangeListener("datumRange", this.timeSeriesBrowseListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateTsb(boolean autorange) {
        CacheTag tag;
        if (this.p != null && this.p.getController().getDataSourceFilter().getController().getTsb() == null) {
            System.err.println("entering that strange branch that probably isn't needed ");
            return;
        }
        DatumRange trange = this.getTimeRange();
        if (trange == null) return;
        QDataSet ds = this.dataSourceController.getDataSet();
        QDataSet dep0 = ds == null ? null : (QDataSet)ds.property("DEPEND_0");
        Object join0 = ds == null ? null : ds.property("JOIN_0");
        CacheTag cacheTag = tag = dep0 == null ? null : (CacheTag)dep0.property("CACHE_TAG");
        if (tag == null && join0 != null) {
            if (join0 instanceof QDataSet) {
                QDataSet qdsj = (QDataSet)join0;
                tag = (CacheTag)qdsj.property("CACHE_TAG");
            } else {
                System.err.println("join property was not a QDataSet: " + join0.toString());
            }
        }
        DatumRange visibleRange = null;
        Datum newResolution = null;
        CacheTag testCacheTag = null;
        if (this.xAxis != null) {
            visibleRange = this.xAxis.getDatumRange();
            if (this.xAxis.getDLength() > 2) {
                newResolution = visibleRange.width().divide(this.xAxis.getDLength());
            } else {
                System.err.println("WARNING: xaxis isn't sized, loading data at full resolution!");
            }
            DatumRange newRange = visibleRange;
            testCacheTag = new CacheTag(DatumRangeUtil.rescale(newRange, 0.01, 0.99), newResolution);
            trange = newRange;
            if (!UnitsUtil.isTimeLocation(visibleRange.getUnits())) {
                System.err.println("x-axis for TSB not time location units: " + visibleRange);
                trange = this.dsf.getController().getApplication().getTimeRange();
                if (!UnitsUtil.isTimeLocation(trange.getUnits())) {
                    System.err.println("  unable to bind to application timeRange because of units.");
                    return;
                }
                System.err.println("  rebinding application timeRange");
                this.release();
                this.setupGen(this.dsf.getController().getApplication(), PROP_TIMERANGE);
            }
        } else {
            testCacheTag = new CacheTag(trange, null);
        }
        if (tag != null && tag.contains(testCacheTag)) {
            logger.fine("loaded dataset satifies request");
            return;
        }
        if (this.xAxis != null) {
            if (this.plot.isOverSize() && !autorange) {
                visibleRange = DatumRangeUtil.rescale(visibleRange, -0.3, 1.3);
            }
            this.dataSourceController.getTsb().setTimeRange(trange);
            this.dataSourceController.getTsb().setTimeResolution(newResolution);
            logger.log(Level.FINE, "updateTsb: {0} (@{1})", new Object[]{trange, newResolution});
        } else {
            this.dataSourceController.getTsb().setTimeRange(trange);
            this.dataSourceController.getTsb().setTimeResolution(null);
            logger.log(Level.FINE, "updateTsb: {0} (@ intrinsic)", trange);
        }
        String surl = this.dataSourceController.tsb.getURI();
        if (!autorange && surl.equals(this.dataSourceController.getTsbSuri())) {
            logger.fine("we do no better with tsb");
            if (this.xAxis != null) return;
            return;
        }
        this.dataSourceController.cancel();
        this.dataSourceController.update();
        this.dataSourceController.setTsbSuri(surl);
    }

    public PlotElement getPlotElement() {
        return this.p;
    }

    public boolean isPendingChanges() {
        if (this.changesSupport.isPendingChanges()) {
            return true;
        }
        return this.changesSupport.isPendingChanges();
    }

    void release() {
        if (this.isListeningToAxis()) {
            this.plot.getXAxis().removePropertyChangeListener("datumRange", this.timeSeriesBrowseListener);
            this.xAxis = null;
        } else if (this.listenNode != null) {
            this.listenNode.removePropertyChangeListener(this.listenProp, this.timeSeriesBrowseListener);
        }
        this.timeSeriesBrowseListener = null;
    }

    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(DatumRange timeRange) {
        DatumRange oldTimeRange = this.timeRange;
        this.timeRange = timeRange;
        this.propertyChangeSupport.firePropertyChange(PROP_TIMERANGE, oldTimeRange, timeRange);
    }

    public Datum getResolution() {
        return this.resolution;
    }

    public void setResolution(Datum resolution) {
        Datum oldResolution = this.resolution;
        this.resolution = resolution;
        this.propertyChangeSupport.firePropertyChange(PROP_RESOLUTION, oldResolution, resolution);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public String toString() {
        return this.dsf + " timeSeriesBrowse controller";
    }

    boolean isListeningToAxis() {
        return this.xAxis != null;
    }
}

