/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.layout;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutUtil {
    private static final Logger logger = Logger.getLogger("virbo.autoplot.autolayout");
    private static boolean ALLOW_EXCESS_SPACE = true;

    private static boolean maybeSetMaximum(DasDevicePosition c, double need, double norm, double em, int pt) {
        em = Math.floor(em);
        double excess = -1.0 * (c.getEmMaximum() - em);
        if (ALLOW_EXCESS_SPACE && c.getMaximum() == norm && excess >= 0.0 && excess < 4.0) {
            return false;
        }
        if (Math.abs(c.getEmMaximum() - em) < 0.1 && Math.abs(norm - c.getMaximum()) < 0.001) {
            return false;
        }
        if (Math.abs(em) > 100.0) {
            System.err.println("autolayout failure.");
        }
        c.setMax(norm, em, pt);
        logger.log(Level.FINE, "reset maximum: {0}", c);
        return true;
    }

    private static boolean maybeSetMinimum(DasDevicePosition c, double need, double norm, double em, int pt) {
        em = Math.ceil(em);
        double excess = c.getEmMinimum() - em;
        if (ALLOW_EXCESS_SPACE && c.getMinimum() == norm && excess >= 0.0 && excess < 4.0) {
            return false;
        }
        if (Math.abs(c.getEmMinimum() - em) < 0.1 && Math.abs(norm - c.getMinimum()) < 0.001) {
            return false;
        }
        if (Math.abs(em) > 100.0) {
            System.err.println("autolayout failure.");
        }
        c.setMin(norm, em, pt);
        logger.log(Level.FINE, "reset minimum: {0}", c);
        return true;
    }

    public static void autolayout(DasCanvas canvas, DasRow r, DasColumn c) {
        Rectangle bounds;
        double em = c.getEmSize();
        int xmin = 90000;
        int xmax = -90000;
        int ymin = 90000;
        int ymax = -90000;
        if (canvas.getWidth() == 0) {
            return;
        }
        for (DasCanvasComponent cc : canvas.getCanvasComponents()) {
            if (cc.getColumn() == c && cc.isVisible()) {
                bounds = cc.getBounds();
                xmin = Math.min(xmin, bounds.x);
                xmax = Math.max(xmax, bounds.x + bounds.width);
            }
            if (cc.getRow() != r || !cc.isVisible()) continue;
            bounds = cc.getBounds();
            ymin = Math.min(ymin, bounds.y);
            ymax = Math.max(ymax, bounds.y + bounds.height);
        }
        bounds = LayoutUtil.getChildBounds(c);
        if (bounds != null) {
            xmin = Math.min(xmin, bounds.x);
            xmax = Math.max(xmax, bounds.x + bounds.width);
            ymin = Math.min(ymin, bounds.y);
            ymax = Math.max(ymax, bounds.y + bounds.height);
        }
        if ((bounds = LayoutUtil.getChildBounds(r)) != null) {
            xmin = Math.min(xmin, bounds.x);
            xmax = Math.max(xmax, bounds.x + bounds.width);
            ymin = Math.min(ymin, bounds.y);
            ymax = Math.max(ymax, bounds.y + bounds.height);
        }
        double MARGIN_LEFT_RIGHT_EM = 1.0;
        boolean changed = false;
        if (Math.abs(xmin) > 9999 || Math.abs(xmax) > 9999 || Math.abs(ymin) > 9999 || Math.abs(ymax) > 9999) {
            System.err.println("invalid bounds returned, returning.");
            return;
        }
        int old = c.getDMinimum();
        int needXmin = old - xmin;
        old = c.getDMaximum();
        int needXmax = xmax - old;
        old = r.getDMinimum();
        int needYmin = old - ymin;
        old = r.getDMaximum();
        int needYmax = ymax - old;
        if (needXmax < -120) {
            System.err.println("needXmax: " + needXmax);
            c.getParent().resizeAllComponents();
            return;
        }
        changed |= LayoutUtil.maybeSetMinimum(c, needXmin, 0.0, (double)needXmin / em + MARGIN_LEFT_RIGHT_EM, 0);
        changed |= LayoutUtil.maybeSetMaximum(c, needXmax, 1.0, (double)(-needXmax) / em - MARGIN_LEFT_RIGHT_EM, 0);
        changed |= LayoutUtil.maybeSetMinimum(r, needYmin, 0.0, (double)needYmin / em, 0);
        if (changed |= LayoutUtil.maybeSetMaximum(r, needYmax, 1.0, (double)(-needYmax) / em, 0)) {
            c.getParent().resizeAllComponents();
        }
    }

    public static List<DasDevicePosition> getChildColumns(DasDevicePosition col, boolean doCol) {
        DasCanvas canvas = col.getParent();
        ArrayList<DasDevicePosition> result = new ArrayList<DasDevicePosition>();
        for (DasCanvasComponent cc : canvas.getCanvasComponents()) {
            DasDevicePosition ccol;
            DasDevicePosition dasDevicePosition = ccol = doCol ? cc.getColumn() : cc.getRow();
            if (cc.getColumn().getParentDevicePosition() != col) continue;
            result.add(cc.getColumn());
        }
        return result;
    }

    public static Rectangle getChildBounds(DasColumn col) {
        DasCanvas canvas = col.getParent();
        Rectangle rect = null;
        for (DasCanvasComponent cc : canvas.getCanvasComponents()) {
            if (cc.getColumn().getParentDevicePosition() != col || !cc.isVisible()) continue;
            if (rect == null) {
                rect = cc.getBounds();
                continue;
            }
            rect.add(cc.getBounds());
        }
        return rect;
    }

    public static Rectangle getChildBounds(DasRow row) {
        DasCanvas canvas = row.getParent();
        Rectangle rect = null;
        for (DasCanvasComponent cc : canvas.getCanvasComponents()) {
            if (cc.getRow().getParentDevicePosition() != row || !cc.isVisible()) continue;
            if (rect == null) {
                rect = cc.getBounds();
                continue;
            }
            rect.add(cc.getBounds());
        }
        return rect;
    }
}

