/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.scriptconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.das2.DasApplication;
import org.das2.util.AboutUtil;
import org.das2.util.ExceptionHandler;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.scriptconsole.GuiExceptionHandlerSubmitForm;
import org.virbo.autoplot.scriptconsole.LogConsole;
import org.virbo.autoplot.state.SerializeUtil;
import org.virbo.autoplot.state.UndoRedoSupport;
import org.virbo.autoplot.state.Vap1_07Scheme;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GuiExceptionHandler
implements ExceptionHandler {
    private static final String UNCAUGHT = "An unexpected error has occurred. The system may not be able to recover properly.  You can inspect information about the crash with the Show Details button below, and submit an automatic bug entry.\n\nThis submission will include information about the program state when the crash occurred, source code version tags, and platform information. If log messages are available, they will be sent as well.\n\n";
    private JButton submitButton;
    private static final String USER_ID = "USER_ID";
    private static final String EMAIL = "EMAIL";
    private static final String FOCUS_URI = "FOCUS_URI";
    private static final String INCLDOM = "INCLDOM";
    private ApplicationModel appModel = null;
    private UndoRedoSupport undoRedoSupport = null;
    private Map<Integer, DiaDescriptor> dialogs = new HashMap<Integer, DiaDescriptor>();
    private LogConsole lc;
    private String focusURI;
    List<LogRecord> recs;
    List<String> bis;
    Map<String, Object> map;
    boolean uncaught;
    Throwable t;

    @Override
    public void handle(Throwable t) {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            t.printStackTrace();
        } else {
            this.showExceptionDialog(t, "");
        }
    }

    @Override
    public void handleUncaught(Throwable t) {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            t.printStackTrace();
        } else {
            this.showExceptionDialog(t, UNCAUGHT);
        }
    }

    private synchronized DiaDescriptor createDialog(final Throwable throwable, final boolean uncaught) {
        final DiaDescriptor diaDescriptor = new DiaDescriptor();
        diaDescriptor.hits = 1;
        final JDialog dialog = new JDialog(DasApplication.getDefaultApplication().getMainFrame());
        if (!uncaught) {
            dialog.setTitle("Error Notification");
        } else {
            dialog.setTitle("Runtime Error Occurred");
        }
        dialog.setModal(false);
        dialog.setResizable(true);
        dialog.setDefaultCloseOperation(2);
        JTextArea messageArea = new JTextArea(10, 40);
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        messageArea.setEditable(false);
        JScrollPane message = new JScrollPane(messageArea);
        message.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)message, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton ok = new JButton("Ok");
        final JToggleButton details = new JToggleButton("Show Details");
        JButton submit = new JButton("Submit Error Report...");
        submit.setToolTipText("<html>Submit exception, platform information, source tags, and possibly log records to RTE server</html>");
        buttonPanel.add(submit);
        buttonPanel.add(details);
        buttonPanel.add(ok);
        mainPanel.add((Component)buttonPanel, "South");
        dialog.getContentPane().add((Component)mainPanel, "Center");
        final JTextArea traceArea = new JTextArea(10, 40);
        traceArea.setLineWrap(false);
        traceArea.setEditable(false);
        traceArea.setTabSize(4);
        diaDescriptor.textArea = messageArea;
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        traceArea.setText(writer.toString());
        final JPanel stackPane = new JPanel(new BorderLayout());
        stackPane.add((Component)new JScrollPane(traceArea), "North");
        stackPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel buttonPanel2 = new JPanel(new FlowLayout(2));
        buttonPanel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        JButton dump = new JButton("Dump to Console");
        buttonPanel2.add(dump);
        this.submitButton = submit;
        stackPane.add((Component)buttonPanel2, "South");
        Dimension size = message.getPreferredSize();
        size.width = stackPane.getPreferredSize().width;
        message.setPreferredSize(size);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
                GuiExceptionHandler.this.dialogs.remove(diaDescriptor.hash);
            }
        });
        details.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (details.isSelected()) {
                    details.setText("Less Details");
                    dialog.getContentPane().add((Component)stackPane, "South");
                    dialog.pack();
                } else {
                    details.setText("More Details");
                    dialog.getContentPane().remove(stackPane);
                    dialog.pack();
                }
            }
        });
        dump.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String text = traceArea.getText();
                System.err.print(text);
            }
        });
        submit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GuiExceptionHandler.this.submitRuntimeException(throwable, uncaught);
            }
        });
        diaDescriptor.dialog = dialog;
        return diaDescriptor;
    }

    public void setApplicationModel(ApplicationModel appModel) {
        this.appModel = appModel;
    }

    public void setUndoRedoSupport(UndoRedoSupport undoRedoSupport) {
        this.undoRedoSupport = undoRedoSupport;
    }

    String updateText(GuiExceptionHandlerSubmitForm form, String userComments) {
        this.map.put(INCLDOM, form.isAllowDom());
        this.map.put(EMAIL, form.getEmailTextField().getText());
        this.map.put(USER_ID, form.getUsernameTextField().getText().replaceAll(" ", "_"));
        return this.formatReport(this.t, this.bis, this.recs, this.map, this.uncaught, userComments);
    }

    private synchronized void showExceptionDialog(Throwable t, String extraInfo) {
        boolean uncaught = extraInfo.equals(UNCAUGHT);
        int hash = GuiExceptionHandler.hashCode(t);
        DiaDescriptor dia1 = this.dialogs.get(hash);
        String errorMessage = extraInfo + t.getClass().getName() + "\n" + (t.getMessage() == null ? "" : t.getMessage());
        if (t.getClass().getName().contains("PyException")) {
            int i;
            String[] ss = t.toString().split("\n");
            if (ss[i = 0].contains("Traceback")) {
                ++i;
            }
            if (ss.length > 0 && ss[i].contains("in ?")) {
                ++i;
            }
            if (ss.length > i) {
                StringBuilder msg = new StringBuilder(ss[i++]);
                while (i < ss.length) {
                    msg.append("\n").append(ss[i++]);
                }
                errorMessage = errorMessage + msg.toString();
            }
        }
        if (dia1 != null) {
            errorMessage = errorMessage + "\n\nError hit " + (1 + dia1.hits) + " times";
            ++dia1.hits;
        }
        if (dia1 == null) {
            dia1 = this.createDialog(t, uncaught);
        }
        JDialog dialog = dia1.dialog;
        this.dialogs.put(hash, dia1);
        dia1.hash = hash;
        dia1.textArea.setText(errorMessage);
        dialog.pack();
        dialog.setLocationRelativeTo(DasApplication.getDefaultApplication().getMainFrame());
        dialog.setVisible(true);
    }

    private static int hashCode(Throwable t) {
        int rteHash = 0;
        if (t.getCause() != null) {
            t = t.getCause();
        }
        StackTraceElement[] ee = t.getStackTrace();
        for (int i = 0; i < ee.length && i < 5; ++i) {
            rteHash = 31 * rteHash + GuiExceptionHandler.hashCode(ee[i]);
        }
        rteHash = Math.abs(rteHash) + (ee.length > 0 ? ee[0].getLineNumber() : 0);
        return rteHash;
    }

    private static int hashCode(StackTraceElement e) {
        int result = 31 * e.getClassName().hashCode() + e.getMethodName().hashCode();
        return result;
    }

    public synchronized void setLogConsole(LogConsole lc) {
        this.lc = lc;
    }

    public synchronized void setFocusURI(String uri) {
        this.focusURI = uri;
    }

    private void escape(StringBuffer sb, String text) {
        if (text == null) {
            text = "<null>";
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(ch);
        }
    }

    private void formatException(Document doc, Element parent, Throwable th) {
        Element ex = doc.createElement("exception");
        Element type = doc.createElement("type");
        type.appendChild(doc.createTextNode(th.getClass().getName()));
        ex.appendChild(type);
        Element msg = doc.createElement("message");
        msg.appendChild(doc.createTextNode(th.toString()));
        ex.appendChild(msg);
        int hash = GuiExceptionHandler.hashCode(th);
        Element hashe = doc.createElement("hash");
        hashe.appendChild(doc.createTextNode(String.valueOf(hash)));
        ex.appendChild(hashe);
        StackTraceElement[] stes = th.getStackTrace();
        Element location = doc.createElement("location");
        if (stes.length > 0) {
            StackTraceElement ste = stes[0];
            Element ele = doc.createElement("class");
            ele.appendChild(doc.createTextNode(ste.getClassName()));
            location.appendChild(ele);
            ele = doc.createElement("method");
            ele.appendChild(doc.createTextNode(ste.getMethodName()));
            location.appendChild(ele);
            ele = doc.createElement("file");
            ele.appendChild(doc.createTextNode(ste.getFileName()));
            location.appendChild(ele);
            ele = doc.createElement("lineNumber");
            ele.appendChild(doc.createTextNode(String.valueOf(ste.getLineNumber())));
            location.appendChild(ele);
            ex.appendChild(location);
            ele = doc.createElement("toString");
            StringWriter sw = new StringWriter();
            th.printStackTrace(new PrintWriter(sw));
            ele.appendChild(doc.createTextNode("\n" + sw.toString()));
            ex.appendChild(ele);
        } else {
            Element ele = doc.createElement("noStackTrace");
            location.appendChild(ele);
            ex.appendChild(location);
        }
        parent.appendChild(ex);
    }

    private void formatBuildInfos(Document doc, Element parent, List<String> bis) {
        Element pp = doc.createElement("buildInfos");
        for (String s : bis) {
            Element jar = doc.createElement("jar");
            jar.appendChild(doc.createTextNode(s));
            pp.appendChild(jar);
        }
        parent.appendChild(pp);
    }

    private void formatSysProp(Document doc, Element parent, String prop) {
        Element ele = doc.createElement("property");
        ele.setAttribute("name", prop);
        ele.setAttribute("value", System.getProperty(prop));
        parent.appendChild(ele);
    }

    private void formatPlatform(Document doc, Element parent) {
        Element p = doc.createElement("platform");
        this.formatSysProp(doc, p, "java.version");
        this.formatSysProp(doc, p, "java.vendor");
        this.formatSysProp(doc, p, "os.name");
        this.formatSysProp(doc, p, "os.arch");
        this.formatSysProp(doc, p, "os.version");
        DecimalFormat nf = new DecimalFormat("0.0");
        String mem = nf.format(Runtime.getRuntime().maxMemory() / 0x100000L);
        String tmem = nf.format(Runtime.getRuntime().totalMemory() / 0x100000L);
        String fmem = nf.format(Runtime.getRuntime().freeMemory() / 0x100000L);
        Element ele = doc.createElement("property");
        ele.setAttribute("runtime.maxMemory", String.valueOf(mem) + " Mb");
        p.appendChild(ele);
        ele = doc.createElement("property");
        ele.setAttribute("runtime.totalMemory", String.valueOf(tmem) + " Mb");
        p.appendChild(ele);
        ele = doc.createElement("property");
        ele.setAttribute("runtime.freeMemory", String.valueOf(fmem) + " Mb");
        p.appendChild(ele);
        parent.appendChild(p);
    }

    private void formatUndos(Document doc, Element parent, UndoRedoSupport undo) {
        Element ele = doc.createElement("states");
        for (int i = undo.getDepth() - 1; i > 0; --i) {
            Element ele1 = doc.createElement("undo");
            ele1.setAttribute("pos", String.valueOf(i));
            ele1.appendChild(doc.createTextNode(undo.getLongUndoDescription(i)));
            ele.appendChild(ele1);
        }
        parent.appendChild(ele);
    }

    private String formatReport(Throwable t, List<String> bis, List<LogRecord> recs, Map<String, Object> data, boolean uncaught, String userComments) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element e = doc.createElement("exceptionReport");
            e.setAttribute("version", "1.1");
            doc.appendChild(e);
            Element app = doc.createElement("applicationId");
            app.appendChild(doc.createTextNode("autoplot"));
            e.appendChild(app);
            Element user = doc.createElement("userComments");
            user.appendChild(doc.createTextNode(userComments));
            e.appendChild(user);
            Element userN = doc.createElement("userName");
            userN.appendChild(doc.createTextNode((String)data.get(USER_ID)));
            e.appendChild(userN);
            Element mail = doc.createElement("email");
            mail.appendChild(doc.createTextNode((String)data.get(EMAIL)));
            e.appendChild(mail);
            Element focus = doc.createElement("focusUri");
            focus.appendChild(doc.createTextNode((String)data.get(FOCUS_URI)));
            e.appendChild(focus);
            this.formatException(doc, e, t);
            Element ele = doc.createElement("uncaught");
            ele.appendChild(doc.createTextNode(String.valueOf(uncaught)));
            e.appendChild(ele);
            if (data.get(INCLDOM) == null || ((Boolean)data.get(INCLDOM)).booleanValue()) {
                if (this.appModel != null) {
                    Application state = this.appModel.getDocumentModel();
                    Element app1 = SerializeUtil.getDomElement(doc, state, new Vap1_07Scheme());
                    Element vap = doc.createElement("vap");
                    vap.appendChild(app1);
                    vap.setAttribute("domVersion", "v1_07");
                    try {
                        vap.setAttribute("appVersionTag", AboutUtil.getReleaseTag());
                    }
                    catch (IOException ex) {
                        vap.setAttribute("appVersionTag", ex.getMessage());
                    }
                    Element dom = doc.createElement("dom");
                    dom.appendChild(vap);
                    e.appendChild(vap);
                }
                if (this.undoRedoSupport != null) {
                    this.formatUndos(doc, e, this.undoRedoSupport);
                }
            }
            this.formatBuildInfos(doc, e, bis);
            this.formatPlatform(doc, e);
            DOMImplementationLS ls = (DOMImplementationLS)doc.getImplementation().getFeature("LS", "3.0");
            LSOutput output = ls.createLSOutput();
            output.setEncoding("UTF-8");
            output.setByteStream(out);
            LSSerializer serializer = ls.createLSSerializer();
            try {
                if (serializer.getDomConfig().canSetParameter("format-pretty-print", Boolean.TRUE)) {
                    serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                }
            }
            catch (Error error) {
                error.printStackTrace();
            }
            serializer.write(doc, output);
        }
        catch (ParserConfigurationException ex) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return out.toString();
    }

    FileFilter getFileNameExtensionFilter(final String desc, final String[] exts) {
        return new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isFile()) {
                    return true;
                }
                int i = 0;
                if (i < exts.length) {
                    if (exts[i].length() > 1 && exts[i].charAt(0) == '.') {
                        return pathname.toString().endsWith(exts[i]);
                    }
                    return pathname.toString().endsWith("." + exts[i]);
                }
                return false;
            }

            public String getDescription() {
                return desc;
            }
        };
    }

    public synchronized void submitRuntimeException(Throwable t, boolean uncaught) {
        int rteHash = GuiExceptionHandler.hashCode(t);
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String eventId = sdf.format(now);
        this.bis = null;
        try {
            this.bis = AboutUtil.getBuildInfos();
        }
        catch (IOException ex) {
            Logger.getLogger(GuiExceptionHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.recs = null;
        if (this.lc != null) {
            this.recs = this.lc.records;
        }
        this.map = new HashMap<String, Object>();
        String id = "anon";
        id = System.getProperty("user.name");
        this.map.put(USER_ID, id);
        this.map.put(EMAIL, "");
        this.map.put(FOCUS_URI, this.focusURI);
        this.uncaught = uncaught;
        this.t = t;
        String report = this.formatReport(t, this.bis, this.recs, this.map, uncaught, "USER COMMENTS");
        String url = "http://papco.org:8080/RTEReceiver/LargeUpload.jsp";
        GuiExceptionHandlerSubmitForm form = new GuiExceptionHandlerSubmitForm();
        form.setGuiExceptionHandler(this);
        boolean notsent = true;
        while (notsent) {
            String email;
            form.getDataTextArea().setText(report);
            form.getUsernameTextField().setText((String)this.map.get(USER_ID));
            form.getEmailTextField().setText((String)this.map.get(EMAIL));
            Object[] choices = new String[]{"Copy to Clipboard", "Save to File", "Cancel", "OK"};
            Window parent = this.appModel == null ? null : SwingUtilities.getWindowAncestor(this.appModel.getCanvas());
            int option = JOptionPane.showOptionDialog(parent, form, "Submit Exception Report", 0, 3, null, choices, choices[3]);
            if (option == 2) {
                return;
            }
            if (option == 1) {
                id = form.getUsernameTextField().getText().replaceAll(" ", "_");
                if (id.trim().equals("")) {
                    id = "anon";
                }
                this.map.put(USER_ID, id);
                email = form.getEmailTextField().getText();
                this.map.put(EMAIL, email);
                report = this.formatReport(t, this.bis, this.recs, this.map, uncaught, form.getUserTextArea().getText());
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(this.getFileNameExtensionFilter("xml files", new String[]{".xml"}));
                String fname = String.format("rte_%010d_%s_%s.xml", new Integer(rteHash), eventId, id);
                chooser.setSelectedFile(new File(fname));
                if (chooser.showSaveDialog(form) != 0) continue;
                try {
                    File f = chooser.getSelectedFile();
                    PrintWriter out = new PrintWriter(f);
                    out.write(report);
                    out.close();
                    notsent = false;
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, ex.toString());
                }
                continue;
            }
            if (option == 3) {
                id = form.getUsernameTextField().getText().replaceAll(" ", "_");
                if (id.trim().equals("")) {
                    id = "anon";
                }
                this.map.put(USER_ID, id);
                email = form.getEmailTextField().getText();
                this.map.put(EMAIL, email);
                report = this.formatReport(t, this.bis, this.recs, this.map, uncaught, form.getUserTextArea().getText());
                String fname = String.format("rte_%010d_%s_%s.xml", new Integer(rteHash), eventId, id);
                HttpClient client = new HttpClient();
                client.getHttpConnectionManager().getParams().setConnectionTimeout(3000);
                PostMethod postMethod = new PostMethod(url);
                Part[] parts = new Part[]{new StringPart("secret", "secret"), new StringPart("todo", "upload"), new FilePart("uploadfile", (PartSource)new ByteArrayPartSource(fname, report.getBytes()))};
                postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
                try {
                    int statusCode1 = client.executeMethod((HttpMethod)postMethod);
                    if (statusCode1 == 200) {
                        if (this.submitButton != null) {
                            this.submitButton.setEnabled(false);
                        }
                        notsent = false;
                        postMethod.releaseConnection();
                        continue;
                    }
                    postMethod.releaseConnection();
                    JOptionPane.showMessageDialog(null, postMethod.getStatusLine());
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, ex.toString());
                }
                continue;
            }
            if (option != 0) continue;
            id = form.getUsernameTextField().getText().replaceAll(" ", "_");
            if (id.trim().equals("")) {
                id = "anon";
            }
            this.map.put(USER_ID, id);
            email = form.getEmailTextField().getText();
            this.map.put(EMAIL, email);
            report = this.formatReport(t, this.bis, this.recs, this.map, uncaught, form.getUserTextArea().getText());
            StringSelection stringSelection = new StringSelection(report);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, new ClipboardOwner(){

                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            });
        }
    }

    public static String safe(String s) {
        try {
            if (s == null) {
                return "null";
            }
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(s);
        }
    }

    public static void main(String[] args) {
        GuiExceptionHandler eh = new GuiExceptionHandler();
        eh.handle(new RuntimeException("Bad Deal!"));
        eh.handle(new RuntimeException("Bad Deal!"));
        eh.handle(new RuntimeException("Bad Deal!"));
        for (int i = 0; i < 3; ++i) {
            eh.handle(new RuntimeException("Bad Deal 2!"));
        }
    }

    static class DiaDescriptor {
        JDialog dialog;
        int hits;
        JTextArea textArea;
        int hash;

        DiaDescriptor() {
        }
    }
}

