/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.scriptconsole;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.virbo.autoplot.scriptconsole.LogConsole;

public class LogConsoleSettingsDialog
extends JDialog {
    LogConsole console;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox logLevelCheckBox;
    private JCheckBox loggerIDCheckBox;
    private JTextField searchForTextField;
    private JCheckBox timeStampsCheckBox;
    private JComboBox verbositySelect;

    public LogConsoleSettingsDialog(Frame parent, boolean modal, LogConsole console) {
        super(parent, modal);
        this.initComponents();
        this.console = console;
    }

    private void updateSearchText() {
        this.console.setSearchText(this.searchForTextField.getText());
    }

    private void initComponents() {
        this.loggerIDCheckBox = new JCheckBox();
        this.timeStampsCheckBox = new JCheckBox();
        this.logLevelCheckBox = new JCheckBox();
        this.verbositySelect = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.searchForTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.loggerIDCheckBox.setText("logger ID");
        this.loggerIDCheckBox.setToolTipText("identifies the logger posting the message");
        this.loggerIDCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.loggerIDCheckBoxActionPerformed(evt);
            }
        });
        this.timeStampsCheckBox.setText("timing");
        this.timeStampsCheckBox.setToolTipText("Show time of the message, in seconds before the most recent message.");
        this.timeStampsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.timeStampsCheckBoxActionPerformed(evt);
            }
        });
        this.logLevelCheckBox.setText("log levels");
        this.logLevelCheckBox.setToolTipText("show the log level (verbosity) of the messages.");
        this.logLevelCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.logLevelCheckBoxActionPerformed(evt);
            }
        });
        this.verbositySelect.setModel(new DefaultComboBoxModel<String>(new String[]{"warnings", "informational", "debug (fine)", "debug (finer)", "debug (finest)", "all"}));
        this.verbositySelect.setToolTipText("filter messages by verbosity.");
        this.verbositySelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.verbositySelectActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Verbosity:");
        this.jLabel2.setText("Highlite Lines Matching:");
        this.jLabel2.setToolTipText("Enter a regular expression.  Lines containing this will be highlited.");
        this.searchForTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.searchForTextFieldActionPerformed(evt);
            }
        });
        this.searchForTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                LogConsoleSettingsDialog.this.searchForTextFieldFocusLost(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.loggerIDCheckBox).addPreferredGap(0).add((Component)this.timeStampsCheckBox).addPreferredGap(0).add((Component)this.logLevelCheckBox)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.verbositySelect, -2, 147, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.searchForTextField, -2, 172, -2))).add(169, 169, 169)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.verbositySelect, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.timeStampsCheckBox).add((Component)this.logLevelCheckBox).add((Component)this.loggerIDCheckBox)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.searchForTextField, -2, -1, -2)).addContainerGap(47, Short.MAX_VALUE)));
        this.pack();
    }

    private void loggerIDCheckBoxActionPerformed(ActionEvent evt) {
        this.console.setShowLoggerId(this.loggerIDCheckBox.isSelected());
        this.console.update();
    }

    private void timeStampsCheckBoxActionPerformed(ActionEvent evt) {
        this.console.setShowTimeStamps(this.timeStampsCheckBox.isSelected());
        this.console.update();
    }

    private void logLevelCheckBoxActionPerformed(ActionEvent evt) {
        this.console.setShowLevel(this.logLevelCheckBox.isSelected());
        this.console.update();
    }

    private void verbositySelectActionPerformed(ActionEvent evt) {
        Level level;
        String o = (String)this.verbositySelect.getSelectedItem();
        if (o.equals("warnings")) {
            level = Level.WARNING;
        } else if (o.equals("informational")) {
            level = Level.INFO;
        } else if (o.equals("debug (fine)")) {
            level = Level.FINE;
        } else if (o.equals("debug (finer)")) {
            level = Level.FINER;
        } else if (o.equals("debug (finest)")) {
            level = Level.FINEST;
        } else if (o.equals("all")) {
            level = Level.ALL;
        } else {
            throw new RuntimeException("bad level string: " + o);
        }
        this.console.setLevel(level.intValue());
        this.console.update();
    }

    private void searchForTextFieldActionPerformed(ActionEvent evt) {
        this.updateSearchText();
    }

    private void searchForTextFieldFocusLost(FocusEvent evt) {
        this.updateSearchText();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LogConsoleSettingsDialog dialog = new LogConsoleSettingsDialog((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

